/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jpos.PosUtils;
import jpos.SP;
import jpos.XMLUtils;
import org.jdom.Element;

public class PaymentGatewayConfig {
    private PaymentGatewayType paymentGatewayType;
    private boolean configRetrievedFromHO = false;
    private Element paymentGatewayXml = null;
    private String getewayIdx = "";
    private String gatewayCode = "";
    private String merchantID = "";
    private String password = "";
    private String connectTo = "";
    private String currency = "";
    private String userName = "";
    private String merchantAccountID = "";
    private String privateKey = "";
    private String publicKey = "";
    private String AP21EncryptionKey = "";
    private String livePrefix = "";
    private String commsMethod = "";
    private String keyIdentifier = "";
    private String keyVersion = "";
    private String passphrase = "";
    private String cloudApiUrl = "";
    private String apiUrl = "";

    public PaymentGatewayConfig(PaymentGatewayType paymentGatewayType, boolean getFromOnline) {
        this.paymentGatewayType = paymentGatewayType;
        this.loadConfig(getFromOnline);
    }

    public PaymentGatewayConfig(Element payGatewayXml) {
        this.configRetrievedFromHO = true;
        this.paymentGatewayXml = payGatewayXml;
        this.paymentGatewayType = PaymentGatewayType.fromDatabaseTypeValue(XMLUtils.getLongValue(this.paymentGatewayXml, "gateway_type"));
        this.merchantID = XMLUtils.getValue(this.paymentGatewayXml, "merchant_id");
        this.merchantAccountID = XMLUtils.getValue(this.paymentGatewayXml, "merchant_account_id");
        this.password = XMLUtils.getValue(this.paymentGatewayXml, "password");
        this.privateKey = XMLUtils.getValue(this.paymentGatewayXml, "private_key");
        this.publicKey = XMLUtils.getValue(this.paymentGatewayXml, "public_key");
        this.connectTo = XMLUtils.getValue(this.paymentGatewayXml, "connect_to");
        this.AP21EncryptionKey = XMLUtils.getValue(this.paymentGatewayXml, "encryption_key");
        this.gatewayCode = XMLUtils.getValue(this.paymentGatewayXml, "gateway_refcode");
        this.currency = XMLUtils.getValue(this.paymentGatewayXml, "currency");
        this.apiUrl = XMLUtils.getValue(this.paymentGatewayXml, "api_url");
    }

    public int GetPayTypeIdx() {
        int payTypeIdx;
        switch (this.paymentGatewayType) {
            case BRAINTREE: {
                payTypeIdx = 848;
                break;
            }
            case PAYPAL_REST: {
                payTypeIdx = 847;
                break;
            }
            case ZIP: {
                payTypeIdx = 795;
                break;
            }
            case AFTER_PAY: {
                payTypeIdx = 776;
                break;
            }
            case OPENPAY: {
                payTypeIdx = 850;
                break;
            }
            default: {
                payTypeIdx = -1;
            }
        }
        return payTypeIdx;
    }

    private void loadConfig(boolean getFromOnline) {
        block32: {
            if (!getFromOnline) {
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT R.RCIDX, R.CODE, B.BLOBTEXT FROM BLOBTEXT B JOIN REFCODE R ON B.BLOBIDX = R.LINKIDX WHERE R.\"ACTIVE\" = 1 AND R.RGIDX = 431 AND R.EXTEND = ?");){
                    stmt.setString(1, String.valueOf(this.paymentGatewayType.getDatabaseTypeValue()));
                    try (ResultSet result = stmt.executeQuery();){
                        Element e;
                        if (!result.next()) break block32;
                        this.getewayIdx = result.getString(1);
                        this.gatewayCode = result.getString(2);
                        String blobData = result.getString(3);
                        this.paymentGatewayXml = e = XMLUtils.getElementFromXMLString(blobData);
                        if (e != null) {
                            this.merchantID = XMLUtils.getValue(e, "MerchantID");
                            this.password = XMLUtils.getValue(e, "Password");
                            this.connectTo = XMLUtils.getValue(e, "ConnectTo");
                            this.currency = XMLUtils.getValue(e, "Currency");
                            this.userName = XMLUtils.getValue(e, "UserName");
                            this.merchantAccountID = XMLUtils.getValue(e, "MerchantAccountID");
                            this.privateKey = XMLUtils.getValue(e, "PrivateKey");
                            this.publicKey = XMLUtils.getValue(e, "PublicKey");
                            this.AP21EncryptionKey = XMLUtils.getValue(e, "AP21EncryptionKey");
                            this.livePrefix = XMLUtils.getValue(e, "LivePrefix");
                            this.commsMethod = XMLUtils.getValue(e, "CommsMethod");
                            this.keyIdentifier = XMLUtils.getValue(e, "KeyIdentifier");
                            this.keyVersion = XMLUtils.getValue(e, "KeyVersion");
                            this.passphrase = XMLUtils.getValue(e, "Passphrase");
                            this.cloudApiUrl = XMLUtils.getValue(e, "CloudApiUrl");
                            this.apiUrl = XMLUtils.getValue(e, "ApiUrl");
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            } else {
                Element payGatewayXml = SP.sParams.OnlineQueryProvider.getOnlineQuery("payment_gateway", String.valueOf(this.GetPayTypeIdx()), false).getXML();
                if (payGatewayXml == null) {
                    this.configRetrievedFromHO = false;
                } else {
                    this.configRetrievedFromHO = true;
                    if (payGatewayXml.getName().equals("payment_gateway")) {
                        this.paymentGatewayXml = payGatewayXml;
                        this.merchantID = XMLUtils.getValue(this.paymentGatewayXml, "merchant_id");
                        this.merchantAccountID = XMLUtils.getValue(this.paymentGatewayXml, "merchant_account_id");
                        this.password = XMLUtils.getValue(this.paymentGatewayXml, "password");
                        this.privateKey = XMLUtils.getValue(this.paymentGatewayXml, "private_key");
                        this.publicKey = XMLUtils.getValue(this.paymentGatewayXml, "public_key");
                        this.connectTo = XMLUtils.getValue(this.paymentGatewayXml, "connect_to");
                        this.AP21EncryptionKey = XMLUtils.getValue(this.paymentGatewayXml, "encryption_key");
                        this.gatewayCode = XMLUtils.getValue(this.paymentGatewayXml, "gateway_refcode");
                        this.currency = XMLUtils.getValue(this.paymentGatewayXml, "currency");
                        this.apiUrl = XMLUtils.getValue(this.paymentGatewayXml, "api_url");
                    }
                }
            }
        }
    }

    public boolean getConfigRetrievedFromHO() {
        return this.configRetrievedFromHO;
    }

    public Element getPaymentGatewayXml() {
        return this.paymentGatewayXml;
    }

    public String getGatewayIdx() {
        return this.getewayIdx;
    }

    public String getGatewayCode() {
        return this.gatewayCode;
    }

    public void setGatewayCode(String gatewayCode) {
        this.gatewayCode = gatewayCode;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectTo() {
        return this.connectTo;
    }

    public void setConnectTo(String connectTo) {
        this.connectTo = connectTo;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getMerchantAccountID() {
        return this.merchantAccountID;
    }

    public void setMerchantAccountID(String merchantAccountID) {
        this.merchantAccountID = merchantAccountID;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getAP21EncryptionKey() {
        return this.AP21EncryptionKey;
    }

    public void setAP21EncryptionKey(String aP21EncryptionKey) {
        this.AP21EncryptionKey = aP21EncryptionKey;
    }

    public String getLivePrefix() {
        return this.livePrefix;
    }

    public void setLivePrefix(String livePrefix) {
        this.livePrefix = livePrefix;
    }

    public String getCommsMethod() {
        return this.commsMethod;
    }

    public void setCommsMethod(String commsMethod) {
        this.commsMethod = commsMethod;
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public void setKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getCloudApiUrl() {
        return this.cloudApiUrl;
    }

    public void setCloudApiUrl(String cloudApiUrl) {
        this.cloudApiUrl = cloudApiUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public static enum PaymentGatewayType {
        SECURE_PAY(0L),
        PAYPAL_REST(1L),
        PAYPAL_CLASSIC(2L),
        AFTER_PAY(3L),
        BRAINTREE(4L),
        MANUAL_PAYMENT(5L),
        ZIP(6L),
        ADYEN(7L),
        OPENPAY(8L);

        private long databaseTypeValue;

        private PaymentGatewayType(long databaseTypeValue) {
            this.databaseTypeValue = databaseTypeValue;
        }

        public long getDatabaseTypeValue() {
            return this.databaseTypeValue;
        }

        public static PaymentGatewayType fromDatabaseTypeValue(long databaseTypeValue) {
            for (PaymentGatewayType type : PaymentGatewayType.values()) {
                if (type.getDatabaseTypeValue() != databaseTypeValue) continue;
                return type;
            }
            return null;
        }
    }
}

