/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayHistTM;
import jpos.pay.PayHistTbl;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class PaymentHistoryDlg
extends PayDialog {
    GridBagLayout gridBagLayoutAll = new GridBagLayout();
    LabelSubHeading lDocketNumber = new LabelSubHeading();
    GridBagLayout gridBagLayoutDets = new GridBagLayout();
    JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    PayHistTM payHistTM = new PayHistTM();
    PayHistTbl payHistTbl = new PayHistTbl(this.payHistTM);
    PosScrollPane spPayHist = new PosScrollPane(this.payHistTbl);
    LabelSubHeading lTotalPaid = new LabelSubHeading();
    DecimalField dfTotalPaid;
    double totalPaid;
    GridBagLayout gridBagLayoutFooter;
    JPanel panelFooter;
    DialogButton bOk;
    DialogButton bCancel;

    public PaymentHistoryDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.initPanelDetails();
        this.initPanelFooter();
        this.panelAll.add((Component)this.lDocketNumber, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void initPanelDetails() {
        this.payHistTbl.revalidate();
        this.spPayHist.setPreferredSize(new Dimension(500, 100));
        this.spPayHist.setMinimumSize(new Dimension(500, 100));
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.setAmtFieldProp(this.dfTotalPaid);
        this.dfTotalPaid.setEnabled(false);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.spPayHist, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 10, 20), 0, 100));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.dfTotalPaid.setText("");
    }

    private void initPanelFooter() {
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
    }

    @Override
    public boolean initDialog() {
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        this.dfTotalPaid.setText(this.totalPaid);
    }

    @Override
    public void okDialog() {
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setSaleDets() {
        this.lDocketNumber.setText("");
        this.payHistTM.setRetTranPs(new Vector<RetTranP>());
        this.totalPaid = 0.0;
        this.payHistTM.fireTableDataChanged();
        this.payHistTbl.revalidate();
    }

    public void setSaleDets(String pDocketNumber, List<?> pOldTendersXML) {
        if (pOldTendersXML != null) {
            this.lDocketNumber.setText(pDocketNumber);
            this.totalPaid = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, this.payHistTM.getRetTranPs());
            this.payHistTM.fireTableDataChanged();
            this.payHistTbl.revalidate();
        }
    }

    public void setLastSaleDets(String pDocketNumber, Vector<RetTranP> retTranPs) {
        this.lDocketNumber.setText(pDocketNumber);
        this.payHistTM.setRetTranPs(retTranPs);
        this.totalPaid = this.payHistTM.getTotal();
        this.payHistTM.fireTableDataChanged();
        this.payHistTbl.revalidate();
    }
}

