/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.eftpos;

import java.awt.Window;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.logging.RollingLog;

public class EftposUtils {
    public static void logInfo(Connection con, String vshidx, Action action, String logText) {
        if (logText == null) {
            logText = "";
        }
        RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, "EFTPOS " + action.toString() + ": " + logText + "\nVSHIDX: " + vshidx);
        if (logText.length() > 200) {
            logText = logText.substring(0, 200);
        }
        try (PreparedStatement stmt = con.prepareStatement("Insert into EFTPOS_LOG(EPLIDX, VSHIDX, TILL_NUMBER, CRDT, ACTION, LOG_TEXT) values (?, ?, ?, CURRENT_TIMESTAMP, ?, ?)");){
            stmt.setLong(1, SP.sParams.nextVal("XEFTPOS_LOG"));
            stmt.setString(2, vshidx);
            stmt.setString(3, SP.sParams.tillnum);
            stmt.setString(4, action.toString());
            stmt.setString(5, logText);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void debugPoint(Window parent, String message) {
        try {
            RollingLog.log(RollingLog.LogType.TRANSACTION, Level.INFO, message);
            EftposDebugMode mode = Settings.getEftposDebugMode();
            if (mode == EftposDebugMode.SCREEN_ONLY || mode == EftposDebugMode.FILE_AND_SCREEN) {
                DlgMessage.showMessage(parent, message, "Transaction Debug Message");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void eftposPaymentDelay() {
        if (Settings.getEftposPaymentDelay() >= 0) {
            try {
                Thread.sleep(Settings.getEftposPaymentDelay());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum EftposDebugMode {
        OFF,
        SCREEN_ONLY,
        FILE_ONLY,
        FILE_AND_SCREEN;

    }

    public static enum Action {
        REQUEST,
        RESPONSE,
        INFORMATION;

    }
}

