/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.paypal;

import bass.eftpos.StringUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpRequest;
import com.paypal.http.HttpResponse;
import com.paypal.http.exceptions.HttpException;
import com.paypal.payments.CapturesRefundRequest;
import com.paypal.payments.Money;
import com.paypal.payments.Refund;
import com.paypal.payments.RefundRequest;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import jpos.SP;
import jpos.logging.RollingLog;
import jpos.pay.PaymentGatewayConfig;
import jpos.pay.RetTranP;
import jpos.pay.paypal.PaypalHttpException;

public class Paypal {
    public static final String ERR_FULLY_REFUNDED = "CAPTURE_FULLY_REFUNDED";
    public static final String ERR_REFUND_AMT_EXCEEDED = "REFUND_AMOUNT_EXCEEDED";
    public static final String ERR_INVALID_PAYMENT_ID = "INVALID_RESOURCE_ID";
    public static final String ERR_CURRENCY_MISMATCH = "REFUND_CAPTURE_CURRENCY_MISMATCH";
    private PayPalEnvironment environment;
    private PayPalHttpClient client;

    public Paypal(PaymentGatewayConfig gatewayConfig) {
        this.environment = gatewayConfig.getConnectTo().trim().equals("Test") ? new PayPalEnvironment.Sandbox(gatewayConfig.getMerchantID(), gatewayConfig.getPassword()) : new PayPalEnvironment.Live(gatewayConfig.getMerchantID(), gatewayConfig.getPassword());
        this.client = new PayPalHttpClient(this.environment);
    }

    public boolean RefundPayment(RetTranP retTranP, StringBuilder processMsg) {
        try {
            Refund refund = null;
            Money amount = new Money();
            amount.currencyCode(retTranP.getETran().getCurrency().getCurrencyCode());
            amount.value(String.valueOf(Math.abs(retTranP.getAmount())));
            RefundRequest refundRequest = new RefundRequest();
            refundRequest.amount(amount);
            CapturesRefundRequest request = new CapturesRefundRequest(retTranP.getETran().getOrigStan()).requestBody(refundRequest);
            RollingLog.log(RollingLog.LogType.PAYPAL, Level.INFO, this.GetRequestLog(retTranP.getETran().getOrigStan(), refundRequest));
            HttpResponse response = this.client.execute((HttpRequest)request);
            refund = (Refund)response.result();
            RollingLog.log(RollingLog.LogType.PAYPAL, Level.INFO, this.GetResponseLog(refund));
            retTranP.getETran().setReference(refund.id());
            return true;
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.PAYPAL, Level.INFO, this.GetResponseLog(e));
            if (e instanceof HttpException) {
                HttpException http = (HttpException)e;
                String error = "";
                if (http.statusCode() == 401) {
                    error = SP.getRS("paypal_auth_failed");
                } else {
                    Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                    PaypalHttpException ex = (PaypalHttpException)gson.fromJson(http.getMessage(), PaypalHttpException.class);
                    if (ex.Details != null && ex.Details.size() > 0) {
                        String issue = ex.Details.get((int)0).Issue;
                        String desc = ex.Details.get((int)0).Description;
                        if (!StringUtils.isNullOrEmpty((String)issue) && !StringUtils.isNullOrEmpty((String)desc)) {
                            error = issue.equals(ERR_FULLY_REFUNDED) ? "This payment has already been fully refunded" : (issue.equals(ERR_REFUND_AMT_EXCEEDED) ? "Cannot refund more than original payment" : (issue.equals(ERR_INVALID_PAYMENT_ID) ? "The original payment reference provided is invalid" : (issue.equals(ERR_CURRENCY_MISMATCH) ? "Refund must be in the same currency as the original payment" : issue + ": " + desc)));
                        }
                    } else {
                        error = !StringUtils.isNullOrEmpty((String)ex.Name) && !StringUtils.isNullOrEmpty((String)ex.Message) ? ex.Name + ": " + ex.Message : "Something went wrong while processing PayPal refund";
                    }
                }
                this.SetProcessMessage(processMsg, error);
            } else if (e instanceof UnknownHostException) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error communicating with PayPal.");
                sb.append("\r\n");
                sb.append("Please check your internet connection and try again.");
                this.SetProcessMessage(processMsg, sb.toString());
            } else if (e instanceof SocketTimeoutException) {
                this.SetProcessMessage(processMsg, "The refund request has timed out. Please try again.");
            } else {
                this.SetProcessMessage(processMsg, e.getMessage());
            }
            return false;
        }
    }

    private void SetProcessMessage(StringBuilder processMsg, String error) {
        if (!StringUtils.isNullOrEmpty((String)error)) {
            processMsg.append(error);
            processMsg.append("\r\n");
        }
    }

    private String GetRequestLog(String origStan, RefundRequest refundRequest) {
        StringBuilder requestLog = new StringBuilder();
        requestLog.append("PayPal Refund Request");
        requestLog.append("\r\n");
        requestLog.append("Original Payment Stan: " + origStan);
        requestLog.append("\r\n");
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        requestLog.append("PayPal Refund Request: " + prettyJson.toJson((Object)refundRequest));
        return requestLog.toString();
    }

    private String GetResponseLog(Object e) {
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return "PayPal Refund Response: " + prettyJson.toJson(e);
    }
}

