/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.qantas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.RetTranP;
import jpos.pay.qantas.Qantas;
import jpos.pay.qantas.QantasTransaction;
import jpos.pay.qantas.QantasTransactionStatus;
import jpos.ui.DialogButton;

public class DlgQantasApproval
extends PayDialog {
    private Qantas qantas;
    private QantasTransaction qantasTransaction;
    private Mode currentMode = Mode.Polling;
    private JLabel userPromptLabel = new JLabel();
    private JLabel timeoutPromptLine1 = new JLabel();
    private JLabel timeoutPromptLine2 = new JLabel();
    private JLabel successImage = new JLabel();
    private JLabel spinner = new JLabel();
    private JLabel timeoutText = new JLabel();
    private RetTranP retTranP;
    private DialogButton okButton;
    private DialogButton cancelButton;
    private double balanceDue;
    private String membershipNumber;
    private Timer pollingTimer;
    private Timer timeoutTimer;
    private int timeOutSecs = 60;
    ReentrantLock lock = new ReentrantLock();
    StringBuilder retMessage = new StringBuilder();
    JPanel panelMain;
    JPanel panelWaitingConfirmation;
    JPanel panelReceivedConfirmation;
    JPanel panelTimeoutOccured;
    private boolean result;
    private PollingRunnable polling;

    public DlgQantasApproval(FrSales frame, String header) {
        super((Frame)frame, header);
        this.qantas = new Qantas();
        this.panelMain = new JPanel();
        this.getContentPane().add(this.panelMain);
        this.jbInit();
    }

    public void jbInit() {
        this.getContentPane().setMinimumSize(new Dimension(400, 250));
        ImageIcon ico = new ImageIcon(SP.sParams.imagepath + "qantaslogo.png");
        this.setIconImage(ico.getImage());
        this.populateForPolling();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DlgQantasApproval.this.pollingTimer != null) {
                            DlgQantasApproval.this.pollingTimer.cancel();
                        }
                        DlgQantasApproval.this.pollingTimer = new Timer();
                        DlgQantasApproval.this.pollingTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                if (DlgQantasApproval.this.polling != null && ((DlgQantasApproval)DlgQantasApproval.this).polling.finished && DlgQantasApproval.this.timeOutSecs > 0) {
                                    DlgQantasApproval.this.lock.lock();
                                    try {
                                        if (DlgQantasApproval.this.qantasTransaction.getStatus() != QantasTransactionStatus.Created) {
                                            DlgQantasApproval.this.pollingTimer.cancel();
                                            if (DlgQantasApproval.this.qantasTransaction.getStatus() == QantasTransactionStatus.BurnSelected) {
                                                if (DlgQantasApproval.this.qantasTransaction.getSelectedValue() == 0.0) {
                                                    DlgQantasApproval.this.triggerModeChange(Mode.EarnOnly);
                                                } else {
                                                    DlgQantasApproval.this.triggerModeChange(Mode.Success);
                                                }
                                                ((DlgQantasApproval)DlgQantasApproval.this).polling.enabled = false;
                                            } else {
                                                DlgQantasApproval.this.cancelDialog();
                                            }
                                            return;
                                        }
                                    }
                                    finally {
                                        DlgQantasApproval.this.lock.unlock();
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DlgQantasApproval.this.startPolling();
                                    }
                                });
                            }
                        }, 0L, 3500L);
                        if (DlgQantasApproval.this.timeoutTimer != null) {
                            DlgQantasApproval.this.timeoutTimer.cancel();
                        }
                        DlgQantasApproval.this.timeoutTimer = new Timer();
                        DlgQantasApproval.this.timeoutTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                DlgQantasApproval.this.timeoutText.setText(String.valueOf(DlgQantasApproval.this.timeOutSecs));
                                DlgQantasApproval.this.getContentPane().repaint();
                                if (DlgQantasApproval.this.timeOutSecs > 0) {
                                    DlgQantasApproval.this.timeOutSecs--;
                                } else if (DlgQantasApproval.this.currentMode != Mode.Timeout) {
                                    DlgQantasApproval.this.triggerModeChange(Mode.Timeout);
                                    ((DlgQantasApproval)DlgQantasApproval.this).polling.enabled = false;
                                }
                            }
                        }, 0L, 1000L);
                    }
                });
            }
        });
    }

    private void startPolling() {
        if (this.qantasTransaction.getStatus() == QantasTransactionStatus.Created) {
            if (this.polling == null) {
                this.polling = new PollingRunnable();
            }
            if (this.polling.finished && this.polling.enabled) {
                new Thread(this.polling).start();
            }
        }
    }

    private void populateForPolling() {
        this.panelMain.removeAll();
        this.panelWaitingConfirmation = new JPanel(new GridBagLayout());
        this.panelMain.add((Component)this.panelWaitingConfirmation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(20, 20, 20, 20), 0, 0));
        this.spinner.setIcon(new ImageIcon(SP.sParams.imagepath + "loading_spinner.gif"));
        this.spinner.setHorizontalAlignment(0);
        this.userPromptLabel = new JLabel(SP.getRS("qantas_user_prompt_label"));
        this.timeoutText = new JLabel(String.valueOf(this.timeOutSecs));
        this.cancelButton = new DialogButton("");
        this.cancelButton.setText(SP.getRS("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgQantasApproval.this.result = false;
                DlgQantasApproval.this.cancelDialog();
            }
        });
        this.panelWaitingConfirmation.add((Component)this.timeoutText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelWaitingConfirmation.add((Component)this.spinner, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelWaitingConfirmation.add((Component)this.userPromptLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelWaitingConfirmation.add((Component)this.cancelButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.cancelButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void populateForSuccess() {
        this.timeoutTimer.cancel();
        this.panelMain.removeAll();
        this.panelReceivedConfirmation = new JPanel(new GridBagLayout());
        this.panelMain.add((Component)this.panelReceivedConfirmation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(20, 20, 20, 20), 0, 0));
        this.successImage.setIcon(new ImageIcon(SP.sParams.imagepath + "success.png"));
        this.successImage.setHorizontalAlignment(0);
        this.successImage.setSize(150, 150);
        this.userPromptLabel = new JLabel(SP.getRS("qantas_user_selected_burn_label"));
        this.okButton = new DialogButton("");
        this.okButton.setText(SP.getRS("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgQantasApproval.this.okDialog();
            }
        });
        this.panelReceivedConfirmation.add((Component)this.successImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelReceivedConfirmation.add((Component)this.userPromptLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.panelReceivedConfirmation.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.okButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.getContentPane().repaint();
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void populateForEarnOnly() {
        this.timeoutTimer.cancel();
        this.panelMain.removeAll();
        this.panelReceivedConfirmation = new JPanel(new GridBagLayout());
        this.panelMain.add((Component)this.panelReceivedConfirmation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(20, 20, 20, 20), 0, 0));
        this.successImage.setIcon(new ImageIcon(SP.sParams.imagepath + "success.png"));
        this.successImage.setHorizontalAlignment(0);
        this.successImage.setSize(150, 150);
        this.userPromptLabel = new JLabel(SP.getRS("qantas_earn_only_selected"));
        this.okButton = new DialogButton("");
        this.okButton.setText(SP.getRS("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgQantasApproval.this.earnOnlyDialog();
            }
        });
        this.panelReceivedConfirmation.add((Component)this.successImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelReceivedConfirmation.add((Component)this.userPromptLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.panelReceivedConfirmation.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.okButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.getContentPane().repaint();
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void populateForTimeout() {
        this.panelMain.removeAll();
        this.panelTimeoutOccured = new JPanel(new GridBagLayout());
        this.panelMain.add((Component)this.panelTimeoutOccured, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(20, 20, 20, 20), 0, 0));
        this.successImage.setIcon(new ImageIcon(SP.sParams.imagepath + "Timeout.png"));
        this.successImage.setHorizontalAlignment(0);
        this.successImage.setSize(150, 150);
        this.timeoutPromptLine1 = new JLabel(SP.getRS("qantas_error_timeout"));
        this.timeoutPromptLine2 = new JLabel(SP.getRS("qantas_error_tryagain"));
        this.cancelButton = new DialogButton("");
        this.cancelButton.setText(SP.getRS("OK"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgQantasApproval.this.cancelDialog();
            }
        });
        this.panelTimeoutOccured.add((Component)this.successImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelTimeoutOccured.add((Component)this.timeoutPromptLine1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelTimeoutOccured.add((Component)this.timeoutPromptLine2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.panelTimeoutOccured.add((Component)this.cancelButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.cancelButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.getContentPane().repaint();
        this.pack();
        PosUtils.centreWindow(this);
    }

    public String getMembershipNumber() {
        return this.membershipNumber;
    }

    public void setMembershipNumber(String number) {
        this.membershipNumber = number;
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setMode(Mode newMode) {
        this.currentMode = newMode;
    }

    public void triggerModeChange(Mode mode) {
        if (this.currentMode == mode) {
            return;
        }
        this.setMode(mode);
        switch (this.currentMode) {
            case Polling: {
                this.populateForPolling();
                return;
            }
            case Success: {
                this.populateForSuccess();
                return;
            }
            case EarnOnly: {
                this.populateForEarnOnly();
                return;
            }
            case Timeout: {
                this.populateForTimeout();
                return;
            }
        }
    }

    public double getBalanceDue() {
        return this.balanceDue;
    }

    public void setBalanceDue(double balanceDue) {
        this.balanceDue = balanceDue;
    }

    public void setRetTranP(RetTranP pRetTranP) {
        this.retTranP = pRetTranP;
    }

    public QantasTransaction getTransaction() {
        return this.qantasTransaction;
    }

    public void setTransaction(QantasTransaction tran) {
        this.qantasTransaction = tran;
        this.timeOutSecs = tran.getTimeout();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void cancelDialog() {
        this.cancelButton.setEnabled(false);
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
        }
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel();
        }
        this.lock.lock();
        try {
            if (this.polling != null) {
                this.polling.enabled = false;
            }
            this.retTranP.setEFTTran(null);
            try {
                if (this.currentMode == Mode.Polling) {
                    this.qantas.cancelTransaction(this.frSales, this.qantasTransaction);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e.getMessage());
            }
        }
        finally {
            this.lock.unlock();
        }
        this.result = false;
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        this.retTranP.setAmount(this.qantasTransaction.getSelectedValue());
        this.result = true;
        this.setVisible(false);
    }

    public void earnOnlyDialog() {
        this.retTranP.setEFTTran(null);
        this.result = false;
        this.setVisible(false);
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent k) {
        return false;
    }

    private static enum Mode {
        Polling,
        Success,
        EarnOnly,
        Timeout;

    }

    public class PollingRunnable
    implements Runnable {
        boolean enabled = true;
        boolean finished = true;

        public void stopPolling() {
            this.enabled = false;
        }

        @Override
        public void run() {
            if (this.enabled) {
                DlgQantasApproval.this.lock.lock();
                try {
                    this.finished = false;
                    DlgQantasApproval.this.retMessage.setLength(0);
                    DlgQantasApproval.this.qantas.pollForUpdate(DlgQantasApproval.this.frSales, DlgQantasApproval.this.qantasTransaction);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                finally {
                    this.finished = true;
                    DlgQantasApproval.this.lock.unlock();
                }
            }
        }
    }
}

