/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.zip;

import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.StyleLine;

public class Order {
    public double totalAmount = 0.0;
    public Vector<OrderItem> items = new Vector();

    public Order(Vector<StyleLine> styleLines) {
        for (int i = 0; i < styleLines.size(); ++i) {
            StyleLine line = styleLines.elementAt(i);
            if (!(line.getQty() > 0.0)) continue;
            double unitPrice = SP.sParams.bUsingExtendedTax ? SP.sParams.rnd((line.getPrice() - line.getDisc() / line.getQty()) * (1.0 + line.getExtTaxPer() / 100.0)) : SP.sParams.rnd(line.getPrice() - line.getDisc() / line.getQty());
            double lineAmount = PosUtils.scale(unitPrice * line.getQty(), 2);
            this.items.add(new OrderItem(line.getSkuDescription(), line.getQty(), lineAmount, line.getBarcode()));
            this.totalAmount += lineAmount;
        }
    }

    public class OrderItem {
        public String name;
        public double quantity;
        public double amount;
        public String sku;

        public OrderItem(String name, double quantity, double amount, String barcode) {
            this.name = name;
            this.quantity = quantity;
            this.amount = amount;
            this.sku = barcode;
        }
    }
}

