/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.teamdev.jxbrowser.js.JsArray;
import com.teamdev.jxbrowser.js.JsObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpos.StringUtils;
import jpos.browser.BrowserUtils;
import jpos.person.PersonAttributes;
import jpos.person.PersonContext;

public class JSPerson {
    private String perIdx;
    private String custIdx;
    private String memIdx;
    private String memName;
    private String memPass;
    private String firstName;
    private String surname;
    private String dob;
    private String jobTitle;
    private int privacy;
    private String sex;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String postcode;
    private String country;
    private boolean addressValidated;
    private String mainPhone;
    private String workPhone;
    private String otherPhone;
    private String taxExemptionReasonIdx;
    private String taxExemptionCertificate;
    private String email;
    private Map<String, String> references = new HashMap<String, String>();
    private Map<String, String[]> customData = new HashMap<String, String[]>();
    private List<PersonContext.Loyalty> loyalties = new ArrayList<PersonContext.Loyalty>();
    private boolean enforceFormatting;

    public String getPerIdx() {
        return this.perIdx;
    }

    public String getCustIdx() {
        return this.custIdx;
    }

    public String getMemIdx() {
        return this.memIdx;
    }

    public String getMemName() {
        return this.memName;
    }

    public String getMemPass() {
        return this.memPass;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getDob() {
        return this.dob;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public boolean isPrivacy() {
        return this.privacy == 1;
    }

    public String getSex() {
        return this.sex;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public String getCountry() {
        return this.country;
    }

    public boolean isAddressValidated() {
        return this.addressValidated;
    }

    public String getMainPhone() {
        return this.mainPhone;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public String getOtherPhone() {
        return this.otherPhone;
    }

    public String getTaxExemptionReasonIdx() {
        return this.taxExemptionReasonIdx;
    }

    public String getTaxExemptionCertificate() {
        return this.taxExemptionCertificate;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean getEnforceFormatting() {
        return this.enforceFormatting;
    }

    public Map<String, String> getReferences() {
        return this.references;
    }

    public Map<String, String[]> getCustomData() {
        return this.customData;
    }

    public List<PersonContext.Loyalty> getLoyalties() {
        return this.loyalties;
    }

    public void setLoyalties(List<PersonContext.Loyalty> loyals) {
        this.loyalties = loyals;
    }

    public void updateAddress(String address1, String address2, String city, String state, String postcode) {
        this.address1 = address1;
        this.address2 = address2;
        this.city = city;
        this.state = state;
        this.postcode = postcode;
    }

    public JSPerson(JsObject person, PersonAttributes attributes) throws IllegalStateException {
        this.perIdx = BrowserUtils.getJsStringProperty(person, "perIdx");
        this.memIdx = BrowserUtils.getJsStringProperty(person, "memIdx");
        this.memName = BrowserUtils.getJsStringProperty(person, "memName");
        this.memPass = BrowserUtils.getJsStringProperty(person, "memPass");
        this.custIdx = BrowserUtils.getJsStringProperty(person, "perIdx");
        this.firstName = BrowserUtils.getJsStringProperty(person, "firstName");
        this.surname = BrowserUtils.getJsStringProperty(person, "surname");
        this.dob = BrowserUtils.getJsStringProperty(person, "dob");
        this.jobTitle = BrowserUtils.getJsStringProperty(person, "jobTitle");
        this.privacy = BrowserUtils.getJsIntProperty(person, "sendMarketing");
        this.sex = BrowserUtils.getJsStringProperty(person, "sex");
        this.address1 = BrowserUtils.getJsStringProperty(person, "address1");
        this.address2 = BrowserUtils.getJsStringProperty(person, "address2");
        this.city = BrowserUtils.getJsStringProperty(person, "city");
        this.state = BrowserUtils.getJsStringProperty(person, "state");
        this.postcode = BrowserUtils.getJsStringProperty(person, "postcode");
        this.country = BrowserUtils.getJsStringProperty(person, "country");
        this.addressValidated = BrowserUtils.getJsBooleanProperty(person, "addressValidated");
        this.mainPhone = BrowserUtils.getJsStringProperty(person, "mainPhone");
        this.email = BrowserUtils.getJsStringProperty(person, "email");
        this.workPhone = BrowserUtils.getJsStringProperty(person, "workPhone");
        this.otherPhone = BrowserUtils.getJsStringProperty(person, "otherPhone");
        this.taxExemptionReasonIdx = BrowserUtils.getJsStringProperty(person, "taxExemptionReasonIdx");
        this.taxExemptionCertificate = BrowserUtils.getJsStringProperty(person, "taxExemptionCertificate");
        this.enforceFormatting = BrowserUtils.getJsBooleanProperty(person, "enforceFormatting");
        JsObject refList = person.property("references").orElse(null);
        for (String ord : attributes.getReferenceOrds().getList()) {
            JsArray valueArray = refList.property(ord).orElse(null);
            String value = ((String)valueArray.get(0L)).trim();
            if (!StringUtils.isNullOrEmpty(value)) {
                this.references.put(ord, value);
                continue;
            }
            this.references.put(ord, "");
        }
        JsObject customDataList = person.property("customData").orElse(null);
        for (PersonAttributes.CustomDataTemplate template : attributes.getCustomDataTemplates().getList()) {
            for (PersonAttributes.CustomDataField field : template.getFields().getList()) {
                JsArray value = customDataList.property(field.getId()).orElse(null);
                this.customData.put(field.getId(), value.length() > 0L ? JSPerson.jsArrayToJavaArray(value) : new String[]{});
            }
        }
    }

    private static String[] jsArrayToJavaArray(JsArray array) {
        String[] javaArray = new String[(int)array.length()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = ((String)array.get((long)i)).trim();
        }
        return javaArray;
    }
}

