/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.teamdev.jxbrowser.browser.event.ConsoleMessageReceived;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.js.ConsoleMessage;
import com.teamdev.jxbrowser.js.ConsoleMessageLevel;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.sql.Connection;
import java.text.MessageFormat;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.browser.BrowserControl;
import jpos.capillary.DlgCapillaryPerson;
import jpos.kleber.KleberUtils;
import jpos.omneo.DlgOmneoPerson;
import jpos.person.PersonAttributes;
import jpos.person.PersonInterface;
import jpos.person.PersonInterfaceUtils;
import jpos.person.PersonSecurity;
import org.jdom.Element;

public class PersonDlg
extends PosDialog
implements AutoCloseable {
    private static final int WIDTH = 980;
    private static final int DEBUG_WIDTH = 800;
    private BrowserControl browserControl;
    private Element person;
    private Element locn;
    private PersonInterface personInterface;
    private boolean attachRequested = false;
    private boolean suppressOmneoPersonMaint = false;

    public PersonDlg(PosFrame frame, String title, Element pPerson, boolean[] pLoyalSec, boolean[] pSalesRepSec, long accountCustidx, boolean loadPersonFromElement) throws Exception {
        this(frame, title, pPerson, pLoyalSec, pSalesRepSec, accountCustidx, loadPersonFromElement, SP.getRS("Attach"));
    }

    public PersonDlg(PosFrame frame, String title, Element pPerson, boolean[] pLoyalSec, boolean[] pSalesRepSec, long accountCustidx, boolean loadPersonFromElement, String attachButtonLabel) throws Exception {
        super(frame, title, true);
        this.setResizable(false);
        this.person = pPerson;
        Connection conn = null;
        try {
            conn = StoreParams.createNewConnection();
            this.personInterface = new PersonInterface(this, accountCustidx > 0L ? String.valueOf(accountCustidx) : "", this.person, new PersonAttributes(), StoreParams.createNewConnection(), KleberUtils.getInstance(this.sParams), new PersonSecurity(frame.getUser(), pLoyalSec, pSalesRepSec, frame), attachButtonLabel);
            if (loadPersonFromElement && !StringUtils.isNullOrEmpty(XMLUtils.getValue(this.person, "peridx"))) {
                this.personInterface.loadPerson(SP.sParams.checkIConn(), XMLUtils.getValue(this.person, "peridx"));
            }
            this.setLayout(new GridBagLayout());
            this.browserControl = new BrowserControl(true);
            this.browserControl.setBoundObject("viewType", 0);
            this.browserControl.setBoundObject("kleberUtils", new KleberUtils(this.sParams));
            this.browserControl.setBoundObject("personInterface", this.personInterface);
            this.browserControl.getBrowser().navigation().set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
                if (params.url().startsWith("mailto:") && Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop != null) {
                        try {
                            URI uri = new URI(params.url());
                            desktop.mail(uri);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return StartNavigationCallback.Response.ignore();
                }
                return StartNavigationCallback.Response.start();
            }));
            if (!Settings.showBrowserDebugger()) {
                this.browserControl.getBrowser().on(ConsoleMessageReceived.class, event -> {
                    ConsoleMessage consoleMessage = event.consoleMessage();
                    if (consoleMessage.level() == ConsoleMessageLevel.LEVEL_ERROR) {
                        PosUtils.logError("Error in Person Maintenance UI: " + consoleMessage.message() + "\nLine: " + consoleMessage.lineNumber() + "\n" + consoleMessage.source());
                    }
                });
            }
            this.add((Component)this.browserControl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.resizeDialog(frame, Settings.showBrowserDebugger() ? 1780 : 980, 0.9f);
            this.browserControl.initialiseSplitterPosition(1, 980);
            this.browserControl.requestViewFocus();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            if (this.personInterface != null) {
                this.personInterface.close();
            }
            if (this.browserControl != null) {
                this.browserControl.disposeBrowserObjects();
            }
            throw e;
        }
    }

    private void loadPage() {
        if (Settings.getReactAppPort() > 0) {
            this.browserControl.loadURL("http://127.0.0.1:" + Settings.getReactAppPort());
        } else {
            this.browserControl.loadFromJar("/jpos/browser/react_app/build/index.html");
        }
    }

    @Override
    public void cancelDialog() {
        this.attachRequested = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.attachRequested = true;
        this.dispose();
    }

    public boolean isAttachRequested() {
        return this.attachRequested;
    }

    public void suppressOmneoPersonMaint(boolean suppressOmneoPersonMaint) {
        this.suppressOmneoPersonMaint = suppressOmneoPersonMaint;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.frParent.isAlternativePersonMaintEnabled() && !this.suppressOmneoPersonMaint) {
            if (this.frParent.isOmneoPersonMaintEnabled()) {
                if (!this.loadOmneoPersonView()) {
                    this.loadPage();
                    super.setVisible(true);
                }
            } else if (this.frParent.isCapillaryPersonMaintEnabled() && !this.loadCapillaryPersonView()) {
                this.loadPage();
                super.setVisible(true);
            }
        } else {
            if (visible) {
                this.loadPage();
            }
            super.setVisible(visible);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadOmneoPersonView() {
        try (DlgOmneoPerson dlg = new DlgOmneoPerson(this.frParent);){
            long selectedPeridx;
            if (this.person.getAttribute("peridx") != null) {
                long peridx = 0L;
                try {
                    peridx = this.person.getAttribute("peridx").getLongValue();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                dlg.setPersonFromAp21(peridx);
            }
            dlg.loadPage();
            dlg.setVisible(true);
            if (dlg.hasFailedToLoad()) {
                boolean peridx = false;
                return peridx;
            }
            if (!dlg.isPersonSelected()) {
                this.attachRequested = false;
                boolean peridx = true;
                return peridx;
            }
            String docketNumber = StringUtils.nullToEmpty(dlg.getDocketNumber());
            if (docketNumber.length() > 0) {
                if (docketNumber.toUpperCase().startsWith("D")) {
                    docketNumber = docketNumber.substring(1);
                }
                if (!this.frParent.populate(docketNumber)) {
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cant_find_transaction_in_ap21"), docketNumber, "\n"), SP.getRS("cant_find_transaction_in_ap21_title"));
                }
            }
            if ((selectedPeridx = dlg.getPersonId()) != 0L) {
                if (!this.personInterface.loadPerson(SP.sParams.checkIConn(), String.valueOf(selectedPeridx))) return true;
                this.attachRequested = true;
                return true;
            }
            String cardNumber = StringUtils.nullToEmpty(dlg.getCardNumber());
            if (cardNumber.length() <= 0) return true;
            DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cant_find_person_in_ap21"), cardNumber, "\n"), SP.getRS("cant_find_person_in_ap21_title"));
            this.attachRequested = false;
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadCapillaryPersonView() {
        try (DlgCapillaryPerson dlg = new DlgCapillaryPerson(this.frParent);){
            if (this.person.getAttribute("peridx") != null) {
                long peridx = 0L;
                try {
                    peridx = this.person.getAttribute("peridx").getLongValue();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                dlg.setPersonFromAp21(peridx);
            }
            dlg.loadPage();
            dlg.setVisible(true);
            if (dlg.hasFailedToLoad()) {
                boolean peridx = false;
                return peridx;
            }
            if (!dlg.isPersonSelected()) {
                this.attachRequested = false;
                boolean peridx = true;
                return peridx;
            }
            long selectedPeridx = dlg.getPersonId();
            String externalId = StringUtils.nullToEmpty(dlg.getExternalId());
            this.frParent.setCapillaryCustomer(dlg.getCapillaryCustomer());
            if (selectedPeridx != 0L) {
                if (!this.personInterface.loadPerson(SP.sParams.checkIConn(), String.valueOf(selectedPeridx))) return true;
                this.attachRequested = true;
                return true;
            }
            this.attachRequested = false;
            if (externalId.length() <= 0) return true;
            String custJson = dlg.getCustomerJson();
            if (custJson != null && custJson.length() > 0) {
                Element capillaryPerson = new Element("person");
                PersonInterfaceUtils.ContextContainer container = new PersonInterfaceUtils.ContextContainer();
                if (!this.personInterface.utils.CreateCapillaryPerson(custJson, capillaryPerson, container)) return true;
                if (container.context != null) {
                    this.personInterface.context = container.context;
                    selectedPeridx = Long.parseLong(this.personInterface.context.perIdx);
                } else {
                    selectedPeridx = capillaryPerson.getAttribute("peridx").getLongValue();
                }
                if (selectedPeridx == 0L) return true;
                if (!this.personInterface.loadPerson(SP.sParams.checkIConn(), String.valueOf(selectedPeridx))) return true;
                this.attachRequested = true;
                return true;
            }
            DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cant_find_person_in_ap21"), externalId, "\n"), SP.getRS("cant_find_person_in_ap21_title"));
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    private void resizeDialog(Window frParent, int width, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = (int)((float)parentRect.x + (float)parentRect.width / 2.0f - (float)width / 2.0f);
        int y = (int)((float)parentRect.y + (float)parentRect.height / 2.0f - (float)height / 2.0f);
        this.setBounds(x, y, width, height);
    }

    @Override
    public void close() throws Exception {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
        if (this.personInterface != null) {
            this.personInterface.close();
        }
    }

    @Override
    public boolean this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 82 || !e.isControlDown() || !Settings.showBrowserDebugger()) {
            return false;
        }
        this.browserControl.reload();
        return true;
    }

    public void showMessage(String message) {
        DlgMessage.showMessage(this, message);
    }
}

