/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.teamdev.jxbrowser.js.JsArray;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import jpos.DlgHistoryFilter;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.HistoryOptions;
import jpos.HistoryOptionsBuilder;
import jpos.PaSales;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.UareU.UareUFingerprintProvider;
import jpos.XMLLocal;
import jpos.XMLUtils;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.AuthenticationToken;
import jpos.basscom.utils.Utils;
import jpos.browser.ListWrapper;
import jpos.capillary.CapillaryCustomer;
import jpos.capillary.CapillaryResult;
import jpos.capillary.CapillaryUtils;
import jpos.crypt.PersonCrypt;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.kleber.KleberUtils;
import jpos.person.DlgEditLoyalty;
import jpos.person.DlgPersonSearchResult;
import jpos.person.DlgPickAddress;
import jpos.person.JSPerson;
import jpos.person.PersonAttributes;
import jpos.person.PersonContext;
import jpos.person.PersonSecurity;
import jpos.person.PersonUtils;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsAdjustDlg;
import jpos.rewards.RewardsAdjustType;
import jpos.rewards.RewardsApiFactory;
import jpos.rewards.RewardsProgram;
import jpos.rewards.RewardsUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class PersonInterfaceUtils {
    private PosFrame frParent;
    private PosDialog parent;
    private String accountCustIdx;
    private PersonAttributes attributes;
    private boolean enforcePhoneValidation = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_PHONE_NUM_VALIDATION);
    private long emailOrPhoneMandatory = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MANDATORY_PERSON_EMAIL);
    private long emailMandatoryWhenMarketingTicked = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.EMAIL_MANDATORY_WHEN_MARKETING_TICKED);
    private boolean usingRewards = RewardsUtils.usingAp21RetailRewards();
    private Vector<RewardsProgram> rewardPrograms = RewardsProgram.getAllPrograms();
    private boolean showHistory = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DISPLAY_POS_PERSON_SPENDING);
    private PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private KleberUtils kleberUtils;
    private Connection localConn;
    private PersonSecurity security;

    public PersonInterfaceUtils(PosDialog parent, PersonAttributes attributes, String accountCustIdx, KleberUtils kleberUtils, Connection localConn, PersonSecurity security) {
        this.parent = parent;
        this.frParent = parent.frParent;
        this.accountCustIdx = accountCustIdx;
        this.attributes = attributes;
        this.kleberUtils = kleberUtils;
        this.localConn = localConn;
        this.security = security;
    }

    private boolean validatePersonName(String name, boolean enforce) {
        if (!SP.sParams.bEnforceFormatting) {
            return true;
        }
        if (enforce) {
            return name.matches("[A-Z][ a-zA-Z'&/-]*");
        }
        return name.matches("[a-zA-Z0-9][ a-zA-Z0-9'&/-]*");
    }

    private boolean hasChanged(String value1, String value2) {
        return !StringUtils.nullToEmpty(value2).equals(StringUtils.nullToEmpty(value1));
    }

    private String cleanPhoneNumber(String text) {
        return text.replaceAll("[^+\\d.]", "");
    }

    public String getCleanPhoneNumber(String phone) {
        phone = StringUtils.nullToEmpty(phone);
        if (this.enforcePhoneValidation) {
            return this.cleanPhoneNumber(phone);
        }
        return phone;
    }

    public boolean isPhoneNumberValid(String phone, String countryCode) {
        if (!this.enforcePhoneValidation) {
            return true;
        }
        if (StringUtils.isNullOrEmpty(phone) || StringUtils.isNullOrEmpty(countryCode)) {
            return true;
        }
        try {
            Phonenumber.PhoneNumber number = this.phoneUtil.parse((CharSequence)phone, countryCode);
            return this.phoneUtil.isValidNumber(number);
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    public String getPhoneNumberWithInternationalPrefix(String phoneNum, String countryCode) {
        if (StringUtils.isNullOrEmpty(countryCode)) {
            return phoneNum;
        }
        try {
            Phonenumber.PhoneNumber numberProto = this.phoneUtil.parse((CharSequence)phoneNum, countryCode);
            return this.phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            return phoneNum;
        }
    }

    private boolean validateState(String state, String countryName) {
        boolean bOk = false;
        int count = 0;
        try (SqlQuery qry = new SqlQuery(this.localConn, "SELECT DISTINCT(UPPER(COALESCE(STATE,''))) FROM POSTCODE WHERE UPPER(COUNTRY) = ? ", countryName.toUpperCase());){
            while (qry.next()) {
                ++count;
                if (!qry.getString(1).equals(state.toUpperCase())) continue;
                bOk = true;
                break;
            }
            if (count == 0) {
                bOk = true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return bOk;
    }

    private boolean isInternalUserCode(String code) {
        String user = StringUtils.nullToEmpty(code).trim().toUpperCase();
        return user.equals("BASS") || user.equals("SYS") || user.equals("WORKFLOW") || user.equals("PRINTSVR");
    }

    private boolean validatePerson(PersonContext context, JSPerson person) {
        if (StringUtils.isNullOrEmpty(person.getFirstName())) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("You_must_enter_a3"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (!this.validatePersonName(person.getFirstName(), person.getEnforceFormatting())) {
            if (person.getEnforceFormatting()) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Name_Validation"), StoreParams.res.getString("Stop"), 0);
            } else {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Name_Digit_Validation"), StoreParams.res.getString("Stop"), 0);
            }
            return false;
        }
        if (StringUtils.isNullOrEmpty(person.getSurname())) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("You_must_enter_a3"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (!this.validatePersonName(person.getSurname(), person.getEnforceFormatting())) {
            if (person.getEnforceFormatting()) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Name_Validation"), StoreParams.res.getString("Stop"), 0);
            } else {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Name_Digit_Validation"), StoreParams.res.getString("Stop"), 0);
            }
            return false;
        }
        switch (EmailPhoneValidation.values()[(int)this.emailOrPhoneMandatory]) {
            case NotMandatory: {
                break;
            }
            case Email: {
                if (!StringUtils.isNullOrEmpty(person.getEmail())) break;
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Email_Mandatory"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            case Phone: {
                if (!StringUtils.isNullOrEmpty(person.getMainPhone())) break;
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Phone_Mandatory"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            case Both: {
                if (!StringUtils.isNullOrEmpty(person.getEmail()) && !StringUtils.isNullOrEmpty(person.getMainPhone())) break;
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Email_And_Phone_Mandatory"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            case Either: {
                if (!StringUtils.isNullOrEmpty(person.getEmail()) || !StringUtils.isNullOrEmpty(person.getMainPhone())) break;
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Email_Or_Phone_Mandatory"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            default: {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("Enforce_Phone_Num_Validation_Out_Of_Range"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        String mainPhone = this.getCleanPhoneNumber(person.getMainPhone());
        String countryCode = this.attributes.getCountryCode(person.getCountry());
        if (this.hasChanged(context.mainPhone, mainPhone) && this.enforcePhoneValidation && !this.isPhoneNumberValid(mainPhone, this.attributes.getCountryCode(person.getCountry()))) {
            DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("Invalid_Contact"), person.getCountry()), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (this.hasChanged(context.email, person.getEmail()) && !StringUtils.isNullOrEmpty(person.getEmail()) && !SP.sParams.getEmailValidator().validate(person.getEmail())) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("Email_must_have_@"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        boolean isNZ = countryCode.equals("NZ");
        if (!person.isAddressValidated()) {
            if (!StringUtils.isNullOrEmpty(person.getAddress1())) {
                if (Settings.isPostcodeMandatory()) {
                    if (StringUtils.isNullOrEmpty(person.getCity())) {
                        DlgMessage.showMessage(this.parent, StoreParams.res.getString("City_validation"), StoreParams.res.getString("Stop"), 0);
                        return false;
                    }
                    if (!isNZ && StringUtils.isNullOrEmpty(person.getState())) {
                        DlgMessage.showMessage(this.parent, StoreParams.res.getString("State_validation"), StoreParams.res.getString("Stop"), 0);
                        return false;
                    }
                    if (!isNZ && !StringUtils.isNullOrEmpty(person.getState()) && Settings.isStateValidation() && !this.validateState(person.getState(), person.getCountry())) {
                        DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("State_Value_Not_Valid"), person.getState()), StoreParams.res.getString("Stop"), 0);
                        return false;
                    }
                    if (StringUtils.isNullOrEmpty(person.getPostcode())) {
                        DlgMessage.showMessage(this.parent, StoreParams.res.getString("Post_code_validation"), StoreParams.res.getString("Stop"), 0);
                        return false;
                    }
                } else if (StringUtils.isNullOrEmpty(person.getCity())) {
                    DlgMessage.showMessage(this.parent, StoreParams.res.getString("City_validation"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
            }
            if (!StringUtils.isNullOrEmpty(person.getAddress2()) && StringUtils.isNullOrEmpty(person.getAddress1())) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("AddLine2_validation"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!isNZ && !StringUtils.isNullOrEmpty(person.getState()) && Settings.isStateValidation() && !this.validateState(person.getState(), person.getCountry())) {
                DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("State_Value_Not_Valid"), person.getState()), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!StringUtils.isNullOrEmpty(person.getCity()) && Settings.isPostcodeMandatory()) {
                if (!isNZ && StringUtils.isNullOrEmpty(person.getState())) {
                    DlgMessage.showMessage(this.parent, StoreParams.res.getString("State_validation"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
                if (StringUtils.isNullOrEmpty(person.getPostcode())) {
                    DlgMessage.showMessage(this.parent, StoreParams.res.getString("Post_code_validation"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
            }
        }
        if (person.getCity().length() > 50) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("City_length_validation"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (!StringUtils.isNullOrEmpty(person.getMemName())) {
            Pattern pattern = Pattern.compile("\\s");
            if (pattern.matcher(person.getMemName()).find()) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("SCode_Cannot_Have_Whitespace"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!person.getMemName().toUpperCase().equals(StringUtils.nullToEmpty(context.memName).toUpperCase()) && this.isInternalUserCode(person.getMemName())) {
                DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("Internal_Memname_Not_Allowed"), person.getMemName().toUpperCase().trim()), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        return true;
    }

    private boolean hasAddressChanged(PersonContext context, JSPerson person) {
        return this.hasChanged(context.address1, person.getAddress1()) || this.hasChanged(context.address2, person.getAddress2()) || this.hasChanged(context.city, person.getCity()) || this.hasChanged(context.state, person.getState()) || this.hasChanged(context.postcode, person.getPostcode()) || this.hasChanged(StringUtils.nullToEmpty(context.country).toUpperCase(Locale.ROOT), StringUtils.nullToEmpty(person.getCountry()).toUpperCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyAddress(JSPerson person) {
        try {
            block34: {
                boolean verificationRequired;
                this.parent.setCursor(StoreParams.waitCursor);
                String countryCode = this.attributes.getCountryCode(person.getCountry());
                boolean bl = verificationRequired = this.kleberUtils.AddressValidationEnabledForCountry(countryCode) && !person.isAddressValidated() && person.getAddress1() != null && !person.getAddress1().trim().isEmpty() && person.getCity() != null && !person.getCity().trim().isEmpty();
                if (!verificationRequired) break block34;
                KleberModels.DtResponse.Address req = new KleberModels.DtResponse.Address();
                req.AddressLine1 = person.getAddress1();
                req.AddressLine2 = person.getAddress2();
                req.City = person.getCity();
                req.State = person.getState();
                req.Postcode = person.getPostcode();
                req.Country = countryCode;
                KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> response = this.kleberUtils.VerifyAddress(req, countryCode);
                this.parent.setCursor(StoreParams.normalCursor);
                if (response.DtResponse.ResultCount <= 0) return false;
                KleberModels.DtResponse.AddressVerifyResult result = (KleberModels.DtResponse.AddressVerifyResult)response.DtResponse.Result.get(0);
                switch (result.MatchType) {
                    case Correct: {
                        if (result.addressChanged) {
                            KleberModels.DtResponse.Address newAddress = new KleberModels.DtResponse.Address();
                            newAddress.AddressLine1 = result.AddressLine1;
                            newAddress.AddressLine2 = result.AddressLine2;
                            newAddress.City = result.City;
                            newAddress.State = result.State;
                            newAddress.Postcode = result.Postcode;
                            newAddress.Country = result.Country;
                            if (newAddress.AddressLine1.trim().equalsIgnoreCase(req.AddressLine1.trim()) && newAddress.AddressLine2.trim().equalsIgnoreCase(req.AddressLine2.trim()) && newAddress.City.trim().equalsIgnoreCase(req.City.trim()) && newAddress.State.trim().equalsIgnoreCase(req.State.trim()) && newAddress.Postcode.trim().equalsIgnoreCase(req.Postcode.trim())) {
                                person.updateAddress(newAddress.AddressLine1, newAddress.AddressLine2, newAddress.City, newAddress.State, newAddress.Postcode);
                                boolean bl2 = true;
                                return bl2;
                            }
                            DlgPickAddress dlg = new DlgPickAddress(this.frParent, (JDialog)this.parent, newAddress, req);
                            try {
                                switch (dlg.getResult()) {
                                    case CANCEL: {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    case OLD: {
                                        boolean bl4 = true;
                                        return bl4;
                                    }
                                    case NEW: {
                                        person.updateAddress(newAddress.AddressLine1, newAddress.AddressLine2, newAddress.City, newAddress.State, newAddress.Postcode);
                                        boolean bl5 = true;
                                        return bl5;
                                    }
                                }
                            }
                            finally {
                                dlg.dispose();
                                dlg = null;
                            }
                        }
                        boolean bl6 = true;
                        return bl6;
                    }
                    case PhantomPrimaryPoint: {
                        if (DlgMessage.showMessage(this.frParent, SP.getRS("Phantom_Primary_Point"), StoreParams.res.getString("Address_Validation"), 0, 3) != 0) {
                            boolean bl7 = true;
                            return bl7;
                        }
                        boolean bl8 = false;
                        return bl8;
                    }
                }
                if (DlgMessage.showMessage(this.frParent, SP.getRS("Could_Not_Verify_Address"), StoreParams.res.getString("Address_Validation"), 0, 3) != 0) return false;
                boolean bl9 = true;
                return bl9;
            }
            boolean bl = true;
            return bl;
        }
        catch (KleberApiException e) {
            boolean bl;
            this.parent.setCursor(StoreParams.normalCursor);
            if (e.getCause() instanceof SocketTimeoutException) {
                if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Address_Verify_Failure"), StoreParams.res.getString("Kleber_Timeout"), 0, 3) != 0) return false;
                bl = true;
                return bl;
            }
            if (e.getCause() instanceof UnknownHostException) {
                if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Address_Verify_Failure"), StoreParams.res.getString("Kleber_Connection_Failed"), 0, 3) != 0) return false;
                bl = true;
                return bl;
            }
            PosUtils.logError(e);
            return false;
        }
        finally {
            this.parent.setCursor(StoreParams.normalCursor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildXml(JSPerson jsPerson, Element person, PersonContext context, boolean active) {
        Element references;
        person.removeAttribute("loaded_offline");
        person.setAttribute("upmemidx", String.valueOf(this.frParent.getUser().getMemidx()));
        person.setAttribute("firstname", jsPerson.getFirstName());
        person.setAttribute("surname", jsPerson.getSurname());
        person.setAttribute("dob", jsPerson.getDob());
        person.setAttribute("jobtitle", jsPerson.getJobTitle());
        person.setAttribute("privacy", jsPerson.isPrivacy() ? "1" : "0");
        person.setAttribute("tax_exemptidx", jsPerson.getTaxExemptionReasonIdx());
        person.setAttribute("tax_exempt_certificate", jsPerson.getTaxExemptionCertificate());
        if (this.frParent.frameType == 10 && !StringUtils.isNullOrEmpty(this.accountCustIdx)) {
            person.setAttribute("custidx", this.accountCustIdx);
        }
        person.setAttribute("sex", jsPerson.getSex());
        person.setAttribute("active", active ? "1" : "0");
        Element locn = person.getChild("locn");
        if (locn == null) {
            locn = new Element("locn");
            person.addContent((Content)locn);
        }
        locn.setAttribute("adrs1", jsPerson.getAddress1());
        locn.setAttribute("adrs2", jsPerson.getAddress2());
        locn.setAttribute("city", jsPerson.getCity());
        locn.setAttribute("state", jsPerson.getState());
        locn.setAttribute("postcode", jsPerson.getPostcode());
        locn.setAttribute("country", jsPerson.getCountry());
        Element phone = PersonUtils.getPhone(person, PersonUtils.PhoneType.MAIN);
        if (phone != null) {
            phone.setText(this.getCleanPhoneNumber(jsPerson.getMainPhone()));
        } else {
            phone = new Element("phonenum");
            phone.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.MAIN.getDatabaseValue()));
            phone.setText(this.getCleanPhoneNumber(jsPerson.getMainPhone()));
            locn.addContent((Content)phone);
        }
        Element work = PersonUtils.getPhone(person, PersonUtils.PhoneType.WORK);
        if (work != null) {
            work.setText(this.getCleanPhoneNumber(jsPerson.getWorkPhone()));
        } else if (!this.getCleanPhoneNumber(jsPerson.getWorkPhone()).equals("")) {
            work = new Element("phonenum");
            work.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.WORK.getDatabaseValue()));
            work.setText(this.getCleanPhoneNumber(jsPerson.getWorkPhone()));
            locn.addContent((Content)work);
        }
        Element other = PersonUtils.getPhone(person, PersonUtils.PhoneType.OTHER);
        if (other != null) {
            other.setText(this.getCleanPhoneNumber(jsPerson.getOtherPhone()));
        } else if (!this.getCleanPhoneNumber(jsPerson.getOtherPhone()).equals("")) {
            other = new Element("phonenum");
            other.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.OTHER.getDatabaseValue()));
            other.setText(this.getCleanPhoneNumber(jsPerson.getOtherPhone()));
            locn.addContent((Content)other);
        }
        Element email = PersonUtils.getPhone(person, PersonUtils.PhoneType.EMAIL);
        boolean hasEmailChanged = this.hasChanged(email != null ? email.getText() : "", jsPerson.getEmail());
        if (email != null) {
            email.setText(jsPerson.getEmail());
        } else if (!StringUtils.isNullOrEmpty(jsPerson.getEmail())) {
            email = new Element("phonenum");
            email.setAttribute("phonetyidx", String.valueOf(PersonUtils.PhoneType.EMAIL.getDatabaseValue()));
            email.setText(jsPerson.getEmail());
            locn.addContent((Content)email);
        }
        if (email != null) {
            email.setAttribute("email_changed", String.valueOf(hasEmailChanged));
        }
        if ((references = person.getChild("references")) == null) {
            references = new Element("references");
            person.addContent((Content)references);
        }
        for (String string : this.attributes.getReferenceOrds().getList()) {
            PersonAttributes.ReferenceGroup group = this.attributes.getReferenceGroup(string);
            if (!group.isEditable()) continue;
            String rcidx = jsPerson.getReferences().get(string);
            if (!StringUtils.isNullOrEmpty(rcidx)) {
                references.setAttribute("ref" + string, rcidx);
                continue;
            }
            references.removeAttribute("ref" + string);
        }
        Element customData = person.getChild("custom_data");
        if (customData != null) {
            person.removeContent((Content)customData);
        }
        customData = new Element("custom_data");
        person.addContent((Content)customData);
        for (PersonAttributes.CustomDataTemplate template : this.attributes.getCustomDataTemplates().getList()) {
            Element card = new Element("card");
            card.setAttribute("template_idx", template.getId());
            card.setAttribute("template_name", StringUtils.nullToEmpty(template.getName()));
            customData.addContent((Content)card);
            for (PersonAttributes.CustomDataField field : template.getFields().getList()) {
                Element fieldElement = new Element("field");
                fieldElement.setAttribute("field_idx", field.getId());
                fieldElement.setAttribute("field_name", StringUtils.nullToEmpty(field.getName()));
                fieldElement.setAttribute("type", field.getType());
                card.addContent((Content)fieldElement);
                String[] values = jsPerson.getCustomData().get(field.getId());
                if ("TagList".equals(field.getType())) {
                    fieldElement.setAttribute("tag_type", field.getListControlType());
                    fieldElement.setAttribute("list_idx", StringUtils.nullOrEmptyToValue(field.getRgIdx(), field.getCustomListIdx()));
                    for (String value : values) {
                        Element tag = new Element("tag");
                        tag.setAttribute("idx", value);
                        fieldElement.addContent((Content)tag);
                    }
                    continue;
                }
                fieldElement.setAttribute("value", values != null && values.length > 0 ? values[0] : "");
            }
        }
        if (!StringUtils.isNullOrEmpty(jsPerson.getMemName())) {
            void var13_17;
            Element element = person.getChild("member");
            if (element == null) {
                Element element2 = new Element("member");
                person.addContent((Content)element2);
            }
            if (this.security.getSalesRepSec(2) && !this.isInternalUserCode(jsPerson.getMemName())) {
                var13_17.setAttribute("memname", jsPerson.getMemName());
                var13_17.setAttribute("memfull", jsPerson.getFirstName() + " " + jsPerson.getSurname());
                var13_17.setAttribute("email", jsPerson.getEmail());
                if (!StringUtils.isNullOrEmpty(jsPerson.getMemPass()) || var13_17.getAttribute("memidx") == null) {
                    var13_17.setAttribute("mempwd", Utils.encrypt(jsPerson.getMemPass().toUpperCase()));
                    AuthenticationToken authToken = new AuthenticationToken();
                    if (authToken.initialise(jsPerson.getMemName(), jsPerson.getMemPass())) {
                        var13_17.setAttribute("memtoken", authToken.generateToken());
                    } else {
                        var13_17.setAttribute("memtoken", "FAILED");
                    }
                }
            } else if (var13_17.getAttribute("memfull") != null) {
                var13_17.removeAttribute("memfull");
            }
        } else {
            person.removeChild("member");
        }
        person.removeChildren("perloyalty");
        DecimalFormat decimalFormat = new DecimalFormat("#");
        decimalFormat.setMaximumFractionDigits(4);
        for (int i = 0; i < jsPerson.getLoyalties().size(); ++i) {
            Element loyalty = new Element("perloyalty");
            PersonContext.Loyalty loyal = jsPerson.getLoyalties().get(i);
            loyalty.setAttribute("rcidx", String.valueOf(loyal.loyaltyIdx));
            loyalty.setText(loyal.loyaltyCode);
            if (loyal.expiryDate.getTimestamp() != null) {
                loyalty.setAttribute("expiry", loyal.expiryDate.getTimestamp().toString());
            } else {
                loyalty.setAttribute("expiry", "");
            }
            if (loyal.cardId != 0L) {
                loyalty.setAttribute("loyalidx", String.valueOf(loyal.cardId));
            }
            if (!loyal.cardNumber.equals("")) {
                loyalty.setAttribute("cardno", loyal.cardNumber);
            }
            if (loyal.balance != 0.0) {
                loyalty.setAttribute("ltot", decimalFormat.format(loyal.balance));
            }
            if (loyal.creditStatusBalance != 0.0) {
                loyalty.setAttribute("credit_status", decimalFormat.format(loyal.creditStatusBalance));
            }
            if (loyal.widx != 0L) {
                loyalty.setAttribute("widx", String.valueOf(loyal.widx));
            }
            if (loyal.pos_idx != 0L) {
                loyalty.setAttribute("pos_idx", String.valueOf(loyal.pos_idx));
            }
            person.addContent((Content)loyalty);
        }
        long cardId = 0L;
        for (int i = 0; i < context.loyalties.size(); ++i) {
            cardId = context.loyalties.get((int)i).cardId;
            if (!this.isLoyaltyDeleted(cardId, jsPerson.getLoyalties())) continue;
            Element loyalty = new Element("perloyalty");
            loyalty.setAttribute("loyalidx", String.valueOf(cardId));
            person.addContent((Content)loyalty);
        }
    }

    private boolean isLoyaltyDeleted(long cardId, List<PersonContext.Loyalty> loyalties) {
        for (int i = 0; i < loyalties.size(); ++i) {
            if (loyalties.get((int)i).cardId != cardId) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaveResult save(boolean online, JSPerson jsPerson, Element person, ContextContainer container) {
        SaveResult saveResult = new SaveResult();
        try {
            Element loyalty;
            this.parent.setCursor(StoreParams.waitCursor);
            XMLOutputter printer = new XMLOutputter();
            boolean queryResult = true;
            if (online) {
                Element prefetch = SP.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(person) + "\u0003prefetch").getXML();
                if (prefetch == null) {
                    SaveResult saveResult2 = saveResult;
                    return saveResult2;
                }
                if (!prefetch.getAttributes().isEmpty()) {
                    if (prefetch.getAttribute("peridx") != null) {
                        person.setAttribute("prefetch_peridx", prefetch.getAttributeValue("peridx"));
                        person.getChild("locn").setAttribute("prefetch_locnidx", prefetch.getAttributeValue("locnidx"));
                        Element phoneNumbers = prefetch.getChild("phonenumbers");
                        if (phoneNumbers != null) {
                            for (Element prefetchPhoneNum : phoneNumbers.getChildren()) {
                                Element phoneNum = (Element)XPath.selectSingleNode((Object)person, (String)("locn/phonenum[@phonetyidx='" + prefetchPhoneNum.getAttributeValue("phonetyidx") + "']"));
                                if (phoneNum == null) continue;
                                phoneNum.setAttribute("prefetch_phonenumidx", prefetchPhoneNum.getAttributeValue("phonenumidx"));
                            }
                        }
                    }
                    if (prefetch.getAttribute("memidx") != null) {
                        person.getChild("member").setAttribute("prefetch_memidx", prefetch.getAttributeValue("memidx"));
                    }
                    if (prefetch.getAttribute("loyalidx") != null) {
                        List loyalties = person.getChildren("perloyalty");
                        String[] idxes = prefetch.getAttributeValue("loyalidx").split(",");
                        int pos = 0;
                        block13: for (int i = 0; i < idxes.length; ++i) {
                            while (pos < loyalties.size()) {
                                if ((loyalty = (Element)loyalties.get(pos++)).getAttribute("loyalidx") != null) continue;
                                loyalty.setAttribute("prefetch_loyalidx", idxes[i]);
                                continue block13;
                            }
                        }
                    }
                }
                SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(person) + "\u0003" + SP.sParams.getStoreIdx()).getXML();
                if (SP.sParams.root == null) {
                    queryResult = false;
                }
            } else {
                queryResult = SP.sParams.getXML(this.frParent, "saveperson", printer.outputString(person) + "\u0003" + SP.sParams.getStoreIdx(), false);
            }
            if (queryResult) {
                Object[] objs;
                Element idxs = SP.sParams.root;
                if (idxs.getName().equals("people")) {
                    SaveResult loadedPerson;
                    objs = new Object[]{StringUtils.isNullOrEmpty(jsPerson.getPerIdx()) ? "create" : "update", "\n", "\n", "\n", "\n"};
                    this.parent.setCursor(StoreParams.normalCursor);
                    if (DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("per_exists"), objs), StoreParams.res.getString("Stop"), 0, 3) == 0) {
                        if (idxs.getChildren("person").size() > 1) {
                            ArrayList<String> existingPeridxs = new ArrayList<String>();
                            for (Object p : idxs.getChildren("person")) {
                                Element per = (Element)p;
                                String currPeridx = XMLUtils.getValue(per, "peridx");
                                if (currPeridx.isEmpty()) continue;
                                existingPeridxs.add(currPeridx);
                            }
                            DlgPersonSearchResult.Result result = DlgPersonSearchResult.showDialog(this.frParent, this.parent, SP.getRS("Person_Search"), true, online, StringUtils.nullToEmpty(this.accountCustIdx), jsPerson.getFirstName(), jsPerson.getSurname(), jsPerson.getMainPhone(), jsPerson.getEmail(), "", existingPeridxs);
                            if (result.getButtonPressed() == DlgPersonSearchResult.Button.NEW) {
                                this.clearPerson(person);
                                container.context = new PersonContext();
                                this.prePopulateNewPerson(result, container.context);
                            } else if (result.getButtonPressed() == DlgPersonSearchResult.Button.OK && result.getPerIdx() != 0L) {
                                try {
                                    container.context = this.loadPerson(String.valueOf(result.getPerIdx()), online, person, null);
                                }
                                catch (Exception ex) {
                                    PosUtils.logError(ex);
                                }
                            }
                        } else {
                            loadedPerson = idxs.getChild("person");
                            long actualPeridx = XMLUtils.getLongValue((Element)loadedPerson, "pos_idx");
                            if (actualPeridx != 0L && XMLUtils.getLongValue((Element)loadedPerson, "widx") == SP.sParams.getStoreIdx()) {
                                loadedPerson.setAttribute("peridx", String.valueOf(actualPeridx));
                            }
                            container.context = this.loadPerson(String.valueOf(actualPeridx), online, person, (Element)loadedPerson);
                        }
                    }
                    saveResult.saveError = true;
                    if (!StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
                        saveResult.matchingError = true;
                    }
                    loadedPerson = saveResult;
                    return loadedPerson;
                }
                if (idxs.getChild("member") != null) {
                    if (idxs.getChild("member").getAttribute("error") != null) {
                        this.parent.setCursor(StoreParams.normalCursor);
                        if (idxs.getChild("member").getAttribute("error").getValue().equals("MEMNAME_IN_USE")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("sper_code_used"), objs), StoreParams.res.getString("Error"), 0);
                        } else if (idxs.getChild("member").getAttribute("error").getValue().equals("AUTH_TOKEN_FAILED")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.parent, StoreParams.res.getString("sper_auth_invalid"), StoreParams.res.getString("Error"), 0);
                        } else if (idxs.getChild("member").getAttribute("error").getValue().equals("MEMBER_LOGGED_INTO_HO")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.parent, StoreParams.res.getString("sper_logged_in_ho"), StoreParams.res.getString("Error"), 0);
                        } else if (idxs.getChild("member").getAttribute("error").getValue().equals("CANT_CREATE_MEMBER")) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("cant_create_member_offline"), objs), StoreParams.res.getString("Error"), 0);
                        } else {
                            DlgMessage.showMessage(this.parent, idxs.getChild("member").getAttribute("error").getValue(), StoreParams.res.getString("Error"), 0);
                        }
                        saveResult.saveError = true;
                        objs = saveResult;
                        return objs;
                    }
                    person.getChild("member").setAttribute(idxs.getChild("member").getAttribute("memidx").detach());
                    List grps = idxs.getChild("member").getChildren();
                    while (grps.size() > 0) {
                        person.getChild("member").addContent((Content)((Element)((Element)grps.get(0)).detach()));
                    }
                }
                person.setAttribute(idxs.getAttribute("peridx").detach());
                if (idxs.getChild("locn") != null) {
                    Element lidxs = idxs.getChild("locn");
                    person.getChild("locn").setAttribute(lidxs.getAttribute("locnidx").detach());
                    List phonenums = person.getChild("locn").getChildren("phonenum");
                    for (int i = 0; i < phonenums.size(); ++i) {
                        Element phonenum = (Element)phonenums.get(i);
                        if (phonenum.getAttribute("phonenumidx") != null) continue;
                        phonenum.setAttribute(PersonUtils.getPhone(idxs, PersonUtils.PhoneType.getPhoneType(phonenum.getAttribute("phonetyidx").getValue())).getAttribute("phonenumidx").detach());
                    }
                }
                List loyals = person.getChildren("perloyalty");
                List loyalidxs = idxs.getChildren("perloyalty");
                int idxsCnt = 0;
                for (int i = 0; i < loyals.size(); ++i) {
                    loyalty = (Element)loyals.get(i);
                    if (idxsCnt < loyalidxs.size() && ((Element)loyalidxs.get(idxsCnt)).getAttribute("error") != null) {
                        DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("cardNo_used"), loyalty.getAttributeValue("cardno"), "\n"), StoreParams.res.getString("Error"), 0);
                        saveResult.saveError = true;
                        SaveResult currPeridx = saveResult;
                        return currPeridx;
                    }
                    if (loyalty.getAttribute("rcidx") == null) continue;
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("loyalidx").detach());
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("cardno").detach());
                    ++idxsCnt;
                }
                Element customData = idxs.getChild("custom_data");
                if (customData != null) {
                    Element errors = customData.getChild("errors");
                    if (errors != null) {
                        StringBuilder errorBuilder = new StringBuilder();
                        for (Object error : errors.getChildren("error")) {
                            errorBuilder.append(((Element)error).getText());
                            errorBuilder.append('\n');
                        }
                        if (errorBuilder.length() > 0) {
                            DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("custom_data_save_warning"), "\n", errorBuilder.toString()), SP.getRS("Warning"), 2);
                        }
                        errors.detach();
                    }
                    person.removeChildren("custom_data");
                    person.addContent(customData.detach());
                }
                saveResult.success = true;
                SaveResult saveResult3 = saveResult;
                return saveResult3;
            }
            SaveResult saveResult4 = saveResult;
            return saveResult4;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            SaveResult saveResult5 = saveResult;
            return saveResult5;
        }
        finally {
            this.parent.setCursor(StoreParams.normalCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonContext loadPerson(String peridx, boolean online, Element personElement, Element personToLoad) {
        Element person = personToLoad;
        try {
            this.parent.setCursor(StoreParams.waitCursor);
            if (personToLoad == null) {
                if (online) {
                    person = SP.sParams.OnlineQueryProvider.getOnlineQuery("person", peridx + "," + SP.sParams.getStoreIdx(), false).getXML();
                    long actualPeridx = XMLUtils.getLongValue(person, "pos_idx");
                    if (actualPeridx != 0L && XMLUtils.getLongValue(person, "widx") == SP.sParams.getStoreIdx()) {
                        person.setAttribute("peridx", String.valueOf(actualPeridx));
                    }
                } else {
                    try {
                        person = XMLLocal.getElement(SP.sParams.conn, "person", peridx);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                        PersonContext personContext = null;
                        this.parent.setCursor(StoreParams.normalCursor);
                        return personContext;
                    }
                }
            }
            if (person == null || person.getAttribute("peridx") == null) {
                DlgMessage.showMessage(this.parent, SP.getRS("Person_Load_Failed"), SP.getRS("Error"), 0);
                PersonContext e = null;
                return e;
            }
            this.moveToPersonElement(person, personElement);
            PersonContext context = new PersonContext();
            PersonContext.updateContextFromPersonXml(personElement, context, this.attributes);
            RewardsAccount rewardsAccount = null;
            if (online && (this.showHistory || RewardsUtils.usingAp21RetailRewards()) && !PersonInterfaceUtils.isGuestAccount(personElement) && SP.sParams.checkIConn()) {
                Element history = SP.sParams.OnlineQueryProvider.getOnlineQuery("cust_hist", personElement.getAttribute("peridx").getValue() + "," + String.valueOf(SP.sParams.getStoreIdx()) + "," + String.valueOf(this.security.getRewardsHistorySec(0))).getXML();
                if (history != null) {
                    Element rewards;
                    if (this.showHistory) {
                        PersonContext.updateContextFromHistoryXml(history, context);
                        PersonContext.updateContextFromTransactionsXml(history, context);
                    }
                    if (RewardsUtils.usingAp21RetailRewards() && (rewards = history.getChild("rewards_account")) != null) {
                        rewardsAccount = new RewardsAccount();
                        rewardsAccount.loadFromXml(XMLUtils.getLongValue(personElement, "peridx"), rewards);
                        Element redemptiohHistory = rewards.getChild("redemption_history");
                        if (redemptiohHistory != null) {
                            PersonContext.updateContextFromRedemptionHistoryXml(redemptiohHistory, context);
                        }
                    }
                }
            } else if (RewardsUtils.usingAp21RetailRewards() && !PersonInterfaceUtils.isGuestAccount(personElement) && !SP.sParams.checkIConn()) {
                rewardsAccount = new RewardsAccount();
                rewardsAccount.loadOffline(XMLUtils.getLongValue(personElement, "peridx"));
            }
            if (rewardsAccount != null) {
                PersonContext.updateContextFromRewardsAccount(rewardsAccount, context);
                personElement.setAttribute(new Attribute("RewardsAccountIdx", String.valueOf(context.rewardsAccountIdx)));
                personElement.setAttribute(new Attribute("ImmediateRewardsProcessing", String.valueOf(context.rewardsProgramImmediatelyIssueRewards)));
            }
            if (online && PersonUtils.isLocalPersonOutOfDate(person)) {
                XMLOutputter printer = new XMLOutputter();
                SP.sParams.getXML(this.parent.frParent, "saveperson", printer.outputString(person) + "\u0003" + SP.sParams.getStoreIdx(), false);
            }
            PersonContext personContext = context;
            return personContext;
        }
        finally {
            this.parent.setCursor(StoreParams.normalCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offlineOnlySave(Element person) {
        boolean queryResult = false;
        if (PersonCrypt.getInstance().keyExists() || DlgMessage.showMessage(this.frParent, SP.getRS("Offline_Key_Check_Person", "\r\n"), SP.getRS("Offline_Key_Check_Person_Hdr"), 0, 2) == 0) {
            try {
                this.parent.setCursor(StoreParams.waitCursor);
                XMLOutputter printer = new XMLOutputter();
                queryResult = SP.sParams.getXML(this.frParent, "saveofflineperson", printer.outputString(person) + "\u0003" + SP.sParams.getStoreIdx(), false);
            }
            finally {
                this.parent.setCursor(StoreParams.normalCursor);
            }
        }
        if (!queryResult) {
            return false;
        }
        person.setAttribute((Attribute)SP.sParams.root.getAttribute("peridx").clone());
        person.setAttribute("loaded_offline", "true");
        List loyals = person.getChildren("perloyalty");
        List loyalidxs = SP.sParams.root.getChildren("perloyalty");
        int idxsCnt = 0;
        for (int i = 0; i < loyals.size(); ++i) {
            Element loyalty = (Element)loyals.get(i);
            if (idxsCnt < loyalidxs.size() && ((Element)loyalidxs.get(idxsCnt)).getAttribute("error") != null) {
                DlgMessage.showMessage(this.parent, MessageFormat.format(StoreParams.res.getString("cardNo_used"), loyalty.getAttributeValue("cardno"), "\n"), StoreParams.res.getString("Error"), 0);
                return false;
            }
            if (loyalty.getAttribute("rcidx") == null) continue;
            loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("loyalidx").detach());
            loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("cardno").detach());
            ++idxsCnt;
        }
        return true;
    }

    private void moveToPersonElement(Element element, Element personElement) {
        try {
            personElement.getChildren().clear();
            personElement.getAttributes().clear();
            List contents = element.getChildren();
            while (contents.size() > 0) {
                personElement.addContent((Content)((Element)((Element)contents.get(0)).detach()));
            }
            List attributes = element.getAttributes();
            while (attributes.size() > 0) {
                personElement.setAttribute(((Attribute)attributes.get(0)).detach());
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public void clearPerson(Element personElement) {
        personElement.getChildren().clear();
        personElement.getAttributes().clear();
    }

    public void prePopulateNewPerson(DlgPersonSearchResult.Result result, PersonContext context) {
        context.firstName = PersonInterfaceUtils.toProperCase(result.getFirstName());
        context.surname = PersonInterfaceUtils.surnameExceptions(result.getSurname());
        context.postcode = result.getPostCode();
        context.email = result.getEmail();
        context.mainPhone = result.getPhone();
    }

    private void cleanPerson(Element person) {
        int i;
        int i2;
        List attributes = person.getAttributes();
        for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
            if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
            person.removeAttribute((Attribute)attributes.get(i2));
        }
        if (person.getChild("locn") != null) {
            attributes = person.getChild("locn").getAttributes();
            for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
                if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
                person.getChild("locn").removeAttribute((Attribute)attributes.get(i2));
            }
            List phonenums = person.getChild("locn").getChildren("phonenum");
            for (i = phonenums.size() - 1; i >= 0; --i) {
                if (!((Element)phonenums.get(i)).getText().equals("")) continue;
                person.getChild("locn").removeContent((Content)((Element)phonenums.get(i)));
            }
        }
        if (person.getChild("member") != null) {
            attributes = person.getChild("member").getAttributes();
            for (i2 = attributes.size() - 1; i2 >= 0; --i2) {
                if (!((Attribute)attributes.get(i2)).getValue().equals("")) continue;
                person.getChild("member").removeAttribute((Attribute)attributes.get(i2));
            }
        }
        List loyalties = person.getChildren("perloyalty");
        for (i = loyalties.size() - 1; i >= 0; --i) {
            if (((Element)loyalties.get(i)).getAttribute("rcidx") == null) {
                person.removeContent((Content)((Element)loyalties.get(i)));
                continue;
            }
            attributes = ((Element)loyalties.get(i)).getAttributes();
            for (int j = attributes.size() - 1; j >= 0; --j) {
                if (!((Attribute)attributes.get(j)).getValue().equals("")) continue;
                ((Element)loyalties.get(i)).removeAttribute((Attribute)attributes.get(j));
            }
        }
    }

    private String validateCapillaryResult(CapillaryResult capillaryResult) {
        String errorMsg = "";
        if (capillaryResult == null) {
            errorMsg = SP.getRS("capillary_failed_GetCustomer");
            return errorMsg;
        }
        if (!capillaryResult.response.status.success) {
            errorMsg = capillaryResult.response.status.message;
            return errorMsg;
        }
        return errorMsg;
    }

    private String validateCapillaryCustomer(CapillaryCustomer capillaryCustomer) {
        String errorMsg = "";
        if (StringUtils.isNullOrEmpty(capillaryCustomer.getFirstName()) || StringUtils.isNullOrEmpty(capillaryCustomer.getLastName())) {
            errorMsg = SP.getRS("capillary_failed_EmptyNewCustomer");
            return errorMsg;
        }
        if (StringUtils.isNullOrEmpty(capillaryCustomer.getEmail()) && StringUtils.isNullOrEmpty(capillaryCustomer.getMobile())) {
            errorMsg = SP.getRS("capillary_failed_EmptyContactDetail");
            return errorMsg;
        }
        if (StringUtils.isNullOrEmpty(capillaryCustomer.getLoyaltyTypeIdx())) {
            errorMsg = SP.getRS("capillary_loyaltytype_not_setup", capillaryCustomer.getCustomerType());
            return errorMsg;
        }
        return errorMsg;
    }

    public boolean CreateCapillaryPerson(String capillaryJson, Element person, ContextContainer container) {
        String errorMsg = "";
        CapillaryResult capillaryResult = CapillaryUtils.loadCapillaryResult(capillaryJson);
        errorMsg = this.validateCapillaryResult(capillaryResult);
        if (!StringUtils.isNullOrEmpty(errorMsg)) {
            DlgMessage.showMessage(this.parent, errorMsg, SP.getRS("capillary_failed_title"), 0);
            return false;
        }
        CapillaryCustomer capillaryCustomer = new CapillaryCustomer();
        capillaryCustomer = CapillaryUtils.getCapillaryCustomer(capillaryResult);
        errorMsg = this.validateCapillaryCustomer(capillaryCustomer);
        if (!StringUtils.isNullOrEmpty(errorMsg)) {
            DlgMessage.showMessage(this.parent, errorMsg, SP.getRS("capillary_failed_title"), 0);
            return false;
        }
        person.setAttribute("firstname", capillaryCustomer.getFirstName());
        person.setAttribute("surname", capillaryCustomer.getLastName());
        Element locn = new Element("locn");
        Element perloyalty = new Element("perloyalty");
        Element phonenum = new Element("phonenum");
        Element email = new Element("phonenum");
        if (!StringUtils.isNullOrEmpty(capillaryCustomer.getEmail())) {
            email.setAttribute("phonetyidx", "159");
            email.addContent(capillaryCustomer.getEmail());
            locn.addContent((Content)email);
        }
        if (!StringUtils.isNullOrEmpty(capillaryCustomer.getMobile())) {
            phonenum.setAttribute("phonetyidx", "154");
            phonenum.addContent(capillaryCustomer.getMobile());
            locn.addContent((Content)phonenum);
        }
        perloyalty.setAttribute("rcidx", capillaryCustomer.getLoyaltyTypeIdx());
        perloyalty.setAttribute("cardno", capillaryCustomer.getExternalId());
        person.addContent((Content)locn);
        person.addContent((Content)perloyalty);
        boolean success = true;
        SaveResult saveResult = this.saveCapillaryPerson(true, capillaryJson, person, container, capillaryCustomer);
        if (saveResult.success) {
            if (!saveResult.saveError) {
                saveResult = this.saveCapillaryPerson(false, capillaryJson, person, container, capillaryCustomer);
            }
        } else {
            DlgMessage.showMessage(this.parent, SP.getRS("Person_Online_Update_Failed") + (StringUtils.isNullOrEmpty(capillaryCustomer.errorMsg) ? "" : capillaryCustomer.errorMsg), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaveResult saveCapillaryPerson(boolean online, String capillaryJson, Element person, ContextContainer container, CapillaryCustomer capillaryCustomer) {
        XMLOutputter xmlOut = new XMLOutputter();
        SaveResult saveResult = new SaveResult();
        saveResult.success = false;
        saveResult.saveError = false;
        try {
            Element loyalty;
            this.frParent.setCursor(StoreParams.waitCursor);
            XMLOutputter printer = new XMLOutputter();
            boolean queryResult = true;
            if (online) {
                Element prefetch = SP.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", xmlOut.outputString(person) + "\u0003prefetch").getXML();
                if (prefetch == null) {
                    SaveResult saveResult2 = saveResult;
                    return saveResult2;
                }
                if (!prefetch.getAttributes().isEmpty()) {
                    person.setAttribute("prefetch_peridx", prefetch.getAttributeValue("peridx"));
                    person.getChild("locn").setAttribute("prefetch_locnidx", prefetch.getAttributeValue("locnidx"));
                    Element phoneNumbers = prefetch.getChild("phonenumbers");
                    if (phoneNumbers != null) {
                        for (Element prefetchPhoneNum : phoneNumbers.getChildren()) {
                            Element phoneNum = (Element)XPath.selectSingleNode((Object)person, (String)("locn/phonenum[@phonetyidx='" + prefetchPhoneNum.getAttributeValue("phonetyidx") + "']"));
                            if (phoneNum == null) continue;
                            phoneNum.setAttribute("prefetch_phonenumidx", prefetchPhoneNum.getAttributeValue("phonenumidx"));
                        }
                    }
                }
                if (prefetch.getAttribute("memidx") != null) {
                    person.getChild("member").setAttribute("prefetch_memidx", prefetch.getAttributeValue("memidx"));
                }
                if (prefetch.getAttribute("loyalidx") != null) {
                    List loyalties = person.getChildren("perloyalty");
                    String[] idxes = prefetch.getAttributeValue("loyalidx").split(",");
                    int pos = 0;
                    block10: for (int i = 0; i < idxes.length; ++i) {
                        while (pos < loyalties.size()) {
                            if ((loyalty = (Element)loyalties.get(pos++)).getAttribute("loyalidx") != null) continue;
                            loyalty.setAttribute("prefetch_loyalidx", idxes[i]);
                            continue block10;
                        }
                    }
                }
                SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", xmlOut.outputString(person) + "\u0003" + SP.sParams.getStoreIdx()).getXML();
                if (SP.sParams.root == null) {
                    queryResult = false;
                }
            } else {
                queryResult = SP.sParams.getXML(this.frParent, "saveperson", xmlOut.outputString(person) + "\u0003" + SP.sParams.getStoreIdx(), false);
            }
            if (queryResult) {
                Element idxs = SP.sParams.root;
                if (idxs.getName().equals("people")) {
                    Object loadedPerson;
                    if (idxs.getChildren("person").size() > 1) {
                        capillaryCustomer.errorMsg = "More than one matching person found and should not be a valid case for Capillary";
                        saveResult.saveError = true;
                    } else {
                        loadedPerson = idxs.getChild("person");
                        long actualPeridx = XMLUtils.getLongValue(loadedPerson, "pos_idx");
                        if (actualPeridx != 0L && XMLUtils.getLongValue(loadedPerson, "widx") == SP.sParams.getStoreIdx()) {
                            loadedPerson.setAttribute("peridx", String.valueOf(actualPeridx));
                        }
                        container.context = this.loadPerson(String.valueOf(actualPeridx), online, person, (Element)loadedPerson);
                        saveResult.success = true;
                    }
                    loadedPerson = saveResult;
                    return loadedPerson;
                }
                person.setAttribute(idxs.getAttribute("peridx").detach());
                if (idxs.getChild("locn") != null) {
                    Element lidxs = idxs.getChild("locn");
                    person.getChild("locn").setAttribute(lidxs.getAttribute("locnidx").detach());
                    List phonenums = person.getChild("locn").getChildren("phonenum");
                    for (int i = 0; i < phonenums.size(); ++i) {
                        Element phonenum = (Element)phonenums.get(i);
                        if (phonenum.getAttribute("phonenumidx") != null) continue;
                        phonenum.setAttribute(PersonUtils.getPhone(idxs, PersonUtils.PhoneType.getPhoneType(phonenum.getAttribute("phonetyidx").getValue())).getAttribute("phonenumidx").detach());
                    }
                }
                List loyals = person.getChildren("perloyalty");
                List loyalidxs = idxs.getChildren("perloyalty");
                int idxsCnt = 0;
                for (int i = 0; i < loyals.size(); ++i) {
                    loyalty = (Element)loyals.get(i);
                    if (idxsCnt < loyalidxs.size() && ((Element)loyalidxs.get(idxsCnt)).getAttribute("error") != null) {
                        capillaryCustomer.errorMsg = MessageFormat.format(StoreParams.res.getString("cardNo_used"), loyalty.getAttributeValue("cardno"), "\n");
                        saveResult.saveError = true;
                        saveResult.success = false;
                        SaveResult saveResult3 = saveResult;
                        return saveResult3;
                    }
                    if (loyalty.getAttribute("rcidx") == null) continue;
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("loyalidx").detach());
                    loyalty.setAttribute(((Element)loyalidxs.get(idxsCnt)).getAttribute("cardno").detach());
                    ++idxsCnt;
                }
                saveResult.success = true;
                SaveResult saveResult4 = saveResult;
                return saveResult4;
            }
            SaveResult saveResult5 = saveResult;
            return saveResult5;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            SaveResult saveResult6 = saveResult;
            return saveResult6;
        }
        finally {
            this.frParent.setCursor(StoreParams.normalCursor);
        }
    }

    public boolean createOrUpdatePerson(PersonContext context, JSPerson jsPerson, Element personElement, ContextContainer newContext) {
        if (!(this.frParent.frameType != 10 || StringUtils.isNullOrEmpty(this.accountCustIdx) || StringUtils.isNullOrEmpty(jsPerson.getPerIdx()) || this.accountCustIdx.equals(String.valueOf(jsPerson.getCustIdx())))) {
            DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("Selected_person_does_not_belong_to_account"), ((PaSales)this.frParent.paBody).tfCust.getText()), SP.getRS("Stop"), 0);
            return false;
        }
        if (PersonInterfaceUtils.isGuestAccount(personElement)) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Edit_Guest_Person"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
            if (!this.security.getPersonMaintSec(1)) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Add_Person_Security"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            context = new PersonContext();
        }
        if (!StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
            if (!StringUtils.isNullOrEmpty(context.memIdx) && !this.security.getSalesRepSec(2)) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Edit_Staff_Security"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (!this.security.getPersonMaintSec(2)) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Edit_Person_Security"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        if (!this.validatePerson(context, jsPerson)) {
            return false;
        }
        if (this.hasAddressChanged(context, jsPerson) && !this.verifyAddress(jsPerson)) {
            return false;
        }
        RewardsProgram signUpProgram = null;
        if (!this.frParent.getUser().isTraningUser() && !PersonInterfaceUtils.isGuestAccount(personElement) && this.usingRewards && StringUtils.isNullOrEmpty(context.rewardsProgramIdx)) {
            signUpProgram = this.checkForRewardsSignUp();
        }
        if (StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
            newContext.context = context;
            this.clearPerson(personElement);
        }
        this.buildXml(jsPerson, personElement, context, true);
        boolean success = true;
        if (!this.frParent.getUser().isTraningUser()) {
            SaveResult saveResult = this.save(true, jsPerson, personElement, newContext);
            if (saveResult.success) {
                if (!saveResult.saveError) {
                    saveResult = this.save(false, jsPerson, personElement, newContext);
                }
                SP.sParams.setPromoCachePurgeFlag(true);
            } else if (!StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
                if (!saveResult.matchingError) {
                    DlgMessage.showMessage(this.parent, SP.getRS("Person_Online_Update_Failed"), StoreParams.res.getString("Stop"), 0);
                }
                saveResult.saveError = true;
            } else if (!saveResult.saveError) {
                saveResult.saveError = !this.offlineOnlySave(personElement);
            }
            boolean bl = success = !saveResult.saveError;
        }
        if ((personElement.getAttribute("peridx") != null || this.frParent.getUser().isTraningUser()) && success) {
            this.cleanPerson(personElement);
            PersonContext.updateContextFromPersonXml(personElement, context, this.attributes);
            if (signUpProgram != null) {
                this.rewardsSignUp(context, signUpProgram, personElement);
            }
            return true;
        }
        return false;
    }

    public boolean acceptPerson(PersonContext context, Element person) {
        if (!(this.frParent.frameType != 10 || StringUtils.isNullOrEmpty(this.accountCustIdx) || StringUtils.isNullOrEmpty(context.perIdx) || this.accountCustIdx.equals(String.valueOf(context.custIdx)))) {
            DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("Selected_person_does_not_belong_to_account"), ((PaSales)this.frParent.paBody).tfCust.getText()), SP.getRS("Stop"), 0);
            return false;
        }
        if (person.getAttribute("peridx") != null || this.frParent.getUser().isTraningUser()) {
            this.cleanPerson(person);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean historySearch(String perIdx, boolean allStores) {
        StringBuffer sbFilter = new StringBuffer();
        if (allStores && !this.security.getHistoryAllStoresSec(0)) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else if (allStores && !SP.sParams.checkIConn()) {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
        } else {
            HistoryOptions options = new HistoryOptionsBuilder().transactionNumber().referenceNumber().productCode().transactionDates().build();
            StringBuffer result = new StringBuffer();
            DlgHistoryFilter histFilter = new DlgHistoryFilter(this.frParent, StoreParams.res.getString("Person_History_Search_Filter"), SP.sParams.checkIConn(), options, sbFilter, result);
            histFilter.setVisible(true);
            if (result.toString().equals("OK")) {
                BJTextField searchField = allStores ? SP.sParams.tfHistAll : SP.sParams.tfHistStore;
                this.parent.setCursor(StoreParams.waitCursor);
                try {
                    if (SP.sParams.checkIConn()) {
                        String sExtraWhere = PosUtils.longVal(perIdx) < 0L ? "H.VHIDX = H.VHIDX AND H.\"ACTIVE\" > 0 AND decode(H.TR_TYPE, 614, H.NOTES1, NULL) IS NULL AND H.CLIENTIDX IN( SELECT P.PERIDX FROM PERSON P WHERE P.ACTIVE = 1 AND P.WIDX = " + SP.sParams.getStoreIdx() + " AND P.POS_PERIDX = " + perIdx + ") " : "H.VHIDX = H.VHIDX AND H.\"ACTIVE\" > 0 AND decode(H.TR_TYPE, 614, H.NOTES1, NULL) IS NULL AND H.CLIENTIDX = " + perIdx + " ";
                        sExtraWhere = sExtraWhere + (allStores ? "" : " AND H.WIDX = " + SP.sParams.getStoreIdx());
                        if (searchField.getToServ() == null) {
                            searchField.setCache(SP.sParams.cacher, SP.sParams.iconn, 265L, "382,367,368,369,370,371,372,375,861,961", "", sExtraWhere + sbFilter.toString() + SP.sParams.sWhseRefSecWhereRETAIL);
                        } else {
                            searchField.setWhere(sExtraWhere + sbFilter.toString() + SP.sParams.sWhseRefSecWhereRETAIL);
                        }
                    } else {
                        String sExtraWhere = "H.COMPLETE > 0 AND H.\"ACTIVE\" > 0 AND (H.TR_TYPE != 614 OR H.NOTES1 IS NULL)  AND H.CLIENTIDX = " + perIdx;
                        if (searchField.getCacher() == null || searchField.getToServ() != null) {
                            searchField.setCache(SP.sParams.cacher, 661L, "922,923,924", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0 LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX", sExtraWhere + sbFilter.toString() + SP.sParams.sWhseRefSecWhereRETAIL);
                        } else {
                            searchField.setWhere(sExtraWhere + sbFilter.toString() + SP.sParams.sWhseRefSecWhereRETAIL);
                        }
                    }
                }
                finally {
                    this.parent.setCursor(StoreParams.normalCursor);
                }
                searchField.clear();
                searchField.setShowSearchForOneResult(true);
                boolean wasOnline = SP.sParams.checkIConn();
                searchField.doSearch(this.parent);
                if (wasOnline && !SP.sParams.checkIConn()) {
                    DlgMessage.showMessage(this.parent, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                searchField.setShowSearchForOneResult(false);
                if (!searchField.getText().equals("")) {
                    this.parent.setCursor(StoreParams.waitCursor);
                    try {
                        this.frParent.menu.populate(this.frParent, (int)searchField.getidx(), searchField.getText().substring(1));
                    }
                    finally {
                        this.parent.setCursor(StoreParams.normalCursor);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean deletePerson(PersonContext context, JSPerson person, Element personElement) {
        if (!StringUtils.isNullOrEmpty(person.getPerIdx())) {
            if (!StringUtils.isNullOrEmpty(person.getMemIdx()) && !this.security.getSalesRepSec(3)) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Edit_Staff_Security"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (PersonInterfaceUtils.isGuestAccount(personElement)) {
                DlgMessage.showMessage(this.parent, StoreParams.res.getString("No_Edit_Guest_Person"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("del_person_confirm"), StoreParams.res.getString("del_person"), 0, 2) != 0) {
                return false;
            }
            try {
                this.buildXml(person, personElement, context, false);
                if (!this.frParent.getUser().isTraningUser()) {
                    XMLOutputter printer = new XMLOutputter();
                    SP.sParams.OnlineQueryProvider.getOnlineQuery("saveperson", printer.outputString(personElement) + "\u0003" + SP.sParams.getStoreIdx()).getXML();
                    SP.sParams.getXML(this.frParent, "saveperson", printer.outputString(personElement) + "\u0003" + SP.sParams.getStoreIdx(), false);
                }
                if (personElement.getAttribute("peridx") != null || this.frParent.getUser().isTraningUser()) {
                    this.cleanPerson(personElement);
                }
                return true;
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
        }
        return false;
    }

    private boolean rewardsSignUp(PersonContext currentContext, RewardsProgram program, Element personElement) {
        IRewardsApiManager apiManager = RewardsApiFactory.getApiManager();
        if (apiManager.signUp(Long.valueOf(currentContext.perIdx), program.getId(), this.frParent.getUser())) {
            PersonContext.updateContextFromRewardsAccount(apiManager.getAccount(), currentContext);
            personElement.setAttribute(new Attribute("RewardsAccountIdx", String.valueOf(currentContext.rewardsAccountIdx)));
            personElement.setAttribute(new Attribute("ImmediateRewardsProcessing", String.valueOf(currentContext.rewardsProgramImmediatelyIssueRewards)));
            return true;
        }
        DlgMessage.showMessage(this.parent, apiManager.getLastError(), SP.getRS("Rewards_Sign_up"));
        return false;
    }

    private RewardsProgram getSignUpProgram() {
        if (this.rewardPrograms.size() > 0) {
            RewardsProgram program;
            if (this.rewardPrograms.size() == 1) {
                program = this.rewardPrograms.elementAt(0);
            } else {
                Object[] programsArray = this.rewardPrograms.toArray();
                program = (RewardsProgram)DlgList.showDialog(this.frParent, SP.getRS("Select_Rewards_Program"), SP.getRS("Rewards_Program"), programsArray, programsArray[0], true);
            }
            return program;
        }
        return null;
    }

    public boolean rewardsSignUp(PersonContext currentContext, Element personElement) {
        if (StringUtils.isNullOrEmpty(currentContext.perIdx)) {
            return false;
        }
        RewardsProgram program = this.getSignUpProgram();
        if (program != null) {
            return this.rewardsSignUp(currentContext, program, personElement);
        }
        return false;
    }

    public boolean manualRewardsRedeem(PersonContext currentContext) {
        if (StringUtils.isNullOrEmpty(currentContext.perIdx)) {
            return false;
        }
        new RewardsAdjustDlg(this.frParent, SP.getRS("Rewards_Manual_Redemption"), currentContext, RewardsAdjustType.REDEEM);
        return true;
    }

    public boolean manualRewardsReissue(PersonContext currentContext, double maxAmount, String parentIdx) {
        if (StringUtils.isNullOrEmpty(currentContext.perIdx)) {
            return false;
        }
        new RewardsAdjustDlg(this.frParent, SP.getRS("Rewards_Manual_Reissue"), currentContext, RewardsAdjustType.REISSUE, maxAmount, parentIdx);
        return true;
    }

    private RewardsProgram checkForRewardsSignUp() {
        if (RewardsUtils.isAutoSignup() && (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_MANAGER_OVERRIDE_FOR_REWARDS_PROGRAM) ? this.security.hasRewardsAssignSec(2) : this.security.getRewardsAssignSec(2))) {
            return this.getSignUpProgram();
        }
        if ((this.security.getRewardsAssignSec(2) || SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_MANAGER_OVERRIDE_FOR_REWARDS_PROGRAM)) && DlgMessage.showMessage(this.parent, SP.getRS("Rewards_Sign_Up_Prompt_Message"), SP.getRS("Rewards_Sign_Up_Prompt_Title"), 0, 3) == 0 && (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_MANAGER_OVERRIDE_FOR_REWARDS_PROGRAM) ? this.security.hasRewardsAssignSec(2) : this.security.getRewardsAssignSec(2))) {
            return this.getSignUpProgram();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean isFingerPrintRegistered(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void scanFingerPrint(String memName) {
        if (this.isInternalUserCode(memName)) {
            return;
        }
        if (!StringUtils.isNullOrEmpty(memName)) {
            if (SP.sParams.bUsingFingerprintLogin && SP.sParams.FingerprintProvider != null) {
                String key = memName.toUpperCase();
                try {
                    if (this.isFingerPrintRegistered(key) && DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("fingerprint_already_exists"), key, "\n"), StoreParams.res.getString("Stop"), 0, 3) != 0) {
                        return;
                    }
                    UareUFingerprintProvider.EnrollmentResult result = SP.sParams.FingerprintProvider.performEnrollment(key);
                    switch (result) {
                        case DUPLICATE: {
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("fingerprint_already_used"), "\n"), StoreParams.res.getString("Stop"), 0);
                            break;
                        }
                        case ERROR: {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Fingerprint_Scanner_Registration_failed"), StoreParams.res.getString("Stop"), 0);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    PosUtils.logError(ex);
                }
            }
        } else {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Enter_SCode2"), StoreParams.res.getString("Stop"), 0);
        }
    }

    public static boolean isGuestAccount(Element personElement) {
        return XMLUtils.getLongValue(personElement, "guest_account") == 1L;
    }

    public static String toProperCase(String s) {
        StringBuffer sb = new StringBuffer(s.toLowerCase().trim());
        boolean bUpper = true;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) >= 'A' && sb.charAt(i) <= 'Z' || sb.charAt(i) >= 'a' && sb.charAt(i) <= 'z') {
                if (bUpper) {
                    sb.replace(i, i + 1, String.valueOf(sb.charAt(i)).toUpperCase());
                }
                bUpper = false;
                continue;
            }
            bUpper = true;
        }
        return sb.toString();
    }

    public static String surnameExceptions(String s) {
        if ((s = PersonInterfaceUtils.toProperCase(s)).length() > 2 && s.startsWith("Mc")) {
            s = s.substring(0, 2) + s.substring(2, 3).toUpperCase() + s.substring(3, s.length());
        }
        if (s.startsWith("Van Der ")) {
            s = "Van d" + s.substring(5, s.length());
        }
        return s;
    }

    public ListWrapper<PersonContext.Loyalty> addLoyaltyCard(ListWrapper<PersonContext.Loyalty> loyalties) {
        PersonContext.Loyalty newLoyalty = new PersonContext.Loyalty();
        DlgEditLoyalty dlg = new DlgEditLoyalty(this.frParent, this.parent, newLoyalty, loyalties, DlgEditLoyalty.EditLoyaltyMode.ADD_NEW, false);
        if (dlg.getResult() == DlgEditLoyalty.EditLoyaltyResult.SAVE) {
            loyalties.getList().add(newLoyalty);
        }
        dlg.dispose();
        dlg = null;
        return loyalties;
    }

    public ListWrapper<PersonContext.Loyalty> editLoyaltyCard(int cardId, ListWrapper<PersonContext.Loyalty> loyalties) {
        PersonContext.Loyalty loyalty = this.getLoyaltyByCardId(cardId, loyalties);
        if (loyalty != null) {
            DlgEditLoyalty dlg;
            boolean securityOverridden = false;
            if (loyalty.managerOnly) {
                if (!Security.hasSecurity(this.frParent, 11165L, this.frParent.getUser().getMemidx(), 0, true)) {
                    DlgMessage.showMessage(this.parent, MessageFormat.format(SP.getRS("cant_edit_manager_loyalty"), loyalty.programName), SP.getRS("Insufficient_security"), -1, 0);
                    return loyalties;
                }
                securityOverridden = true;
            }
            if ((dlg = new DlgEditLoyalty(this.frParent, this.parent, loyalty, loyalties, DlgEditLoyalty.EditLoyaltyMode.EDIT_EXISTING, securityOverridden)).getResult() == DlgEditLoyalty.EditLoyaltyResult.SAVE) {
                for (int i = 0; i < loyalties.size(); ++i) {
                    PersonContext.Loyalty editedLoyalty = loyalties.get(i);
                    if (editedLoyalty.cardId != loyalty.cardId) continue;
                    editedLoyalty.loyaltyIdx = loyalty.loyaltyIdx;
                    editedLoyalty.loyaltyCode = loyalty.loyaltyCode;
                    editedLoyalty.programName = loyalty.programName;
                    editedLoyalty.cardNumber = loyalty.cardNumber;
                    editedLoyalty.expiryDateStr = loyalty.expiryDateStr;
                }
            }
            dlg.dispose();
            dlg = null;
        }
        return loyalties;
    }

    private PersonContext.Loyalty getLoyaltyByCardId(int cardId, ListWrapper<PersonContext.Loyalty> loyalty) {
        for (int i = 0; i < loyalty.size(); ++i) {
            if (loyalty.get((int)i).cardId != (long)cardId) continue;
            return loyalty.get(i);
        }
        return null;
    }

    public ListWrapper<PersonContext.Loyalty> LoyaltyToListWrapper(List<PersonContext.Loyalty> loyalties) {
        ListWrapper<PersonContext.Loyalty> loyaltyList = new ListWrapper<PersonContext.Loyalty>(new ArrayList());
        for (PersonContext.Loyalty loyalty : loyalties) {
            loyaltyList.getList().add(loyalty);
        }
        return loyaltyList;
    }

    public List<PersonContext.Loyalty> JsLoyaltyToList(JsArray loyalties) {
        ArrayList<PersonContext.Loyalty> loyaltyList = new ArrayList<PersonContext.Loyalty>();
        try {
            int i = 0;
            while ((long)i < loyalties.length()) {
                loyaltyList.add((PersonContext.Loyalty)loyalties.get((long)i));
                ++i;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return loyaltyList;
    }

    public static enum EmailPhoneValidation {
        NotMandatory,
        Email,
        Phone,
        Both,
        Either;

    }

    private static class SaveResult {
        public boolean success = false;
        public boolean saveError = false;
        public boolean matchingError = false;
    }

    public static class ContextContainer {
        public PersonContext context;
    }
}

