/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.quickreceipts.CartonContent;
import jpos.quickreceipts.CartonException;
import org.jdom.Element;

public class Carton {
    private String barcode = "";
    private String hiddenBarcode = "";
    private String transIdx = "";
    private String transType = "";
    private String transNumber = "";
    private String transDescription = "";
    private String deliveryNumber = "";
    private String supplierIdx = "";
    private String supplierName = "";
    private String fromWarehouseIdx = "";
    private String fromWarehouseName = "";
    private String carrierIdx = "";
    private int cartonNumber = 0;
    private int totalNumberCartons = 0;
    private Vector<CartonContent> contents = new Vector();

    protected String getBarcode() {
        return this.barcode;
    }

    protected void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    protected String getTransIdx() {
        return this.transIdx;
    }

    protected String getHiddenBarcode() {
        return this.hiddenBarcode;
    }

    protected void setHiddenBarcode(String hiddenBarcode) {
        this.hiddenBarcode = hiddenBarcode;
    }

    protected String getTransType() {
        return this.transType;
    }

    protected String getTransNumber() {
        return this.transNumber;
    }

    protected String getTransDescription() {
        return this.transDescription;
    }

    protected String getDeliveryNumber() {
        return this.deliveryNumber;
    }

    protected String getFromWarehouseIdx() {
        return this.fromWarehouseIdx;
    }

    protected String getSupplierIdx() {
        return this.supplierIdx;
    }

    protected String getFromName() {
        if (this.transType.equals("PO")) {
            return this.supplierName;
        }
        return this.fromWarehouseName;
    }

    protected String getCarrierIdx() {
        return this.carrierIdx;
    }

    protected void setCartonNumber(int cartonNumber) {
        this.cartonNumber = cartonNumber;
    }

    protected int getCartonNumber() {
        return this.cartonNumber;
    }

    protected int getTotalNumberCartons() {
        return this.totalNumberCartons;
    }

    protected Vector<CartonContent> getContents() {
        return this.contents;
    }

    protected double getTotalQty() {
        double qty = 0.0;
        for (int i = 0; i < this.contents.size(); ++i) {
            qty += this.contents.elementAt(i).getStyleLine().getReqQty();
        }
        return qty;
    }

    protected static Carton createCartonFromXml(Element carton) throws CartonException {
        try {
            if (carton != null && carton.getChild("skus") != null) {
                Carton c = new Carton();
                c.barcode = carton.getAttribute("barcode").getValue();
                c.hiddenBarcode = carton.getAttribute("barcode").getValue();
                c.transIdx = carton.getAttribute("trans_idx").getValue();
                c.transType = carton.getAttribute("trans_type").getValue();
                c.transNumber = carton.getAttribute("trans_number").getValue();
                c.deliveryNumber = carton.getAttribute("delivery").getValue();
                if (c.transType.equals("PO")) {
                    c.supplierIdx = carton.getAttribute("from_idx").getValue();
                    c.supplierName = carton.getAttribute("from_name").getValue();
                    c.transDescription = MessageFormat.format(SP.getRS("Purchase_Order_x"), c.transNumber);
                } else {
                    c.fromWarehouseIdx = carton.getAttribute("from_idx").getValue();
                    c.fromWarehouseName = carton.getAttribute("from_name").getValue();
                    c.transDescription = MessageFormat.format(SP.getRS("Warehouse_Transfer_x"), c.transNumber);
                }
                c.carrierIdx = carton.getAttribute("carrier_idx").getValue();
                c.totalNumberCartons = PosUtils.intVal(carton.getAttribute("cartons").getValue());
                List skus = carton.getChild("skus").getChildren();
                for (int i = 0; i < skus.size(); ++i) {
                    Element sku = (Element)skus.get(i);
                    c.getContents().add(new CartonContent(sku.getAttribute("skuidx").getValue(), sku.getAttribute("qty").getDoubleValue()));
                }
                return c;
            }
            throw new CartonException("Error", SP.getRS("barcode_missing"));
        }
        catch (CartonException e) {
            throw e;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }
}

