/*
 * Decompiled with CFR 0.152.
 */
package jpos.searchfields;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import jpos.SP;
import jpos.basscom.swing.BJTextField;
import jpos.ui.TouchButton;

public class SearchButton
extends TouchButton {
    private BJTextField searchField;

    public SearchButton(String msg, final BJTextField searchField, SearchIcon searchIcon) {
        super(msg);
        this.searchField = searchField;
        if (searchIcon == SearchIcon.SEARCH) {
            this.setIcon(new ImageIcon(SP.sParams.imagepath + "search.png"));
        } else if (searchIcon == SearchIcon.CALENDAR) {
            this.setIcon(new ImageIcon(SP.sParams.imagepath + "calendar.png"));
        }
        this.setMargin(new Insets(-2, -2, -2, -2));
        this.setBorder(this.searchField.getBorder());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        searchField.search();
                    }
                });
            }
        });
    }

    @Override
    public int getButtonWidth() {
        if (this.searchField != null) {
            return this.searchField.getMinimumSize().height;
        }
        return 0;
    }

    @Override
    public int getButtonHeight() {
        if (this.searchField != null) {
            return this.searchField.getMinimumSize().height;
        }
        return 0;
    }

    public static enum SearchIcon {
        SEARCH,
        CALENDAR;

    }
}

