/*
 * Decompiled with CFR 0.152.
 */
package jpos.stockreceipt;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jpos.stockreceipt.CartonItem;
import jpos.stockreceipt.DateOnlyXmlAdapter;
import jpos.stockreceipt.StockTransaction;

@XmlRootElement(name="Carton")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Carton {
    @XmlElement(name="SSCC")
    String sscc;
    @XmlElement(name="From")
    String from;
    @XmlElement(name="FromIdx")
    long fromIdx;
    @XmlElement(name="ConNote")
    String conNote;
    @XmlElement(name="DelIns")
    String delIns;
    @XmlElement(name="ShipDate")
    @XmlJavaTypeAdapter(value=DateOnlyXmlAdapter.class)
    Date shipDate;
    @XmlElement(name="EstimatedArrivalDate")
    @XmlJavaTypeAdapter(value=DateOnlyXmlAdapter.class)
    Date estimatedArrivalDate;
    @XmlElement(name="Carrier")
    String carrier;
    @XmlElementWrapper(name="Items")
    @XmlElement(name="CartonItem")
    List<CartonItem> items;
    @XmlElementWrapper(name="CartonsInASN")
    @XmlElement(name="sscc")
    List<String> cartonsInASN;
    @XmlElementWrapper(name="CartonsReceivedInASN")
    @XmlElement(name="sscc")
    List<String> cartonsReceivedInASN;

    public List<String> getCartonsInASN() {
        if (this.cartonsInASN == null) {
            this.cartonsInASN = new ArrayList<String>();
        }
        return this.cartonsInASN;
    }

    public void setCartonsInASN(List<String> cartonsInASN) {
        this.cartonsInASN = cartonsInASN;
    }

    public List<String> getCartonsReceivedInASN() {
        if (this.cartonsReceivedInASN == null) {
            this.cartonsReceivedInASN = new ArrayList<String>();
        }
        return this.cartonsReceivedInASN;
    }

    public void setCartonsReceivedInASN(List<String> cartonsReceivedInASN) {
        this.cartonsReceivedInASN = cartonsReceivedInASN;
    }

    public String GetSscc() {
        return this.sscc;
    }

    public void setSscc(String sscc) {
        this.sscc = sscc;
    }

    public List<CartonItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<CartonItem>();
        }
        return this.items;
    }

    public void setItems(List<CartonItem> items) {
        this.items = items;
    }

    public String GetFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public long getFromIdx() {
        return this.fromIdx;
    }

    public void setFromIdx(long fromIdx) {
        this.fromIdx = fromIdx;
    }

    public String GetConNote() {
        return this.conNote;
    }

    public void setConNote(String conNote) {
        this.conNote = conNote;
    }

    public Date GetShipDate() {
        return this.shipDate;
    }

    public void setShipDate(Date shipDate) {
        this.shipDate = shipDate;
    }

    public Date GetEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(Date estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public String getDelIns() {
        return this.delIns;
    }

    public void setDelIns(String delIns) {
        this.delIns = delIns;
    }

    public void setReceivedQty(String barcode, long skuIdx, double qty) throws IllegalArgumentException {
        if (qty < 0.0) {
            throw new IllegalArgumentException("Received qty cannot be less than 0");
        }
        CartonItem lastItem = null;
        double left = qty;
        for (CartonItem item : this.items) {
            if (!item.barcode.equals(barcode)) continue;
            item.currReceivedQty = Math.min(item.qty, left);
            left = left - item.currReceivedQty < 0.0 ? 0.0 : left - item.currReceivedQty;
            lastItem = item;
        }
        if (left > 0.0) {
            if (lastItem != null) {
                lastItem.currReceivedQty += left;
            } else {
                lastItem = new CartonItem();
                lastItem.skuidx = skuIdx;
                lastItem.barcode = barcode;
                lastItem.currReceivedQty = left;
                lastItem.qty = 0.0;
                lastItem.tranIdx = this.items.get((int)0).tranIdx;
                lastItem.tranNumber = this.items.get((int)0).tranNumber;
                lastItem.tranType = this.items.get((int)0).tranType;
                this.items.add(lastItem);
            }
        }
    }

    public double getTotalQty() {
        double total = 0.0;
        for (CartonItem item : this.items) {
            total += item.qty;
        }
        return total;
    }

    public String getTranType() {
        Iterator<CartonItem> iterator = this.items.iterator();
        if (iterator.hasNext()) {
            CartonItem item = iterator.next();
            return item.tranType;
        }
        return "";
    }

    public String getTranNum() {
        HashSet<String> tranNums = new HashSet<String>();
        for (CartonItem item : this.items) {
            tranNums.add(item.tranNumber);
        }
        return String.join((CharSequence)",", tranNums);
    }

    public String getTranIdx() {
        HashSet<String> tranIdxs = new HashSet<String>();
        for (CartonItem item : this.items) {
            tranIdxs.add(String.valueOf(item.tranIdx));
        }
        return String.join((CharSequence)",", tranIdxs);
    }

    public List<StockTransaction> getTransactions() {
        ArrayList<StockTransaction> trans = new ArrayList<StockTransaction>();
        HashSet<Long> tranIdxs = new HashSet<Long>();
        for (CartonItem item : this.items) {
            if (tranIdxs.contains(item.tranIdx)) continue;
            StockTransaction tran = new StockTransaction();
            tran.tranIdx = item.tranIdx;
            tran.tranNum = item.tranNumber;
            tran.tranType = item.tranType;
            tran.from = this.from;
            tran.fromIdx = this.fromIdx;
            trans.add(tran);
            tranIdxs.add(item.tranIdx);
        }
        return trans;
    }

    public boolean hasUnexpectedItem() {
        for (CartonItem item : this.items) {
            if (!(item.currReceivedQty > item.qty)) continue;
            return true;
        }
        return false;
    }

    public static Carton createCartonFromXmlString(String carton) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Carton.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        StringReader reader = new StringReader(carton);
        return (Carton)unmarshaller.unmarshal((Reader)reader);
    }

    public static String serialise(Carton carton) throws Exception {
        StringWriter sw = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Carton.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)carton, (Writer)sw);
        return sw.toString();
    }

    public double getOvers() {
        double overs = 0.0;
        for (CartonItem ci : this.items) {
            if (!(ci.getQty() < ci.getCurrReceivedQty() + ci.getPrevReceivedQty())) continue;
            overs += ci.getCurrReceivedQty() + ci.getPrevReceivedQty() - ci.getQty();
        }
        return overs;
    }

    public double getUnders() {
        double unders = 0.0;
        for (CartonItem ci : this.items) {
            if (!(ci.getQty() > ci.getCurrReceivedQty() + ci.getPrevReceivedQty())) continue;
            unders += ci.getQty() - (ci.getCurrReceivedQty() + ci.getPrevReceivedQty());
        }
        return unders;
    }
}

