/*
 * Decompiled with CFR 0.152.
 */
package jpos.stockreceipt;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import jpos.Carrier;
import jpos.DlgMessage;
import jpos.FrTransferInAbstact;
import jpos.Note;
import jpos.PosDouble;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SkuReservation;
import jpos.SpecialOrderReceiptProcessor;
import jpos.Store;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.basscom.utils.Utils;
import jpos.labelprinting.PrinterLabelFactory;
import jpos.labelprinting.SkuLabel;
import jpos.stockreceipt.Carton;
import jpos.stockreceipt.CartonItem;
import jpos.stockreceipt.NonASNTransaction;
import jpos.stockreceipt.PaStockReceipt;
import jpos.stockreceipt.PaStockReceiptFoot;
import jpos.stockreceipt.StockTransaction;
import jpos.stockreceipt.TransactionItem;
import org.jdom.Element;

public class FrStockReceipt
extends FrTransferInAbstact {
    public static final int unexpectedLineType = 99;
    boolean quarantineUnexpectedItems = false;
    private boolean autoPrintDisplayLabels = false;
    private int autoPrintDisplayLabelQty = 0;
    List<Long> vhidxs = new ArrayList<Long>();
    String completedTransNum = "";
    boolean forceScan = false;
    Carrier carrier = null;
    Carton cartonReceipt = null;
    NonASNTransaction nonASNTransactionReceipt = null;
    private Vector<SkuReservation> reservations = new Vector();
    private Element specialOrder = null;
    protected Element transRoot = null;
    private List<Long> clrIdxsToPrint;
    private List<Long> skusToPrint;

    public Carton getCartonReceipt() {
        return this.cartonReceipt;
    }

    public NonASNTransaction getNonASNTransactionReceipt() {
        return this.nonASNTransactionReceipt;
    }

    public FrStockReceipt(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 3, 11103L, psParams, StoreParams.res.getString("Carton_Receipt"));
        this.forceScan = psParams.isForceScanInStockReceipt();
        this.autoPrintDisplayLabels = psParams.isAutoPrintLabelOnReceipt();
        if (this.autoPrintDisplayLabels) {
            this.autoPrintDisplayLabelQty = psParams.getAutoPrintLabelQty();
        }
        this.paBody = new PaStockReceipt(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaStockReceiptFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaStockReceipt)this.paBody).tfBarcode.requestFocus();
            this.setButtons();
        }
    }

    @Override
    protected void setTransType() {
        this.setTransType(250);
    }

    @Override
    public void setTransType(int ptype) {
        this.transType = ptype;
        if (this.paBody != null) {
            PaStockReceipt body = (PaStockReceipt)this.paBody;
            body.setFromField(this.transType);
            this.setButtons();
            body.tfBarcode.setText("");
            if (this.transType == 248) {
                body.tfDock.setVisible(true);
                body.lDock.setVisible(true);
                body.tfBarcode.requestFocus();
                body.tfSupplier.setEnabled(true);
                body.lFeedBack.setText(StoreParams.res.getString("Direct_Stock_Receipt"));
            } else if (this.transType == 251) {
                body.tfBarcode.requestFocus();
                body.tfSupplier.setEnabled(false);
                body.lFeedBack.setText(StoreParams.res.getString("Purchase_Order") + this.transnum);
            } else if (this.transnum != null) {
                body.lFeedBack.setText(StoreParams.res.getString("Transfer_") + " #" + this.transnum);
            } else {
                body.lFeedBack.setText(StoreParams.res.getString("Stock_Transfer_In"));
            }
            body.setColumnsVisibility();
        }
    }

    @Override
    public boolean validateTrans() {
        PaStockReceipt body = (PaStockReceipt)this.paBody;
        if (body.tblStyles.isEditing()) {
            body.tblStyles.getCellEditor().stopCellEditing();
        }
        if (!((PaStockReceiptFoot)this.paFoot).bComplete.isEnabled()) {
            return false;
        }
        if (body.tblStyles.getQty() <= body.tblStyles.getOrigQty()) {
            return false;
        }
        double totalReceived = body.tblStyles.getQty() - body.tblStyles.getOrigQty();
        if (this.transType == 248 || this.transType == 251) {
            if (body.tfDock.getText().equals("")) {
                DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a2"));
                body.tfDock.requestFocus();
                return false;
            }
            if (body.tfSupplier.getText().length() == 0 || body.tfSupplier.getidx() <= 0L) {
                if (this.transType == 248) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("You_must_enter_a6"));
                    body.tfSupplier.requestFocus();
                    return false;
                }
                if (this.transType == 251) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_supplier"), objs));
                    return false;
                }
            }
            if (this.quarantineUnexpectedItems && this.getCartonReceipt() != null ? !this.confirmQuarantineReceipt() : !this.confirmStockReceipt(this.transType, body, totalReceived)) {
                return false;
            }
        } else {
            if (body.tfWhse.getidx() <= 0L) {
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_from_store_contact_support"), "\n"));
                return false;
            }
            if (this.quarantineUnexpectedItems && this.getCartonReceipt() != null ? !this.confirmQuarantineReceipt() : !this.confirmStockReceipt(this.transType, body, totalReceived)) {
                return false;
            }
        }
        try {
            this.setCursor(StoreParams.waitCursor);
            Vector<StyleLine> styleLines = new Vector<StyleLine>();
            for (int i = 0; i < body.tblStyles.getRowCount(); ++i) {
                if (!(body.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                styleLines.add((StyleLine)body.tblStyles.getItemAt(i));
            }
            this.reservations = SkuReservation.allocateTransfersToReservations(styleLines);
            if (this.reservations.size() > 0) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("stk_reserved"), objs), StoreParams.res.getString("Reserved_Stock"), 1);
            }
            this.specialOrder = SpecialOrderReceiptProcessor.loadSpecialOrderFromPurchaseOrder(this.pordidx);
            if (this.specialOrder != null) {
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("SpecialOrder_stk"), "\n"), StoreParams.res.getString("Reserved_Stock"), 1);
            }
            this.setCursor(StoreParams.normalCursor);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.setCursor(StoreParams.normalCursor);
        }
        return true;
    }

    @Override
    public synchronized boolean completeTrans() {
        if (this.completedTransNum != null && this.completedTransNum.equals(this.transnum)) {
            return false;
        }
        boolean success = false;
        try {
            this.completedTransNum = this.transnum;
            success = super.completeTrans();
        }
        finally {
            if (!success) {
                this.completedTransNum = null;
            }
        }
        return success;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            PaStockReceipt body = (PaStockReceipt)this.paBody;
            String from_widx = this.transType == 250 && body.tfWhse.getidx() > 0L ? String.valueOf(body.tfWhse.getidx()) : "null";
            String supplier = this.transType != 250 && body.tfSupplier.getidx() >= 0L ? String.valueOf(body.tfSupplier.getidx()) : "null";
            String db_carrier = this.carrier == null || this.carrier.getId() <= 0L ? "null" : String.valueOf(this.carrier.getId());
            String db_pordidx = this.pordidx == -1L ? "null" : String.valueOf(this.pordidx);
            try {
                PosUtils.startTrans(this.sParams.conn);
                if (this.stockReceiptLoaded()) {
                    this.clrIdxsToPrint = new ArrayList<Long>();
                    this.skusToPrint = new ArrayList<Long>();
                    this.insertDBStockReceipt();
                    if (this.getCartonReceipt() != null) {
                        this.markCartonReceiptLockAsComplete();
                    }
                } else {
                    this.vhidx = this.sParams.nextVal("XRET_TRANH");
                    try (Statement stmt = this.sParams.conn.createStatement();){
                        stmt.executeUpdate(" INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE,  TILL_NUMBER, FROM_WIDX, SUPPLIERIDX, TO_WIDX, CARRIERIDX, PORDIDX, SALE_DATE) VALUES( " + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", " + PosUtils.StringToSqlString(this.transnum) + ", current_timestamp, " + " " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + "," + this.getUser().getMemidx() + ", " + (this.docknum == null ? "null" : PosUtils.StringToSqlString(this.docknum)) + ", 0, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", " + from_widx + ", " + supplier + ", " + from_widx + ", " + db_carrier + ", " + db_pordidx + ", TRUNC_DATE(current_timestamp))");
                        Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
                        body.tblStyles.db_insertLines(this.transType);
                        stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + ";");
                        this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
                    }
                }
                PosUtils.endTrans(this.sParams.conn);
            }
            catch (Exception e) {
                PosUtils.releaseTrans(this.sParams.conn);
                PosUtils.logError(e);
                return false;
            }
            if (this.autoPrintDisplayLabels && this.skusToPrint != null && this.skusToPrint.size() > 0 && this.autoPrintDisplayLabelQty > 0) {
                int errorCount = 0;
                boolean printFailed = false;
                try {
                    for (Long sku : this.skusToPrint) {
                        if (this.printDisplayLabels(sku)) continue;
                        printFailed = true;
                        ++errorCount;
                    }
                    String msg = printFailed && errorCount != this.skusToPrint.size() ? MessageFormat.format(SP.getRS("Label_Print_After_Receipt"), (this.skusToPrint.size() - errorCount) * this.autoPrintDisplayLabelQty) + "\r\n" + MessageFormat.format(SP.getRS("Label_Print_After_Receipt_Error"), errorCount * this.autoPrintDisplayLabelQty) : (errorCount == this.skusToPrint.size() ? MessageFormat.format(SP.getRS("Label_Print_After_Receipt_Error"), errorCount * this.autoPrintDisplayLabelQty) : MessageFormat.format(SP.getRS("Label_Print_After_Receipt"), this.skusToPrint.size() * this.autoPrintDisplayLabelQty));
                    DlgMessage.showMessage(this, msg, SP.getRS("Label_Printing"), -1, 1);
                }
                catch (Exception e) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Label_Print_After_Receipt_Error"), this.skusToPrint.size() * this.autoPrintDisplayLabelQty), SP.getRS("Label_Printing"), -1, 2);
                }
            }
            Vector<SkuReservation> reservationsToPrint = new Vector<SkuReservation>();
            for (SkuReservation reservation : this.reservations) {
                reservation.updateAvailQty();
                boolean markedToPrint = false;
                for (SkuReservation reservationToPrint : reservationsToPrint) {
                    if (reservationToPrint.getVhidx() != reservation.getVhidx()) continue;
                    markedToPrint = true;
                    break;
                }
                if (markedToPrint) continue;
                reservationsToPrint.add(reservation);
            }
            for (SkuReservation reservationToPrint : reservationsToPrint) {
                reservationToPrint.printStoreDocket(this, true);
            }
            SpecialOrderReceiptProcessor.printSpecialOrder(this, this.specialOrder);
            return true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    protected void setButtons() {
        PaStockReceipt body = (PaStockReceipt)this.paBody;
        if (body.tblStyles.getRowCount() > 0 || this.transType != 250 || this.getCartonReceipt() != null || this.getNonASNTransactionReceipt() != null) {
            ((PaStockReceiptFoot)this.paFoot).bTransferOrders.setEnabled(false);
            ((PaStockReceiptFoot)this.paFoot).bVoid.setEnabled(true);
        } else {
            ((PaStockReceiptFoot)this.paFoot).bTransferOrders.setEnabled(true);
            ((PaStockReceiptFoot)this.paFoot).bVoid.setEnabled(false);
        }
        if (this.getCartonReceipt() == null && this.getNonASNTransactionReceipt() == null || this.transType == 1) {
            ((PaStockReceiptFoot)this.paFoot).bPrintCheckList.setEnabled(false);
        } else {
            ((PaStockReceiptFoot)this.paFoot).bPrintCheckList.setEnabled(true);
        }
        if (this.transType == 250) {
            ((PaStockReceiptFoot)this.paFoot).bImport.setEnabled(this.transnum != null);
        } else if (this.transType == 251) {
            ((PaStockReceiptFoot)this.paFoot).bImport.setEnabled(this.pordidx > 0L);
        } else {
            ((PaStockReceiptFoot)this.paFoot).bImport.setEnabled(this.transType == 248);
        }
        if (this.docknum == null) {
            if (body.tblStyles.getRowCount() > 0 && this.transType != 1 && !this.forceScan) {
                ((PaStockReceiptFoot)this.paFoot).bDelete.setEnabled(true);
            } else {
                ((PaStockReceiptFoot)this.paFoot).bDelete.setEnabled(false);
            }
            if (body.tblStyles.getQty() > body.tblStyles.getOrigQty()) {
                ((PaStockReceiptFoot)this.paFoot).bComplete.setEnabled(true);
            } else {
                ((PaStockReceiptFoot)this.paFoot).bComplete.setEnabled(false);
            }
            if (this.transType == 248) {
                ((PaStockReceiptFoot)this.paFoot).bRecAll.setEnabled(false);
                ((PaStockReceiptFoot)this.paFoot).bDirect.setEnabled(false);
            } else {
                if (body.tblStyles.getRowCount() > 0 && this.transType != 1) {
                    ((PaStockReceiptFoot)this.paFoot).bRecAll.setEnabled(true);
                } else {
                    ((PaStockReceiptFoot)this.paFoot).bRecAll.setEnabled(false);
                }
                if (this.transType == 251 || this.transnum != null) {
                    ((PaStockReceiptFoot)this.paFoot).bDirect.setEnabled(false);
                } else {
                    ((PaStockReceiptFoot)this.paFoot).bDirect.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            PaStockReceipt body = (PaStockReceipt)this.paBody;
            this.clearCartonLocks();
            super.voidTrans(logout);
            this.transRoot = null;
            this.carrier = null;
            this.pordidx = -1L;
            this.cartonReceipt = null;
            this.nonASNTransactionReceipt = null;
            this.vhidxs.clear();
            this.reservations.clear();
            this.specialOrder = null;
            body.tblStyles.clear();
            body.tfWhse.setEnabled(false);
            body.tfWhse.clear();
            body.tfSupplier.setEnabled(false);
            body.tfSupplier.clear();
            body.lFrom.setText(StoreParams.res.getString("From"));
            body.tfDock.setVisible(false);
            body.lDock.setVisible(false);
            body.tfBarcode.setText("");
            body.tfDock.setText("");
            body.lFeedBack2.clear();
            body.lSsccDisplay.clear();
            body.lFeedBack.setForeground(this.getDefaultColor());
            body.tblStyles.showReceivedCols(true);
            body.lCarton.setText("");
            body.lCarrier.setText("");
            body.lConNote.setText("");
            body.lCartonXofY.setText("");
            this.setButtons();
        }
    }

    @Override
    public void delLines() {
        if (((PaStockReceiptFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaStockReceipt)this.paBody).delLines();
            this.setFocus();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 116) {
            ((PaStockReceiptFoot)this.paFoot).bDirect.doClick();
        } else if (e.getKeyCode() == 119) {
            if (((PaStockReceiptFoot)this.paFoot).bRecAll.isVisible()) {
                ((PaStockReceiptFoot)this.paFoot).bRecAll.doClick();
            }
        } else if (e.getKeyCode() == 117) {
            if (e.isAltDown()) {
                // empty if block
            }
        } else if (e.getKeyCode() == 118 && ((PaStockReceiptFoot)this.paFoot).bPrintCheckList.isEnabled()) {
            ((PaStockReceiptFoot)this.paFoot).bPrintCheckList.doClick();
        } else if (e.getKeyCode() != 115) {
            if ((this.transType == 251 || this.transType == 250 || this.transType == 248) && e.getKeyCode() == 73 && e.isAltDown()) {
                ((PaStockReceiptFoot)this.paFoot).bImport.doClick();
            } else {
                return false;
            }
        }
        return true;
    }

    public void transferSearch() {
        if (this.hasSecurity(11132L, 0)) {
            if (this.sParams.checkIConn()) {
                PaStockReceipt body = (PaStockReceipt)this.paBody;
                body.tfTransSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                body.tfTransSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (body.tfTransSearch.getidx() > 0L) {
                    body.tfBarcode.setText("TVHIDX" + body.tfTransSearch.getidx());
                    body.tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    public void purchOrderSearch() {
        if (this.hasSecurity(11147L, 0)) {
            if (this.sParams.checkIConn()) {
                PaStockReceipt body = (PaStockReceipt)this.paBody;
                body.tfPurchOrderSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                body.tfPurchOrderSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (body.tfPurchOrderSearch.getidx() > 0L) {
                    body.tfBarcode.setText(body.tfPurchOrderSearch.getText());
                    body.tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    public void transferOrderSearch() {
        if (this.hasSecurity(2786L, 0)) {
            if (this.sParams.checkIConn()) {
                PaStockReceipt body = (PaStockReceipt)this.paBody;
                body.tfTransferOrderSearch.clear();
                boolean wasOnline = this.sParams.checkIConn();
                body.tfTransferOrderSearch.doSearch();
                if (wasOnline && !this.sParams.checkIConn()) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
                }
                if (body.tfTransferOrderSearch.getidx() > 0L) {
                    body.tfBarcode.setText("O" + body.tfTransferOrderSearch.getidxStr());
                    body.tfBarcode_actionPerformed(null);
                }
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    @Override
    public void setStatusText(String msg) {
        ((PaStockReceiptFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaStockReceiptFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaStockReceiptFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        PaStockReceipt body = (PaStockReceipt)this.paBody;
        return body.tblStyles.getRowCount() == 0 && this.transnum == null && body.tfDock.getText().equals("");
    }

    @Override
    protected void setEditable(boolean peditable) {
        PaStockReceipt body = (PaStockReceipt)this.paBody;
        super.setEditable(peditable);
        body.tblStyles.setEditable(this.editable);
        body.tfWhse.setEnabled(this.editable);
        body.tfSupplier.setEnabled(this.editable);
        body.tfDock.setEnabled(this.editable);
        ((PaStockReceiptFoot)this.paFoot).bComplete.setEnabled(this.editable);
        ((PaStockReceiptFoot)this.paFoot).bDelete.setEnabled(this.editable && !this.forceScan);
        ((PaStockReceiptFoot)this.paFoot).bDirect.setEnabled(this.editable);
        ((PaStockReceiptFoot)this.paFoot).bRecAll.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        try {
            PaStockReceipt body;
            if (super.populate(trans)) {
                Store store;
                body = (PaStockReceipt)this.paBody;
                String storeno = "000";
                if (trans.getAttribute("widx") != null && (store = body.getTransferInStore(trans.getAttribute("widx").getLongValue())) != null) {
                    storeno = store.getStoreNo();
                }
                body.tfWhse.clear();
                body.tfSupplier.clear();
                if (this.transType == 248 || this.transType == 251) {
                    body.tfDock.setText(trans.getAttribute("trans_number").getValue());
                    if (trans.getAttribute("supplieridx") != null) {
                        boolean bFound = false;
                        for (int j = 0; j < body.suppliers.size(); ++j) {
                            if (body.suppliers.elementAt(j).getIdx() != trans.getAttribute("supplieridx").getLongValue()) continue;
                            body.tfSupplier.setAll(body.suppliers.elementAt(j).getIdx(), body.suppliers.elementAt(j).getCode(), body.suppliers.elementAt(j).getName());
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_supplier_sec"), objs), StoreParams.res.getString("Error"), 0);
                            return false;
                        }
                    }
                } else if (trans.getAttribute("from_widx") != null) {
                    store = body.getTransferInStore(trans.getAttribute("from_widx").getLongValue());
                    if (store != null) {
                        body.tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                    } else {
                        body.tfWhse.clear();
                    }
                }
                body.lFeedBack2.setText(StoreParams.res.getString("Docket_") + " D" + storeno + trans.getAttribute("docket_number").getValue());
                if (trans.getAttribute("sscc").getValue().length() > 0) {
                    body.lSsccDisplay.setText(StoreParams.res.getString("Carton_Number") + trans.getAttribute("sscc").getValue());
                }
                if (!body.tblStyles.populate(trans)) {
                    body.tfBarcode.setText(StoreParams.res.getString("Error_loading"));
                    return false;
                }
                body.tblStyles.setOrigQtys(0.0);
                body.db_populateQty(trans.getAttribute("trans_number").getValue(), trans.getAttribute("vhidx").getValue());
                if (trans.getAttribute("carrier") != null) {
                    this.carrier = new Carrier(trans.getAttribute("carrier").getLongValue());
                }
            } else {
                return false;
            }
            body.update();
            this.setEditable(false);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
        List<Long> printVhidxs;
        if (this.stockReceiptLoaded()) {
            printVhidxs = this.vhidxs;
        } else {
            printVhidxs = new ArrayList<Long>();
            printVhidxs.add(this.vhidx);
        }
        for (Long idx : printVhidxs) {
            Object[] objs;
            try (Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Transfer"), false, this.sParams.getDocketConnection(), (long)idx, reprint);){
                if (r1.isValidReceipt()) {
                    r1.PrintTransferIn();
                } else {
                    objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
                }
            }
            if (!this.hasUnexpectedItem(idx)) continue;
            r1 = new Receipt(this, StoreParams.res.getString("Printing_Transfer"), false, this.sParams.getDocketConnection(), (long)idx, reprint);
            var6_6 = null;
            try {
                if (r1.isValidReceipt()) {
                    r1.PrintStockReceiptUnexpected();
                    continue;
                }
                objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (r1 == null) continue;
                if (var6_6 != null) {
                    try {
                        r1.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                    continue;
                }
                r1.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean hasUnexpectedItem(long vhidx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void printCheckList() {
        Receipt r1 = new Receipt(this, StoreParams.res.getString("Printing_Check"), false, this.sParams.getDocketConnection(), 0L, false);
        r1.printTransferChecklist(this.transRoot);
        r1.close();
    }

    protected void receiptAll() {
        if (this.hasSecurity(11118L, 0)) {
            if (!this.sParams.checkIConn()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            } else {
                ((PaStockReceipt)this.paBody).receiptAll();
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
    }

    @Override
    protected void setTransnum() {
        if (this.transType == 251 || this.transType == 248) {
            this.transnum = ((PaStockReceipt)this.paBody).tfDock.getText();
        }
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaStockReceipt)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaStockReceipt)this.paBody).tblStyles.model.getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaStockReceipt)this.paBody).tblStyles.RefreshImage();
    }

    @Override
    public void processLogin() {
    }

    public void ImportBarcodes(Vector<String> vBarcodes) {
        ((PaStockReceipt)this.paBody).processBarcodes(vBarcodes);
    }

    public boolean stockReceiptLoaded() {
        return this.cartonReceipt != null || this.nonASNTransactionReceipt != null;
    }

    protected void insertDBStockReceipt() throws SQLException {
        List<Object> trans;
        if (this.nonASNTransactionReceipt != null) {
            trans = new ArrayList();
            trans.add(this.nonASNTransactionReceipt);
        } else {
            trans = this.cartonReceipt.getTransactions();
        }
        boolean firstTran = true;
        for (StockTransaction stockTransaction : trans) {
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE,  TILL_NUMBER, FROM_WIDX, SUPPLIERIDX, TO_WIDX, PORDIDX, CARRIERIDX, SALE_DATE) VALUES(?, ?, 1, ?, ?,  current_timestamp, ?, ?, ?, ?, ?, 0, ?, ?, ?, ?, ?, ?, TRUNC_DATE(current_timestamp))");){
                prepStmt.setLong(1, this.vhidx);
                prepStmt.setInt(2, this.transType);
                prepStmt.setLong(3, this.sParams.getStoreIdx());
                if (stockTransaction.tranType.equals("TR")) {
                    prepStmt.setString(4, stockTransaction.tranNum);
                } else {
                    prepStmt.setString(4, this.transnum);
                }
                prepStmt.setLong(5, this.getUser().getPeridx());
                prepStmt.setLong(6, this.getUser().getMemidx());
                prepStmt.setLong(7, this.getUser().getPeridx());
                prepStmt.setLong(8, this.getUser().getMemidx());
                if (!firstTran) {
                    this.setDocketnum();
                }
                prepStmt.setString(9, this.docknum);
                prepStmt.setString(10, this.sParams.tillnum);
                if (stockTransaction.tranType.equals("TR")) {
                    prepStmt.setLong(11, stockTransaction.fromIdx);
                    prepStmt.setNull(12, 4);
                    prepStmt.setLong(13, stockTransaction.fromIdx);
                    prepStmt.setNull(14, 4);
                } else {
                    prepStmt.setNull(11, 4);
                    prepStmt.setLong(12, stockTransaction.fromIdx);
                    prepStmt.setNull(13, 4);
                    prepStmt.setLong(14, stockTransaction.tranIdx);
                }
                if (this.carrier != null && this.carrier.getId() > 0L) {
                    prepStmt.setLong(15, this.carrier.getId());
                } else {
                    prepStmt.setNull(15, 4);
                }
                prepStmt.executeUpdate();
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            this.insertDBSockReceiptDetails(stockTransaction.tranIdx);
            String sscc = this.cartonReceipt == null ? "" : this.cartonReceipt.sscc;
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("update ret_tranh set sscc = ?, complete = 1 where vhidx = ?");){
                prepStmt.setString(1, sscc);
                prepStmt.setLong(2, this.vhidx);
                prepStmt.executeUpdate();
            }
            if (sscc != "") {
                PreparedStatement stmtCartonsReceived = this.sParams.conn.prepareStatement("INSERT INTO CARTONS_RECEIVED(CARTON, RECEIVE_DATE) SELECT ?, CURRENT_TIMESTAMP FROM DUAL WHERE NOT EXISTS (SELECT 1 FROM CARTONS_RECEIVED WHERE CARTON = ?)");
                stmtCartonsReceived.setString(1, sscc);
                stmtCartonsReceived.setString(2, sscc);
                stmtCartonsReceived.executeUpdate();
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
            this.vhidxs.add(this.vhidx);
            firstTran = false;
        }
    }

    protected void insertDBSockReceiptDetails(long forTranidx) throws SQLException {
        List<TransactionItem> items = this.cartonReceipt != null ? new ArrayList<CartonItem>(this.cartonReceipt.items) : this.nonASNTransactionReceipt.items;
        for (TransactionItem item : items) {
            StyleLine line;
            if (item instanceof CartonItem && ((CartonItem)item).tranIdx != forTranidx || !(item.getCurrReceivedQty() > 0.0)) continue;
            if (this.quarantineUnexpectedItems && item.currReceivedQty > item.qty - item.prevReceivedQty) {
                if (item.qty - item.prevReceivedQty > 0.0) {
                    line = new StyleLine(item.skuidx, item.qty - item.prevReceivedQty, this.sParams);
                    line.db_insertline();
                }
                line = new StyleLine(item.barcode, false, this.sParams);
                line.setQty(item.getCurrReceivedQty() - item.qty + item.prevReceivedQty);
                line.db_insertline();
                try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("update ret_trand set line_type = ?, line_code = ?  where vshidx = ?");){
                    prepStmt.setInt(1, 99);
                    prepStmt.setString(2, item.barcode);
                    prepStmt.setLong(3, this.sParams.currVal("XRET_TRAND"));
                    prepStmt.executeUpdate();
                }
                if (line.getSkuidx() >= 0L) continue;
                prepStmt = this.sParams.conn.prepareStatement("update ret_trand set skuidx = null  where vshidx = ?");
                var8_7 = null;
                try {
                    prepStmt.setLong(1, this.sParams.currVal("XRET_TRAND"));
                    prepStmt.executeUpdate();
                    continue;
                }
                catch (Throwable throwable) {
                    var8_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (prepStmt == null) continue;
                    if (var8_7 != null) {
                        try {
                            prepStmt.close();
                        }
                        catch (Throwable throwable) {
                            var8_7.addSuppressed(throwable);
                        }
                        continue;
                    }
                    prepStmt.close();
                    continue;
                }
            }
            line = new StyleLine(item.skuidx, item.currReceivedQty, this.sParams);
            line.db_insertline();
            if (!this.autoPrintDisplayLabels || !item.printLabel.booleanValue() || this.clrIdxsToPrint.contains(line.getClridx())) continue;
            this.clrIdxsToPrint.add(line.getClridx());
            this.skusToPrint.add(line.getSkuidx());
        }
    }

    private boolean printDisplayLabels(long skuidx) {
        Date dNow = new Date();
        Timestamp tNow = new Timestamp(dNow.getTime());
        SkuLabel skuLabel = PrinterLabelFactory.createSkuLabel(skuidx, tNow);
        skuLabel.setPrintQuantity(this.autoPrintDisplayLabelQty);
        return skuLabel.writeLabelToFile();
    }

    protected void clearCartonLocks() {
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("DELETE FROM CARTON_RECEIPT_LOCKS WHERE LAST_UPDATED_TILL = ? AND RECEIPT_STATE = 1");){
            stmt.setString(1, this.sParams.tillnum.toUpperCase());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public void dispose() {
        this.clearCartonLocks();
        super.dispose();
    }

    private boolean confirmQuarantineReceipt() {
        StringBuilder warningMsg = new StringBuilder();
        double overs = this.getCartonReceipt().getOvers();
        double unders = this.getCartonReceipt().getUnders();
        if (overs > 0.0) {
            warningMsg.append(MessageFormat.format(SP.getRS("Stock_Receipt_Over"), overs) + "\r\n");
        }
        if (unders > 0.0) {
            warningMsg.append(MessageFormat.format(SP.getRS("Stock_Receipt_Short"), unders) + "\r\n");
        }
        warningMsg.append(SP.getRS("Complete_Receipt"));
        return DlgMessage.showMessage(this, warningMsg.toString(), SP.getRS("Unexpected_Items"), 2, 3) == 0;
    }

    private boolean confirmStockReceipt(int transType, PaStockReceipt body, double totalReceived) {
        StringBuilder msg = new StringBuilder();
        String stkShort = null;
        if (this.getCartonReceipt() != null && this.getCartonReceipt().getUnders() > 0.0) {
            stkShort = SP.getRS(this.getCartonReceipt().getUnders() > 1.0 ? "Stock_Receipt_Short" : "Stock_Receipt_Short_1");
            msg.append(MessageFormat.format(stkShort, this.getCartonReceipt().getUnders()) + "\r\n");
        } else if (this.getNonASNTransactionReceipt() != null && this.getNonASNTransactionReceipt().getUnders() > 0.0) {
            stkShort = SP.getRS(this.getNonASNTransactionReceipt().getUnders() > 1.0 ? "Stock_Receipt_Short" : "Stock_Receipt_Short_1");
            msg.append(MessageFormat.format(stkShort, this.getNonASNTransactionReceipt().getUnders()) + "\r\n");
        }
        String fromDesc = transType == 248 || transType == 251 ? body.tfSupplier.getDesc() : body.tfWhse.getDesc();
        if (transType == 248) {
            msg.append(MessageFormat.format(SP.getRS(totalReceived > 1.0 ? "units_received_docket" : "unit_received_docket"), PosDouble.valueOf(totalReceived, 4), fromDesc, "\r\n", body.tfDock.getText()) + "\r\n");
        } else {
            msg.append(MessageFormat.format(SP.getRS(totalReceived > 1.0 ? "units_received" : "unit_received"), PosDouble.valueOf(totalReceived, 4), fromDesc) + "\r\n");
        }
        int dlgIcon = 1;
        if (this.getCartonReceipt() == null) {
            msg.append(SP.getRS("Complete_Receipt"));
        } else if (this.getCartonReceipt().getOvers() == 0.0 && this.getCartonReceipt().getUnders() == 0.0) {
            msg.append(SP.getRS("Complete_Receipt"));
        } else {
            msg.append(SP.getRS("Complete_Receipt_Final"));
            dlgIcon = 2;
        }
        if (this.getNonASNTransactionReceipt() != null && this.getNonASNTransactionReceipt().getUnders() == 0.0 && this.getNonASNTransactionReceipt().getOvers() == 0.0) {
            return true;
        }
        return DlgMessage.showMessage(this, msg.toString(), SP.getRS("Confirm_rec"), 2, dlgIcon) == 0;
    }

    protected void markCartonReceiptLockAsComplete() throws SQLException {
        try (PreparedStatement stmtUpd = this.sParams.conn.prepareStatement("UPDATE CARTON_RECEIPT_LOCKS  SET LAST_UPDATED = CURRENT_TIMESTAMP, LAST_UPDATED_MEMIDX = ?, LAST_UPDATED_TILL = ?, RECEIPT_STATE = 2 WHERE SSCC = ?");){
            stmtUpd.setLong(1, this.getUser().getMemidx());
            stmtUpd.setString(2, this.sParams.tillnum.toUpperCase());
            stmtUpd.setString(3, this.getCartonReceipt().sscc);
            stmtUpd.executeUpdate();
        }
    }
}

