/*
 * Decompiled with CFR 0.152.
 */
package jpos.stockreceipt;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import jpos.Carrier;
import jpos.DlgMessage;
import jpos.PaTransferInAbstract;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTableListener;
import jpos.PosTableModelEvent;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.Store;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.utils.Utils;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.stockreceipt.Carton;
import jpos.stockreceipt.CartonItem;
import jpos.stockreceipt.FrStockReceipt;
import jpos.stockreceipt.NonASNTransaction;
import jpos.stockreceipt.PaStockReceiptFoot;
import jpos.stockreceipt.TransactionItem;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class PaStockReceipt
extends PaTransferInAbstract {
    SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String barcode = "";
            try (SqlQuery sql = new SqlQuery(PaStockReceipt.this.sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    barcode = sql.getString(1);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            PaStockReceipt.this.processBarcodeLater(barcode);
        }
    };
    ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(PaStockReceipt.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String apn = sql.getString(2);
                    if (sql.next()) {
                        PaStockReceipt.this.tfSize.search(this.getidx(), PaStockReceipt.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaStockReceipt.this.processBarcodeLater(apn);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaStockReceipt.this.frParent.isLoggedIn(true)) {
                FrStockReceipt frame;
                PaStockReceipt.this.search = true;
                if (this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans)) {
                    this.setText("");
                }
                if (!(frame = (FrStockReceipt)PaStockReceipt.this.frParent).stockReceiptLoaded() && frame.transType != 248 && frame.transType != 1) {
                    if (PaStockReceipt.this.incomingStockSearch(this.getText())) {
                        PaStockReceipt.this.displayCartonDetails();
                        if (!PaStockReceipt.this.getTransferDets("")) {
                            PaStockReceipt.this.frParent.voidTrans(false);
                        }
                    }
                } else {
                    super.actionSearch();
                }
                this.requestFocus();
                this.selectAll();
            }
        }

        @Override
        public void actionValidate() {
            if (!PaStockReceipt.this.search) {
                return;
            }
            PaStockReceipt.this.search = false;
            if (!(this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans) || !((FrStockReceipt)PaStockReceipt.this.frParent).stockReceiptLoaded() && ((PaStockReceipt)PaStockReceipt.this).frParent.transType != 248)) {
                super.actionValidate();
                try (SqlQuery sqlClr = new SqlQuery(PaStockReceipt.this.sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (sqlClr.next()) {
                        long clridx = sqlClr.getLong(1);
                        String clrname = sqlClr.getString(2);
                        if (sqlClr.next()) {
                            PaStockReceipt.this.tfClr.search(this.getidx(), this.getText());
                        } else {
                            try (SqlQuery sqlBarcode = new SqlQuery(PaStockReceipt.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                                if (sqlBarcode.next()) {
                                    String apn = sqlBarcode.getString(2);
                                    if (sqlBarcode.next()) {
                                        PaStockReceipt.this.tfSize.search(clridx, this.getText(), clrname);
                                    } else {
                                        PaStockReceipt.this.processBarcodeLater(apn);
                                    }
                                }
                            }
                        }
                    }
                    this.clear();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    BJTextField tfTransSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    BJTextField tfPurchOrderSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    BJTextField tfTransferOrderSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    BJTextField tfIncomingStockSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    StyleTable tblStyles;
    private TotalsTable tblTotals;
    LabelSubHeading lFrom = new LabelSubHeading();
    protected BJTextField tfWhse = new BJTextField(TouchTextField.FontSize.LARGE);
    protected HintTextField tfSupplier = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE);
    private SearchPanel supplierSearchPanel = new SearchPanel(this.tfSupplier);
    protected Vector<Store> transferInStores = new Vector();
    protected Vector<Reference> suppliers = new Vector();
    LabelSubHeading lCarton = new LabelSubHeading();
    LabelSubHeading lSsccDisplay = new LabelSubHeading();
    LabelSubHeading lCarrier = new LabelSubHeading();
    LabelSubHeading lConNote = new LabelSubHeading();
    LabelSubHeading lCartonXofY = new LabelSubHeading();
    GridBagLayout gridBagLayout = new GridBagLayout();
    StringField tfDock = new StringField(20, TouchTextField.FontSize.LARGE);
    LabelSubHeading lFeedBack = new LabelSubHeading();
    LabelSubHeading lDock = new LabelSubHeading();
    String num;
    LabelSubHeading lFeedBack2 = new LabelSubHeading();
    StoreParams sParams;
    boolean blindReceipt = true;

    public PaStockReceipt(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        this.blindReceipt = Settings.getBlindReceipt();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        try {
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT SR.SUPIDX, SR.CODE, SR.NAME FROM SUPPLIER SR WHERE SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER + " ORDER BY SR.CODE");){
                while (sql.next()) {
                    this.suppliers.add(new Reference(sql.getString(3), sql.getString(2), sql.getLong(1)));
                }
            }
            sql = new SqlQuery(this.sParams.conn, "SELECT W.STORENO, W.WIDX, R.CODE, R.NAME FROM WHSE W, REFCODE R WHERE R.RCIDX = W.WIDX AND R.RGIDX = 7 AND W.\"TYPE\" <> 'V' AND R.\"ACTIVE\" = 1 " + this.sParams.sWhseRefSecWhereWHSEStkReceipts + " " + "ORDER BY R.CODE");
            var2_3 = null;
            try {
                while (sql.next()) {
                    this.transferInStores.add(new Store(sql.getString(4), sql.getString(3), sql.getString(1), sql.getLong(2)));
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (var2_3 != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.tfWhse.setCache(this.sParams.cacher, 985L, "3798,3797", "", "1=1 " + this.sParams.sWhseRefSecWhereWHSEStkReceipts);
        this.tfWhse.setSearchKey(123);
        this.tfWhse.searchWithEnter(true);
        this.tfWhse.setShowSearchForOneResult(true);
        this.tfSupplier.setCache(this.sParams.cacher, 694L, "", "", "SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER);
        this.tfSupplier.setSearchKey(123);
        this.tfSupplier.searchWithEnter(true);
        this.tfSupplier.setShowSearchForOneResult(true);
        this.setFromField(250);
        this.tblStyles = new StyleTable(this.frParent, null);
        this.tblStyles.addTableModelListener(new PosTableListener(){

            @Override
            public void tableValueChanging(PosTableModelEvent e) {
                if (((PaStockReceipt)PaStockReceipt.this).frParent.transnum == null && ((FrStockReceipt)((PaStockReceipt)PaStockReceipt.this).frParent).pordidx < 0L || ((PaStockReceipt)PaStockReceipt.this).frParent.transType != 250 && ((PaStockReceipt)PaStockReceipt.this).frParent.transType != 251) {
                    return;
                }
                if (((FrStockReceipt)PaStockReceipt.this.frParent).canOverReceipt()) {
                    if (((FrStockReceipt)PaStockReceipt.this.frParent).getCartonReceipt() != null) {
                        e.setAllow(PaStockReceipt.this.lockCartonReceipt(((FrStockReceipt)PaStockReceipt.this.frParent).getCartonReceipt()));
                    }
                    return;
                }
                if (e.getColumn() == 6) {
                    if (((FrStockReceipt)PaStockReceipt.this.frParent).getCartonReceipt() != null && !PaStockReceipt.this.lockCartonReceipt(((FrStockReceipt)PaStockReceipt.this.frParent).getCartonReceipt())) {
                        e.setAllow(false);
                        return;
                    }
                    int row = e.getFirstRow();
                    double prevReceived = ((PosDouble)PaStockReceipt.this.tblStyles.getValueAt(row, 5)).doubleValue();
                    Object o = e.getNewValue();
                    Double d = Double.parseDouble(o.equals("") ? "0.0" : o.toString());
                    if (d > PaStockReceipt.this.tblStyles.getReqQty(row) - prevReceived) {
                        PaStockReceipt.this.notifyOverReceipt();
                        e.setAllow(false);
                    }
                }
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 6 || e.getType() == 1) {
                    PaStockReceipt.this.stockReceiveQtyChanges(e);
                }
                PaStockReceipt.this.update();
            }
        });
        this.tblStyles.model.setAllowEditingReceivedCol(!((FrStockReceipt)this.frParent).forceScan);
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 4: {
                        return new PosDouble(PaStockReceipt.this.tblStyles.getReqQty());
                    }
                    case 5: {
                        return new PosDouble(PaStockReceipt.this.tblStyles.getOrigQty());
                    }
                    case 6: {
                        return new PosDouble(PaStockReceipt.this.tblStyles.getQty() - PaStockReceipt.this.tblStyles.getOrigQty());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaStockReceipt.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStockReceipt.this.tfBarcode_actionPerformed(e);
            }
        });
        this.lFrom.setText(StoreParams.res.getString("Supplier"));
        this.tfWhse.setFieldWidth(200);
        this.tfSupplier.setFieldWidth(200);
        this.tfDock.setFieldWidth(120);
        this.tfDock.setHorizontalAlignment(4);
        this.tfDock.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaStockReceipt.this.tfDock_focusGained(e);
            }
        });
        this.tfDock.setVisible(false);
        this.lDock.setVisible(false);
        this.lFeedBack.setText(StoreParams.res.getString("Transfer"));
        this.lDock.setText(StoreParams.res.getString("Docket_"));
        this.add((Component)this.lFeedBack, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lDock, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 8, 0, 8), 0, 0));
        this.add((Component)this.lFrom, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 1, 2, 2, 1.0, 0.0, 18, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add((Component)this.lFeedBack2, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 0, new Insets(0, 260, 10, 0), 0, 0));
        this.add((Component)this.lSsccDisplay, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.tfDock, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 8, 10, 8), 0, 0));
        this.add((Component)this.tfWhse, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.supplierSearchPanel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.lCarton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 5), 0, 0));
        this.add((Component)this.lConNote, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 10, 10), 0, 0));
        this.add((Component)this.lCartonXofY, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 10, 5), 0, 0));
        this.add((Component)this.lCarrier, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 3, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 6, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add(this.tfTransSearch);
        this.tfTransSearch.setVisible(false);
        this.add(this.tfPurchOrderSearch);
        this.tfPurchOrderSearch.setVisible(false);
        this.add(this.tfTransferOrderSearch);
        this.tfTransferOrderSearch.setVisible(false);
        this.add(this.tfIncomingStockSearch);
        this.tfIncomingStockSearch.setVisible(false);
        this.add(this.tfClr);
        this.tfClr.setVisible(false);
        this.add(this.tfSize);
        this.tfSize.setVisible(false);
        this.tfTransSearch.setCache(this.sParams.cacher, this.sParams.iconn, 662L, "1089,1090,1091,1102", "", "H.\"ACTIVE\" = 1 AND NVL(H.TRANSFER_COMPLETE_FLAG, 0) = 0 AND H.TO_WIDX = " + this.sParams.getStoreIdx() + this.sParams.sWhseRefSecWhereWHSEStkReceipts);
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.RECEIVING_PO_BY_ASN)) {
            this.tfPurchOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1510L, "15115", "", "P.WHSE = " + this.sParams.getStoreIdx());
        } else {
            this.tfPurchOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1082L, "10391", "", "P.WHSE = " + this.sParams.getStoreIdx());
        }
        this.tfTransferOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1474L, "14275,14281,14276", "", "AND H.TOTQ + H.totpack > 0 AND WH.WIDX = " + this.sParams.getStoreIdx());
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tfDock);
        v.add(this.tfWhse);
        v.add(this.tfSupplier);
        v.add(this.tblStyles);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void processBarcodeLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PaStockReceipt.this.processBarcode(barcode);
                    PaStockReceipt.this.tfBarcode.setText("");
                    PaStockReceipt.this.tfBarcode.requestFocus();
                }
                catch (BarcodeException be) {
                    PaStockReceipt.this.tfBarcode.setText(be.getMessage());
                    PaStockReceipt.this.tfBarcode.selectAll();
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void processBarcode(String barcode) throws BarcodeException {
        frame = (FrStockReceipt)this.frParent;
        if (!frame.stockReceiptLoaded() && frame.transType != 248 && frame.transType != 1 && barcode.length() > 1 && !barcode.substring(0, 1).toUpperCase().equals("O")) {
            if (this.incomingStockSearch(barcode)) {
                this.displayCartonDetails();
                if (!this.getTransferDets("")) {
                    this.frParent.voidTrans(false);
                }
                return;
            }
            throw new BarcodeException(StoreParams.invalidBarcode);
        }
        if (!frame.stockReceiptLoaded() && frame.transType != 248 && frame.transType != 1 && barcode.length() > 1 && barcode.substring(0, 1).toUpperCase().equals("O")) {
            this.num = barcode;
            this.frParent.voidTrans(false);
            if (!this.getTransferDets(this.num)) {
                this.frParent.voidTrans(false);
                throw new BarcodeException(StoreParams.invalidTrans);
            }
        } else if (!(barcode.isEmpty() || barcode.equals(StoreParams.invalidBarcode) || this.frParent.transnum == null && this.frParent.transType != 248 && this.frParent.transType != 251)) {
            try {
                defBarcode = PosUtils.getDefaultBarcode(barcode);
                if (!defBarcode.isEmpty()) {
                    linenum = this.tblStyles.addEAN(defBarcode);
                    if (linenum == -1) {
                        throw new BarcodeException(StoreParams.invalidBarcode);
                    }
                    if (linenum >= -1) ** GOTO lbl120
                    throw new BarcodeException(StoreParams.invalidBarcode);
                }
                if (barcode.length() == 20) {
                    if (this.frParent.transType != 250) {
                        throw new BarcodeException(StoreParams.invalidBarcode);
                    }
                    try {
                        stmt = this.sParams.conn.prepareStatement("SELECT RECEIVE_DATE FROM CARTONS_RECEIVED WHERE CARTON = ?");
                        var5_9 = null;
                        try {
                            stmt.setString(1, barcode);
                            r = stmt.executeQuery();
                            var7_14 = null;
                            try {
                                if (r.next()) {
                                    throw new BarcodeException("Error", StoreParams.res.getString("barcode_scanned_in_previous_session"));
                                }
                            }
                            catch (Throwable var8_17) {
                                var7_14 = var8_17;
                                throw var8_17;
                            }
                            finally {
                                if (r != null) {
                                    if (var7_14 != null) {
                                        try {
                                            r.close();
                                        }
                                        catch (Throwable var8_16) {
                                            var7_14.addSuppressed(var8_16);
                                        }
                                    } else {
                                        r.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable r) {
                            var5_9 = r;
                            throw r;
                        }
                        finally {
                            if (stmt != null) {
                                if (var5_9 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable r) {
                                        var5_9.addSuppressed(r);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        PosUtils.logError(e);
                    }
                    this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("carton", barcode).getXML();
                    if (this.sParams.root == null) ** GOTO lbl120
                    if (this.sParams.root.getChild("skus") != null) {
                        skus = this.sParams.root.getChild("skus").getChildren();
                        if (skus.size() <= 0) ** GOTO lbl120
                        for (i = 0; i < skus.size(); ++i) {
                            sku = (Element)skus.get(i);
                            trannum = "";
                            if (sku.getAttribute("trannum") != null) {
                                trannum = sku.getAttribute("trannum").getValue();
                            }
                            if (!trannum.equals(this.frParent.transnum)) {
                                objs = new Object[]{barcode};
                                throw new BarcodeException(StoreParams.cartonContentInvalid, MessageFormat.format(StoreParams.res.getString("CartonNotOnTrans"), objs));
                            }
                            if (sku.getAttribute("barcode") != null) continue;
                            objs = new Object[]{sku.getAttribute("desc").getValue()};
                            throw new BarcodeException(StoreParams.cartonContentInvalid, MessageFormat.format(StoreParams.res.getString("SkuWithoutBarcode"), objs));
                        }
                        for (i = 0; i < skus.size(); ++i) {
                            sku = (Element)skus.get(i);
                            try {
                                qty = sku.getAttribute("qty").getIntValue();
                            }
                            catch (DataConversionException e) {
                                qty = 0;
                            }
                            defBarcode = PosUtils.getDefaultBarcode(sku.getAttribute("barcode").getValue());
                            while (qty > 0) {
                                if (this.tblStyles.addEAN(defBarcode) == -1) {
                                    throw new BarcodeException(StoreParams.invalidBarcode);
                                }
                                --qty;
                            }
                        }
                    }
                    throw new BarcodeException(StoreParams.cartonContentInvalid);
                }
                if (frame.quarantineUnexpectedItems) {
                    if (DlgMessage.showMessage(frame, MessageFormat.format(SP.getRS("Unrecognised_Barcode_Confirm"), new Object[]{barcode}), SP.getRS("Unrecognised_Barcode"), 0, 3) == 0) {
                        this.tblStyles.setAllowInvalid(true);
                        row = this.tblStyles.addEAN(barcode, true, false);
                        if (row >= 0) {
                            this.tblStyles.setAllowInvalid(false);
                            this.tblStyles.setValueAt(barcode, row, 0);
                        }
                        throw new BarcodeException(StoreParams.invalidBarcode);
                    }
                    throw new BarcodeException(StoreParams.res.getString("BarcodeInvalid"));
                }
                throw new BarcodeException(StoreParams.res.getString("BarcodeInvalid"));
            }
            catch (NumberFormatException n) {
                throw new BarcodeException(StoreParams.invalidBarcode);
            }
        } else {
            if (frame.stockReceiptLoaded() || this.frParent.transType == 248 || frame.transType == 1) {
                throw new BarcodeException(SP.getRS("BarcodeInvalid"));
            }
            if (this.frParent.transnum == null) {
                throw new BarcodeException(StoreParams.noTrans);
            }
            throw new BarcodeException(StoreParams.invalidBarcode);
        }
lbl120:
        // 6 sources

        this.tfBarcode.requestFocus();
    }

    protected void tfBarcode_actionPerformed(ActionEvent e) {
        this.frParent.setCursor(StoreParams.waitCursor);
        try {
            this.processBarcode(this.tfBarcode.getText());
            this.tfBarcode.setText("");
            this.tfBarcode.selectAll();
            this.tfBarcode.requestFocus();
        }
        catch (BarcodeException be) {
            if (be.getErrorDetail() != null) {
                DlgMessage.showMessage(this.frParent, be.getErrorDetail(), StoreParams.res.getString("Stop"), 0);
            }
            this.tfBarcode.setText(be.getMessage());
            this.tfBarcode.selectAll();
            this.tfBarcode.requestFocus();
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    protected void delLines() {
        int[] rows = this.tblStyles.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (this.tblStyles.getOrigQty(rows[i]) == 0.0) {
                String barcode = this.tblStyles.getBarcode(rows[i]);
                this.tblStyles.delLine(rows[i], false, true);
                FrStockReceipt frame = (FrStockReceipt)this.frParent;
                if (!frame.stockReceiptLoaded()) continue;
                StyleLine line = this.tblStyles.getStyleLines().get(i);
                Carton carton = frame.getCartonReceipt();
                if (carton != null) {
                    carton.setReceivedQty(barcode, line.getSkuidx(), 0.0);
                    continue;
                }
                if (frame.getNonASNTransactionReceipt() == null) continue;
                NonASNTransaction tran = frame.getNonASNTransactionReceipt();
                tran.setReceivedQty(barcode, line.getSkuidx(), 0.0);
                continue;
            }
            this.tblStyles.setRowSelectionInterval(rows[i], rows[i]);
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("This_line_has_already"), objs));
        }
    }

    protected boolean getTransferDets(String number) {
        FrStockReceipt frame = (FrStockReceipt)this.frParent;
        if (frame.getNonASNTransactionReceipt() != null) {
            NonASNTransaction tran = frame.getNonASNTransactionReceipt();
            if (tran.tranType.equals("PO")) {
                frame.pordidx = tran.tranIdx;
                frame.setTransnum(tran.tranNum);
                frame.setTransType(251);
                if (!this.checkSupplier(tran.getFromIdx())) {
                    return false;
                }
                this.tfSupplier.clear();
                this.tfSupplier.setAll(tran.fromIdx, tran.from, tran.from);
            } else if (tran.tranType.equals("TR")) {
                frame.setTransnum(tran.tranNum);
                frame.setTransType(250);
                this.tfWhse.clear();
                this.tfWhse.setAll(tran.fromIdx, tran.from, tran.from);
            }
            return this.stockReceiptpopulateQty();
        }
        if (frame.getCartonReceipt() != null) {
            Carton carton = frame.getCartonReceipt();
            if (carton.getTranType().equals("PO")) {
                frame.pordidx = Long.parseLong(carton.getTranIdx());
                frame.setTransnum(carton.getTranNum());
                frame.setTransType(251);
                if (!this.checkSupplier(carton.getFromIdx())) {
                    return false;
                }
                this.tfSupplier.clear();
                this.tfSupplier.setAll(carton.fromIdx, carton.from, carton.from);
            } else if (carton.getTranType().equals("TR")) {
                frame.setTransnum(carton.getTranNum());
                frame.setTransType(250);
                this.tfWhse.clear();
                this.tfWhse.setAll(carton.fromIdx, carton.from, carton.from);
            }
            return this.stockReceiptpopulateQty();
        }
        if (number.length() < 2) {
            return false;
        }
        this.lFeedBack.setText(StoreParams.res.getString("Searching_for"));
        this.frParent.validate();
        this.frParent.paint(this.frParent.getGraphics());
        ((PaStockReceiptFoot)this.frParent.paFoot).bDirect.setEnabled(false);
        try {
            Element root;
            if (number.substring(0, 1).toUpperCase().equals("O")) {
                if (!this.frParent.hasSecurity(2786L, 0)) {
                    return false;
                }
                try {
                    int sordidx = Integer.parseInt(number.substring(1));
                    this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("transferorder", sordidx + "," + this.sParams.getStoreIdx()).getXML();
                    if (this.sParams.root == null) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            ((FrStockReceipt)this.frParent).transRoot = root = (Element)this.sParams.root.clone();
            if (root.getAttribute("widx") == null) {
                return false;
            }
            if (!this.isDataUpToDate(root)) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_not_up_to_date"), "\n", "\n"), StoreParams.res.getString("Error"), 0);
                this.frParent.voidTrans(false);
                return true;
            }
            if (root.getAttribute("to_widx") == null || root.getAttribute("to_widx").getLongValue() != this.sParams.getStoreIdx()) {
                Object[] objs = new Object[]{"\n"};
                String msg = MessageFormat.format(StoreParams.res.getString("This_transfer_has"), objs);
                DlgMessage.showMessage(this.frParent, msg, StoreParams.res.getString("Stop"), 2);
                this.frParent.voidTrans(false);
                return true;
            }
            if (root.getAttribute("transfer_complete_flag") != null) {
                int nCompleteFlag = root.getAttribute("transfer_complete_flag").getIntValue();
                if (nCompleteFlag == 3) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_cancelled"), objs), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                if (nCompleteFlag > 0) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_complete"), objs), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
            }
            String connote = "";
            if (root.getAttribute("connum") != null) {
                connote = StringUtils.nullToEmpty(root.getAttribute("connum").getValue());
                this.lFeedBack2.setText(SP.getRS("ConNote_X", connote));
            }
            if (root.getAttribute("carrier") != null) {
                ((FrStockReceipt)this.frParent).carrier = new Carrier(root.getAttribute("carrier").getLongValue());
                if (!StringUtils.isNullOrEmpty(((FrStockReceipt)this.frParent).carrier.getUrl())) {
                    this.lFeedBack2.setLink(((FrStockReceipt)this.frParent).carrier.getUrl(connote));
                }
            }
            if (!this.tblStyles.populate(root)) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_was_an_error"), objs), StoreParams.res.getString("Invalid"), 0);
                return false;
            }
            if (number.substring(0, 1).toUpperCase().equals("O")) {
                this.frParent.setTransnum(root.getAttribute("trans_number").getValue());
                this.frParent.setTransType(1);
                this.tfWhse.clear();
                if (root.getAttribute("widx") != null) {
                    Store store = this.getTransferInStore(root.getAttribute("widx").getLongValue());
                    if (store != null) {
                        this.tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                    } else {
                        this.tfWhse.clear();
                    }
                }
            } else {
                return false;
            }
            this.update();
            if (this.tblStyles.getReqQty() == 0.0) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_are_no_qtys_on"), objs));
                return false;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected void update() {
        ((FrStockReceipt)this.frParent).setButtons();
    }

    protected void db_populateQty(String num, String vhidx) {
        String from_widx = this.frParent.transType == 250 && this.tfWhse.getidx() > 0L ? String.valueOf(this.tfWhse.getidx()) : "";
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.TRANS_NUMBER, H.DOCKET_NUMBER, D.SKUIDX, D.QTY FROM RET_TRANH H, RET_TRAND D, STYLE S, CLR C, SKU K WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE = " + this.frParent.transType + " AND D.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX " + " AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(num) + (vhidx != null ? " AND H.VHIDX < " + vhidx : "") + (!from_widx.equals("") ? " AND H.FROM_WIDX = " + from_widx : "") + " ORDER BY S.STYLECODE, C.CLRCODE, K.SIZESEQ ");){
            while (sql.next()) {
                int row = this.tblStyles.addSku(sql.getLong(3), 0.0, true, true);
                this.tblStyles.addSku(sql.getLong(3), sql.getDouble(4), true, true);
                this.tblStyles.setOrigQty(row, sql.getDouble(4) + this.tblStyles.getOrigQty(row));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected boolean stockReceiptpopulateQty() {
        boolean error = false;
        if (!this.blindReceipt) {
            FrStockReceipt frame = (FrStockReceipt)this.frParent;
            if (frame.getCartonReceipt() != null) {
                Carton carton = frame.getCartonReceipt();
                for (CartonItem item : carton.items) {
                    long skuidx = item.skuidx;
                    int row = this.tblStyles.addSku(skuidx, 0.0, true, true);
                    if (row >= 0) {
                        StyleLine line = this.tblStyles.getStyleLines().get(row);
                        line.setReqQty(item.getQty() + line.getReqQty());
                        continue;
                    }
                    error = true;
                    break;
                }
            } else if (frame.getNonASNTransactionReceipt() != null) {
                NonASNTransaction tran = frame.getNonASNTransactionReceipt();
                for (TransactionItem item : tran.items) {
                    long skuidx = item.skuidx;
                    int row = this.tblStyles.addSku(skuidx, 0.0, true, true);
                    if (row >= 0) {
                        StyleLine line = this.tblStyles.getStyleLines().get(row);
                        line.setReqQty(item.getQty() + line.getReqQty());
                        line.setOrigQty(item.getPrevReceivedQty());
                        line.setQty(item.getPrevReceivedQty());
                        continue;
                    }
                    error = true;
                    break;
                }
            }
            if (error) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("There_was_an_error"), "\r\n"), SP.getRS("Invalid"), 0);
                return !error;
            }
        }
        return !error;
    }

    protected void setFromField(int type) {
        if (type == 251 || type == 248) {
            this.tfSupplier.setVisible(true);
            this.tfWhse.setVisible(false);
            this.lFrom.setText(StoreParams.res.getString("Supplier"));
        } else {
            this.tfSupplier.setVisible(false);
            this.tfWhse.setVisible(true);
            this.lFrom.setText(StoreParams.res.getString("From"));
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANTransferIn);
    }

    void tfDock_focusGained(FocusEvent e) {
        this.frParent.setStatusMsg(StoreParams.res.getString("enter_docket"));
    }

    protected void receiptAll() {
        FrStockReceipt frame;
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        if ((frame = (FrStockReceipt)this.frParent).getCartonReceipt() != null && !this.lockCartonReceipt(frame.getCartonReceipt())) {
            return;
        }
        for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
            double prevReceived;
            double required = ((PosDouble)this.tblStyles.getValueAt(i, 4)).doubleValue();
            if (required - (prevReceived = ((PosDouble)this.tblStyles.getValueAt(i, 5)).doubleValue()) < 0.0) {
                this.tblStyles.setValueAt(new PosDouble(0.0), i, 6);
                continue;
            }
            this.tblStyles.setValueAt(new PosDouble(required - prevReceived), i, 6);
        }
    }

    public Store getTransferInStore(long widx) {
        for (int i = 0; i < this.transferInStores.size(); ++i) {
            if (this.transferInStores.elementAt(i).getWidx() != widx) continue;
            return this.transferInStores.elementAt(i);
        }
        return null;
    }

    private boolean isDataUpToDate(Element transaction) {
        String transactionNumber;
        Timestamp localLastRecDate;
        PosDateFormatter headOfficeLastRecDate = new PosDateFormatter(null, 3, 3, 2);
        if (transaction.getAttribute("last_received_date") != null) {
            try {
                headOfficeLastRecDate.setTimestampInternal(transaction.getAttribute("last_received_date").getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isPurchaseOrder = transaction.getName().equals("porder");
        long fromWarehouse = 0L;
        if (!isPurchaseOrder && transaction.getAttribute("widx") != null) {
            try {
                fromWarehouse = transaction.getAttribute("widx").getLongValue();
            }
            catch (DataConversionException e) {
                // empty catch block
            }
        }
        if ((localLastRecDate = this.getLastReceiveDate(transactionNumber = isPurchaseOrder ? transaction.getAttributeValue("pordidx") : transaction.getAttributeValue("trans_number"), fromWarehouse, isPurchaseOrder)) == null) {
            return true;
        }
        return headOfficeLastRecDate.getTimestamp() != null && localLastRecDate.getTime() <= headOfficeLastRecDate.getTimestamp().getTime();
    }

    private boolean isDataUpToDate(NonASNTransaction tran) {
        String transactionNumber;
        Timestamp localLastRecDate;
        boolean isPurchaseOrder = tran.tranType.equals("PO");
        long fromWarehouse = 0L;
        if (!isPurchaseOrder) {
            fromWarehouse = tran.fromIdx;
        }
        if ((localLastRecDate = this.getLastReceiveDate(transactionNumber = isPurchaseOrder ? String.valueOf(tran.tranIdx) : tran.tranNum, fromWarehouse, isPurchaseOrder)) == null) {
            return true;
        }
        return tran.lastReceivedTime != null && localLastRecDate.getTime() <= tran.lastReceivedTime.getTime();
    }

    /*
     * Exception decompiling
     */
    private boolean isCartonReceived(String sscc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getLastReceiveDate(String transactionNumber, long fromWarehouse, boolean isPurchaseOrder) {
        PreparedStatement stmt = null;
        try {
            if (!isPurchaseOrder) {
                stmt = this.sParams.conn.prepareStatement("SELECT MAX(H.TRAND) AS TRAND FROM RET_TRANH H WHERE H.TR_TYPE = 250 AND H.TRANS_NUMBER = ? AND H.FROM_WIDX = ? AND H.\"ACTIVE\" = 1");
                stmt.setString(1, transactionNumber);
                stmt.setLong(2, fromWarehouse);
            } else {
                stmt = this.sParams.conn.prepareStatement("SELECT MAX(H.TRAND) AS TRAND FROM RET_TRANH H WHERE H.TR_TYPE = 251 AND H.PORDIDX = ? AND H.\"ACTIVE\" = 1");
                stmt.setString(1, transactionNumber);
            }
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    Timestamp time = result.getTimestamp("trand");
                    if (time != null) {
                        time.setTime(time.getTime() / 1000L * 1000L);
                    }
                    Timestamp timestamp = time;
                    PosUtils.closeStatement(stmt);
                    return timestamp;
                }
            }
            PosUtils.closeStatement(stmt);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        finally {
            PosUtils.closeStatement(stmt);
        }
        return null;
    }

    public void processBarcodes(Vector<String> vBarcodes) {
        this.frParent.setCursor(StoreParams.waitCursor);
        for (int i = 0; i < vBarcodes.size(); ++i) {
            String barcode = vBarcodes.elementAt(i);
            try {
                if (barcode.indexOf(",") > 0) {
                    barcode = barcode.substring(0, barcode.indexOf(","));
                }
                this.processBarcode(barcode);
                continue;
            }
            catch (BarcodeException e) {
                Object[] objs = new Object[]{e.getMessage() + " " + barcode, "\n"};
                if (DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("ContinueProceed"), objs), StoreParams.res.getString("Continue_"), 0, 3) == 1) break;
            }
        }
        this.tfBarcode.setText("");
        this.tfBarcode.selectAll();
        this.tfBarcode.requestFocus();
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    private void displayCartonDetails() {
        if (this.frParent instanceof FrStockReceipt) {
            FrStockReceipt frame = (FrStockReceipt)this.frParent;
            String docketDefault = "";
            if (frame.getCartonReceipt() != null) {
                Carton carton = frame.getCartonReceipt();
                this.lCarton.setText(SP.getRS("Carton_Number") + carton.sscc);
                if (carton.carrier != null && !carton.carrier.isEmpty()) {
                    this.lCarrier.setText(SP.getRS("Carrier_Heading") + " " + carton.carrier);
                }
                if (carton.conNote != null && !carton.conNote.isEmpty()) {
                    this.lConNote.setText(SP.getRS("Consignment_Heading") + " " + carton.conNote);
                }
                String cartonXofY = MessageFormat.format(SP.getRS("ASN_Cartons_Progress"), carton.getCartonsReceivedInASN().size() + 1, carton.getCartonsInASN().size());
                this.lCartonXofY.setText(cartonXofY);
                if (carton.getTranType().equals("PO") && (docketDefault = carton.getTranNum() + "_" + String.valueOf(carton.getCartonsReceivedInASN().size() + 1)).length() > 20) {
                    docketDefault = "..." + docketDefault.substring(docketDefault.length() - 15, docketDefault.length());
                }
                this.setColumnsVisibility();
            } else if (frame.getNonASNTransactionReceipt() != null) {
                NonASNTransaction tran = frame.getNonASNTransactionReceipt();
                if (tran.carrier != null && !tran.carrier.isEmpty()) {
                    this.lCarrier.setText(SP.getRS("Carrier_Heading") + " " + tran.carrier);
                }
                if (tran.conNote != null && !tran.conNote.isEmpty()) {
                    this.lConNote.setText(SP.getRS("Consignment_Heading") + tran.conNote);
                }
                if (tran.GetTranType().equals("PO") && (docketDefault = tran.GetTranNum()).length() > 20) {
                    docketDefault = "..." + docketDefault.substring(docketDefault.length() - 17, docketDefault.length());
                }
                this.setColumnsVisibility();
            }
            if (docketDefault != null && !docketDefault.isEmpty()) {
                this.tfDock.setText(docketDefault);
            }
        }
    }

    public void setStockSearchCache(List<String> tranTypes, String skuFilter) {
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT SSCC, LAST_UPDATED FROM CARTON_RECEIPT_LOCKS WHERE SSCC IS NOT NULL AND RECEIPT_STATE = 2 UNION SELECT CARTON, RECEIVE_DATE FROM CARTONS_RECEIVED ORDER BY 2 DESC");
             ResultSet result = stmt.executeQuery();){
            StringBuilder ssccExclusions = new StringBuilder();
            for (int i = 0; result.next() && i < 40; ++i) {
                ssccExclusions.append(",'" + result.getString("SSCC"));
                ssccExclusions.append("'");
            }
            if (ssccExclusions.length() > 0) {
                ssccExclusions.deleteCharAt(0);
                ssccExclusions.insert(0, " AND (S.SSCC IS NULL OR S.SSCC NOT IN (");
                ssccExclusions.append("))");
            }
            String tranTypeFilter = "";
            if (tranTypes.size() == 0) {
                tranTypeFilter = " and 1 = 0";
            } else if (tranTypes.size() == 1) {
                tranTypeFilter = " and S.TRAN_TYPE = '" + tranTypes.get(0) + "'";
            }
            this.tfIncomingStockSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1512L, "", "", "S.WIDX = " + this.sParams.getStoreIdx() + ssccExclusions + tranTypeFilter + skuFilter);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected void setColumnsVisibility() {
        if (this.frParent.transType == 1) {
            this.tblStyles.showReceivedCols(false);
            this.tblStyles.showPrevReceivedCols(false);
            this.tblStyles.showRequiredCols(true);
        } else {
            if (this.frParent.transType == 248) {
                this.tblStyles.showRequiredCols(false);
            } else {
                this.tblStyles.showRequiredCols(!this.blindReceipt);
            }
            if (this.frParent instanceof FrStockReceipt) {
                if (((FrStockReceipt)this.frParent).getCartonReceipt() != null || this.frParent.transType == 248) {
                    this.tblStyles.showPrevReceivedCols(false);
                } else {
                    this.tblStyles.showPrevReceivedCols(!this.blindReceipt);
                }
            }
            this.tblStyles.showReceivedCols(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean lockCartonReceipt(Carton carton) {
        try {
            PosUtils.startTrans(this.sParams.conn);
            String sscc = carton.GetSscc();
            String tillName = this.sParams.tillnum.toUpperCase();
            long memIdx = this.frParent.getUser().getMemidx();
            try (PreparedStatement stmtAdd = this.sParams.conn.prepareStatement("INSERT INTO CARTON_RECEIPT_LOCKS  (SSCC, LAST_UPDATED_MEMIDX, LAST_UPDATED, LAST_UPDATED_TILL, RECEIPT_STATE) VALUES (?,?,CURRENT_TIMESTAMP,?,1)");){
                stmtAdd.setString(1, sscc);
                stmtAdd.setLong(2, memIdx);
                stmtAdd.setString(3, tillName);
                stmtAdd.executeUpdate();
                PosUtils.endTrans(this.sParams.conn);
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 335544665) {
                    PosUtils.logError(e);
                    return false;
                }
                try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT crl.*, m.MEMFULL as MEMNAME  FROM CARTON_RECEIPT_LOCKS crl LEFT JOIN MEMBER m ON m.MEMIDX = crl.LAST_UPDATED_MEMIDX  WHERE crl.SSCC = ? ");){
                    stmt.setString(1, sscc);
                    try (ResultSet result = stmt.executeQuery();){
                        if (!result.next()) return false;
                        if (result.getInt("RECEIPT_STATE") == 2 || result.getInt("RECEIPT_STATE") == 1 && !result.getString("LAST_UPDATED_TILL").equals(tillName)) {
                            String memName = result.getString("MEMNAME");
                            String lockTill = result.getString("LAST_UPDATED_TILL");
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("Receipt_Already_Locked_Message"), memName, lockTill), SP.getRS("Receipt_Already_Locked_Title"), 0);
                            boolean bl = false;
                            return bl;
                        }
                        try (PreparedStatement stmtUpd = this.sParams.conn.prepareStatement("UPDATE CARTON_RECEIPT_LOCKS  SET RECEIPT_STATE = 1, LAST_UPDATED = CURRENT_TIMESTAMP, LAST_UPDATED_MEMIDX = ?, LAST_UPDATED_TILL = ? WHERE SSCC = ?");){
                            stmtUpd.setLong(1, memIdx);
                            stmtUpd.setString(2, tillName);
                            stmtUpd.setString(3, sscc);
                            stmtUpd.executeUpdate();
                        }
                        PosUtils.endTrans(this.sParams.conn);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (SQLException e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
        }
        return false;
    }

    protected void stockReceiveQtyChanges(TableModelEvent e) {
        block8: {
            double receivedQty;
            String barcode;
            StyleLine line;
            FrStockReceipt frame;
            block9: {
                frame = (FrStockReceipt)this.frParent;
                if (!frame.stockReceiptLoaded()) break block8;
                int row = e.getFirstRow();
                line = this.tblStyles.getStyleLines().get(row);
                barcode = line.getBarcode();
                receivedQty = ((PosDouble)this.tblStyles.getValueAt(row, 6)).doubleValue();
                Carton carton = frame.getCartonReceipt();
                if (carton == null) break block9;
                if (line.isValid()) {
                    carton.setReceivedQty(barcode, line.getSkuidx(), receivedQty);
                } else {
                    carton.setReceivedQty(barcode, -1L, receivedQty);
                }
                for (CartonItem item : carton.getItems()) {
                    if (item.printLabel != null) continue;
                    Element result = this.sParams.OnlineQueryProvider.getOnlineQuery("clridx_stock_by_store", line.getClridx() + "@" + this.sParams.getStore().getStoreNo()).getXML();
                    if (result != null) {
                        item.printLabel = Integer.parseInt(result.getText()) <= 0;
                        continue;
                    }
                    item.printLabel = false;
                }
                break block8;
            }
            if (frame.getNonASNTransactionReceipt() == null) break block8;
            NonASNTransaction tran = frame.getNonASNTransactionReceipt();
            if (line.isValid()) {
                tran.setReceivedQty(barcode, line.getSkuidx(), receivedQty);
            } else {
                tran.setReceivedQty(barcode, -1L, receivedQty);
            }
            for (TransactionItem item : tran.getItems()) {
                if (item.printLabel != null) continue;
                Element result = this.sParams.OnlineQueryProvider.getOnlineQuery("clridx_stock_by_store", line.getClridx() + "@" + this.sParams.getStore().getStoreNo()).getXML();
                if (result != null) {
                    item.printLabel = Integer.parseInt(result.getText()) <= 0;
                    continue;
                }
                item.printLabel = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incomingStockSearch(String filter) {
        block57: {
            FrStockReceipt frame = (FrStockReceipt)this.frParent;
            ArrayList<String> tranTypes = new ArrayList<String>();
            if (this.frParent.hasSecurity(11147L, 0)) {
                tranTypes.add("PO");
            }
            if (this.frParent.hasSecurity(11132L, 0)) {
                tranTypes.add("TR");
            }
            if (tranTypes.size() > 0) {
                if (this.sParams.checkIConn()) {
                    this.tfIncomingStockSearch.clear();
                    filter = filter.trim();
                    String queryFilter = "";
                    String skuFilter = "";
                    try (PreparedStatement bar = this.sParams.conn.prepareStatement("SELECT skuidx  FROM BARCODE WHERE code = ?");){
                        bar.setString(1, filter);
                        try (ResultSet resultSku = bar.executeQuery();){
                            if (resultSku.next()) {
                                skuFilter = " AND CheckIncomingSkus(s.INCOMING_STOCK_ID, " + resultSku.getInt("SKUIDX") + ") = 1";
                            }
                        }
                    }
                    catch (SQLException e) {
                        PosUtils.logError(e);
                    }
                    if (skuFilter.isEmpty()) {
                        if (filter.length() == 20) {
                            queryFilter = "PC_" + filter;
                            try {
                                if (this.isCartonReceived(filter)) {
                                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Carton_Received"), StoreParams.res.getString("Error"), -1, 0);
                                    return false;
                                }
                            }
                            catch (SQLException e) {
                                PosUtils.logError(e);
                            }
                        } else if (filter.toUpperCase().startsWith("T") || filter.toUpperCase().startsWith("D")) {
                            queryFilter = "TR_" + filter;
                        } else if (filter.toUpperCase().startsWith("P")) {
                            queryFilter = "PO_" + filter;
                        }
                    }
                    this.setStockSearchCache(tranTypes, skuFilter);
                    Element queryResult = null;
                    if (!queryFilter.isEmpty()) {
                        queryResult = this.sParams.OnlineQueryProvider.getOnlineQuery("newstockreceipt", String.join((CharSequence)",", tranTypes) + "@" + queryFilter).getXML(false);
                    }
                    if (queryResult == null) {
                        try {
                            this.tfIncomingStockSearch.setSuppressNoDataMessage(true);
                            this.tfIncomingStockSearch.doSearch();
                        }
                        finally {
                            this.tfIncomingStockSearch.setSuppressNoDataMessage(false);
                        }
                        queryFilter = this.tfIncomingStockSearch.getidxStr();
                        if (!queryFilter.isEmpty() && queryFilter != "0") {
                            queryResult = this.sParams.OnlineQueryProvider.getOnlineQuery("newstockreceipt", String.join((CharSequence)",", tranTypes) + "@" + queryFilter).getXML(false);
                        }
                    }
                    if (queryResult != null) {
                        Element root;
                        ((FrStockReceipt)this.frParent).transRoot = root = (Element)queryResult.clone();
                        ((FrStockReceipt)this.frParent).completedTransNum = "";
                        XMLOutputter outp = new XMLOutputter();
                        String temp = outp.outputString(queryResult);
                        try {
                            Carton carton = null;
                            NonASNTransaction nonASNTransactionReceipt = null;
                            if (queryResult.getName().equals("Carton")) {
                                carton = Carton.createCartonFromXmlString(temp);
                                if (this.isCartonReceived(carton.sscc)) {
                                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Carton_Received"), StoreParams.res.getString("Error"), -1, 0);
                                    return false;
                                }
                                this.refreshASNCartonReceived(carton);
                                frame.cartonReceipt = carton;
                                return true;
                            }
                            nonASNTransactionReceipt = NonASNTransaction.createTransactionFromXmlString(temp);
                            if (!this.nonASNReceiptLocking(nonASNTransactionReceipt)) break block57;
                            if (!this.isDataUpToDate(nonASNTransactionReceipt)) {
                                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_not_up_to_date"), "\n", "\n"), StoreParams.res.getString("Error"), 0);
                                break block57;
                            }
                            frame.nonASNTransactionReceipt = nonASNTransactionReceipt;
                            return true;
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                    }
                } else {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                }
            } else {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
            }
        }
        return false;
    }

    private void refreshASNCartonReceived(Carton carton) throws SQLException {
        List dbCartons = carton.cartonsInASN.stream().map(sscc -> Utils.StrToDBX(sscc)).collect(Collectors.toList());
        ArrayList<String> groups = new ArrayList<String>();
        int maxCartonSize = 1498;
        for (int i = 0; i < dbCartons.size(); i += maxCartonSize) {
            groups.add(String.join((CharSequence)",", dbCartons.subList(i, Math.min(i + maxCartonSize, dbCartons.size()))));
        }
        List<String> cartonRecv = carton.getCartonsReceivedInASN();
        for (String group : groups) {
            Throwable throwable;
            ResultSet result;
            try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT sscc  FROM CARTON_RECEIPT_LOCKS WHERE SSCC in (" + group + ")  AND RECEIPT_STATE = 2");){
                result = stmt.executeQuery();
                throwable = null;
                try {
                    while (result.next()) {
                        if (cartonRecv.contains(result.getString(1))) continue;
                        cartonRecv.add(result.getString(1));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (result != null) {
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            stmt = this.sParams.conn.prepareStatement("SELECT CARTON  FROM CARTONS_RECEIVED WHERE CARTON in (" + group + ")");
            var9_10 = null;
            try {
                result = stmt.executeQuery();
                throwable = null;
                try {
                    while (result.next()) {
                        if (cartonRecv.contains(result.getString(1))) continue;
                        cartonRecv.add(result.getString(1));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (result == null) continue;
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    result.close();
                }
            }
            catch (Throwable throwable6) {
                var9_10 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt == null) continue;
                if (var9_10 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var9_10.addSuppressed(throwable7);
                    }
                    continue;
                }
                stmt.close();
            }
        }
        carton.setCartonsReceivedInASN(cartonRecv);
    }

    private boolean nonASNReceiptLocking(NonASNTransaction tran) {
        if (this.frParent.transType == 251 || this.frParent.transType == 250) {
            String transNum;
            String uniqueLockId = transNum = tran.GetTranNum();
            if (this.frParent.transType == 250) {
                uniqueLockId = tran.getFromIdx() + "-" + uniqueLockId;
            }
            if (!this.frParent.lockTransaction(uniqueLockId, transNum, this.frParent.transType)) {
                this.frParent.voidTrans(false);
                return false;
            }
        }
        return true;
    }

    private boolean checkSupplier(long fromIdx) {
        this.tfSupplier.clear();
        if (this.frParent.transType == 248 || this.frParent.transType == 251) {
            boolean bFound = false;
            for (int j = 0; j < this.suppliers.size(); ++j) {
                if (this.suppliers.elementAt(j).getIdx() != fromIdx) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("Unable_retrieve_no_supplier_sec"), objs), SP.getRS("Error"), 0);
                return false;
            }
        }
        return true;
    }

    class BarcodeException
    extends Exception {
        String errDetail;

        public BarcodeException(String barcodeErr) {
            super(barcodeErr);
        }

        public BarcodeException(String barcodeErr, String errDetail) {
            super(barcodeErr);
            this.errDetail = errDetail;
        }

        public BarcodeException() {
            super("Unknown barcode");
        }

        public String getErrorDetail() {
            return this.errDetail;
        }
    }
}

