/*
 * Decompiled with CFR 0.152.
 */
package jpos.taxlookup;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.logging.RollingLog;
import jpos.taxlookup.AvaTaxMenu;
import jpos.taxlookup.AvaTaxSettings;
import jpos.taxlookup.ITaxLookup;
import jpos.taxlookup.TaxLookupDeliveryInfo;
import jpos.taxlookup.TaxLookupPerson;
import jpos.taxlookup.TaxMenu;
import net.avalara.avatax.rest.client.AvaTaxClient;
import net.avalara.avatax.rest.client.AvaTaxClientException;
import net.avalara.avatax.rest.client.TransactionBuilder;
import net.avalara.avatax.rest.client.enums.DocumentType;
import net.avalara.avatax.rest.client.enums.TaxOverrideType;
import net.avalara.avatax.rest.client.enums.TransactionAddressType;
import net.avalara.avatax.rest.client.models.AvaTaxMessage;
import net.avalara.avatax.rest.client.models.ErrorDetail;
import net.avalara.avatax.rest.client.models.PingResultModel;
import net.avalara.avatax.rest.client.models.TransactionAddressModel;
import net.avalara.avatax.rest.client.models.TransactionLineDetailModel;
import net.avalara.avatax.rest.client.models.TransactionLineModel;
import net.avalara.avatax.rest.client.models.TransactionModel;

public class AvaTaxLookup
implements ITaxLookup {
    private final String DEFAULT_CUST_CODE = "NA";
    private String errorMessage;

    @Override
    public boolean calculateTax(Vector<StyleLine> styleLines, TaxLookupPerson person, TaxLookupDeliveryInfo deliveryInfo, boolean allowLogging) {
        if (allowLogging) {
            RollingLog.log(RollingLog.LogType.AVATAX, Level.INFO, "Calculating Tax...");
        }
        this.errorMessage = null;
        AvaTaxSettings settings = new AvaTaxSettings();
        if (!this.checkSettings(settings)) {
            return false;
        }
        AvaTaxClient client = null;
        try {
            client = this.initClient(settings);
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
        TransactionModel transaction = null;
        try {
            String customerCode = person.getCustomerCode().isEmpty() ? "NA" : person.getCustomerCode();
            TransactionBuilder builder = new TransactionBuilder(client, settings.getCompanyCode(), DocumentType.SalesOrder, customerCode);
            this.addCustomerDetails(builder, person);
            this.addAddresses(builder, settings, deliveryInfo);
            builder.getIntermediaryTransactionModel().setReportingLocationCode(SP.sParams.getStore(SP.sParams.getStoreIdx()).getCode());
            int lineNumber = 0;
            for (StyleLine styleLine : styleLines) {
                builder = builder.withLine(String.valueOf(++lineNumber), new BigDecimal(SP.sParams.rnd(styleLine.getQty() * styleLine.getPrice() - styleLine.getDisc())), new BigDecimal(Math.abs(styleLine.getQty())), styleLine.getExtendedTaxCode(), styleLine.getSkuCode(), styleLine.getSkuDescription());
                if (styleLine.getTaxOverrideReason().isEmpty()) continue;
                builder = builder.withLineTaxOverride(TaxOverrideType.TaxAmount, styleLine.getTaxOverrideReason(), new BigDecimal(styleLine.getTax()), new Date());
            }
            transaction = builder.Create();
            this.logTaxResponse(transaction, allowLogging);
            for (TransactionLineModel line : transaction.getLines()) {
                StyleLine styleLine = styleLines.elementAt(PosUtils.intVal(line.getLineNumber()) - 1);
                if (styleLine == null || !styleLine.getTaxOverrideReason().isEmpty()) continue;
                double totalTax = 0.0;
                double totalRate = 0.0;
                for (TransactionLineDetailModel detail : line.getDetails()) {
                    totalRate += detail.getRate().doubleValue();
                }
                totalTax = line.getTaxCalculated().doubleValue();
                double netWithoutTax = SP.sParams.rnd(styleLine.getQty() * styleLine.getPrice() - styleLine.getDisc());
                if (netWithoutTax == 0.0) {
                    styleLine.setExtTaxPer(Math.abs(totalRate * 100.0));
                    continue;
                }
                styleLine.setExtTaxPer(Math.abs(totalTax / netWithoutTax * 100.0));
            }
            this.errorMessage = null;
            return true;
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
    }

    @Override
    public boolean commitTax(String transactionNumber, boolean isLBSOComplete, String taxOverrideReason, String salesRep, Vector<StyleLine> styleLines, TaxLookupPerson person, TaxLookupDeliveryInfo deliveryInfo, boolean allowLogging) {
        if (allowLogging) {
            RollingLog.log(RollingLog.LogType.AVATAX, Level.INFO, "Committing Tax for transaction..." + transactionNumber);
        }
        this.errorMessage = null;
        AvaTaxSettings settings = new AvaTaxSettings();
        if (!this.checkSettings(settings)) {
            return false;
        }
        AvaTaxClient client = null;
        try {
            client = this.initClient(settings);
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
        TransactionModel transaction = null;
        try {
            String customerCode = person.getCustomerCode().isEmpty() ? "NA" : person.getCustomerCode();
            TransactionBuilder builder = new TransactionBuilder(client, settings.getCompanyCode(), DocumentType.SalesInvoice, customerCode).withTransactionCode(transactionNumber).withCommit();
            this.addCustomerDetails(builder, person);
            this.addAddresses(builder, settings, deliveryInfo);
            builder.getIntermediaryTransactionModel().setSalespersonCode(salesRep);
            builder.getIntermediaryTransactionModel().setPosLaneCode(settings.getMachineName());
            builder.getIntermediaryTransactionModel().setReportingLocationCode(SP.sParams.getStore(SP.sParams.getStoreIdx()).getCode());
            int lineNumber = 0;
            HashMap<Integer, Long> lines = new HashMap<Integer, Long>();
            for (StyleLine styleLine : styleLines) {
                lines.put(++lineNumber, styleLine.getVshidx());
                double requiredQty = 0.0;
                requiredQty = isLBSOComplete && !styleLine.isNew() ? styleLine.getBackedUpQtyBeforeSave() : styleLine.getQty();
                builder = builder.withLine(String.valueOf(lineNumber), new BigDecimal(SP.sParams.rnd(styleLine.getQty() * styleLine.getPrice() - styleLine.getDisc())), new BigDecimal(Math.abs(requiredQty)), styleLine.getExtendedTaxCode(), styleLine.getSkuCode(), styleLine.getSkuDescription());
                String overrideReason = null;
                overrideReason = !taxOverrideReason.isEmpty() ? taxOverrideReason : styleLine.getTaxOverrideReason();
                if (overrideReason.isEmpty()) continue;
                double overrideTaxAmt = 0.0;
                overrideTaxAmt = isLBSOComplete ? styleLine.getTaxfForOldLayBy() : styleLine.getTax();
                builder = builder.withLineTaxOverride(TaxOverrideType.TaxAmount, overrideReason, new BigDecimal(overrideTaxAmt), new Date());
            }
            transaction = builder.Create();
            this.logTaxResponse(transaction, allowLogging);
            this.saveTaxResponse(transaction, lines);
            this.errorMessage = null;
            return true;
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
    }

    @Override
    public String getLastErrorMessage() {
        return StringUtils.nullToEmpty(this.errorMessage);
    }

    @Override
    public boolean testConnection(boolean allowLogging) {
        if (allowLogging) {
            RollingLog.log(RollingLog.LogType.AVATAX, Level.INFO, "Testing Connection...");
        }
        this.errorMessage = null;
        AvaTaxSettings settings = new AvaTaxSettings();
        if (!this.checkSettings(settings)) {
            return false;
        }
        AvaTaxClient client = null;
        try {
            client = this.initClient(settings);
            PingResultModel ping = client.ping();
            if (!ping.getAuthenticated().booleanValue()) {
                this.errorMessage = "Could not authenticate credentials";
                return false;
            }
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
        TransactionModel transaction = null;
        try {
            TransactionBuilder builder = new TransactionBuilder(client, settings.getCompanyCode(), DocumentType.SalesOrder, "TEST_CUSTOMER").withAddress(TransactionAddressType.SingleLocation, settings.getStoreLocation().getAddressLine1(), settings.getStoreLocation().getAddressLine2(), null, settings.getStoreLocation().getCity(), settings.getStoreLocation().getState(), settings.getStoreLocation().getPostcode(), settings.getStoreLocation().getCountry()).withLine(new BigDecimal(100.0), new BigDecimal(1), "P0000000");
            builder.getIntermediaryTransactionModel().setReportingLocationCode(SP.sParams.getStore(SP.sParams.getStoreIdx()).getCode());
            transaction = builder.Create();
            if (transaction != null && transaction.getMessages() != null && transaction.getMessages().size() > 0) {
                this.processErrorMessage(settings, transaction.getMessages());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.processException(settings, e);
            return false;
        }
    }

    @Override
    public TaxMenu getMenu(PosFrame parent) {
        return new AvaTaxMenu(parent);
    }

    private AvaTaxClient initClient(AvaTaxSettings settings) throws Exception {
        return new AvaTaxClient(settings.getAppName(), settings.getAppVersion(), settings.getMachineName(), settings.getRemoteUrl()).withSecurity(settings.getAccount(), settings.getLicense());
    }

    private void addCustomerDetails(TransactionBuilder builder, TaxLookupPerson person) {
        if (!person.getCustomerCode().isEmpty()) {
            if (!person.getAvaTaxExemptCode().isEmpty()) {
                builder = builder.withCustomerUsageType(person.getAvaTaxExemptCode());
            }
            if (!person.getTaxExemptCertificate().isEmpty()) {
                builder = builder.withExemptionNo(person.getTaxExemptCertificate());
            }
        }
    }

    private void addAddresses(TransactionBuilder builder, AvaTaxSettings settings, TaxLookupDeliveryInfo deliveryInfo) {
        if (deliveryInfo != null && deliveryInfo.isDeliveryAddressLoaded() && deliveryInfo.isDeliveryAddressComplete()) {
            builder = builder.withAddress(TransactionAddressType.ShipFrom, settings.getStoreLocation().getAddressLine1(), settings.getStoreLocation().getAddressLine2(), null, settings.getStoreLocation().getCity(), settings.getStoreLocation().getState(), settings.getStoreLocation().getPostcode(), settings.getStoreLocation().getCountry());
            builder = builder.withAddress(TransactionAddressType.ShipTo, deliveryInfo.getAddressLine1(), deliveryInfo.getAddressLine2(), null, deliveryInfo.getCity(), deliveryInfo.getState(), deliveryInfo.getPostcode(), deliveryInfo.getCountry().getCode());
        } else {
            builder = builder.withAddress(TransactionAddressType.SingleLocation, settings.getStoreLocation().getAddressLine1(), settings.getStoreLocation().getAddressLine2(), null, settings.getStoreLocation().getCity(), settings.getStoreLocation().getState(), settings.getStoreLocation().getPostcode(), settings.getStoreLocation().getCountry());
        }
    }

    private boolean checkSettings(AvaTaxSettings settings) {
        this.errorMessage = "";
        if (StringUtils.nullToEmpty(settings.getAccount()).isEmpty()) {
            this.errorMessage = this.errorMessage + SP.getRS("AvaTax_Account_Missing") + "\n";
        }
        if (StringUtils.nullToEmpty(settings.getLicense()).isEmpty()) {
            this.errorMessage = this.errorMessage + SP.getRS("AvaTax_License_Missing") + "\n";
        }
        if (StringUtils.nullToEmpty(settings.getCompanyCode()).isEmpty()) {
            this.errorMessage = this.errorMessage + SP.getRS("AvaTax_Company_Code_Missing") + "\n";
        }
        if (StringUtils.nullToEmpty(settings.getRemoteUrl()).isEmpty()) {
            this.errorMessage = this.errorMessage + SP.getRS("AvaTax_Remote_URL_Missing") + "\n";
        }
        if (this.errorMessage.length() > 0) {
            RollingLog.log(RollingLog.LogType.AVATAX, Level.SEVERE, this.errorMessage);
            return false;
        }
        return true;
    }

    private void logTaxResponse(TransactionModel transaction, boolean allowLogging) {
        if (!allowLogging) {
            return;
        }
        StringBuffer log = new StringBuffer();
        log.append("\nTransaction Status: " + transaction.getStatus().toString());
        log.append("\nCode: " + transaction.getCode());
        log.append("\nId: " + transaction.getId());
        log.append("\nTotal Amount: " + transaction.getTotalAmount().toString());
        log.append("\nTotal Tax Calculated Amount: " + transaction.getTotalTaxCalculated().toString());
        log.append("\nTotalTax: " + transaction.getTotalTax().toString());
        for (TransactionAddressModel address : transaction.getAddresses()) {
            String addressType = "Unknown";
            if (address.getId().equals(transaction.getOriginAddressId())) {
                addressType = "From";
            } else if (address.getId().equals(transaction.getDestinationAddressId())) {
                addressType = "To";
            }
            log.append("\n" + addressType + " Adrs1: " + address.getLine1() + ", Adrs2: " + address.getLine2() + ", City: " + address.getCity() + ", Region: " + address.getRegion() + ", Postcode: " + address.getPostalCode() + ", Country: " + address.getCountry());
        }
        for (TransactionLineModel line : transaction.getLines()) {
            log.append("\n         Line: " + line.getLineNumber() + ", Style: " + line.getItemCode() + ", Descript: " + line.getDescription() + ", TaxCode: " + line.getTaxCode() + ", Tax: " + line.getTax());
            for (TransactionLineDetailModel detail : line.getDetails()) {
                log.append("\n          JurisType: " + detail.getJurisType() + " | Region: " + detail.getRegion() + " | Rate: " + detail.getRate() + " | TaxableAmount: " + detail.getTaxableAmount() + " | Tax: " + detail.getTax() + " | JuriName: " + detail.getJurisName() + " | JurisCode: " + detail.getJurisCode() + " | TaxName: " + detail.getTaxName());
            }
        }
        RollingLog.log(RollingLog.LogType.AVATAX, Level.INFO, log.toString());
    }

    private void saveTaxResponse(TransactionModel transaction, Map<Integer, Long> linesNumAndVshidxs) {
        for (TransactionLineModel line : transaction.getLines()) {
            for (TransactionLineDetailModel detail : line.getDetails()) {
                Integer vshidx = Integer.parseInt(line.getLineNumber());
                if (vshidx == -1) continue;
                try {
                    PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO AVATAX_SALE_ITEMS_DET(ADIDX, VSHIDX, EXEMPT_AMT, TAXABLE_AMT, TAX_NAME, TAX, JURIS_TYPE, JURIS_RATE, JURIS_REGION, JURIS_CODE, JURIS_NAME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
                    Throwable throwable = null;
                    try {
                        long avataxDetIdx = SP.sParams.nextVal("XAVATAX_SALE_ITEMS_DET");
                        stmt.setLong(1, avataxDetIdx);
                        stmt.setLong(2, linesNumAndVshidxs.get(vshidx));
                        stmt.setBigDecimal(3, detail.getExemptAmount());
                        stmt.setBigDecimal(4, detail.getTaxableAmount());
                        stmt.setString(5, detail.getTaxName());
                        stmt.setBigDecimal(6, detail.getTax());
                        stmt.setInt(7, detail.getJurisdictionType().getValue());
                        stmt.setBigDecimal(8, detail.getRate());
                        stmt.setString(9, detail.getRegion());
                        stmt.setString(10, detail.getJurisCode());
                        stmt.setString(11, detail.getJurisName());
                        stmt.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    }

    private void processErrorMessage(AvaTaxSettings settings, ArrayList<AvaTaxMessage> messages) {
        String logError = this.errorMessage = SP.getRS("AvaTax_Exception");
        for (AvaTaxMessage message : messages) {
            String messageSummary = message.getSummary();
            this.errorMessage = messageSummary.toLowerCase().contains("nested exception") ? this.errorMessage + "\n" + MessageFormat.format(SP.getRS("AvaTax_Online_Communication_Error"), settings.getRemoteUrl(), "\n") : this.errorMessage + "\n" + messageSummary;
            logError = logError + "\n" + messageSummary + "\n" + message.getDetails();
        }
        RollingLog.log(RollingLog.LogType.AVATAX, Level.SEVERE, logError);
    }

    private void processException(AvaTaxSettings settings, Exception e) {
        if (e.getMessage().contains("java.net.") || e.getMessage().contains("404") || e.getMessage().toLowerCase().contains("nested exception")) {
            this.errorMessage = MessageFormat.format(SP.getRS("AvaTax_Online_Communication_Error"), settings.getRemoteUrl(), "\n");
        } else if (e instanceof AvaTaxClientException) {
            this.errorMessage = SP.getRS("AvaTax_Exception") + "\n" + ((AvaTaxClientException)e).getErrorResult().getError().getMessage();
            ArrayList details = ((AvaTaxClientException)e).getErrorResult().getError().getDetails();
            if (details != null && details.size() > 0) {
                for (ErrorDetail detail : details) {
                    this.errorMessage = this.errorMessage + "\n" + detail.getDescription();
                }
            }
        } else {
            this.errorMessage = SP.getRS("AvaTax_Exception") + "\n" + e.getMessage();
        }
        RollingLog.log(RollingLog.LogType.AVATAX, this.errorMessage, e);
    }
}

