/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import jpos.ui.GlowBorder;

public class PulseBorder
extends GlowBorder
implements AutoCloseable {
    private int refreshRateMilliseconds = 40;
    private double pulsesPerMinute = 0.0;
    private double pulseFrequency = 0.0;
    private Timer mainTimer = new Timer(this.refreshRateMilliseconds, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            double oldAlphaFactor = PulseBorder.this.alphaFactor;
            PulseBorder.this.ticks++;
            PulseBorder.this.alphaFactor = PulseBorder.this.calcAlphaFactor(PulseBorder.this.pulseFrequency, (double)((long)PulseBorder.this.refreshRateMilliseconds * PulseBorder.this.ticks) / 1000.0);
            if (PulseBorder.this.resetTimer && !PulseBorder.this.increasing && PulseBorder.this.alphaFactor >= oldAlphaFactor) {
                PulseBorder.this.resetTimer = false;
                PulseBorder.this.alphaFactor = 0.0;
                PulseBorder.this.ticks = 0L;
                if (PulseBorder.this.pulsesPerMinute <= 0.0) {
                    PulseBorder.this.mainTimer.stop();
                } else {
                    PulseBorder.this.setFrequency();
                }
            }
            if (PulseBorder.this.alphaFactor > oldAlphaFactor) {
                PulseBorder.this.increasing = true;
            } else if (PulseBorder.this.alphaFactor <= oldAlphaFactor) {
                PulseBorder.this.increasing = false;
            }
            PulseBorder.this.getParent().repaint();
        }
    });
    private long ticks = 0L;
    private boolean resetTimer = false;
    private boolean increasing = true;
    private double alphaFactor = 0.0;

    public PulseBorder(JPanel parent, int maxThickness) {
        super(parent, maxThickness);
        this.mainTimer.setRepeats(true);
        this.mainTimer.setCoalesce(true);
    }

    public double getPulsesPerMinute() {
        return this.pulsesPerMinute;
    }

    public void pulse(double pulsesPerMinute) {
        this.pulsesPerMinute = pulsesPerMinute;
        if (this.mainTimer.isRunning()) {
            this.resetTimer = true;
        } else if (pulsesPerMinute > 0.0) {
            this.setFrequency();
            this.startTimer(this.mainTimer);
        }
    }

    public void stopPulse(boolean force) {
        this.pulsesPerMinute = 0.0;
        if (force) {
            this.mainTimer.stop();
        } else {
            this.resetTimer = true;
        }
    }

    private void startTimer(Timer timer) {
        if (timer.isRunning()) {
            timer.stop();
        }
        timer.start();
    }

    private double calcAlphaFactor(double pulseFrequency, double seconds) {
        return 0.5 * (Math.cos(2.0 * pulseFrequency * seconds * Math.PI + Math.PI) + 1.0);
    }

    private void setFrequency() {
        this.pulseFrequency = this.pulsesPerMinute / 60.0;
    }

    @Override
    public Color transformColour(Color colour) {
        Color transForm = super.transformColour(colour);
        return new Color(transForm.getRed(), transForm.getGreen(), transForm.getBlue(), (int)(255.0 * this.alphaFactor));
    }

    @Override
    public void close() {
        if (this.mainTimer.isRunning()) {
            this.mainTimer.stop();
        }
    }
}

