/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import jpos.ui.Colours;
import jpos.ui.DragScrollListener;
import jpos.ui.Fonts;
import jpos.ui.UIConstants;

public class TouchList<E>
extends JList<E> {
    public TouchList() {
        this.init();
    }

    public TouchList(E[] listData) {
        super(listData);
        this.init();
    }

    public TouchList(Vector<? extends E> listData) {
        super(listData);
        this.init();
    }

    private void init() {
        this.addDragScrollListener();
        this.addKeyListener();
        this.setFixedCellHeight(UIConstants.TABLE_ROW_HEIGHT);
        this.setFont(Fonts.PlainText);
        this.addPaddingToCell();
        this.setSelectionForeground(Colours.BLACK);
        this.setSelectionBackground(Colours.SELECTED_ROW);
    }

    private void addDragScrollListener() {
        DragScrollListener l = new DragScrollListener(this);
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
    }

    private void addPaddingToCell() {
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                c.setBorder(new EmptyBorder(2, 2, 2, 2));
                return c;
            }
        });
    }

    private void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){
            private long nTime = 0L;
            private String sTyped = "";

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyChar() >= 'A' && e.getKeyChar() <= 'z') {
                    Date d = new Date();
                    this.sTyped = d.getTime() - this.nTime <= 500L ? this.sTyped + e.getKeyChar() : "" + e.getKeyChar();
                    this.nTime = d.getTime();
                    TouchList list = TouchList.this;
                    ListModel model = list.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        if (model.getElementAt(i).toString().length() < this.sTyped.length() || !model.getElementAt(i).toString().toUpperCase().startsWith(this.sTyped.toUpperCase())) continue;
                        list.setSelectedValue(model.getElementAt(i), true);
                        break;
                    }
                }
            }
        });
    }
}

