/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Window;
import java.sql.SQLException;
import java.text.MessageFormat;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.voucher.IGatewayCreator;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.vii.ViiGateway;

public class VoucherGatewayManager {
    private static VoucherGatewayManager instance;
    private long gatewayRcidx;
    private GatewayType type;
    private IVoucherGateway gateway = null;

    private VoucherGatewayManager() {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.EXTEND FROM REFCODE R WHERE R.\"ACTIVE\" = 1 AND R.RGIDX = 454");){
            if (qry.next()) {
                this.gatewayRcidx = qry.getLong("RCIDX");
                this.type = GatewayType.getById(qry.getString("EXTEND"));
            } else {
                this.gatewayRcidx = -1L;
            }
        }
        catch (SQLException e) {
            this.gatewayRcidx = -1L;
        }
    }

    public long getGatewayRcidx() {
        return this.gatewayRcidx;
    }

    public String getGatewayTypeName() {
        return this.type != null ? this.type.getName() : "";
    }

    public IVoucherGateway getGateway() {
        return this.getGateway(null);
    }

    public IVoucherGateway getGateway(Window errorMessageParent) {
        block3: {
            if (this.gateway == null && this.gatewayRcidx > 0L) {
                try {
                    this.gateway = this.type != null ? this.type.createGateway(this.gatewayRcidx) : null;
                }
                catch (VoucherGatewayException e) {
                    if (errorMessageParent == null) break block3;
                    DlgMessage.showMessage(errorMessageParent, MessageFormat.format(SP.getRS("voucher_gateway_not_available"), "\n", this.type.getName(), e.getMessage()), SP.getRS("Error"), 0);
                }
            }
        }
        return this.gateway;
    }

    public static boolean isGatewayInUse() {
        return VoucherGatewayManager.getInstance().getGatewayRcidx() > 0L;
    }

    public static boolean isGatewayReady() {
        return VoucherGatewayManager.isGatewayReady(null);
    }

    public static boolean isGatewayReady(Window errorMessageParent) {
        return VoucherGatewayManager.getInstance().getGateway(errorMessageParent) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMappedVoucher(String voucherNumber) {
        if (!voucherNumber.matches("^[0-9]+$")) {
            return "";
        }
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT GATEWAY_NUM FROM VOUCHER_GATEWAY_MAP WHERE INTERNAL_NUM = ? AND GATEWAY_NUM > ''", voucherNumber);){
            if (qry.next()) {
                String string2 = qry.getString("GATEWAY_NUM");
                return string2;
            }
            String string = "";
            return string;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return "";
        }
    }

    public double limitVoucherValue(double value) {
        if (this.getGatewayRcidx() <= 0L || this.getGateway() == null) {
            return value;
        }
        if (this.gateway.getMinValue() > 0.0 && value < this.gateway.getMinValue()) {
            return this.gateway.getMinValue();
        }
        if (this.gateway.getMaxValue() > 0.0 && value > this.gateway.getMaxValue()) {
            return this.gateway.getMaxValue();
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidGatewayVoucher(String voucherNumber) {
        if (this.getGatewayRcidx() <= 0L) return false;
        if (voucherNumber == null) {
            return false;
        }
        if (!voucherNumber.matches("^[0-9]+$")) {
            return false;
        }
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM VOUCHER_GATEWAY_RANGE WHERE VOUCHER_GATEWAY_IDX = ? AND ? LIKE PREFIX || '%' AND LENGTH = ? ORDER BY IDX", this.getGatewayRcidx(), voucherNumber, voucherNumber.length());){
            boolean bl = qry.next();
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getGatewayVoucherScanSkuBarcode(String voucherNumber) {
        if (this.getGatewayRcidx() <= 0L) return "";
        if (voucherNumber == null) {
            return "";
        }
        if (!voucherNumber.matches("^[0-9]+$")) {
            return "";
        }
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT B.CODE FROM VOUCHER_GATEWAY_RANGE R JOIN BARCODE B ON R.SCAN_SKUIDX = B.SKUIDX WHERE R.VOUCHER_GATEWAY_IDX = ? AND ? LIKE R.PREFIX || '%' AND R.LENGTH = ? AND R.SCAN_SKUIDX IS NOT NULL ORDER BY IDX", this.getGatewayRcidx(), voucherNumber, voucherNumber.length());){
            if (qry.next()) {
                String string2 = qry.getString("CODE");
                return string2;
            }
            String string = "";
            return string;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return "";
        }
    }

    public static VoucherGatewayManager getInstance() {
        if (instance == null) {
            instance = new VoucherGatewayManager();
        }
        return instance;
    }

    public static void clearInstance() throws Exception {
        if (instance != null) {
            if (VoucherGatewayManager.instance.gateway != null) {
                VoucherGatewayManager.instance.gateway.close();
            }
            instance = null;
        }
    }

    private static enum GatewayType {
        UNKNOWN("", "Unknown", rcIdx -> null),
        VII("0", "Vii", rcIdx -> new ViiGateway(rcIdx));

        private String id;
        private String name;
        private IGatewayCreator gatewayCreator;

        private GatewayType(String id, String name, IGatewayCreator gatewayCreator) {
            this.id = id;
            this.name = name;
            this.gatewayCreator = gatewayCreator;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public IVoucherGateway createGateway(long rcIdx) throws VoucherGatewayException {
            return this.gatewayCreator.create(rcIdx);
        }

        public static GatewayType getById(String id) {
            for (GatewayType gate : GatewayType.values()) {
                if (!gate.getId().equals(id)) continue;
                return gate;
            }
            return UNKNOWN;
        }
    }
}

