/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.IOErrorHandler;
import ReceiptPrinter.StoreDetails;
import ReceiptPrinter.ThreadEODReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.ui.LabelSubHeading;

public class EODReport
extends JDialog {
    JPanel jPanel1 = new JPanel();
    LabelSubHeading jLabel1 = new LabelSubHeading(){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 100);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(400, 100);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(400, 100);
        }
    };
    private Connection conn;
    boolean reprint = false;
    String docknum = "";
    private long nPrinterTimeout = 0L;
    BorderLayout borderLayout1 = new BorderLayout();

    public EODReport(Frame parent, String title, boolean modal, Connection conn, String docket_number, boolean preprint) {
        super(parent, title, modal);
        this.conn = conn;
        this.docknum = docket_number;
        this.reprint = preprint;
        this.nPrinterTimeout = PosUtils.longVal(StoreDetails.getString("timeout"));
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void close() {
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel1.setToolTipText("");
        this.jPanel1.setMinimumSize(new Dimension(400, 100));
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setHorizontalAlignment(0);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.setSize(400, 100);
        PosUtils.centreWindow(this);
    }

    public boolean PrintEODReport() {
        this.setVisible(true);
        IOErrorHandler errorHandler = new IOErrorHandler();
        this.paint(this.getGraphics());
        this.jLabel1.setText(StoreParams.res.getString("Printing_Report"));
        this.jLabel1.paint(this.jLabel1.getGraphics());
        ThreadEODReport eod = new ThreadEODReport(this.conn, this.docknum, this.reprint, errorHandler);
        eod.setDaemon(true);
        eod.start();
        try {
            eod.join(this.nPrinterTimeout * 1000L);
        }
        catch (InterruptedException e) {
            PosUtils.logError(e);
        }
        if (eod.isAlive()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Error_printing_message"), StoreParams.res.getString("Error_printing"), 0);
        } else if (errorHandler.isError()) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("error_creating_receipt_new"), "\n", errorHandler.getErrorMessage()), StoreParams.res.getString("Error"), 0);
        }
        this.setVisible(false);
        return true;
    }
}

