/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jpos.DlgManualLoyaltyDiscount;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.LoyaltyDetails;
import jpos.PaSales;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.XMLUtils;
import jpos.capillary.CapillaryApiManager;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.rewards.GiftSku;
import jpos.rewards.RewardsUtils;
import org.jdom.Element;

public class AttachedLoyaltyManager {
    private Vector<LoyaltyInfo> loyalties = new Vector();

    public Vector<LoyaltyInfo> getLoyalties() {
        return this.loyalties;
    }

    public void clear() {
        this.loyalties.clear();
    }

    public boolean contains(String cardNo) {
        return this.findLoyaltyByCardNo(cardNo) != null;
    }

    private LoyaltyInfo findLoyaltyByCardNo(String cardNo) {
        for (LoyaltyInfo info : this.loyalties) {
            if (!info.cardNo.equalsIgnoreCase(cardNo)) continue;
            return info;
        }
        return null;
    }

    public void add(PosFrame parent, Element person, String cardNo) {
        Element loyaltyElement = this.getMatchingPersonLoyalty(person, cardNo);
        if (loyaltyElement == null) {
            return;
        }
        LoyaltyInfo loyaltyInfo = this.findLoyaltyByCardNo(cardNo);
        if (loyaltyInfo == null) {
            loyaltyInfo = new LoyaltyInfo(cardNo);
            this.loyalties.add(loyaltyInfo);
        }
        loyaltyInfo.setupLoyalty(loyaltyElement);
    }

    public void addRetailRewards() {
        for (LoyaltyInfo info : this.loyalties) {
            if (info.loyaltyDetails.getLoyalty().getIdx() != 787L) continue;
            return;
        }
        LoyaltyInfo loyaltyInfo = new LoyaltyInfo("RETAIL_REWARDS");
        loyaltyInfo.setupLoyalty(787L);
        this.loyalties.add(loyaltyInfo);
    }

    public int size() {
        return this.loyalties.size();
    }

    public String getLoyaltyCardNo(int index) {
        return this.loyalties.get(index).cardNo;
    }

    public void promptForCapillaryLoyaltyOverrides(FrSales parent, Element person, boolean ignoreAlreadyAdded) {
        if (person == null || person.getAttribute("peridx") == null) {
            return;
        }
        for (LoyaltyInfo info : this.loyalties) {
            boolean transactionHasValue;
            boolean bl = transactionHasValue = ((PaSales)parent.paBody).tblStyles.getDueAvailableForManualLoyalty() + info.getNewLoyaltyAmount() > 0.0;
            if (transactionHasValue) {
                if (ignoreAlreadyAdded && info.getNewLoyaltyAmount() != 0.0) continue;
                this.promptUserForCapillaryLoyaltyAmount(parent, person, info);
                continue;
            }
            if (ignoreAlreadyAdded) continue;
            DlgMessage.showMessage(parent, SP.getRS("Nothing_can_be_discounted"), SP.getRS("Error"), 0);
        }
    }

    private void promptUserForCapillaryLoyaltyAmount(FrSales parent, Element person, LoyaltyInfo info) {
        try (DlgManualLoyaltyDiscount dlg = new DlgManualLoyaltyDiscount(parent, person, info);){
            dlg.setAmount(info.newLoyaltyAmount);
            dlg.setPoints(info.newLoyaltyPoints);
            dlg.setPointsBalance(info.newLoyaltyPointsBalance);
            dlg.setVisible(true);
            if (dlg.isOkPressed()) {
                info.newLoyaltyAmount = dlg.getAmount();
                info.newLoyaltyPoints = dlg.getPoints();
                info.newLoyaltyPointsBalance = dlg.getPointsBalance();
                parent.setThirdPartyCouponCode(dlg.getThirdPartyCouponCode());
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void promptForLoyaltyOverrides(FrSales parent, Element person, boolean ignoreAlreadyAdded) {
        if (person == null || person.getAttribute("peridx") == null) {
            return;
        }
        boolean usingRewards = RewardsUtils.usingAp21RetailRewards();
        for (LoyaltyInfo info : this.loyalties) {
            boolean transactionHasValue;
            if (!info.loyaltyDetails.getPromptForAmount()) continue;
            boolean showOnZeroTransaction = !ignoreAlreadyAdded && usingRewards && info.loyaltyDetails.getLoyalty().getIdx() == 787L;
            boolean bl = transactionHasValue = ((PaSales)parent.paBody).tblStyles.getDueAvailableForManualLoyalty() + info.getNewLoyaltyAmount() > 0.0;
            if (showOnZeroTransaction || transactionHasValue) {
                if (ignoreAlreadyAdded && info.getNewLoyaltyAmount() != 0.0) continue;
                this.promptUserForLoyaltyAmount(parent, person, info);
                continue;
            }
            if (ignoreAlreadyAdded) continue;
            DlgMessage.showMessage(parent, SP.getRS("Nothing_can_be_discounted"), SP.getRS("Error"), 0);
        }
    }

    private void promptUserForLoyaltyAmount(FrSales parent, Element person, LoyaltyInfo info) {
        boolean isRetailRewards;
        OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
        boolean noApi = info.loyaltyDetails.getLoyalty().getIdx() != 787L && !setup.isUsingLoyaltyApi(info.loyaltyDetails.getLoyalty().getIdx());
        boolean bl = isRetailRewards = RewardsUtils.usingAp21RetailRewards() && info.loyaltyDetails.getLoyalty().getIdx() == 787L;
        if (noApi || isRetailRewards || parent.rewardsApiManager.getBalance() > 0.0) {
            try (DlgManualLoyaltyDiscount dlg = new DlgManualLoyaltyDiscount(parent, person, info);){
                dlg.setAmount(info.newLoyaltyAmount);
                dlg.setVisible(true);
                if (dlg.isOkPressed()) {
                    info.newLoyaltyAmount = dlg.getAmount();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GiftSku promptForRewardsGift(FrSales parent, Element person) {
        LoyaltyInfo info;
        Iterator<LoyaltyInfo> iterator = this.loyalties.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while ((info = iterator.next()).loyaltyDetails.getLoyalty().getIdx() != 787L);
        try (DlgManualLoyaltyDiscount dlg = new DlgManualLoyaltyDiscount(parent, person, info, true);){
            dlg.setVisible(true);
            if (!dlg.isOkPressed()) return null;
            GiftSku giftSku = dlg.getSelectedGift();
            return giftSku;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    private Element getMatchingPersonLoyalty(Element person, String cardNo) {
        List loyalties = person.getChildren("perloyalty");
        for (int i = 0; i < loyalties.size(); ++i) {
            Element loyalty = (Element)loyalties.get(i);
            if (!loyalty.getAttribute("cardno").getValue().equalsIgnoreCase(cardNo)) continue;
            return loyalty;
        }
        return null;
    }

    public String getManualLoyaltyAmountsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<LoyaltyAmounts>");
        for (LoyaltyInfo info : this.loyalties) {
            if (RewardsUtils.usingCapillaryRewards()) {
                sb.append(String.format("<Rewards amount=\"%s\" />", new PosDouble(SP.sParams.rnd(info.newLoyaltyAmount + info.returnLoyaltyAmount)).toString()));
                break;
            }
            if (!info.loyaltyDetails.getPromptForAmount()) continue;
            if (info.loyaltyDetails.getLoyalty().getIdx() == 787L) {
                sb.append(String.format("<Rewards amount=\"%s\" />", new PosDouble(SP.sParams.rnd(info.newLoyaltyAmount + info.returnLoyaltyAmount)).toString()));
                continue;
            }
            sb.append(String.format("<Loyalty loyalty_idx=\"%s\" amount=\"%s\" />", info.loyaltyDetails.getLoyalty().getIdx(), new PosDouble(info.newLoyaltyAmount).toString()));
        }
        sb.append("</LoyaltyAmounts>");
        return sb.toString();
    }

    public void fixUpAmounts(FrSales frSales) {
        PaSales salesPanel = (PaSales)frSales.paBody;
        for (LoyaltyInfo info : this.loyalties) {
            if (!info.loyaltyDetails.getPromptForAmount()) continue;
            double tableAmount = salesPanel.tblStyles.getLoyaltyTotal(info.getLoyaltyDetails().getLoyalty().getIdx());
            if (info.loyaltyDetails.getLoyalty().getIdx() == 787L) {
                info.newLoyaltyAmount = Math.max(SP.sParams.rnd(tableAmount - info.returnLoyaltyAmount), 0.0);
                double transTotal = salesPanel.tblStyles.getDueAvailableForManualLoyalty() + info.getNewLoyaltyAmount();
                if (!(transTotal < frSales.getRewardsMinimumSpend()) || info.newLoyaltyAmount == 0.0) continue;
                info.newLoyaltyAmount = 0.0;
                salesPanel.tblStyles.processPromotions();
                continue;
            }
            info.newLoyaltyAmount = tableAmount;
        }
    }

    public void setRewardsReturnAmount(double amount) {
        for (LoyaltyInfo info : this.loyalties) {
            if (info.loyaltyDetails.getLoyalty().getIdx() != 787L) continue;
            info.returnLoyaltyAmount = amount;
            break;
        }
    }

    public void requestRewardsRedemption(FrSales frSales) {
        OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
        for (LoyaltyInfo info : this.loyalties) {
            if (info.loyaltyDetails.getLoyalty().getIdx() != 787L && !setup.isUsingLoyaltyApi(info.loyaltyDetails.getLoyalty().getIdx()) && !RewardsUtils.usingCapillaryRewards()) continue;
            frSales.rewardsApiManager.setCardNo(info.cardNo);
            frSales.rewardsApiManager.setPerIdx(XMLUtils.getLongValue(frSales.getPerson(), "peridx"));
            frSales.rewardsApiManager.setRequestAmount(info.newLoyaltyAmount);
            if (!(frSales.rewardsApiManager instanceof CapillaryApiManager) || !RewardsUtils.usingCapillaryRewards()) break;
            ((CapillaryApiManager)frSales.rewardsApiManager).setRequestPoints(info.newLoyaltyPoints);
            ((CapillaryApiManager)frSales.rewardsApiManager).setRequestPointsBalance(info.newLoyaltyPointsBalance);
            break;
        }
    }

    public class LoyaltyInfo {
        private String cardNo;
        private double newLoyaltyAmount = 0.0;
        private double returnLoyaltyAmount = 0.0;
        private double newLoyaltyPoints = 0.0;
        private double newLoyaltyPointsBalance = 0.0;
        private LoyaltyDetails loyaltyDetails;

        public String getCardNo() {
            return this.cardNo;
        }

        public double getNewLoyaltyAmount() {
            return this.newLoyaltyAmount;
        }

        public double getReturnLoyaltyAmount() {
            return this.returnLoyaltyAmount;
        }

        public double getNewLoyaltyPoints() {
            return this.newLoyaltyPoints;
        }

        public double getNewLoyaltyPointsBalance() {
            return this.newLoyaltyPointsBalance;
        }

        public LoyaltyDetails getLoyaltyDetails() {
            return this.loyaltyDetails;
        }

        public LoyaltyInfo(String cardNo) {
            this.cardNo = cardNo;
        }

        public void setupLoyalty(Element loyalty) {
            this.loyaltyDetails = new LoyaltyDetails(new Reference(366L, loyalty.getText(), false));
        }

        public void setupLoyalty(long rcidx) {
            this.loyaltyDetails = new LoyaltyDetails(new Reference(rcidx, false));
        }
    }
}

