/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.StringUtils;

public class Barcode {
    private String barcode;
    private BarcodeType type;

    public Barcode(String barcode, BarcodeType type) {
        this.barcode = StringUtils.nullToEmpty(barcode);
        this.type = type;
    }

    public boolean isValid() {
        switch (this.type) {
            case NONE: {
                return true;
            }
            case EAN13: {
                return this.barcode.length() == 13 && this.validateEAN();
            }
        }
        return true;
    }

    public static boolean isValid(String barcode, BarcodeType type) {
        Barcode code = new Barcode(barcode, type);
        return code.isValid();
    }

    private boolean validateEAN() {
        if (this.barcode.isEmpty() || !Barcode.isAllDigits(this.barcode)) {
            return false;
        }
        String mainCode = this.barcode.substring(0, this.barcode.length() - 1);
        int checkDigit = Character.getNumericValue(this.barcode.charAt(this.barcode.length() - 1));
        try {
            if (checkDigit != this.calcEanCheckDigit(mainCode)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private int calcEanCheckDigit(String barcode) throws Exception {
        char[] digits = barcode.toCharArray();
        int sum = 0;
        for (int i = 0; i < digits.length; ++i) {
            char c = digits[digits.length - i - 1];
            if (!Character.isDigit(c)) {
                throw new Exception("EAN barcode contains non-numeric characters");
            }
            sum += Character.getNumericValue(c) * (i % 2 == 0 ? 3 : 1);
        }
        int checkDigit = 10 - sum % 10;
        return checkDigit < 10 ? checkDigit : 0;
    }

    private static boolean isAllDigits(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static enum BarcodeType {
        NONE(0),
        EAN13(1);

        private final int databaseFlag;

        private BarcodeType(int databaseFlag) {
            this.databaseFlag = databaseFlag;
        }

        public static BarcodeType getBarcodeType(int databaseFlag) {
            for (BarcodeType barcodeType : BarcodeType.values()) {
                if (barcodeType.databaseFlag != databaseFlag) continue;
                return barcodeType;
            }
            return NONE;
        }
    }
}

