/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DlgMessage;
import jpos.MLengthTextArea;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.SignInSettings;
import jpos.StoreParams;
import jpos.User;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchPasswordField;
import jpos.ui.TouchTextField;

public class DlgClock
extends PosDialog {
    JPanel panel = new JPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    LabelSubHeading lUser = new LabelSubHeading();
    PosScrollPane scrollNotes = new PosScrollPane();
    DialogButton bOK = new DialogButton("");
    DialogButton bCancel = new DialogButton("");
    LabelNormal lTime = new LabelNormal();
    TouchPasswordField pfPass = new TouchPasswordField(TouchTextField.FontSize.LARGE);
    User user;
    PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(new Date().getTime()));
    MLengthTextArea tpNotes = new MLengthTextArea(250);
    LabelNormal lNotes = new LabelNormal();
    boolean accepted = false;

    public DlgClock(PosFrame frame, String title, boolean modal, User puser) {
        super(frame, title, modal);
        try {
            this.user = puser;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    void jbInit() throws Exception {
        this.pfPass.setHint(SP.getRS("Password"));
        this.dateFormatter.setFormat(1, 2);
        Object[] objs = new Object[]{this.user.getLoginName()};
        if (!this.user.clockedOn()) {
            this.lUser.setText(MessageFormat.format(StoreParams.res.getString("user_has_clocked_on"), objs));
        } else {
            this.lUser.setText(MessageFormat.format(StoreParams.res.getString("user_has_clocked_off"), objs));
        }
        this.lTime.setText(this.dateFormatter.toString());
        this.panel.setLayout(this.gridBagLayout);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgClock.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgClock.this.cancelDialog();
            }
        });
        this.lNotes.setText(StoreParams.res.getString("Notes"));
        this.scrollNotes.setHorizontalScrollBarPolicy(31);
        this.scrollNotes.setMinimumSize(new Dimension(300, 200));
        this.scrollNotes.setPreferredSize(new Dimension(300, 200));
        this.getContentPane().add(this.panel);
        this.scrollNotes.getViewport().add((Component)this.tpNotes, null);
        this.panel.add((Component)this.lUser, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.lTime, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (SignInSettings.getInstance().isUsernameOnly() && !this.user.isFingerprintLogin() && !this.user.clockedOn()) {
            this.panel.add((Component)this.pfPass, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        } else {
            this.pfPass.setVisible(false);
        }
        this.panel.add((Component)this.lNotes, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.panel.add((Component)this.scrollNotes, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.panel.add((Component)this.bOK, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.panel.add((Component)this.bCancel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.pack();
        PosUtils.centreWindow(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!DlgClock.this.pfPass.isVisible()) {
                    DlgClock.this.tpNotes.requestFocus();
                } else {
                    DlgClock.this.pfPass.requestFocus();
                }
            }
        });
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void cancelDialog() {
        if (!this.user.clockedOn()) {
            this.user.invalidate();
        }
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (!this.user.clockedOn()) {
            if (SignInSettings.getInstance().isUsernameOnly() && !this.user.isFingerprintLogin() && !this.user.attemptLogin(this.user.getMemName(), new String(this.pfPass.getPassword()), this.frParent.secidx, true, false)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Incorrect_Password"), StoreParams.res.getString("Incorrect_Password"), 2);
                return;
            }
            this.user.clockOn(this.tpNotes.getText(), this.user.isFingerprintLogin());
        } else {
            this.user.clockOff(this.tpNotes.getText(), this.user.isFingerprintLogin());
            this.user.invalidate();
        }
        this.accepted = true;
        this.dispose();
    }
}

