/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.DlgMessage;
import jpos.MLengthTextArea;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchList;

public class DlgReason
extends PosDialog {
    private TouchList<Reference> lstRefcode;
    private TouchList<Reference> lstParentRefcode;
    private LabelSubHeading lTitle = new LabelSubHeading();
    private DialogButton bOK = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private long rgidx;
    private StringBuffer rcidx;
    private StringBuffer notes;
    private String sExtraWhere = "";
    private boolean notesAreMandatory;
    private boolean isReturn;
    private boolean renderParentChildDialog = false;
    private Vector<Reference> refcodes = new Vector();
    private Vector<Reference> parentRefcodes = new Vector();
    private MLengthTextArea tpNotes;
    private LabelNormal lReason = new LabelNormal();
    private LabelNormal lParentReason = new LabelNormal();
    private LabelNormal lNotes = new LabelNormal();
    private PosScrollPane scrollNotes = new PosScrollPane();
    private PosScrollPane scrollParentReason = new PosScrollPane();
    private PosScrollPane scrollReason = new PosScrollPane();
    private GridBagLayout gridBagLayout = new GridBagLayout();

    public DlgReason(PosFrame frame, String title, boolean modal, long prgidx, StringBuffer prcidx, StringBuffer pnotes, boolean editable, String spExtraWhere, boolean isReturn) {
        this(frame, title, modal, prgidx, prcidx, pnotes, editable, spExtraWhere, 250, false, isReturn);
    }

    public DlgReason(PosFrame frame, String title, boolean modal, long prgidx, StringBuffer prcidx, StringBuffer pnotes, boolean editable, String spExtraWhere, int maxNotesLength, boolean notesAreMandatory, boolean isReturn) {
        super(frame, title, modal);
        try {
            this.rgidx = prgidx;
            this.rcidx = prcidx;
            this.notes = pnotes;
            this.sExtraWhere = spExtraWhere;
            this.notesAreMandatory = notesAreMandatory;
            this.isReturn = isReturn;
            if (this.sExtraWhere == null) {
                this.sExtraWhere = "";
            }
            if (this.sExtraWhere.length() > 0) {
                this.sExtraWhere = " AND " + this.sExtraWhere;
            }
            this.tpNotes = new MLengthTextArea(maxNotesLength);
            this.jbInit(title);
            this.pack();
            PosUtils.centreWindow(this);
            if (editable) {
                if (this.rgidx > -1L) {
                    if (this.renderParentChildDialog) {
                        this.lstParentRefcode.requestFocus();
                    } else {
                        this.lstRefcode.requestFocus();
                    }
                } else {
                    this.tpNotes.requestFocus();
                }
            } else {
                this.setEditable(false);
                this.bCancel.requestFocus();
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    void jbInit(String title) throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout);
        this.lTitle.setText(title);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReason.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReason.this.cancelDialog();
            }
        });
        this.scrollReason.setPreferredSize(new Dimension(259, 200));
        this.scrollNotes.setPreferredSize(new Dimension(259, 131));
        boolean refcodeParentExists = false;
        if (this.rgidx > -1L) {
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.RCIDX, R.CODE, R.NAME, G.L_NAME, REFPARENT.RCIDX, REFPARENT.CODE, REFPARENT.NAME, GROUPPARENT.L_NAME FROM REFCODE R  JOIN REFGRP G ON R.RGIDX = G.RGIDX  LEFT JOIN REFCODE REFPARENT ON REFPARENT.RCIDX = R.RPCIDX AND REFPARENT.ACTIVE = 1  LEFT JOIN REFGRP GROUPPARENT ON GROUPPARENT.RGIDX = REFPARENT.RGIDX AND GROUPPARENT.ACTIVE = 1 WHERE R.RGIDX = " + this.rgidx + " " + this.sExtraWhere + " AND R.ACTIVE = 1  ORDER BY REFPARENT.NAME, R.NAME");){
                int cnt = 0;
                int index = 0;
                long previousParentRcidx = 0L;
                while (sql.next()) {
                    this.lReason.setText(MessageFormat.format(StoreParams.res.getString("Select_"), sql.getString(4)));
                    this.lParentReason.setText(MessageFormat.format(StoreParams.res.getString("Select_"), sql.getString(8)));
                    Reference reference = new Reference(sql.getString(3), sql.getString(2), sql.getLong(1), sql.getLong(5));
                    Reference parentReference = new Reference(sql.getString(7), sql.getString(6), sql.getLong(5));
                    reference.setShowName(true);
                    parentReference.setShowName(true);
                    this.refcodes.add(reference);
                    if (parentReference.getIdx() != previousParentRcidx) {
                        this.parentRefcodes.add(parentReference);
                    }
                    previousParentRcidx = parentReference.getIdx();
                    if (sql.getString(1).equals(this.rcidx.toString())) {
                        index = cnt;
                    }
                    ++cnt;
                }
                for (Reference r : this.parentRefcodes) {
                    if (r.getIdx() <= 0L) continue;
                    refcodeParentExists = true;
                    break;
                }
                boolean bl = this.renderParentChildDialog = refcodeParentExists && this.isReturn;
                if (this.renderParentChildDialog) {
                    this.lstParentRefcode = new TouchList<Reference>(this.parentRefcodes);
                    this.lstParentRefcode.setSelectionMode(0);
                    this.renderChildListFromParent(this.parentRefcodes.get(0).getIdx());
                    if (!this.parentRefcodes.isEmpty()) {
                        this.lstParentRefcode.setSelectedIndex(0);
                    }
                } else {
                    this.lstRefcode = new TouchList<Reference>(this.refcodes);
                }
                if (!this.refcodes.isEmpty()) {
                    this.lstRefcode.setSelectedIndex(index);
                }
                this.lstRefcode.setSelectionMode(0);
            }
            catch (SQLException e) {
                this.dispose();
            }
        }
        if (this.lstRefcode == null) {
            this.lstRefcode = new TouchList();
        }
        this.tpNotes.setText(this.notes.toString());
        this.tpNotes.setBorder(this.lstRefcode.getBorder());
        this.lReason.setHorizontalAlignment(2);
        this.lNotes.setText(StoreParams.res.getString("Enter_any_additional"));
        if (this.rgidx > -1L) {
            if (this.renderParentChildDialog) {
                this.lParentReason.setHorizontalAlignment(2);
                this.scrollParentReason.setPreferredSize(new Dimension(259, 200));
                this.getContentPane().add((Component)this.scrollParentReason, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 8), 0, 0));
                this.scrollParentReason.getViewport().add(this.lstParentRefcode, null);
                this.getContentPane().add((Component)this.scrollReason, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 0, 29), 0, 0));
                this.scrollReason.getViewport().add(this.lstRefcode, null);
                this.getContentPane().add((Component)this.lReason, new GridBagConstraints(1, 1, 2, 1, 0.5, 0.0, 17, 0, new Insets(21, 8, 4, 0), 0, 0));
                this.getContentPane().add((Component)this.lParentReason, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.0, 17, 0, new Insets(21, 24, 4, 0), 0, 0));
                this.lstParentRefcode.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            DlgReason.this.renderChildListFromParent(((Reference)DlgReason.this.lstParentRefcode.getSelectedValue()).getIdx());
                            DlgReason.this.scrollReason.getViewport().add(DlgReason.this.lstRefcode);
                            if (DlgReason.this.refcodes.size() > 0) {
                                DlgReason.this.lstRefcode.setSelectedIndex(0);
                            }
                        }
                    }
                });
            } else {
                this.getContentPane().add((Component)this.scrollReason, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 29), 0, 0));
                this.scrollReason.getViewport().add(this.lstRefcode, null);
                this.getContentPane().add((Component)this.lReason, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(21, 24, 4, 0), 0, 0));
            }
        }
        this.getContentPane().add((Component)this.scrollNotes, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 29), 0, 0));
        this.scrollNotes.getViewport().add((Component)this.tpNotes, null);
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, this.renderParentChildDialog ? 13 : 10, 0, new Insets(18, 0, 17, this.renderParentChildDialog ? 24 : 0), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, this.renderParentChildDialog ? 17 : 10, 0, new Insets(18, this.renderParentChildDialog ? 24 : 0, 17, 0), 0, 0));
        this.getContentPane().add((Component)this.lTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(12, 24, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.lNotes, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(16, 24, 4, 0), 0, 0));
        this.createFocusTraversalPolicy(this.renderParentChildDialog);
    }

    private void renderChildListFromParent(long parentRcidx) {
        Vector<Reference> tempRefcodes = new Vector<Reference>();
        for (Reference r : this.refcodes) {
            if (r.getParentIdx() != parentRcidx) continue;
            tempRefcodes.add(r);
        }
        this.lstRefcode = new TouchList(tempRefcodes);
        this.lstRefcode.setSelectionMode(0);
        this.createFocusTraversalPolicy(true);
    }

    private void createFocusTraversalPolicy(boolean renderParentChildDialog) {
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        if (this.rgidx > -1L) {
            if (renderParentChildDialog) {
                v.add(this.lstParentRefcode);
            }
            v.add(this.lstRefcode);
        }
        v.add(this.tpNotes);
        v.add(this.bOK);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    private void setEditable(boolean editable) {
        this.bOK.setEnabled(editable);
        this.lstRefcode.setEnabled(editable);
        this.tpNotes.setEnabled(editable);
    }

    @Override
    public void okDialog() {
        if (this.rgidx > -1L) {
            if (this.lstRefcode.getSelectedIndex() != -1) {
                this.rcidx.replace(0, this.rcidx.length(), String.valueOf(((Reference)this.lstRefcode.getSelectedValue()).getIdx()));
            } else {
                this.rcidx.replace(0, this.rcidx.length(), "-1");
            }
        } else {
            this.rcidx.replace(0, this.rcidx.length(), "0");
        }
        if (this.notesAreMandatory && this.tpNotes.getText().length() == 0) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Additional_Notes_Required"), this.getTitle(), 0);
        } else {
            this.notes.replace(0, this.notes.length(), this.tpNotes.getText());
            this.dispose();
        }
    }

    @Override
    public void cancelDialog() {
        this.rcidx.replace(0, this.rcidx.length(), "-1");
        this.dispose();
    }
}

