/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import com.google.gson.Gson;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import jpos.AttachedLoyaltyManager;
import jpos.Currency;
import jpos.DiscLine;
import jpos.Discount;
import jpos.DlgHistoryFilter;
import jpos.DlgKitEntry;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.DlgSalesReps;
import jpos.DlgSplitOrderList;
import jpos.FrReservations;
import jpos.HistoryOptions;
import jpos.HistoryOptionsBuilder;
import jpos.HistorySearchType;
import jpos.IActionDetailLogWriter;
import jpos.Kit;
import jpos.LoyaltyDetails;
import jpos.MultiLineDisc;
import jpos.Note;
import jpos.NoteType;
import jpos.OmniChannel;
import jpos.PaSales;
import jpos.PaSalesFoot;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.Promotions.PromotionUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SalesRep;
import jpos.Security;
import jpos.Sku;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.Store;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.TransTypes;
import jpos.TranslatedException;
import jpos.XMLLocal;
import jpos.XMLUtils;
import jpos.basscom.utils.Utils;
import jpos.coupons.Coupon;
import jpos.coupons.CouponManager;
import jpos.crypt.PersonCrypt;
import jpos.custorder.CurrentOrder;
import jpos.custorder.CustomerOrderSale;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DespatchInfo;
import jpos.custorder.DlgReassignOrderReasons;
import jpos.custorder.DlgRejectOrderConfirmation;
import jpos.custorder.ServiceLevelAgreement;
import jpos.custorder.UnattendedDeliveryOptions;
import jpos.logging.RollingLog;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.pay.PayUtils;
import jpos.pay.afterpay.AfterpayGateway;
import jpos.pay.eftpos.EftposUtils;
import jpos.pay.zip.ZipPay;
import jpos.person.Country;
import jpos.person.EmailStatus;
import jpos.person.PersonDlgProxy;
import jpos.person.PersonUtils;
import jpos.pointspartner.PointsPartnerManager;
import jpos.rewards.GiftSku;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsApiFactory;
import jpos.rewards.RewardsUtils;
import jpos.searchfields.TransactionSearchField;
import jpos.taxlookup.ITaxLookup;
import jpos.taxlookup.TaxLookupDeliveryInfo;
import jpos.taxlookup.TaxLookupFactory;
import jpos.taxlookup.TaxLookupPerson;
import jpos.ui.Colours;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherUtils;
import jpos.voucher.vii.ViiGateway;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class FrSales
extends PosFrame {
    public java.sql.Date dueDate = null;
    public java.sql.Date nextPayDate = null;
    protected String dateCalc;
    protected long from_widx = -1L;
    public Element transRoot;
    public DespatchInfo despatchInfo = new DespatchInfo();
    public DeliveryInfo deliveryInfo = new DeliveryInfo();
    public PointsPartnerManager pointsPartners = new PointsPartnerManager();
    public IRewardsApiManager rewardsApiManager = RewardsApiFactory.getApiManager();
    public String[] refs = null;
    protected Element person = new Element("person");
    Vector<SkuReservation> reservations = new Vector();
    Vector<NoteType> perNoteTypes = new Vector();
    Vector<NoteType> custNoteTypes = new Vector();
    Vector<Discount> discTypes = new Vector();
    AttachedLoyaltyManager attachedLoyaltyCards = new AttachedLoyaltyManager();
    private CouponManager couponManager = new CouponManager();
    public double totOrder = 0.0;
    public double totPaidOrder = 0.0;
    protected boolean lbsoCancel = false;
    protected boolean lbsoComplete = false;
    protected boolean custOrderComplete = false;
    private String ownerDocketNumber;
    private String externalReference;
    private SimpleDateFormat extRefDateFormat = new SimpleDateFormat("yyyyMMdd");
    private boolean completingOrder = false;
    public SalesRep salesRep;
    private String loyaltySpendText = "";
    private static long lastPersonSwapLookup = 0L;
    private boolean bPrintPromoVoucher = false;
    private PayUtils.ReceiptDeliveryMethod deliveryMethod;
    private boolean returningSale = false;
    private boolean isRecallSale = false;
    private boolean cancellingLayby = false;
    private String filledEmail = "";

    public String getFilledEmail() {
        return this.filledEmail;
    }

    public void setFilledEmail(String filledEmail) {
        this.filledEmail = filledEmail;
    }

    public boolean isReturningSale() {
        return this.returningSale;
    }

    public boolean shouldReturnRewards() {
        if (this.transType == 239 && this.isReturningSale()) {
            boolean hasRewardsAccount;
            boolean bl = hasRewardsAccount = RewardsUtils.usingAp21RetailRewards() && this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() != RewardsAccount.AccountState.NO_ACCOUNT;
            if (hasRewardsAccount) {
                return this.rewardsApiManager.getAccount().getRewardsProgram().getReissueRewards();
            }
        }
        return false;
    }

    public double getRewardsMinimumSpend() {
        boolean hasRewardsAccount;
        boolean bl = hasRewardsAccount = RewardsUtils.usingAp21RetailRewards() && this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() != RewardsAccount.AccountState.NO_ACCOUNT;
        if (hasRewardsAccount) {
            return this.rewardsApiManager.getAccount().getCurrentTierMinimumSpend();
        }
        return 0.0;
    }

    public boolean isWebOrderUpdate() {
        return this.transType == 715 && this.despatchInfo != null && "WEB".equalsIgnoreCase(this.despatchInfo.getOrigin());
    }

    public boolean isRefundFloorToDoorOrder() {
        return this.transRoot != null && this.transRoot.getAttribute("is_refund_floor_to_door") != null && this.transRoot.getAttribute("is_refund_floor_to_door").getValue().equals("1");
    }

    public boolean isCustOrderOnHold() {
        return this.transRoot != null && this.transRoot.getAttribute("is_on_hold") != null && this.transRoot.getAttribute("is_on_hold").getValue().equals("1");
    }

    public boolean isTransSameCurrency() {
        if (this.transRoot != null && this.transRoot.getAttribute("trading_currency") != null) {
            return this.transRoot.getAttribute("trading_currency").getValue().equals(this.sParams.storeCurrency.getIdx());
        }
        return true;
    }

    public void setLaybyCancelling(boolean set) {
        this.cancellingLayby = set;
    }

    public FrSales(PosMenuController pmenu, StoreParams psParams) {
        this(pmenu, psParams, 1, 11102L, StoreParams.res.getString("Sale_Entry"));
    }

    public FrSales(PosMenuController pmenu, StoreParams psParams, int frtype, long security, String title) {
        super(pmenu, null, frtype, security, psParams, title);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public long getFromWidx() {
        return this.from_widx;
    }

    public long getOwnerWidx() {
        return XMLUtils.getLongValue(this.transRoot, "owner_widx");
    }

    public boolean isOwnerCompanyDifferent() {
        return XMLUtils.getLongValue(this.transRoot, "owner_different_company_flag") > 0L;
    }

    public long getReturnWidx() {
        return XMLUtils.getLongValue(this.transRoot, "return_widx");
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            if (this.frameType == 1 || this.frameType == 12) {
                ((PaSales)this.paBody).tfBarcode.requestFocus();
            } else if (this.frameType == 10) {
                if (((PaSales)this.paBody).tfCust.getidx() == -1L || ((PaSales)this.paBody).tfCust.getidx() == 0L) {
                    ((PaSales)this.paBody).tfCust.requestFocus();
                } else {
                    ((PaSales)this.paBody).tfBarcode.requestFocus();
                }
            }
        }
    }

    @Override
    protected void updateSec(boolean[] formSec) {
        if (!formSec[0]) {
            this.discTypes.clear();
            ((PaSales)this.paBody).tblStyles.setPriceChangeAllowed(false);
        } else {
            ((PaSales)this.paBody).tblStyles.setPriceChangeAllowed(this.hasSecurity(11117L, 0));
            this.discTypes.clear();
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.CODE, R.NAME, R.LINKIDX, B.BLOBTEXT FROM REFCODE R, BLOBTEXT B WHERE R.RGIDX = 271 AND B.BLOBIDX = R.LINKIDX AND R.\"ACTIVE\" = 1 AND R.RCIDX<>557 ORDER BY R.CODE");){
                while (sql.next()) {
                    Discount disc = new Discount(sql.getLong(1), 271L, sql.getString(2), sql.getString(3), sql.getLong(4), "", sql.getString(5), "", "");
                    if (disc.getLoyaltyOnly()) continue;
                    this.discTypes.add(disc);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    private void jbInit() throws Exception {
        this.salesRep = new SalesRep();
        if (this.frameType == 1 || this.frameType == 12) {
            this.menuTurnOffPromotions.setVisible(true);
            this.menuPersonSeparator.setVisible(true);
            this.menuPersonLoyaltyAmounts.setVisible(true);
            this.menuPersonRedeemRewardsGift.setVisible(RewardsUtils.usingAp21RetailRewards());
        }
        NoteType.readNoteTypes(this.perNoteTypes, 12L, 0L, this.sParams);
        if (this.frameType == 10) {
            NoteType.readNoteTypes(this.custNoteTypes, 3L, 0L, this.sParams);
        }
        this.dateCalc = this.sParams.getLBDateCalc();
        this.paBody = new PaSales(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaSalesFoot(this);
        ((PaSalesFoot)this.paFoot).setButtons(this.transType);
        this.contentPane.add((Component)this.paFoot, "South");
        this.manageSalesRepLabel();
        this.setTaxLookupDisabledForSession(false);
        this.setFilledEmail("");
        this.pack();
    }

    private boolean canAttachedPersonHaveManualLoyalties() {
        if (this.person == null) {
            return false;
        }
        if (this.person.getAttribute("peridx") == null) {
            return false;
        }
        List loyalties = this.person.getChildren("perloyalty");
        for (int i = 0; i < loyalties.size(); ++i) {
            Element loyalty = (Element)loyalties.get(i);
            LoyaltyDetails loyaltyDetails = new LoyaltyDetails(new Reference(366L, loyalty.getText(), false));
            if (!loyaltyDetails.getPromptForAmount()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setTransType() {
        if (this.frameType == 1) {
            this.transType = 239;
        } else if (this.frameType == 10) {
            this.transType = 556;
        } else if (this.frameType == 12) {
            this.transType = 714;
        }
        if (this.paFoot != null) {
            ((PaSalesFoot)this.paFoot).setButtons(this.transType);
        }
    }

    @Override
    public void setTransType(int type) {
        this.transType = type;
        ((PaSalesFoot)this.paFoot).setButtons(type);
    }

    public void setFromWidx(long widx) {
        this.from_widx = widx;
    }

    @Override
    public boolean validateTrans() {
        return this.validateTrans(true);
    }

    public boolean validateTrans(boolean complete) {
        if (((PaSales)this.paBody).tblStyles.getRowCount() == 0 && !this.isAccountCustomer() && this.transType != 715) {
            return false;
        }
        if (((PaSales)this.paBody).tblStyles.isEditing()) {
            ((PaSales)this.paBody).tblStyles.getCellEditor().stopCellEditing();
        }
        if (this.transType == 614) {
            if (((PaSales)this.paBody).tblStyles.getQty() == 0.0 || ((PaSales)this.paBody).tblStyles.hasNegQtys()) {
                return false;
            }
            if (this.person.getAttribute("peridx") == null) {
                String orgDocNumber = this.docknum;
                try (PersonDlgProxy permaint = new PersonDlgProxy(this, SP.getRS("Person") + " - " + SP.getRS("Reservation"), this.person, this.getSecurity(11106L), new boolean[]{false, false, false, false}, 0L, false);){
                    permaint.setVisible(true);
                }
                catch (Exception ex) {
                    PosUtils.logError(ex);
                }
                if (this.docknum != null && !this.docknum.equals(orgDocNumber)) {
                    return false;
                }
            }
            if (this.getPerson().getAttribute("peridx") != null) {
                this.updatePersonDisplayText();
                ((PaSales)this.paBody).tblStyles.removeDiscounts();
                if (!((PaSales)this.paBody).tblStyles.setStkAvailability()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            String db_tax_exempt_certificate;
            String db_tax_exemptidx;
            if (this.transType == 556) {
                String numType = ((PaSales)this.paBody).tblStyles.getDue() >= 0.0 ? "2" : "3";
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("num", numType).getXML();
                if (this.sParams.root == null) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_invnum"), objs), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                if (!this.sParams.root.getName().equals("num")) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("no_invnum"), objs), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                this.transnum = this.sParams.root.getText();
            } else if (this.transType == 241 && ((PaSales)this.paBody).tblStyles.getQty() == 0.0) {
                ((PaSales)this.paBody).tblStyles.setReason("569");
            } else if (this.transType == 244 && ((PaSales)this.paBody).tblStyles.getQty() == 0.0) {
                ((PaSales)this.paBody).tblStyles.setReason("645");
            }
            String db_peridx = this.person.getAttribute("peridx") != null ? this.person.getAttribute("peridx").getValue() : "null";
            String string = db_tax_exemptidx = this.person.getAttribute("tax_exemptidx") != null ? this.person.getAttribute("tax_exemptidx").getValue() : "null";
            if (db_tax_exemptidx.isEmpty()) {
                db_tax_exemptidx = "null";
            }
            String string2 = db_tax_exempt_certificate = this.person.getAttribute("tax_exempt_certificate") != null ? this.person.getAttribute("tax_exempt_certificate").getValue() : "";
            String db_from_widx = this.getFromWidx() != -1L ? String.valueOf(this.getFromWidx()) : (this.transType == 556 || this.transType == 714 ? String.valueOf(this.sParams.getStoreIdx()) : "null");
            String notes2 = "null";
            String custOrderNum = "null";
            if (TransTypes.isLayby(this.transType)) {
                notes2 = PosUtils.StringToSqlString(this.dateCalc);
            } else if (this.transType == 556 || this.transType == 558 || this.transType == 714 || this.transType == 715) {
                notes2 = this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT ? PosUtils.StringToSqlString("O" + this.sParams.getStore().getStoreNo() + this.transnum) : PosUtils.StringToSqlString(((PaSales)this.paBody).tfCustOrderNum.getText());
                custOrderNum = notes2;
                if (custOrderNum.length() > 30) {
                    custOrderNum = custOrderNum.substring(0, 30);
                }
            } else if (this.transType == 239 && this.isReturningSale()) {
                notes2 = PosUtils.StringToSqlString(((PaSales)this.paBody).tfCustOrderNum.getText());
                custOrderNum = StringUtils.truncate(notes2, 30);
            }
            String db_sordidx = this.transRoot != null && this.transRoot.getAttribute("sordidx") != null ? this.transRoot.getAttribute("sordidx").getValue() : "null";
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            PosDateFormatter.truncateTime(this.dueDate);
            String due = this.dueDate == null ? "null" : PosUtils.StringToSqlString(this.dueDate.toString());
            boolean labySpecOrdCancel = (this.transType == 241 || this.transType == 244) && ((PaSales)this.paBody).tblStyles.getQty() == 0.0;
            boolean completeCustOrder = TransTypes.isCustOrder(this.transType) && ((PaSales)this.paBody).tblStyles.getOutstandingQty() - ((PaSales)this.paBody).tblStyles.getPickUpQty() == 0.0;
            boolean custOrderPacked = TransTypes.isCustOrder(this.transType) && ((PaSales)this.paBody).tblStyles.getQty() - ((PaSales)this.paBody).tblStyles.getPackedQty() == 0.0;
            String[] refs = new String[10];
            if (SP.sParams.bDoingNewSave) {
                refs = ((PaSales)this.paBody).doPayments.getRefTblIdxs();
            } else {
                for (int i = 0; i < 10; ++i) {
                    refs[i] = "null";
                }
            }
            String sSaleDate = "TRUNC_DATE(current_timestamp)";
            if (this.sParams.bAccuralAccounting && (TransTypes.isLayby(this.transType) || TransTypes.isSpecialOrder(this.transType))) {
                sSaleDate = "NULL";
            } else if (TransTypes.isCustOrder(this.transType)) {
                sSaleDate = "NULL";
            }
            String deliveryLocnidx = this.despatchInfo.getDeliveryLocnidx() != null ? PosUtils.StringToSqlString(this.despatchInfo.getDeliveryLocnidx()) : "NULL";
            String billingLocnidx = this.despatchInfo.getBillingLocnidx() != null ? PosUtils.StringToSqlString(this.despatchInfo.getBillingLocnidx()) : "NULL";
            String origin = "NULL";
            origin = this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT ? "'WEB'" : (this.despatchInfo.getOrigin() != null ? PosUtils.StringToSqlString(this.despatchInfo.getOrigin()) : "NULL");
            String saleTypeIdx = "NULL";
            if (this.transType == 239) {
                long saleTypeLong = XMLUtils.getLongValue(this.transRoot, "sale_type_idx");
                if (saleTypeLong == 0L) {
                    saleTypeLong = 840L;
                }
                saleTypeIdx = String.valueOf(saleTypeLong);
            }
            String shipFromWidx = "NULL";
            if (this.despatchInfo.getShipFromCurrent()) {
                shipFromWidx = String.valueOf(this.sParams.getStoreIdx());
            }
            EftposUtils.debugPoint(this, "Inserting into RET_TRANH table\nVHIDX: " + this.vhidx);
            try (Statement stmt = this.sParams.conn.createStatement();){
                String header_capillary_redemption = "";
                String value_capillary_redemption_id = "";
                String value_capillary_redemption_points = "";
                if (!pcomplete && RewardsUtils.usingCapillaryRewards() && ((PaSales)this.paBody).frParent.getCapillaryCustomer() != null) {
                    header_capillary_redemption = ", CAPILLARY_REDEMPTION_ID, CAPILLARY_POINTS_BALANCE";
                    value_capillary_redemption_id = ", '" + ((PaSales)this.paBody).frParent.getCapillaryCustomer().getExternalId() + "'";
                    value_capillary_redemption_points = ", " + ((PaSales)this.paBody).frParent.getCapillaryCustomer().getPointsBalance();
                }
                stmt.executeUpdate(" INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRANS_NUMBER, TRAND,  TILL_NUMBER, STAFF_SALE_FLAG, NOTES2, CORDER, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, COMPLETE, CLIENTIDX, LAYBY_CANCEL,  LAYBY_DUE, FROM_WIDX, ORIG_SORDIDX, SORDIDX,  REF1, REF2, REF3, REF4, REF5, REF6, REF7, REF8, REF9, REF10, SALE_DATE, CUST_ORDER_COMPLETE, CONNUM,  CARRIERIDX, CARRIER_CODE, SERVICETYPE_IDX, TAX_EXEMPTIDX, TAX_EXEMPT_CERTIFICATE,  DELIVERY_LOCNIDX, BILLING_LOCNIDX, ORIGIN,  POINTS_PARTNER_RCIDX, POINTS_PARTNER_NUM,  COUNTRY_CODE, TRACKING_NUMBER, SALE_TYPE_IDX, SHIP_FROM_WIDX" + header_capillary_redemption + ") VALUES( " + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", " + (this.transnum == null ? "null" : PosUtils.StringToSqlString(this.transnum)) + ", CURRENT_TIMESTAMP, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", 0, " + notes2 + ", " + custOrderNum + ", " + this.salesRep.getPeridx() + ", " + this.salesRep.getMemidx() + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", 0, " + db_peridx + ", " + (labySpecOrdCancel ? "1" : "null") + ", " + due + ", " + db_from_widx + ", " + db_sordidx + ", " + db_sordidx + ", " + refs[0] + ", " + refs[1] + ", " + refs[2] + ", " + refs[3] + ", " + refs[4] + ", " + refs[5] + ", " + refs[6] + ", " + refs[7] + ", " + refs[8] + ", " + refs[9] + ", " + sSaleDate + ", " + (completeCustOrder ? "1" : "null") + ", " + PosUtils.StringToSqlString(this.despatchInfo.getConnoteNumber()) + ", " + Utils.longToDBX(this.despatchInfo.getFinalCarrierIdx()) + ", " + PosUtils.StringToSqlString(this.despatchInfo.getCarrierName()) + ", " + Utils.longToDBX(PosUtils.longVal(this.despatchInfo.getFinalServiceTypeIdx())) + ", " + db_tax_exemptidx + ", " + PosUtils.StringToSqlString(db_tax_exempt_certificate) + ", " + deliveryLocnidx + ", " + billingLocnidx + ", " + origin + ", " + (this.pointsPartners.getCurrentPartner() != null ? Long.valueOf(this.pointsPartners.getCurrentPartner().getPartnerIdx()) : "null") + ", " + PosUtils.StringToSqlString(this.pointsPartners.getMembershipNumber()) + ", " + PosUtils.StringToSqlString(PosUtils.getCountryOfOrigin().getCode()) + ", " + PosUtils.StringToSqlString(this.despatchInfo.getTrackingNumber()) + ", " + saleTypeIdx + ", " + shipFromWidx + value_capillary_redemption_id + value_capillary_redemption_points + ")");
                if (RewardsUtils.usingCapillaryRewards() && ((PaSales)this.paBody).frParent.getCapillaryCustomer() != null) {
                    String sql = "UPDATE RET_TRANH SET CAPILLARY_POINTS_BALANCE = " + ((PaSales)this.paBody).frParent.getCapillaryCustomer().getPointsBalance() + " WHERE VHIDX = " + this.vhidx + " AND CAPILLARY_POINTS_BALANCE IS NULL";
                    stmt.executeUpdate(sql);
                }
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            ((PaSales)this.paBody).tblStyles.model.vDetailNotesSaved = new Vector();
            ((PaSales)this.paBody).tblStyles.db_insertLines(this.transType);
            if (SP.sParams.bDoingNewSave) {
                ((PaSales)this.paBody).doPayments.setTansNumber(this.transnum);
                boolean paymentsSuccessful = ((PaSales)this.paBody).doPayments.dbInserts(this.sParams.conn);
                if (!paymentsSuccessful) {
                    DlgMessage.showMessage(this, "Payment Methods were not successful. If issue persists please contact head office.");
                    this.vhidx = -1L;
                    PosUtils.releaseTrans(this.sParams.conn);
                    return false;
                }
            }
            this.setSaleDate();
            if (this.attachedLoyaltyCards.size() > 0) {
                stmt = this.sParams.conn.createStatement();
                var21_28 = null;
                try {
                    for (AttachedLoyaltyManager.LoyaltyInfo info : this.attachedLoyaltyCards.getLoyalties()) {
                        if (info.getLoyaltyDetails().getLoyalty().getIdx() == 787L) continue;
                        stmt.executeUpdate("INSERT INTO RET_LOYALTY(VHIDX, CARDNO) VALUES (" + this.vhidx + ", " + PosUtils.StringToSqlString(info.getCardNo()) + ")");
                    }
                }
                catch (Throwable throwable) {
                    var21_28 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var21_28 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var21_28.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            if (completeCustOrder) {
                this.markCustOrderAsComplete();
            }
            if (pcomplete && TransTypes.isCustOrder(this.transType)) {
                this.markCustOrderAsPacked(custOrderPacked);
            }
            if (!this.sParams.bDoingNewSave) {
                this.finishTransaction(pcomplete, false);
            }
            PromotionUtils.checkPromotionVersion();
            return true;
        }
        catch (Exception e) {
            this.vhidx = -1L;
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
    }

    public boolean addCreditNoteGiftVoucher(double value) {
        try {
            String barcode = "";
            String vouchSKU = VoucherUtils.getCreditNoteGiftVoucherSKU();
            SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT CODE FROM BARCODE WHERE SKUIDX = " + vouchSKU);
            if (sql.next() && (barcode = sql.getString(1)) != "") {
                StyleTable tbl = ((PaSales)this.paBody).tblStyles;
                int line = ((PaSales)this.paBody).tblStyles.addEAN(barcode, true, true, true);
                if (line == -2) {
                    DlgMessage.showMessage(this, "No voucher range set up for Credit Note Gift Vouchers. Please contact Head Office");
                    return false;
                }
                StyleLine style = (StyleLine)((PaSales)this.paBody).tblStyles.model.getRow(line);
                style.setPrice(value);
                ((PaSales)this.paBody).tblStyles.model.db_insertLine(line);
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public boolean addViiVoucherForRefund(double value) {
        if (VoucherGatewayManager.getInstance().getGateway() instanceof ViiGateway) {
            try {
                ViiGateway gateway = (ViiGateway)VoucherGatewayManager.getInstance().getGateway();
                String barcode = gateway.getDigitalRefundBarcode();
                if (barcode.equals("")) {
                    DlgMessage.showMessage(this, "There is no barcode configured for the Product being used for Vii Return Vouchers. \n Please contact head office");
                    return false;
                }
                StyleTable tbl = ((PaSales)this.paBody).tblStyles;
                ((PaSales)this.paBody).tblStyles.setReturnVoucherAmount(value);
                int line = ((PaSales)this.paBody).tblStyles.addEAN(barcode, true, true, false);
                if (line == -2) {
                    return false;
                }
                StyleLine style = (StyleLine)((PaSales)this.paBody).tblStyles.model.getRow(line);
                style.setPrice(value);
                style.setIsRefundVoucher(true);
                ((PaSales)this.paBody).tblStyles.model.db_insertLine(line);
                return true;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return false;
    }

    private long getSaleTypeIdxForCustOrderSale() {
        if (this.transType == 714) {
            return 840L;
        }
        if (this.transType == 715) {
            return this.despatchInfo != null && this.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH ? 841L : 842L;
        }
        return 0L;
    }

    private void markCustOrderAsPacked(boolean custOrderPacked) {
        try (PreparedStatement stmtUpdt = this.sParams.conn.prepareStatement("UPDATE RETAIL_CUST_ORDERS_OUTSTANDING SET DELETE_FLAG = ? WHERE TRANS_NUMBER = ? AND WIDX = ?");){
            stmtUpdt.setInt(1, custOrderPacked ? 1 : 0);
            stmtUpdt.setString(2, this.transnum);
            stmtUpdt.setLong(3, this.sParams.getStoreIdx());
            stmtUpdt.executeUpdate();
            this.menu.countOrdersToPack(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void markCustOrderAsComplete() {
        try (PreparedStatement stmtUpdt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET CUST_ORDER_COMPLETE = 1 WHERE FROM_WIDX = ? AND TRANS_NUMBER = ? AND TR_TYPE IN (714,715)");){
            stmtUpdt.setLong(1, this.getFromWidx());
            stmtUpdt.setString(2, this.transnum);
            stmtUpdt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public CurrentOrder GetCurrentOrder() {
        CurrentOrder currentOrder = this.despatchInfo.getCurrentOrder();
        return currentOrder;
    }

    public Boolean GetLock() {
        DespatchInfo.Lock lock = this.despatchInfo.getLock(this.getUser().getMemidx());
        if (lock.Error.length() > 0) {
            if (lock.ErrorDontContinue) {
                DlgMessage.showMessage(this, lock.Error, SP.getRS("Error_Locking_Order_Title"), 0);
            } else if (DlgMessage.showMessage(this, SP.getRS("Error_Locking_Order_Details") + "\r\n\r\nError Text >> " + lock.Error, SP.getRS("Error_Locking_Order_Title"), 0, 2, 0) == 0) {
                return true;
            }
            this.setCursor(StoreParams.normalCursor);
            this.setFocus();
            return false;
        }
        if (lock.OrderLockStatus == DespatchInfo.OrderLockingStatus.OFFLINE) {
            return true;
        }
        if (lock.OrderLockStatus != DespatchInfo.OrderLockingStatus.LOCKED) {
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Order_Already_Locked_Message"), lock.lockedByName, lock.LockedBySystem), SP.getRS("Order_Already_Locked_Title"), 0);
            this.setCursor(StoreParams.normalCursor);
            this.setFocus();
            return false;
        }
        return true;
    }

    public boolean rejectCustOrder(long vhidx, long memidx) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("vhidx", vhidx);
        payload.put("memidx", memidx);
        return this.rejectCustOrder(payload);
    }

    public boolean rejectCustOrder(Map<String, Object> payload) {
        Gson gson = new Gson();
        String payloadStr = gson.toJson(payload);
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("reject", payloadStr).getXML();
        if (SP.sParams.root == null) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return false;
        }
        if (SP.sParams.root.getChild("error") != null) {
            String err = SP.sParams.root.getChild("error").getText();
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_reassign_order"), "\n", err), SP.getRS("Error"), -1, 0);
            return false;
        }
        try (PreparedStatement stmtUpdt = this.sParams.conn.prepareStatement("DELETE FROM RETAIL_CUST_ORDERS_OUTSTANDING WHERE TRANS_NUMBER = ? AND WIDX = ?");){
            stmtUpdt.setString(1, this.transnum);
            stmtUpdt.setLong(2, this.sParams.getStoreIdx());
            stmtUpdt.executeUpdate();
            this.menu.countOrdersToPack(this.sParams.conn);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return true;
    }

    public boolean finishTransaction(boolean pcomplete, boolean fetchDocketNum) {
        return this.processFinishTransaction(pcomplete, fetchDocketNum);
    }

    private boolean processFinishTransaction(boolean pcomplete, boolean fetchDocketNum) {
        CustomerOrderSale custOrderSale = null;
        boolean bFoundReservation = false;
        String taxLookupError = "";
        try {
            boolean labySpecOrdCancel = (this.transType == 241 || this.transType == 244) && ((PaSales)this.paBody).tblStyles.getQty() == 0.0;
            VoucherUtils.completePendingVouchers(this.sParams.conn, this.vhidx);
            for (int i = 0; i < this.reservations.size(); ++i) {
                this.reservations.elementAt(i).reverseReservation(this.getUser().getMemidx(), this.getUser().getPeridx(), this.docknum);
                bFoundReservation = true;
            }
            if (this.transType == 240 || this.transType == 242 || this.transType == 241 && !labySpecOrdCancel) {
                PosDateFormatter.truncateTime(this.nextPayDate);
                String payDue = this.nextPayDate == null ? "null" : PosUtils.StringToSqlString(this.nextPayDate.toString());
                try (Statement stmt = this.sParams.conn.createStatement();){
                    stmt.executeUpdate("INSERT INTO LAYBY_PAYDUEDATES(LBIDX, TRANS_NUMBER, FROM_WIDX, PAYMENT_DUE,  UPMEMIDX, UPDT, GEN_FROM_DOCKET, GEN_FROM_WIDX, MODIFIED) SELECT " + this.sParams.nextVal("XLAYBY_PAYDUEDATES") + ", TRANS_NUMBER, FROM_WIDX, " + payDue + ",  TRANSMEMIDX, CURRENT_TIMESTAMP, DOCKET_NUMBER, " + this.sParams.getStoreIdx() + ", 0 FROM RET_TRANH WHERE VHIDX = " + this.vhidx);
                }
                this.sParams.yTabInsert("LAYBY_PAYDUEDATES", "LBIDX", "" + this.sParams.currVal("XLAYBY_PAYDUEDATES"));
                PosDateFormatter.truncateTime(this.dueDate);
                var9_15 = null;
                try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET LAYBY_DUE = ? WHERE FROM_WIDX = ? AND TR_TYPE IN (240,241,242) AND TRANS_NUMBER = ?");){
                    prepStmt.setDate(1, this.dueDate);
                    prepStmt.setLong(2, this.getFromWidx());
                    prepStmt.setString(3, this.transnum);
                    prepStmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    var9_15 = throwable;
                    throw throwable;
                }
            }
            if (pcomplete) {
                ITaxLookup taxLookup;
                boolean commitTax;
                boolean returningForAnotherStore;
                long paymentVhidx = -1L;
                long returnWidx = this.getReturnWidx();
                boolean bl = returningForAnotherStore = this.transType == 239 && this.isReturningSale() && returnWidx > 0L && returnWidx != this.sParams.getStoreIdx() && !this.sParams.getStore(returnWidx).getStoreNo().equals("000");
                if (fetchDocketNum) {
                    if (returningForAnotherStore) {
                        this.docknum = this.ownerDocketNumber;
                    } else {
                        this.setDocketnum();
                    }
                }
                if (this.transType == 239 || this.transType == 240 || this.transType == 241 || this.transType == 242 || this.transType == 714 && this.deliveryInfo != null && (this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP)) {
                    try {
                        this.assignReceiptDeliveryMethod(this.filledEmail);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                boolean taxLookupSuccess = false;
                boolean isLBSOComplete = (TransTypes.isLayby(this.transType) || TransTypes.isSpecialOrder(this.transType)) && this.completingOrder;
                boolean bl2 = commitTax = isLBSOComplete || this.transType == 239;
                if (!this.isTransSameCurrency() || this.isOwnerCompanyDifferent() || this.transType == 241 && this.cancellingLayby) {
                    commitTax = false;
                }
                if (commitTax && !this.isTaxLookupDisabled() && (taxLookup = TaxLookupFactory.getTaxLookup()) != null) {
                    EftposUtils.debugPoint(this, "Getting Extended Tax Rate from 3rd Party\nVHIDX: " + this.vhidx + ", Complete: 1, Docket Number: " + this.docknum);
                    TaxLookupPerson taxPerson = new TaxLookupPerson(this.person);
                    TaxLookupDeliveryInfo taxDelivInfo = new TaxLookupDeliveryInfo(this.deliveryInfo, this.despatchInfo);
                    Vector<StyleLine> styleLines = isLBSOComplete ? ((PaSales)this.paBody).tblStyles.getStyleLines() : ((PaSales)this.paBody).tblStyles.getTaxLookupStyleLines();
                    String overrideReason = "";
                    if (isLBSOComplete) {
                        String string = overrideReason = TransTypes.isLayby(this.transType) ? SP.getRS("Layby") : SP.getRS("SpecialOrder");
                    }
                    if (taxLookup.commitTax(this.encodeDocketNumber(), isLBSOComplete, overrideReason, this.getUser().getMemName(), styleLines, taxPerson, taxDelivInfo, true)) {
                        ((PaSales)this.paBody).tblStyles.model.fireTableDataChanged();
                        taxLookupSuccess = true;
                    } else {
                        taxLookupError = taxLookup.getLastErrorMessage();
                    }
                }
                if (this.couponManager.getCoupon() != null) {
                    this.couponManager.finalise(this.vhidx, this.getUser().getMemidx());
                }
                if (this.transType == 239 && this.getPerson().getAttribute("ImmediateRewardsProcessing") != null && XMLUtils.getBooleanValue(this.getPerson(), "ImmediateRewardsProcessing") && ((PaSales)this.paBody).tblStyles.getDueApplicableForRewardsAccrual() > 0.0) {
                    Element payload = new Element("rewards_transaction");
                    payload.setAttribute("widx", String.valueOf(SP.sParams.getStoreIdx()));
                    payload.setAttribute("memidx", String.valueOf(this.getUser().getMemidx()));
                    payload.setAttribute("account_idx", String.valueOf(this.getPerson().getAttributeValue("RewardsAccountIdx")));
                    payload.setAttribute("docketnum", this.docknum);
                    double amount = ((PaSales)this.paBody).tblStyles.getDueApplicableForRewardsAccrual();
                    payload.setAttribute("amount", String.valueOf(amount));
                    XMLOutputter printer = new XMLOutputter();
                    Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("rewards_instant", printer.outputString(payload)).getXML();
                    if (result == null || !XMLUtils.getBooleanValue(result, "result")) {
                        DlgMessage.showMessage(this, "Unable to instantly issue rewards on this transaction.");
                        PosUtils.logError(XMLUtils.getValue(result, "message"));
                        PosUtils.logError(XMLUtils.getValue(result, "stacktrace"));
                    }
                }
                if (this.rewardsApiManager.hasUncommittedRedemption()) {
                    this.rewardsApiManager.commitTransaction(this.vhidx);
                }
                if (SP.sParams.bUsingCapillaryRewards && !StringUtils.isNullOrEmpty(this.couponManager.getThirdPartyCouponCode())) {
                    this.couponManager.updateThirdPartyCoupon(this.vhidx, "Capillary");
                }
                if (VoucherGatewayManager.isGatewayInUse() && VoucherGatewayManager.isGatewayReady()) {
                    VoucherGatewayManager.getInstance().getGateway().finaliseTransaction(this.vhidx);
                }
                if (AfterpayGateway.exists()) {
                    AfterpayGateway.removeInProgressFlag(this.vhidx);
                }
                ZipPay.removeNeedReverseFlag(this.vhidx);
                String deliveryMethodId = "NULL";
                if (this.transType == 714 && (this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || this.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT)) {
                    this.deliveryInfo.saveToDatabase(this.vhidx);
                    deliveryMethodId = String.valueOf(this.deliveryInfo.getDeliveryMethod().getId());
                }
                EftposUtils.debugPoint(this, "Updating RET_TRANH table\nVHIDX: " + this.vhidx + ", Complete: 1, Docket Number: " + this.docknum);
                try (Statement stmt = this.sParams.conn.createStatement();){
                    stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1, DOCKET_NUMBER = " + PosUtils.StringToSqlString(this.docknum) + ", TAX_LOOKUP = " + (taxLookupSuccess ? "1" : "0") + ", DEL_METHOD_IDX = " + deliveryMethodId + " WHERE VHIDX = " + this.vhidx);
                }
                String docketNumber = this.docknum;
                if (returningForAnotherStore && fetchDocketNum) {
                    EftposUtils.debugPoint(this, "Assigning VHIDX: " + this.vhidx + " to store WIDX: " + returnWidx);
                    paymentVhidx = OmniChannel.assignSaleToOwner(this.sParams.conn, this.vhidx, returnWidx, this.docknum);
                    docketNumber = OmniChannel.encodeDocketNumber(returnWidx, this.docknum);
                    OmniChannel.consumeDocketNumber(SP.sParams.conn, returnWidx, this.docknum);
                }
                EftposUtils.debugPoint(this, "Flagging transaction to be sent to HO\nVHIDX: " + this.vhidx + ", Docket Number: " + docketNumber);
                this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.vhidx);
                if (paymentVhidx > 0L) {
                    EftposUtils.debugPoint(this, "Flagging payment transaction to be sent to HO\nVHIDX: " + paymentVhidx + ", Docket Number: " + this.docknum);
                    this.sParams.yTabInsert("RET_TRANH", "VHIDX", String.valueOf(paymentVhidx));
                }
            }
            ((PaSales)this.paBody).tblStyles.model.vDetailNotesSaved = null;
            if (TransTypes.isCustOrder(this.transType)) {
                custOrderSale = new CustomerOrderSale(this, this.vhidx, ((PaSales)this.paBody).tblStyles.model.getData(), !this.isTaxLookupDisabled(), this.getOwnerWidx(), this.ownerDocketNumber, this.getSaleTypeIdxForCustOrderSale());
                if (!custOrderSale.createSaleTransaction()) {
                    if (!this.sParams.conn.getAutoCommit()) {
                        PosUtils.releaseTrans(this.sParams.conn);
                    }
                    return false;
                }
                taxLookupError = custOrderSale.getTaxLookupError();
            }
            if (!this.sParams.conn.getAutoCommit()) {
                PosUtils.endTrans(this.sParams.conn);
            }
            if (taxLookupError.length() > 0) {
                taxLookupError = taxLookupError + "\n" + SP.getRS("AvaTax_Tax_Not_Posted");
                DlgMessage.showMessage(this, taxLookupError, StoreParams.res.getString("Error"), 0);
                RollingLog.log(RollingLog.LogType.AVATAX, Level.SEVERE, SP.getRS("AvaTax_Tax_Not_Posted"));
            }
        }
        catch (Exception e) {
            try {
                if (!this.sParams.conn.getAutoCommit()) {
                    PosUtils.releaseTrans(this.sParams.conn);
                }
            }
            catch (SQLException e1) {
                PosUtils.logError(e1);
            }
            PosUtils.logError(e);
            return false;
        }
        try {
            PosFrame reservationScreen;
            if (TransTypes.isCustOrder(this.transType) && custOrderSale != null && custOrderSale.getSaleVhidx() > 0L) {
                this.printReceipt(false, custOrderSale.getSaleVhidx());
            }
            if (bFoundReservation && (reservationScreen = this.menu.getFrame(11)) != null) {
                ((FrReservations)reservationScreen).refresh();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    private boolean setSaleDate() {
        if (this.completingOrder && this.sParams.bAccuralAccounting && (TransTypes.isLayby(this.transType) || TransTypes.isSpecialOrder(this.transType))) {
            String db_from_widx = this.getFromWidx() != -1L ? String.valueOf(this.getFromWidx()) : "null";
            try (Statement stmt = this.sParams.conn.createStatement();){
                String update = null;
                update = TransTypes.isLayby(this.transType) ? "UPDATE RET_TRANH H SET H.SALE_DATE = TRUNC_DATE(current_timestamp)  WHERE H.\"ACTIVE\" = 1  AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(this.transnum) + " AND H.FROM_WIDX = " + db_from_widx + " AND H.TR_TYPE IN (240, 241, 242)" : "UPDATE RET_TRANH H SET H.SALE_DATE = TRUNC_DATE(current_timestamp)  WHERE H.\"ACTIVE\" = 1  AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(this.transnum) + " AND H.FROM_WIDX = " + db_from_widx + " AND H.TR_TYPE IN (243, 244, 245)";
                stmt.executeUpdate(update);
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return true;
    }

    @Override
    public void voidTrans(boolean logout) {
        this.voidTrans(logout, false, true);
    }

    public void voidTrans(boolean logout, boolean writeLog, boolean loadAttachPersonDlg) {
        if (!logout || this.isLoggedIn(!logout)) {
            Vector<IActionDetailLogWriter> rowsToLog;
            if (writeLog && (rowsToLog = ((PaSales)this.paBody).tblStyles.getRowsToLog()).size() > 0) {
                long clientidx = this.person.getAttribute("peridx") != null ? PosUtils.longVal(this.person.getAttribute("peridx").getValue()) : 0L;
                PosUtils.logUserAction("RESET", this.transType, this.vhidx, this.getUser().getMemidx(), clientidx, rowsToLog);
            }
            this.setTaxLookupDisabledForTransaction(false);
            this.setFromWidx(-1L);
            this.person = new Element("person");
            ((PaSalesFoot)this.paFoot).changeAttachPersonButton(false);
            this.setPromotionsEnabled(true);
            PromotionUtils.resetDiscountEngine();
            this.refs = null;
            this.dueDate = null;
            this.nextPayDate = null;
            this.transRoot = null;
            this.returningSale = false;
            this.isRecallSale = false;
            this.processLogin();
            this.despatchInfo = new DespatchInfo();
            this.deliveryInfo = new DeliveryInfo();
            this.pointsPartners = new PointsPartnerManager();
            RewardsUtils.reset();
            this.rewardsApiManager = RewardsApiFactory.getApiManager();
            if (this.frameType == 12) {
                ((PaSales)this.paBody).tblStyles.setColumnName(7, SP.getRS("Taken"));
                this.paHead.setTitle(SP.getRS("Customer_Order"));
                ((PaSalesFoot)this.paFoot).bReprintLabels.setEnabled(false);
                ((PaSalesFoot)this.paFoot).bReassignOrder.setEnabled(false);
                ((PaSalesFoot)this.paFoot).bPayment.setText(SP.getRS("F9_Pack_Pay"));
            }
            this.reservations.clear();
            this.clearAttachedLoyaltyCards();
            this.couponManager.reset(this.getUser().getMemidx());
            ((PaSalesFoot)this.paFoot).lCoupon.setText("");
            this.dateCalc = this.sParams.getLBDateCalc();
            this.totOrder = 0.0;
            this.totPaidOrder = 0.0;
            this.completingOrder = false;
            this.lbsoCancel = false;
            this.lbsoComplete = false;
            this.custOrderComplete = false;
            this.cancellingLayby = false;
            this.ownerDocketNumber = null;
            this.externalReference = null;
            ((PaSales)this.paBody).OldLBSOCancFee = null;
            ((PaSales)this.paBody).lFeedBack.setText("");
            ((PaSales)this.paBody).lPerson.setText("");
            ((PaSales)this.paBody).lRewards.setText("");
            ((PaSales)this.paBody).lRewards.setVisible(false);
            ((PaSales)this.paBody).lCoupons.setText("");
            ((PaSales)this.paBody).lCoupons.setVisible(false);
            ((PaSales)this.paBody).lGift.setText("");
            ((PaSales)this.paBody).lGift.setVisible(false);
            ((PaSales)this.paBody).cancLayby = false;
            ((PaSales)this.paBody).cancSpecialOrder = false;
            ((PaSales)this.paBody).tblStyles.clear();
            ((PaSales)this.paBody).tfBarcode.setText("");
            ((PaSales)this.paBody).update();
            ((PaSales)this.paBody).crDolChecked = false;
            ((PaSales)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            ((PaSales)this.paBody).lPerson.setForeground(this.getDefaultColor());
            ((PaSales)this.paBody).lCustDets.setForeground(this.getDefaultColor());
            ((PaSalesFoot)this.paFoot).bPayment.setEnabled(true);
            ((PaSales)this.paBody).pOSBalance.setVisible(false);
            super.voidTrans(logout);
            ((PaSales)this.paBody).tfCustOrderNum.setText("");
            if (this.frameType == 10) {
                ((PaSales)this.paBody).tfCust.clear();
                ((PaSales)this.paBody).lCustDets.setText("");
                ((PaSales)this.paBody).tblStyles.setEditable(false);
                this.setFocus();
            } else if (this.frameType == 12) {
                ((PaSales)this.paBody).tfCustOrderNum.setVisible(true);
                ((PaSales)this.paBody).lCustOrderNum.setVisible(true);
            }
        }
        if (this.sParams.useDisplayDevice) {
            this.sParams.displayDevice.displayWelcomeMessage();
        }
        this.checkForPersonSwaps();
        if (loadAttachPersonDlg) {
            this.loadAttachPersonDlg();
        }
    }

    public boolean loadAttachPersonDlg() {
        if (this.sParams.promptForPerson == 2L && this.getUser().getMemidx() > 0L && this.person.getAttribute("peridx") == null && this.transType == 239) {
            this.attachPerson("", false);
            return true;
        }
        return false;
    }

    public void setPerson(Element person) {
        this.setPerson(person, false, false);
    }

    public void setPerson(Element pperson, boolean validateEmail, boolean showPersonMaint) {
        if (this.person != pperson) {
            this.person = pperson;
            try {
                if (this.person != null && this.person.getAttribute("peridx") != null) {
                    this.clearNotes(this.perNoteTypes);
                    for (int i = 0; i < this.perNoteTypes.size(); ++i) {
                        this.perNoteTypes.elementAt(i).setKeyIdx(this.person.getAttribute("peridx").getLongValue(), this.person.getAttribute("peridx").getLongValue() < 0L);
                    }
                    this.addNotes(this.perNoteTypes, this.person.getChildren("note"));
                }
            }
            catch (DataConversionException ex) {
                PosUtils.logError(ex);
            }
            if (this.person != null) {
                this.updatePersonDisplayText();
                if (showPersonMaint) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FrSales.this.attachPerson("", false);
                        }
                    });
                } else if (validateEmail) {
                    this.performPersonEmailAddressValidation(this.person);
                }
            }
            ((PaSalesFoot)this.paFoot).changeAttachPersonButton(this.person != null);
        }
    }

    private void clearNotes(Vector<NoteType> types) {
        Vector<Note> removeList = new Vector<Note>();
        block0: for (Note note : this.notes) {
            NoteType nt = note.getNoteType();
            for (NoteType nt2 : types) {
                if (nt.nRcidx != nt2.nRcidx) continue;
                removeList.addElement(note);
                continue block0;
            }
        }
        this.notes.removeAll(removeList);
        this.notesSet();
    }

    private void performPersonEmailAddressValidation(Element person) {
        if (!this.sParams.checkIConn()) {
            return;
        }
        if (person == null) {
            return;
        }
        Element email = PersonUtils.getPhone(person, PersonUtils.PhoneType.EMAIL);
        if (email == null) {
            return;
        }
        if (PersonUtils.getEmailStatus(email) == EmailStatus.FORCED_OK) {
            return;
        }
        String emailAddress = email.getText();
        if (PersonUtils.getEmailStatus(email) == EmailStatus.ASSUMED_OK && this.sParams.getEmailValidator().validate(emailAddress)) {
            return;
        }
        String message = MessageFormat.format(StoreParams.res.getString("email_validate_fail_and_update"), emailAddress, PersonUtils.getPerName(person), "\n");
        if (1 == DlgMessage.showMessage(this, message, StoreParams.res.getString("Confirm_Email_Address"), 0, 3)) {
            return;
        }
        this.editPerson();
    }

    private void editPerson() {
        Element clonedPerson = (Element)this.person.clone();
        try (PersonDlgProxy permaint = new PersonDlgProxy(this, SP.getRS("Person"), clonedPerson, this.getSecurity(11106L), new boolean[]{false, false, false, false}, 0L, true);){
            permaint.setVisible(true);
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        if (clonedPerson.getAttribute("peridx") == null) {
            return;
        }
        try {
            if (clonedPerson.getAttribute("peridx").getLongValue() == this.person.getAttribute("peridx").getLongValue()) {
                this.person = clonedPerson;
            }
        }
        catch (DataConversionException ex) {
            PosUtils.logError(ex);
        }
    }

    private void checkForPersonSwaps() {
        Date now = new Date();
        if (lastPersonSwapLookup < now.getTime() - 300000L) {
            lastPersonSwapLookup = now.getTime();
            this.getPersonSwaps();
        }
    }

    private void getPersonSwaps() {
        if (!this.sParams.checkIConn()) {
            return;
        }
        try {
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_person_on_transaction_changes", String.valueOf(this.sParams.getStoreIdx())).getXML();
            if (result == null) {
                return;
            }
            List changes = result.getChildren("change");
            for (Object change : changes) {
                Element changeElement = (Element)change;
                String docketNumber = changeElement.getAttributeValue("docket_number");
                String newClientidx = changeElement.getAttributeValue("new_clientidx");
                String localClientidx = changeElement.getAttributeValue("local_clientidx");
                String createdWidx = changeElement.getAttributeValue("created_widx");
                long peridx = PosUtils.longVal(localClientidx) < 0L && PosUtils.longVal(createdWidx) == this.sParams.getStoreIdx() ? PosUtils.longVal(localClientidx) : PosUtils.longVal(newClientidx);
                boolean doChange = false;
                if (peridx == 0L) {
                    doChange = true;
                } else {
                    try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM PERSON WHERE PERIDX = " + peridx);){
                        if (sql.next()) {
                            doChange = true;
                        }
                    }
                }
                if (!doChange) continue;
                this.changePersonOnTransaction(peridx, docketNumber);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean isSaleOrder() {
        return TransTypes.isSale(this.transType);
    }

    public boolean isLocalTransaction() {
        return this.transRoot.getAttributeValue("vhidx_local") != null && this.transRoot.getAttributeValue("vhidx_local").toLowerCase().equals("true");
    }

    public boolean retailEmailReceiptTriggerExists() {
        String retailEmailReceiptTriggerExistsVal = "";
        if (this.isLocalTransaction()) {
            Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("check_trigger", "2226,0,1").getXML();
            retailEmailReceiptTriggerExistsVal = result.getAttributeValue("triggerExists");
        } else if (this.isSaleOrder()) {
            retailEmailReceiptTriggerExistsVal = this.transRoot.getAttributeValue("retailEmailReceiptTriggerExists");
        }
        if (retailEmailReceiptTriggerExistsVal == null) {
            return false;
        }
        return retailEmailReceiptTriggerExistsVal.toLowerCase().equals("true");
    }

    public void sendRetailEmailReceipt(String originalEmail, String newEmail, PayUtils.ReceiptDeliveryMethod receiptDeliveryMethod) {
        boolean updateEmail = true;
        if (originalEmail != null && originalEmail.equals(newEmail)) {
            updateEmail = false;
        }
        if (!this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return;
        }
        Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("send_retail_email_receipt", this.transRoot.getAttributeValue("vhidx") + "," + newEmail + "," + this.transRoot.getAttributeValue("widx") + "," + this.getUser().getMemidx() + "," + receiptDeliveryMethod.ordinal() + "," + this.transRoot.getAttributeValue("vhidx_local") + "," + this.transRoot.getAttributeValue("despatch_widx")).getXML();
        if (result == null) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return;
        }
        if (result.getChild("error") != null) {
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_resend_transaction_receipt"), "\n", result.getChild("error").getText()), SP.getRS("Error"), -1, 0);
            return;
        }
    }

    protected void changePersonOnExistingTransaction() {
        if (!Security.hasSecurity(this, 12625L, this.getUser().getMemidx(), 2, true)) {
            DlgMessage.showMessage(this, SP.getRS("Insufficient_security_change_person"), SP.getRS("Insufficient_security"), -1, 0);
            return;
        }
        if (!this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
            return;
        }
        Element newPerson = new Element("person");
        try (PersonDlgProxy permaint = new PersonDlgProxy(this, SP.getRS("change_person"), newPerson, this.getSecurity(11106L), new boolean[]{false, false, false, false}, 0L, false);){
            permaint.setVisible(true);
            if (permaint.isAttachRequested()) {
                String newPeridx;
                String oldPeridx = this.person.getAttribute("peridx") == null ? "" : StringUtils.nullToEmpty(this.person.getAttribute("peridx").getValue());
                String string = newPeridx = newPerson.getAttribute("peridx") == null ? "" : StringUtils.nullToEmpty(newPerson.getAttribute("peridx").getValue());
                if (oldPeridx.equals(newPeridx)) {
                    return;
                }
                if (PosUtils.longVal(newPeridx) <= 0L) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_assign_person_created_offline"), "\n"), SP.getRS("Error"), -1, 0);
                    return;
                }
                boolean useLocalVhidx = this.transRoot.getAttribute("vhidx_local") != null && this.transRoot.getAttribute("vhidx_local").getValue().equals("true");
                SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("change_person_on_transaction", this.transRoot.getAttributeValue("vhidx") + "," + newPeridx + "," + this.getUser().getMemidx() + "," + this.sParams.getStoreIdx() + "," + (useLocalVhidx ? "1" : "0")).getXML();
                if (SP.sParams.root == null) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                    return;
                }
                if (SP.sParams.root.getChild("error") != null) {
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_change_person"), "\n", SP.sParams.root.getChild("error").getText()), SP.getRS("Error"), -1, 0);
                    return;
                }
                long transactionLocalWidx = XMLUtils.getLongValue(this.transRoot, "despatch_widx");
                if (transactionLocalWidx == 0L) {
                    transactionLocalWidx = XMLUtils.getLongValue(this.transRoot, "widx");
                }
                if (this.transRoot.getAttribute("widx") != null && transactionLocalWidx == this.sParams.getStoreIdx()) {
                    this.changePersonOnTransaction(PosUtils.longVal(newPeridx), this.transRoot.getAttribute("docket_number").getValue(), XMLUtils.getLongValue(this.transRoot, "widx"));
                }
                Store origStore = this.sParams.getStore(this.transRoot.getAttribute("widx").getLongValue());
                String docketNumber = origStore.getStoreNo() + this.transRoot.getAttribute("docket_number").getValue();
                this.voidTrans(false);
                this.populate(docketNumber);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void changePersonOnTransaction(long newPeridx, String docketNumber) {
        this.changePersonOnTransaction(newPeridx, docketNumber, this.sParams.getStoreIdx());
    }

    private void changePersonOnTransaction(long newPeridx, String docketNumber, long widx) {
        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET CLIENTIDX = ? WHERE DOCKET_NUMBER = ? AND WIDX = ?");){
            if (newPeridx != 0L) {
                prepStmt.setLong(1, newPeridx);
            } else {
                prepStmt.setNull(1, 4);
            }
            prepStmt.setString(2, docketNumber);
            prepStmt.setLong(3, widx);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public Element getPerson() {
        return this.person;
    }

    public boolean isRecallSale() {
        return this.isRecallSale;
    }

    public boolean isPersonValid() {
        return this.person.getAttribute("peridx") != null;
    }

    public boolean isAccountCustomer() {
        if (this.person != null) {
            if (this.person.getAttribute("custidx") != null) {
                String sCustidx = this.person.getAttribute("custidx").getValue();
                for (int i = 0; i < this.sParams.vMailOrderCustidxs.size(); ++i) {
                    if (!sCustidx.equals(this.sParams.vMailOrderCustidxs.elementAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void refreshTransaction() {
        ((PaSales)this.paBody).tblStyles.beginUpdate();
        ((PaSales)this.paBody).tblStyles.endUpdate();
    }

    public void clearAttachedLoyaltyCards() {
        this.attachedLoyaltyCards.clear();
        this.loyaltySpendText = "";
    }

    public void attachPerson(String sAlternativeTitle, boolean suppressOmneoPersonMaint) {
        if (!this.canAttachPerson()) {
            return;
        }
        Element clonedPerson = (Element)this.person.clone();
        try (PersonDlgProxy permaint = new PersonDlgProxy(this, sAlternativeTitle != null && !sAlternativeTitle.equals("") ? sAlternativeTitle : StoreParams.res.getString("Person"), clonedPerson, this.getSecurity(11106L), new boolean[]{false, false, false, false}, 0L, clonedPerson.getAttribute("peridx") != null);){
            permaint.suppressOmneoPersonMaint(suppressOmneoPersonMaint);
            permaint.setVisible(true);
            if (permaint.isAttachRequested() && clonedPerson.getAttribute("peridx") != null) {
                boolean differentPerson;
                boolean bl = differentPerson = !XMLUtils.getValue(clonedPerson, "peridx").equals(XMLUtils.getValue(this.person, "peridx"));
                if (this.person.getAttribute("peridx") == null || differentPerson) {
                    this.clearAttachedLoyaltyCards();
                }
                this.setPerson(clonedPerson);
                this.addAllLoyaltyCards(true);
                if (!StringUtils.isNullOrEmpty(XMLUtils.getValue(this.person, "peridx")) && differentPerson && this.couponManager.getCoupon() != null) {
                    this.setCouponCode(this.couponManager.getCoupon().getCode());
                }
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        ((PaSales)this.paBody).tblStyles.beginUpdate();
        ((PaSales)this.paBody).tblStyles.endUpdate();
        if (this.sParams.useDisplayDevice && this.frameType == 1) {
            this.sParams.displayDevice.discountChange(((PaSales)this.paBody).tblStyles.getDisc());
        }
        this.setFocus();
    }

    protected boolean canAttachPerson() {
        if (this.vhidx == -1L && !XMLUtils.getValue(this.person, "peridx").isEmpty() && ((PaSales)this.paBody).tblStyles.getGifts().size() > 0) {
            DlgMessage.showMessage(this, SP.getRS("Gift_Cannot_Change_Person"), SP.getRS("Error"), 0);
            return false;
        }
        return true;
    }

    protected void addAllLoyaltyCards(boolean clearExisting) {
        if (clearExisting) {
            this.clearAttachedLoyaltyCards();
            ((PaSales)this.paBody).tblStyles.removeAllLoyalyDiscounts();
        }
        List loyalties = this.person.getChildren("perloyalty");
        boolean usingCapillaryRedemption = RewardsUtils.usingCapillaryRewards();
        if (usingCapillaryRedemption) {
            if (((PaSales)this.paBody).frParent.getCapillaryCustomer() == null) {
                return;
            }
            String externalId = ((PaSales)this.paBody).frParent.getCapillaryCustomer().getExternalId();
            for (int i = 0; i < loyalties.size(); ++i) {
                if (!((Element)loyalties.get(i)).getAttribute("cardno").getValue().equals(externalId)) continue;
                this.addLoyalty(((Element)loyalties.get(i)).getAttribute("cardno").getValue());
            }
        } else {
            for (int i = 0; i < loyalties.size(); ++i) {
                this.addLoyalty(((Element)loyalties.get(i)).getAttribute("cardno").getValue());
            }
        }
        this.loadRetailRewards();
    }

    protected boolean checkGiftVoucherLines(int[] rows) {
        return ((PaSales)this.paBody).tblStyles.checkTableForGiftVouchers(rows);
    }

    protected boolean checkReturnLines(int[] rows) {
        return ((PaSales)this.paBody).tblStyles.checkTableForReturns(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean returnGoods(int[] rows) {
        if (!TransTypes.isSpecialOrder(this.transType) && !TransTypes.isCustOrder(this.transType) && ((PaSalesFoot)this.paFoot).bReturn.isEnabled()) {
            Security.OverrideUser overrideUser = new Security.OverrideUser();
            if (!Security.hasSecurity(this, this.docknum != null ? 11183L : 11184L, this.getUser().getMemidx(), 2, true, overrideUser)) {
                DlgMessage.showMessage(this, StoreParams.res.getString(this.docknum != null ? "no_security_docket_present_returns" : "no_security_non_docket_returns"), StoreParams.res.getString("Insufficient_security"), -1, 0);
                return false;
            }
            boolean cancel = true;
            Vector<Integer> removeReturnList = new Vector<Integer>();
            ((PaSales)this.paBody).tblStyles.beginUpdate();
            try {
                int i;
                if (this.sParams.useDisplayDevice && this.frameType == 1) {
                    this.sParams.displayDevice.ResetDiscounts();
                }
                for (i = rows.length - 1; i >= 0; --i) {
                    if (!(((PaSales)this.paBody).tblStyles.getItemAt(rows[i]) instanceof StyleLine)) continue;
                    if (((PaSales)this.paBody).tblStyles.getQty(rows[i]) <= 0.0) {
                        cancel = false;
                        continue;
                    }
                    if (((PaSales)this.paBody).tblStyles.refund(rows[i], this, overrideUser.getUser() == null ? null : new SalesRep(overrideUser.getUser()))) {
                        cancel = false;
                        continue;
                    }
                    removeReturnList.add(rows[i]);
                }
                if (!cancel) {
                    if (TransTypes.isLayby(this.transType)) {
                        this.setTransType(239);
                    }
                    ((PaSales)this.paBody).lFeedBack.setText(StoreParams.refundmsg);
                    this.setEditable(true);
                    if (this.vhidx != -1L) {
                        for (i = ((PaSales)this.paBody).tblStyles.getRowCount() - 1; i >= 0; --i) {
                            Object line = ((PaSales)this.paBody).tblStyles.getItemAt(i);
                            if (removeReturnList.contains(i)) {
                                ((PaSales)this.paBody).tblStyles.delLine(i, false, true);
                                continue;
                            }
                            if (line instanceof StyleLine) {
                                if (((PaSales)this.paBody).tblStyles.isRowSelected(i)) continue;
                                ((PaSales)this.paBody).tblStyles.delLine(i, false, true);
                                continue;
                            }
                            if (line instanceof DiscLine) {
                                if (!((PaSales)this.paBody).tblStyles.isRowSelected(i)) continue;
                                int discNum = ((DiscLine)line).getStyleParent().getDiscLines().indexOf(line);
                                ((PaSales)this.paBody).tblStyles.addRowSelectionInterval(i - discNum - 1, i - discNum - 1);
                                continue;
                            }
                            if (!(line instanceof Note)) continue;
                            if (((PaSales)this.paBody).tblStyles.isRowSelected(i)) {
                                int numNotesDiscs = ((Note)line).styleParent.getDiscLines().size() + ((Note)line).styleParent.getNotes().indexOf(line);
                                ((PaSales)this.paBody).tblStyles.addRowSelectionInterval(i - numNotesDiscs - 1, i - numNotesDiscs - 1);
                            }
                            ((PaSales)this.paBody).tblStyles.delLine(i, false, true);
                        }
                    }
                    this.reservations.clear();
                    this.setReturnEnabled();
                    this.vhidx = -1L;
                    this.transnum = null;
                    if (this.frameType != 10) {
                        if (this.transRoot != null && this.transRoot.getAttribute("docket_number") != null) {
                            this.transnum = this.transRoot.getAttribute("docket_number").getValue();
                            this.setFromWidx(PosUtils.longVal(this.transRoot.getAttribute("widx").getValue()));
                        }
                        if (this.person != null && this.person.getAttribute("peridx") != null) {
                            this.setPerson(this.person);
                        }
                    } else {
                        this.setTransType(556);
                    }
                    this.returningSale = true;
                }
                ((PaSales)this.paBody).tblStyles.selectFirstRow();
            }
            finally {
                ((PaSales)this.paBody).tblStyles.endUpdate();
            }
            return !cancel;
        }
        return false;
    }

    @Override
    public void delLines() {
        if (((PaSalesFoot)this.paFoot).bDelete.isEnabled()) {
            if (TransTypes.isSpecialOrder(this.transType) && !((PaSales)this.paBody).tblStyles.canEditSpecialOrder()) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("cant_modify_special_orders"), objs), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (!(this.transType != 242 && this.transType != 245 && this.transType != 715 || ((PaSales)this.paBody).checkChangeOrder(this.transType))) {
                return;
            }
            Vector<StyleLine> styleLineList = new Vector<StyleLine>();
            int[] rows = ((PaSales)this.paBody).tblStyles.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Object row = ((PaSales)this.paBody).tblStyles.model.getRow(rows[i]);
                if (row instanceof StyleLine) {
                    styleLineList.add((StyleLine)row);
                }
                if (this.transType == 715 && row instanceof StyleLine && ((StyleLine)row).getTakenQty() > 0.0) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("taken_lines_cannot_be_removed"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
                if (!(row instanceof StyleLine) || ((StyleLine)row).canEditPromoLine()) continue;
                DlgMessage.showMessage(this, StoreParams.res.getString("cant_modify_order_with_promo"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            Vector<Object> lines = ((PaSales)this.paBody).delLines();
            if (this.sParams.useDisplayDevice) {
                if (styleLineList.size() == 1) {
                    this.sParams.displayDevice.productChange(((StyleLine)styleLineList.get(0)).getSkuidx(), ((StyleLine)styleLineList.get(0)).getPrice(), false, ((PaSales)this.paBody).tblStyles.getDisc());
                } else {
                    this.sParams.displayDevice.discountChange(((PaSales)this.paBody).tblStyles.getDisc());
                }
            }
            Vector<IActionDetailLogWriter> styleLines = new Vector<IActionDetailLogWriter>();
            for (Object line : lines) {
                if (!(line instanceof StyleLine)) continue;
                styleLines.add((StyleLine)line);
            }
            if (styleLines.size() > 0) {
                long clientidx = this.person.getAttribute("peridx") != null ? PosUtils.longVal(this.person.getAttribute("peridx").getValue()) : 0L;
                PosUtils.logUserAction("DELETE", this.transType, this.vhidx, this.getUser().getMemidx(), clientidx, styleLines);
            }
            for (int i = this.reservations.size() - 1; i >= 0; --i) {
                if (!lines.contains(this.reservations.elementAt(i).getStyleLine())) continue;
                this.reservations.remove(i);
            }
            this.updatePersonDisplayText();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 120) {
            ((PaSalesFoot)this.paFoot).bPayment.doClick();
        } else if (e.getKeyCode() == 119 && ((PaSalesFoot)this.paFoot).bHistory.isVisible() && ((PaSalesFoot)this.paFoot).bHistory.isEnabled()) {
            ((PaSalesFoot)this.paFoot).bHistory.doClick();
        } else if (e.getKeyCode() == 116) {
            if (this.frameType == 10) {
                ((PaSalesFoot)this.paFoot).bAccountSearch.doClick();
            } else if (this.frameType == 1 && ((PaSalesFoot)this.paFoot).bSpecialOrder.isEnabled() && ((PaSalesFoot)this.paFoot).bSpecialOrder.isVisible()) {
                ((PaSalesFoot)this.paFoot).bSpecialOrder.doClick();
            } else if (this.frameType == 12 && ((PaSalesFoot)this.paFoot).bCustOrder.isEnabled() && ((PaSalesFoot)this.paFoot).bCustOrder.isVisible()) {
                ((PaSalesFoot)this.paFoot).bCustOrder.doClick();
            }
        } else if (e.getKeyCode() == 90 && e.isAltDown() && ((PaSalesFoot)this.paFoot).bReserve.isEnabled() && ((PaSalesFoot)this.paFoot).bReserve.isVisible()) {
            ((PaSalesFoot)this.paFoot).bReserve.doClick();
        } else if (e.getKeyCode() == 117) {
            if (this.frameType == 10 && ((PaSalesFoot)this.paFoot).bRefresh.isEnabled() && ((PaSalesFoot)this.paFoot).bRefresh.isVisible()) {
                ((PaSalesFoot)this.paFoot).bRefresh.doClick();
            } else if (TransTypes.isCustOrder(this.transType) && ((PaSalesFoot)this.paFoot).bCancelCustOrder.isVisible() && ((PaSalesFoot)this.paFoot).bCancelCustOrder.isEnabled()) {
                ((PaSalesFoot)this.paFoot).bCancelCustOrder.doClick();
            } else if (((PaSalesFoot)this.paFoot).bCancelLayBy.isEnabled() && ((PaSalesFoot)this.paFoot).bCancelLayBy.isVisible()) {
                ((PaSalesFoot)this.paFoot).bCancelLayBy.doClick();
            } else if (((PaSalesFoot)this.paFoot).bLayBy.isEnabled() && ((PaSalesFoot)this.paFoot).bLayBy.isVisible()) {
                ((PaSalesFoot)this.paFoot).bLayBy.doClick();
            }
        } else if (e.getKeyCode() == 118) {
            if (TransTypes.isCustOrder(this.transType) && ((PaSalesFoot)this.paFoot).bPrintPickList.isVisible() && ((PaSalesFoot)this.paFoot).bPrintPickList.isEnabled()) {
                ((PaSalesFoot)this.paFoot).bPrintPickList.doClick();
            } else if (((PaSalesFoot)this.paFoot).bReturn.isVisible() && ((PaSalesFoot)this.paFoot).bReturn.isEnabled()) {
                ((PaSalesFoot)this.paFoot).bReturn.doClick();
            }
        } else if (e.getKeyCode() == 115 && !e.isAltDown() && ((PaSalesFoot)this.paFoot).bDisc.isVisible() && ((PaSalesFoot)this.paFoot).bDisc.isEnabled()) {
            ((PaSalesFoot)this.paFoot).bDisc.doClick();
        } else if (e.getKeyCode() == 67 && e.isAltDown() && ((PaSalesFoot)this.paFoot).bPerson.isVisible() && ((PaSalesFoot)this.paFoot).bPerson.isEnabled()) {
            ((PaSalesFoot)this.paFoot).bPerson.doClick();
        } else if (e.getKeyCode() == 82 && e.isAltDown() && ((PaSalesFoot)this.paFoot).bHold.isVisible() && ((PaSalesFoot)this.paFoot).bHold.isEnabled()) {
            ((PaSalesFoot)this.paFoot).bHold.doClick();
        } else if (e.getKeyCode() == 68 && e.isAltDown()) {
            ((PaSales)this.paBody).tblStyles.setNotes();
        } else if (e.getKeyCode() == 75 && e.isAltDown() && (this.frameType == 10 || this.frameType == 12)) {
            ((PaSalesFoot)this.paFoot).bKit.doClick();
        } else if (e.getKeyCode() == 83 && e.isAltDown()) {
            ((PaSalesFoot)this.paFoot).bChangeSalesRep.doClick();
        } else if (e.getKeyCode() == 88 && e.isAltDown()) {
            if (((PaSalesFoot)this.paFoot).bCoupon.isEnabled() && ((PaSalesFoot)this.paFoot).bCoupon.isVisible()) {
                ((PaSalesFoot)this.paFoot).bCoupon.doClick();
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaSales)this.paBody).tblStyles.setEditable(this.editable);
        ((PaSales)this.paBody).tfCust.setEnabled(this.editable);
        ((PaSales)this.paBody).tfCustOrderNum.setEnabled(this.editable);
        if (this.editable) {
            ((PaSales)this.paBody).tfCust.setBackground(Colours.WHITE);
            ((PaSales)this.paBody).tfCustOrderNum.setBackground(Colours.WHITE);
        }
        if (this.frameType != 12) {
            ((PaSalesFoot)this.paFoot).bHold.setEnabled(this.editable);
        }
        ((PaSalesFoot)this.paFoot).bLayBy.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bSpecialOrder.setEnabled(this.editable);
        if (this.frameType != 10) {
            ((PaSalesFoot)this.paFoot).bDisc.setEnabled(this.editable);
        }
        ((PaSalesFoot)this.paFoot).bDelete.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bCancelLayBy.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bPerson.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bReserve.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bRefresh.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bKit.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bChangeSalesRep.setEnabled(this.editable);
        this.setReturnEnabled();
        ((PaSalesFoot)this.paFoot).bCancelCustOrder.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bPrintPickList.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bCoupon.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bPayment.setEnabled(this.editable);
        ((PaSalesFoot)this.paFoot).bPayment.setToolTipText(null);
    }

    private void restrictCustOrderActions(boolean restrictCancellation) {
        ((PaSales)this.paBody).tblStyles.setEditable(false);
        ((PaSales)this.paBody).tfCust.setEnabled(false);
        ((PaSales)this.paBody).tfCustOrderNum.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bDisc.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bDelete.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bPerson.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bKit.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bChangeSalesRep.setEnabled(false);
        ((PaSalesFoot)this.paFoot).bCoupon.setEnabled(false);
        if (restrictCancellation) {
            ((PaSalesFoot)this.paFoot).bCancelCustOrder.setEnabled(false);
        }
    }

    protected void setReturnEnabled() {
        ((PaSalesFoot)this.paFoot).bReturn.setEnabled(false);
        if (this.isTransSameCurrency()) {
            ((PaSalesFoot)this.paFoot).bReturn.setToolTipText(null);
        } else {
            ((PaSalesFoot)this.paFoot).bReturn.setToolTipText(StoreParams.res.getString("different_trading_currency"));
        }
        if (!(TransTypes.isSpecialOrder(this.transType) || TransTypes.isCustOrder(this.transType) || TransTypes.isLayby(this.transType) && !this.lbsoComplete || !this.isTransSameCurrency())) {
            for (int i = 0; i < ((PaSales)this.paBody).tblStyles.getRowCount(); ++i) {
                if (!(((PaSales)this.paBody).tblStyles.getQty(i) > 0.0)) continue;
                ((PaSalesFoot)this.paFoot).bReturn.setEnabled(true);
                break;
            }
        }
    }

    protected void HoldRecall() {
        if (((PaSalesFoot)this.paFoot).bHold.isEnabled()) {
            if (((PaSales)this.paBody).tblStyles.getRowCount() == 0) {
                ((PaSales)this.paBody).tfHeldSales.clear();
                ((PaSales)this.paBody).tfHeldSales.doSearch();
                if (((PaSales)this.paBody).tfHeldSales.getidx() > 0L) {
                    Element trans = new Element("transaction");
                    if (this.db_getTransActionXML(new Long(((PaSales)this.paBody).tfHeldSales.getidx()), trans)) {
                        ((PaSales)this.paBody).tblStyles.setPopulatingRecall(true);
                        this.populate(trans);
                        String transNum = trans.getAttributeValue("trans_number");
                        String fromWidx = trans.getAttributeValue("from_widx");
                        if (transNum != null & transNum != "" && fromWidx != null && fromWidx != "") {
                            Element origTrans = this.sParams.OnlineQueryProvider.getOnlineQuery("trans_bywidx", fromWidx + "," + transNum).getXML();
                            ((PaSales)this.paBody).doPayments.setXMLOldRetTranPs(origTrans);
                        }
                        ((PaSales)this.paBody).tblStyles.setPopulatingRecall(false);
                        this.deleteTrans(this.vhidx);
                    }
                }
            } else if (this.validateTrans(false)) {
                this.setCursor(StoreParams.waitCursor);
                this.setTransType(239);
                this.docknum = null;
                this.completeTrans(false);
                this.vhidx = -1L;
                this.voidTrans(true);
                this.setCursor(StoreParams.normalCursor);
            }
        }
    }

    public void refundFloorToDoorOrder() {
        String title = StoreParams.res.getString("Floor_To_Door_Order_Filter");
        HistoryOptions options = new HistoryOptionsBuilder().transactionNumber().phone().firstname().surname().build();
        StringBuffer result = new StringBuffer();
        StringBuffer sbFilter = new StringBuffer();
        DlgHistoryFilter histFilter = new DlgHistoryFilter(this, title, this.sParams.checkIConn(), options, sbFilter, result, HistorySearchType.SearchType.FLOOR_TO_DOOR_HISTORY);
        histFilter.setVisible(true);
        if (!result.toString().equals("OK")) {
            return;
        }
        if (!this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Floor_to_Door_Offline"), StoreParams.res.getString("Error"), -1, 0);
            return;
        }
        ((PaSales)this.paBody).tfSecSearch.setSearchMode(TransactionSearchField.SearchMode.NORMAL);
        ((PaSales)this.paBody).tfSecSearch.setCustomNoDataMessage(SP.getRS("Floor_To_Door_Search_No_Data_Found"));
        ((PaSales)this.paBody).tfSecSearch.setTitleExt("");
        String extraWhere = "WH.WEBSHIDX IN (SELECT T.WEBSHIDX FROM WEBSALES_TRANSACTIONS T WHERE T.IMPORT_STATUS IN (2, 8) AND T.WEBSHIDX = WH.WEBSHIDX)" + sbFilter.toString();
        if (this.sParams.sWhseRefSecWhereRETAIL != null && !this.sParams.sWhseRefSecWhereRETAIL.trim().isEmpty()) {
            extraWhere = extraWhere + " and exists(select 1 from ret_tranh h join websales_transactions wt on h.vhidx = wt.vhidx where wh.webshidx = wt.webshidx " + this.sParams.sWhseRefSecWhereRETAIL + ")";
        }
        ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1533L, "15672,15693", "", extraWhere);
        ((PaSales)this.paBody).tfSecSearch.clear();
        ((PaSales)this.paBody).tfSecSearch.doSearch();
        String orderNum = ((PaSales)this.paBody).tfSecSearch.getText();
        if (!orderNum.equals("")) {
            this.setCursor(StoreParams.waitCursor);
            Element splitOrders = this.sParams.OnlineQueryProvider.getOnlineQuery("web_order_splits", ((PaSales)this.paBody).tfSecSearch.getidxStr()).getXML();
            this.setCursor(StoreParams.normalCursor);
            if (splitOrders != null) {
                StringBuffer wstIdx = new StringBuffer();
                DlgSplitOrderList splitOrderDlg = new DlgSplitOrderList((PosFrame)this, splitOrders, orderNum, wstIdx);
                splitOrderDlg.setVisible(true);
                if (wstIdx.toString().equals("")) {
                    return;
                }
                this.populateFloorToDoorOrder(wstIdx.toString());
            }
        }
    }

    public boolean populateFloorToDoorOrder(String wstIdx) {
        Reference trans = new Reference(714L);
        if (!this.isVoid()) {
            Object[] objs = new Object[]{trans.getName(), "\n"};
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("uncompleted_trans"), objs), trans.getName(), 0, 2) != 0) {
                return false;
            }
        }
        this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("web_order_transaction", String.valueOf(wstIdx)).getXML();
        if (this.sParams.root == null) {
            return false;
        }
        Element webOrder = new Element("transaction");
        this.copyElementChildren(this.sParams.root, webOrder);
        webOrder.setAttribute("is_refund_floor_to_door", "1");
        if (this.populate(webOrder)) {
            this.setFocus();
            return true;
        }
        return false;
    }

    protected void secSearch(int nSearchType, String extraWhere) {
        this.secSearch(nSearchType, extraWhere, true);
    }

    public void secSearch(int nSearchType, String extraWhere, boolean promptForFilter) {
        if (this.frameType == 10) {
            if (!this.sParams.checkIConn()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                return;
            }
        } else {
            StringBuffer sbFilter = new StringBuffer();
            if (promptForFilter) {
                String title = "";
                HistoryOptions options = null;
                if (nSearchType == 240) {
                    title = StoreParams.res.getString("Layby_Search_Filter");
                    options = new HistoryOptionsBuilder().transactionNumber().phone().firstname().surname().build();
                } else if (nSearchType == 243) {
                    title = StoreParams.res.getString("Special_Order_Search_Filter");
                    options = new HistoryOptionsBuilder().transactionNumber().phone().firstname().surname().build();
                } else if (nSearchType == 714) {
                    title = StoreParams.res.getString("Cust_Order_Search_Filter");
                    options = new HistoryOptionsBuilder().transactionNumber().referenceNumber().phone().deliveryAddress().firstname().surname().build();
                }
                if (options != null) {
                    StringBuffer result = new StringBuffer();
                    DlgHistoryFilter histFilter = new DlgHistoryFilter(this, title, this.sParams.checkIConn(), options, sbFilter, result);
                    histFilter.setVisible(true);
                    if (!result.toString().equals("OK")) {
                        return;
                    }
                }
            }
            this.setCursor(StoreParams.waitCursor);
            ((PaSales)this.paBody).tfSecSearch.setSearchMode(TransactionSearchField.SearchMode.NORMAL);
            ((PaSales)this.paBody).tfSecSearch.setCustomNoDataMessage(null);
            if (nSearchType == 240) {
                ((PaSales)this.paBody).tfSecSearch.setTitleExt("- " + StoreParams.res.getString("Layby"));
                if (this.sParams.checkIConn()) {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, this.sParams.iconn, 265L, "382,367,368,369,370,371,372,373,375,861,961", "", "H.VHIDX = H.VHIDX AND H.TR_TYPE = 240 AND H.LAYBY_TOTAL+H.LAYBY_PAID<>0 AND COALESCE(H.LAYBY_CANCEL,0)=0 AND H.\"ACTIVE\" > 0" + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                } else {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, 661L, "922,923,924", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0 LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX LEFT JOIN PERSON P ON P.PERIDX = H.CLIENTIDX", "H.TR_TYPE = 240 AND H.COMPLETE > 0 AND COALESCE(H.LAYBY_CANCEL,0)=0 AND H.\"ACTIVE\" > 0" + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                }
            } else if (nSearchType == 243) {
                ((PaSales)this.paBody).tfSecSearch.setTitleExt("- " + StoreParams.res.getString("SpecialOrder"));
                if (this.sParams.checkIConn()) {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, this.sParams.iconn, 265L, "382,367,368,369,370,371,372,373,375,861,961", "", "H.VHIDX = H.VHIDX AND H.TR_TYPE = 243 AND H.LAYBY_TOTAL+H.LAYBY_PAID<>0 AND COALESCE(H.LAYBY_CANCEL,0)=0 AND H.\"ACTIVE\" > 0" + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                } else {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, 661L, "922,923,924", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0 LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX LEFT JOIN PERSON P ON P.PERIDX = H.CLIENTIDX", "H.TR_TYPE = 243 AND H.COMPLETE > 0 AND COALESCE(H.LAYBY_CANCEL,0)=0 AND H.\"ACTIVE\" > 0" + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                }
            } else if (nSearchType == 714) {
                ((PaSales)this.paBody).tfSecSearch.setSearchMode(TransactionSearchField.SearchMode.CUSTOMER_ORDERS);
                ((PaSales)this.paBody).tfSecSearch.setTitleExt("- " + StoreParams.res.getString("Customer_Order"));
                if (this.sParams.checkIConn()) {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1331L, "10582, 10583, 10585, 10586, 10587, 10588, 10581", "", "H.VHIDX = H.VHIDX AND H.TR_TYPE = 714 AND H.\"ACTIVE\" > 0 AND NVL(H.CUST_ORDER_COMPLETE,0) = 0 AND DECODE(H.TR_TYPE,714,DECODE(H.CUST_ORDER_COMPLETE,1,NULL,1)) = 1 " + extraWhere + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                } else {
                    ((PaSales)this.paBody).tfSecSearch.setCache(this.sParams.cacher, 1332L, "10592, 10594, 10593", "RET_TRANH H LEFT JOIN RET_TRAND D ON D.VHIDX = H.VHIDX AND D.SEQUENCE_NUMBER = 0  LEFT JOIN SKU ON SKU.SKUIDX = D.SKUIDX  LEFT JOIN CLR ON CLR.CLRIDX = SKU.CLRIDX  LEFT JOIN STYLE S ON S.STYLEIDX = CLR.STYLEIDX LEFT JOIN PERSON P ON P.PERIDX = H.CLIENTIDX", "H.TR_TYPE = 714 AND H.COMPLETE > 0 AND H.\"ACTIVE\" > 0 AND 0 < (SELECT SUM(COALESCE(D2.QTY,0) - COALESCE(D2.TAKEN,0)) FROM RET_TRANH H2, RET_TRAND D2 \tWHERE H2.VHIDX = D2.VHIDX AND H2.\"ACTIVE\" = 1 AND D2.\"ACTIVE\" = 1 \tAND H2.TR_TYPE IN (714,715) \tAND H.TRANS_NUMBER = H2.TRANS_NUMBER AND H.WIDX = H2.FROM_WIDX)" + sbFilter.toString() + this.sParams.sWhseRefSecWhereRETAIL);
                }
            }
            this.setCursor(StoreParams.normalCursor);
        }
        ((PaSales)this.paBody).tfSecSearch.clear();
        boolean wasOnline = this.sParams.checkIConn();
        ((PaSales)this.paBody).tfSecSearch.doSearch();
        if (wasOnline && !this.sParams.checkIConn()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("online_search_error"), StoreParams.res.getString("Error"), -1, 0);
        }
        if (!((PaSales)this.paBody).tfSecSearch.getText().equals("")) {
            this.setCursor(StoreParams.waitCursor);
            this.menu.populate(this, this.frameType == 10 ? 556 : (int)((PaSales)this.paBody).tfSecSearch.getidx(), ((PaSales)this.paBody).tfSecSearch.getText().substring(1));
            this.setCursor(StoreParams.normalCursor);
        }
    }

    @Override
    public void setStatusText(String msg) {
        ((PaSalesFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaSalesFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaSalesFoot)this.paFoot).statusBar.reset();
    }

    public boolean populate(String num, boolean invoice, boolean showNotFoundErrors) {
        if (invoice) {
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("invoice", num).getXML();
            if (this.sParams.root != null) {
                return this.populate((Element)this.sParams.root.clone());
            }
            return false;
        }
        return this.populate(num, showNotFoundErrors);
    }

    @Override
    public boolean populate(String docket, boolean showNotFoundErrors) {
        if (this.frameType == 10) {
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("trans", docket).getXML();
            if (this.sParams.root == null) {
                if (showNotFoundErrors) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                }
                return false;
            }
            if (this.sParams.root.getAttribute("vhidx") == null) {
                if (showNotFoundErrors) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("docket_not_found"), StoreParams.res.getString("Error_loading"), 0);
                }
                return false;
            }
            Element trans = new Element("transaction");
            this.copyElementChildren(this.sParams.root, trans);
            if (!this.populate(trans)) {
                this.voidTrans(false);
                return false;
            }
            return true;
        }
        this.checkForPersonSwaps();
        return super.populate(docket, showNotFoundErrors);
    }

    @Override
    public boolean isVoid() {
        return ((PaSales)this.paBody).tblStyles.getRowCount() == 0 && this.transnum == null && ((PaSales)this.paBody).tfCust.getidx() <= 0L;
    }

    @Override
    public boolean populate(Element trans) {
        try {
            if (super.populate(trans)) {
                String transNumber;
                String storeno;
                this.transRoot = trans;
                if (this.frameType == 1 && this.transType != 239 && !TransTypes.isLayby(this.transType) && !TransTypes.isSpecialOrder(this.transType) && this.transType != 614) {
                    return false;
                }
                if (this.frameType == 10 && this.transType != 556) {
                    return false;
                }
                if (this.frameType == 12 && this.transType != 714 && this.transType != 715) {
                    return false;
                }
                if (this.transType == 714 && XMLUtils.getValue(trans, "loaded_offline").equals("true") && XMLUtils.getValue(trans, "origin").equals("WEB")) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Floor_to_Door_Offline"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
                if (TransTypes.isLayby(this.transType) && !this.sParams.bUsingLaybys) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("laybys_not_available_at_store"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
                if (TransTypes.isSpecialOrder(this.transType) && !this.sParams.bUsingSpecialOrders) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("specialorders_not_available_at_store"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
                if (TransTypes.isCustOrder(this.transType) && !this.sParams.bUsingCustOrders) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("customer_orders_not_available_at_store"), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
                if (this.frameType == 10) {
                    ((PaSales)this.paBody).tblStyles.setEditable(true);
                }
                Attribute pointsPartnerId = trans.getAttribute("points_partner_rcidx");
                Attribute pointsPartnerNumber = trans.getAttribute("points_partner_num");
                if (pointsPartnerId != null && !pointsPartnerId.getValue().isEmpty()) {
                    this.pointsPartners.setCurrentPartner(pointsPartnerId.getLongValue());
                }
                if (pointsPartnerNumber != null && !pointsPartnerNumber.getValue().isEmpty()) {
                    this.pointsPartners.setMembershipNumber(pointsPartnerNumber.getValue());
                }
                if (this.transType == 614) {
                    int i;
                    if (this.transRoot.getAttribute("widx").getLongValue() != this.sParams.getStoreIdx()) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("reservation_from_different_store"), StoreParams.res.getString("Reservation_") + " " + this.transnum, 0);
                        return false;
                    }
                    Vector<SkuReservation> reservations = new Vector<SkuReservation>();
                    List transStyles = trans.getChildren("styles");
                    for (int i2 = 0; i2 < transStyles.size(); ++i2) {
                        List styles = ((Element)transStyles.get(i2)).getChildren("style");
                        for (int j = 0; j < styles.size(); ++j) {
                            long skuidx = ((Element)styles.get(j)).getAttribute("skuidx").getLongValue();
                            SkuReservation reservation = null;
                            for (int r = 0; r < reservations.size(); ++r) {
                                if (((SkuReservation)reservations.get(r)).getStyleLine().getSkuidx() != skuidx) continue;
                                reservation = (SkuReservation)reservations.get(r);
                                break;
                            }
                            if (reservation == null) {
                                reservation = new SkuReservation(this.transnum, skuidx, this.sParams, false);
                                if (reservation == null || reservation.getStyleLine() == null || !reservation.getStyleLine().isValid()) {
                                    Object[] objs = new Object[]{"\n"};
                                    DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("reservation_unaccessible_new"), objs), StoreParams.res.getString("Reservation_") + " " + this.transnum, 0);
                                }
                                if (reservation.getVhidx() == -1L) {
                                    return false;
                                }
                                reservations.add(reservation);
                            }
                            reservation.setPerson(trans.getChild("person"));
                        }
                    }
                    boolean complete = true;
                    for (i = 0; i < reservations.size(); ++i) {
                        if (((SkuReservation)reservations.get(i)).getStyleLine().getQty() == 0.0) continue;
                        complete = false;
                        break;
                    }
                    for (i = 0; i < reservations.size(); ++i) {
                        SkuReservation reservation = (SkuReservation)reservations.get(i);
                        if (complete) {
                            reservation.getStyleLine().setQty(reservation.getOrigQty());
                        }
                        if (reservation.getStyleLine().getQty() == 0.0) continue;
                        this.addReservation(reservation);
                    }
                    if (complete) {
                        ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Completed") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                        this.setEditable(false);
                        ((PaSalesFoot)this.paFoot).bReturn.setEnabled(false);
                        ((PaSalesFoot)this.paFoot).bPayment.setEnabled(false);
                    } else {
                        this.setTransType(239);
                    }
                } else {
                    if (trans.getAttribute("srepidx") != null) {
                        this.changeSalesRep(trans.getAttribute("srepidx").getLongValue());
                    }
                    if (trans.getChild("cust") != null && trans.getChild("cust").getChild("person") != null) {
                        this.setPerson(trans.getChild("cust").getChild("person"));
                    } else if (trans.getChild("person") != null) {
                        this.setPerson(trans.getChild("person"), true, false);
                    }
                    if (this.getPerson() != null) {
                        if (((PaSales)this.paBody).tblStyles.isRecall()) {
                            this.addAllLoyaltyCards(true);
                        } else {
                            this.loadRetailRewards();
                        }
                    }
                    if (((PaSales)this.paBody).tblStyles.isRecall()) {
                        this.isRecallSale = true;
                    }
                    if (((PaSales)this.paBody).tblStyles.isRecall() && trans.getAttribute("from_widx") != null) {
                        this.setFromWidx(trans.getAttribute("from_widx").getLongValue());
                    }
                    if (!((PaSales)this.paBody).tblStyles.populate(trans)) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Missing_style"), objs), StoreParams.res.getString("Error"), 0);
                        return false;
                    }
                    for (int i = ((PaSales)this.paBody).tblStyles.getRowCount() - 1; i >= 0; --i) {
                        if (((PaSales)this.paBody).tblStyles.getQty(i) != 0.0 || !(((PaSales)this.paBody).tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                        ((PaSales)this.paBody).tblStyles.delLine(i, false, false);
                    }
                }
                if (trans.getAttribute("tr_type").getIntValue() == 240) {
                    this.setTransType(242);
                    storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                    transNumber = "L" + storeno + trans.getAttribute("trans_number").getValue();
                    ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Layby_") + " " + transNumber);
                    this.setFromWidx(trans.getAttribute("from_widx").getLongValue());
                    if (trans.getAttribute("layby_due") != null) {
                        PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
                        try {
                            dateFormatter.setTimestampInternal(trans.getAttribute("layby_due").getValue());
                            if (dateFormatter.getTimestamp() != null) {
                                this.dueDate = new java.sql.Date(dateFormatter.getTime());
                            }
                            PosDateFormatter.truncateTime(this.dueDate);
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                    }
                    if (trans.getAttribute("notes2") != null) {
                        this.dateCalc = trans.getAttribute("notes2").getValue();
                    }
                    Iterator payments = trans.getChildren("payments").iterator();
                    while (payments.hasNext()) {
                        for (Element tender : ((Element)payments.next()).getChildren("tender")) {
                            if (tender.getAttribute("payment_typeidx").getLongValue() == 456L || tender.getAttribute("payment_typeidx").getLongValue() == 457L) {
                                this.totOrder += PosUtils.doubleValInternal(tender.getText());
                            }
                            if (tender.getAttribute("payment_typeidx").getLongValue() != 457L) continue;
                            this.totPaidOrder += PosUtils.doubleValInternal(tender.getText());
                        }
                    }
                    for (Element subtran : trans.getChildren("subtrans")) {
                        if (subtran.getAttribute("layby_cancel") == null) continue;
                        this.lbsoCancel = true;
                        this.totOrder = 0.0;
                        this.totPaidOrder = 0.0;
                        if (((PaSales)this.paBody).tblStyles.getRowCount() - 1 > 0 && ((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1) instanceof StyleLine && ((StyleLine)((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1)).getSkuidx() == this.sParams.lbCancFeeSku) {
                            ((PaSales)this.paBody).OldLBSOCancFee = (StyleLine)((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1);
                            continue;
                        }
                        ((PaSales)this.paBody).OldLBSOCancFee = new StyleLine(this.sParams);
                    }
                    this.totOrder = this.sParams.rnd(this.totOrder);
                    this.totPaidOrder = this.sParams.rnd(this.totPaidOrder * -1.0);
                    if (this.lbsoComplete || this.lbsoCancel) {
                        ((PaSales)this.paBody).tfOSBalance.setText(0.0);
                    } else {
                        ((PaSales)this.paBody).tfOSBalance.setText(((PaSales)this.paBody).tblStyles.getDue() - this.totPaidOrder);
                    }
                    if (this.totOrder == 0.0) {
                        if (this.lbsoCancel) {
                            ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Cancelled") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                        } else {
                            ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Completed") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                            this.lbsoComplete = true;
                        }
                        this.setEditable(false);
                    }
                    ((PaSalesFoot)this.paFoot).setButtons(this.transType);
                    if (!this.lockTransaction(transNumber, transNumber, 240)) {
                        return false;
                    }
                    boolean bUpToDate = false;
                    String sLocalDocNum = this.getLastLocalOrderChange(trans.getAttribute("trans_number").getValue(), trans.getAttribute("from_widx").getValue(), 240);
                    if (sLocalDocNum == null) {
                        bUpToDate = true;
                    }
                    if (!bUpToDate) {
                        for (Element subtran : trans.getChildren("subtrans")) {
                            if (subtran.getAttribute("widx").getLongValue() != this.sParams.getStoreIdx() || !subtran.getAttribute("docket_number").getValue().equals(sLocalDocNum)) continue;
                            bUpToDate = true;
                            break;
                        }
                    }
                    if (!bUpToDate) {
                        Object[] objs = new Object[]{"\n", "\n"};
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("layby_not_up_to_date"), objs), StoreParams.res.getString("transaction_out_of_date"), 0);
                        return false;
                    }
                } else if (trans.getAttribute("tr_type").getIntValue() == 243) {
                    this.setTransType(245);
                    storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                    transNumber = "S" + storeno + trans.getAttribute("trans_number").getValue();
                    ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("SpecialOrder_") + " " + transNumber);
                    this.setFromWidx(trans.getAttribute("from_widx").getLongValue());
                    Iterator payments = trans.getChildren("payments").iterator();
                    while (payments.hasNext()) {
                        for (Element tender : ((Element)payments.next()).getChildren("tender")) {
                            if (tender.getAttribute("payment_typeidx").getLongValue() == 642L || tender.getAttribute("payment_typeidx").getLongValue() == 643L) {
                                this.totOrder += PosUtils.doubleValInternal(tender.getText());
                            }
                            if (tender.getAttribute("payment_typeidx").getLongValue() != 643L) continue;
                            this.totPaidOrder += PosUtils.doubleValInternal(tender.getText());
                        }
                    }
                    for (Element subtran : trans.getChildren("subtrans")) {
                        if (subtran.getAttribute("layby_cancel") == null) continue;
                        this.lbsoCancel = true;
                        this.totOrder = 0.0;
                        this.totPaidOrder = 0.0;
                        if (((PaSales)this.paBody).tblStyles.getRowCount() - 1 > 0 && ((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1) instanceof StyleLine && ((StyleLine)((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1)).getSkuidx() == this.sParams.specOrdAdminFeeSku) {
                            ((PaSales)this.paBody).OldLBSOCancFee = (StyleLine)((PaSales)this.paBody).tblStyles.getItemAt(((PaSales)this.paBody).tblStyles.getRowCount() - 1);
                            continue;
                        }
                        ((PaSales)this.paBody).OldLBSOCancFee = new StyleLine(this.sParams);
                    }
                    this.totOrder = this.sParams.rnd(this.totOrder);
                    this.totPaidOrder = this.sParams.rnd(this.totPaidOrder * -1.0);
                    if (this.lbsoComplete || this.lbsoCancel) {
                        ((PaSales)this.paBody).tfOSBalance.setText(0.0);
                    } else {
                        ((PaSales)this.paBody).tfOSBalance.setText(((PaSales)this.paBody).tblStyles.getDue() - this.totPaidOrder);
                    }
                    if (this.totOrder == 0.0) {
                        if (this.lbsoCancel) {
                            ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Cancelled") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                        } else {
                            ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Completed") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                            this.lbsoComplete = false;
                        }
                        this.setEditable(false);
                    }
                    if (!this.lockTransaction(transNumber, transNumber, 243)) {
                        return false;
                    }
                    boolean bUpToDate = false;
                    String sLocalDocNum = this.getLastLocalOrderChange(trans.getAttribute("trans_number").getValue(), trans.getAttribute("from_widx").getValue(), 243);
                    if (sLocalDocNum == null) {
                        bUpToDate = true;
                    }
                    if (!bUpToDate) {
                        for (Element subtran : trans.getChildren("subtrans")) {
                            if (subtran.getAttribute("widx").getLongValue() != this.sParams.getStoreIdx() || !subtran.getAttribute("docket_number").getValue().equals(sLocalDocNum)) continue;
                            bUpToDate = true;
                            break;
                        }
                    }
                    if (!bUpToDate) {
                        Object[] objs = new Object[]{"\n", "\n"};
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("specialorder_not_up_to_date"), objs), StoreParams.res.getString("Error"), 0);
                        return false;
                    }
                } else if (trans.getAttribute("tr_type").getIntValue() == 239) {
                    this.setTransType(239);
                    String string = storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                    if (trans.getAttribute("docket_number") != null) {
                        transNumber = "D" + storeno + trans.getAttribute("docket_number").getValue();
                        String reference = trans.getAttribute("notes2") != null ? trans.getAttribute("notes2").getValue() : "";
                        ((PaSales)this.paBody).tfCustOrderNum.setText(reference);
                        if (reference.length() > 0) {
                            reference = " " + SP.getRS("Reference_Number", reference);
                        }
                        ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Sale") + " " + transNumber + reference);
                        this.despatchInfo = new DespatchInfo();
                        this.despatchInfo.setOrigin(trans.getAttribute("origin") != null ? trans.getAttribute("origin").getValue() : null);
                        this.setEditable(false);
                        if (this.sParams.checkIConn()) {
                            ((PaSalesFoot)this.paFoot).bPerson.setEnabled(true);
                        }
                        if (!this.lockTransaction(transNumber, transNumber, 239)) {
                            return false;
                        }
                    }
                } else if (trans.getAttribute("tr_type").getIntValue() == 714) {
                    Object[] objs;
                    Element billingLocn;
                    long slaidx;
                    String custOrderNumber;
                    ((PaSalesFoot)this.paFoot).lOnHold.setVisible(this.isCustOrderOnHold());
                    ((PaSalesFoot)this.paFoot).bPayment.setEnabled(!this.isCustOrderOnHold());
                    ((PaSalesFoot)this.paFoot).bReassignOrder.setEnabled(!this.isCustOrderOnHold());
                    ((PaSales)this.paBody).tblStyles.setEditable(!this.isCustOrderOnHold());
                    storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                    transNumber = "O" + storeno + trans.getAttribute("trans_number").getValue();
                    this.setTransType(715);
                    if (this.isRefundFloorToDoorOrder() && trans.getAttribute("sordidx") != null) {
                        transNumber = trans.getAttribute("trans_number").getValue();
                    }
                    this.setFromWidx(trans.getAttribute("from_widx").getLongValue());
                    ((PaSales)this.paBody).tfCustOrderNum.setVisible(false);
                    ((PaSales)this.paBody).lCustOrderNum.setVisible(false);
                    String string = custOrderNumber = trans.getAttribute("notes2") != null ? trans.getAttribute("notes2").getValue() : "";
                    if (custOrderNumber.length() > 0) {
                        ((PaSales)this.paBody).lFeedBack.setText(SP.getRS("Customer_order_feedback_message", transNumber, custOrderNumber));
                    } else {
                        ((PaSales)this.paBody).lFeedBack.setText(SP.getRS("Customer_order_feedback_message_simple", transNumber));
                    }
                    ((PaSales)this.paBody).tfCustOrderNum.setText(custOrderNumber);
                    String custOrderTitle = null;
                    this.despatchInfo = new DespatchInfo();
                    this.despatchInfo.setDateLastModified(trans.getAttributeValue("last_updated"));
                    this.despatchInfo.setOrigin(trans.getAttribute("origin") != null ? trans.getAttribute("origin").getValue() : null);
                    this.despatchInfo.setDeliveryInstructions(trans.getAttribute("delivery_instructions") != null ? trans.getAttribute("delivery_instructions").getValue() : null);
                    if (!XMLUtils.getBooleanValue(trans, "vhidx_local")) {
                        this.despatchInfo.setOriginalVhidx(((PaSales)this.paBody).frParent.vhidx);
                    } else if (!XMLUtils.getBooleanValue(trans, "loaded_offline")) {
                        for (Object subtran : trans.getChildren("subtrans")) {
                            Element subtranElement = (Element)subtran;
                            if (XMLUtils.getLongValue(subtranElement, "tr_type") != 714L) continue;
                            this.despatchInfo.setOriginalVhidx(XMLUtils.getLongValue(subtranElement, "vhidx"));
                            break;
                        }
                    }
                    if (trans.getAttribute("docket_number") != null && trans.getAttribute("docket_number").getValue() != null && !trans.getAttribute("docket_number").getValue().equals("-1")) {
                        this.despatchInfo.setOriginalDocketNumber(storeno + trans.getAttribute("docket_number").getValue());
                    }
                    if ((slaidx = XMLUtils.getLongValue(trans, "sla_idx")) > 0L) {
                        this.despatchInfo.setServiceLevelAgreement(new ServiceLevelAgreement(slaidx));
                    }
                    this.despatchInfo.setUnattendedDeliveryOption(trans.getAttribute("unattended_delivery_option") != null ? UnattendedDeliveryOptions.getUnattendedDeliveryOptionsType(trans.getAttribute("unattended_delivery_option").getIntValue()) : UnattendedDeliveryOptions.None);
                    Element deliveryLocn = trans.getChild("delivery_location");
                    if (deliveryLocn != null) {
                        String contact;
                        this.despatchInfo.setCompanyName(deliveryLocn.getAttribute("tradename") != null ? deliveryLocn.getAttribute("tradename").getValue() : null);
                        this.despatchInfo.setDeliveryLocnidx(deliveryLocn.getAttribute("locnidx") != null ? deliveryLocn.getAttribute("locnidx").getValue() : null);
                        this.despatchInfo.setAddressLine1(deliveryLocn.getAttribute("adrs1") != null ? deliveryLocn.getAttribute("adrs1").getValue() : null);
                        this.despatchInfo.setAddressLine2(deliveryLocn.getAttribute("adrs2") != null ? deliveryLocn.getAttribute("adrs2").getValue() : null);
                        this.despatchInfo.setCity(deliveryLocn.getAttribute("city") != null ? deliveryLocn.getAttribute("city").getValue() : null);
                        this.despatchInfo.setState(deliveryLocn.getAttribute("state") != null ? deliveryLocn.getAttribute("state").getValue() : null);
                        this.despatchInfo.setPostcode(deliveryLocn.getAttribute("postcode") != null ? deliveryLocn.getAttribute("postcode").getValue() : null);
                        this.despatchInfo.setCountry(new Country(deliveryLocn.getAttribute("country") != null ? deliveryLocn.getAttribute("country").getValue() : null));
                        this.despatchInfo.setPhone(deliveryLocn.getAttribute("main_phone") != null ? deliveryLocn.getAttribute("main_phone").getValue() : null);
                        this.despatchInfo.setEmail(deliveryLocn.getAttribute("email") != null ? deliveryLocn.getAttribute("email").getValue() : null);
                        this.despatchInfo.setMobile(deliveryLocn.getAttribute("mobile") != null ? deliveryLocn.getAttribute("mobile").getValue() : null);
                        String string2 = contact = deliveryLocn.getAttribute("contact") != null ? deliveryLocn.getAttribute("contact").getValue() : null;
                        if (!StringUtils.isNullOrEmpty(contact)) {
                            this.despatchInfo.setCustomerName(contact);
                        } else if (this.person != null) {
                            this.despatchInfo.setCustomerName(PersonUtils.getPerName(this.person));
                        }
                    }
                    if ((billingLocn = trans.getChild("billing_location")) != null) {
                        this.despatchInfo.setBillingLocnidx(billingLocn.getAttribute("locnidx") != null ? billingLocn.getAttribute("locnidx").getValue() : null);
                    }
                    if (trans.getAttribute("store_despatch") != null) {
                        this.despatchInfo.setDespatchType(DespatchInfo.DespatchType.mapDespatchType(trans.getAttribute("store_despatch").getIntValue()));
                    }
                    if (this.isRefundFloorToDoorOrder()) {
                        custOrderTitle = SP.getRS("Customer_Order_Refund");
                        ((PaSales)this.paBody).tblStyles.setColumnName(7, SP.getRS("Shipped"));
                    } else if (this.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH) {
                        boolean shouldAttributeToOrigin;
                        custOrderTitle = SP.getRS("Customer_Order_Store_Despatch");
                        ((PaSales)this.paBody).tblStyles.setColumnName(7, SP.getRS("Shipped"));
                        ((PaSalesFoot)this.paFoot).bReprintLabels.setEnabled(true);
                        ((PaSalesFoot)this.paFoot).bReassignOrder.setEnabled(!this.isCustOrderOnHold());
                        this.despatchInfo.setOrderNumber(transNumber);
                        this.despatchInfo.setCustomerOrderNumber(custOrderNumber);
                        if (trans.getAttribute("order_currency_code") != null) {
                            this.despatchInfo.setOrderCurrencyCode(trans.getAttribute("order_currency_code").getValue());
                        }
                        if (trans.getAttribute("carrier") != null) {
                            this.despatchInfo.setCarrierIdx(trans.getAttribute("carrier").getValue());
                        }
                        if (trans.getAttribute("service_type") != null) {
                            this.despatchInfo.setServiceTypeIdx(trans.getAttribute("service_type").getValue());
                        }
                        this.despatchInfo.setExpectedDeliveryDate(XMLUtils.getDate(trans, "expected_delivery_date"));
                        long ownerWidx = XMLUtils.getLongValue(trans, "owner_widx");
                        long widx = XMLUtils.getLongValue(trans, "widx");
                        boolean bl = shouldAttributeToOrigin = ownerWidx != 0L && ownerWidx != widx;
                        if (!XMLUtils.getValue(trans, "owner_trading_currency").equals(SP.sParams.storeCurrency.getIdx()) && !shouldAttributeToOrigin) {
                            ((PaSalesFoot)this.paFoot).bPayment.setEnabled(false);
                            ((PaSalesFoot)this.paFoot).bPayment.setToolTipText("Cannot pack a transaction from another store if Omni-Channel Sales Attribution is not turned on");
                        }
                    } else {
                        custOrderTitle = SP.getRS("Customer_Order_Customer_Pickup");
                        ((PaSales)this.paBody).tblStyles.setColumnName(7, SP.getRS("Taken"));
                        ((PaSalesFoot)this.paFoot).bReprintLabels.setEnabled(false);
                        ((PaSalesFoot)this.paFoot).bReassignOrder.setEnabled(!this.isCustOrderOnHold());
                    }
                    this.paHead.setTitle(custOrderTitle);
                    Iterator payments = trans.getChildren("payments").iterator();
                    while (payments.hasNext()) {
                        for (Element tender : ((Element)payments.next()).getChildren("tender")) {
                            if (tender.getAttribute("payment_typeidx").getLongValue() == 716L) continue;
                            this.totPaidOrder += PosUtils.doubleValInternal(tender.getText());
                        }
                    }
                    boolean custOrderPosted = true;
                    for (Element subtran : trans.getChildren("subtrans")) {
                        if (subtran.getAttribute("cust_order_complete") != null && subtran.getAttribute("cust_order_complete").getIntValue() == 1) {
                            this.custOrderComplete = true;
                        }
                        if (subtran.getAttribute("post_status") == null || !subtran.getAttribute("post_status").getValue().equals("false")) continue;
                        custOrderPosted = false;
                    }
                    this.totOrder = this.sParams.rnd(((PaSales)this.paBody).tblStyles.getDue());
                    this.totPaidOrder = this.sParams.rnd(this.totPaidOrder);
                    ((PaSales)this.paBody).tfOSBalance.setText(((PaSales)this.paBody).tblStyles.getDue() - this.totPaidOrder);
                    if (this.custOrderComplete) {
                        ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Completed") + " " + ((PaSales)this.paBody).lFeedBack.getText());
                        this.setEditable(false);
                    } else if (this.isOwnerCompanyDifferent()) {
                        this.restrictCustOrderActions(true);
                    } else if (this.isWebOrderUpdate()) {
                        this.restrictCustOrderActions(false);
                    }
                    if (!this.lockTransaction(transNumber, transNumber, 714)) {
                        return false;
                    }
                    boolean bUpToDate = false;
                    String sLocalDocNum = this.getLastLocalOrderChange(trans.getAttribute("trans_number").getValue(), trans.getAttribute("from_widx").getValue(), 714);
                    if (sLocalDocNum == null) {
                        bUpToDate = true;
                    }
                    if (!bUpToDate) {
                        for (Element subtran : trans.getChildren("subtrans")) {
                            if (subtran.getAttribute("widx").getLongValue() != this.sParams.getStoreIdx() || !subtran.getAttribute("docket_number").getValue().equals(sLocalDocNum)) continue;
                            bUpToDate = true;
                            break;
                        }
                    }
                    if (!bUpToDate) {
                        objs = new Object[]{"\n", "\n"};
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("custorder_not_up_to_date"), objs), StoreParams.res.getString("Error"), 0);
                        return false;
                    }
                    if (!custOrderPosted) {
                        objs = new Object[]{"\n", "\n"};
                        DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("custorder_not_validated"), objs), StoreParams.res.getString("Error"), 0);
                        return false;
                    }
                    if (this.isRefundFloorToDoorOrder()) {
                        ((PaSales)this.paBody).tblStyles.setEditable(false);
                        PaSalesFoot footer = (PaSalesFoot)this.paFoot;
                        footer.bPayment.setText(SP.getRS("F9_Refund"));
                        footer.bChangeSalesRep.setEnabled(false);
                        footer.bPerson.setEnabled(false);
                        footer.bPrintPickList.setEnabled(false);
                        footer.bDisc.setEnabled(false);
                        footer.bCancelCustOrder.setEnabled(false);
                        footer.bDelete.setEnabled(false);
                        footer.bKit.setEnabled(false);
                        footer.bCustOrder.setEnabled(false);
                        footer.bReprintLabels.setEnabled(false);
                        if (this.getFromWidx() != this.sParams.getStoreIdx()) {
                            footer.bReassignOrder.setEnabled(false);
                        } else {
                            footer.bReassignOrder.setEnabled(!this.isCustOrderOnHold());
                        }
                    }
                } else if (this.frameType == 10 && trans.getAttribute("tr_type").getIntValue() == 556) {
                    ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Debtor_Sale_Invoice") + " " + trans.getAttribute("trans_number").getValue());
                    ((PaSales)this.paBody).tfCustOrderNum.setText(trans.getAttribute("notes2") != null ? trans.getAttribute("notes2").getValue() : "");
                    this.setFromWidx(trans.getAttribute("from_widx").getLongValue());
                    this.setEditable(false);
                    this.setTransType(558);
                    if (trans.getChild("cust") != null) {
                        ((PaSales)this.paBody).tfBarcode.requestFocus();
                        ((PaSales)this.paBody).tfCust.setText(trans.getChild("cust").getAttribute("code").getValue());
                        ((PaSales)this.paBody).tfCust.setidx(trans.getChild("cust").getAttribute("custidx").getLongValue());
                        ((PaSales)this.paBody).lCustDets.setText(trans.getChild("cust").getAttribute("name").getValue());
                        for (int i = 0; i < this.custNoteTypes.size(); ++i) {
                            this.custNoteTypes.elementAt(i).setKeyIdx(trans.getChild("cust").getAttribute("custidx").getLongValue(), false);
                        }
                        this.addNotes(this.custNoteTypes, trans.getChild("cust").getChildren("note"));
                    }
                }
            } else {
                return false;
            }
            if ((this.transType == 242 || this.transType == 245 || this.transType == 715) && this.getFromWidx() != this.sParams.getStoreIdx()) {
                ((PaSales)this.paBody).tblStyles.setEditable(false);
            }
        }
        catch (DataConversionException e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    private String getLastLocalOrderChange(String sTransNum, String sOrigStore, int nTrType) {
        String sDocNum = null;
        String sExtraWhere = null;
        if (nTrType == 240) {
            sExtraWhere = "240,241,242";
        } else if (nTrType == 243) {
            sExtraWhere = "243,244,245";
        } else if (nTrType == 714) {
            sExtraWhere = "714,715";
        }
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT R.DOCKET_NUMBER FROM RET_TRANH R WHERE R.\"ACTIVE\" > 0 AND FROM_WIDX = " + sOrigStore + " AND R.TRANS_NUMBER = " + PosUtils.StringToSqlString(sTransNum) + " AND R.TR_TYPE IN(" + sExtraWhere + ") ORDER BY R.TRAND DESC");){
            if (sql.next()) {
                sDocNum = sql.getString(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return sDocNum;
    }

    @Override
    public void printReceipt(boolean reprint) {
        this.printReceipt(reprint, 0L);
    }

    public void printReceipt(boolean reprint, long npVhidx) {
        long nlVhIdx = 0L;
        int nlTransType = this.transType;
        Element lastTrans = null;
        Element lastStyles = null;
        Element lastPayments = null;
        boolean lastTransRemoved = false;
        boolean lastStylesRemoved = false;
        boolean lastPaymentsRemoved = false;
        long ownerWidx = this.getOwnerWidx();
        if (npVhidx != 0L) {
            nlVhIdx = npVhidx;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT TR_TYPE FROM RET_TRANH WHERE VHIDX = " + nlVhIdx);){
                if (sql.next()) {
                    nlTransType = sql.getInt(1);
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
        } else if (reprint) {
            List subtrans = this.transRoot.getChildren("subtrans");
            lastTrans = (Element)subtrans.get(subtrans.size() - 1);
            if (lastTrans.getAttribute("widx") != null && (PosUtils.longVal(lastTrans.getAttribute("widx").getValue()) == this.sParams.getStoreIdx() || XMLUtils.getLongValue(lastTrans, "despatch_widx") == this.sParams.getStoreIdx())) {
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT VHIDX FROM RET_TRANH WHERE DOCKET_NUMBER = ? AND WIDX = ?", XMLUtils.getValue(lastTrans, "docket_number"), XMLUtils.getValue(lastTrans, "widx"));){
                    if (sql.next()) {
                        nlVhIdx = sql.getLong(1);
                        if (TransTypes.isLayby(nlTransType) || TransTypes.isSpecialOrder(nlTransType) || TransTypes.isCustOrder(nlTransType)) {
                            List transPayments;
                            long XmlVhidx = PosUtils.longVal(lastTrans.getAttribute("vhidx").getValue());
                            lastTransRemoved = this.transRoot.removeContent((Content)lastTrans);
                            List transStyles = this.transRoot.getChildren("styles");
                            if (transStyles.size() > 0 && PosUtils.longVal((lastStyles = (Element)transStyles.get(transStyles.size() - 1)).getAttribute("vhidx").getValue()) == XmlVhidx) {
                                lastStylesRemoved = this.transRoot.removeContent((Content)lastStyles);
                            }
                            if ((transPayments = this.transRoot.getChildren("payments")).size() > 0 && PosUtils.longVal((lastPayments = (Element)transPayments.get(transPayments.size() - 1)).getAttribute("vhidx").getValue()) == XmlVhidx) {
                                lastPaymentsRemoved = this.transRoot.removeContent((Content)lastPayments);
                            }
                        }
                    } else {
                        nlVhIdx = -1L;
                    }
                }
                catch (SQLException ex) {
                    PosUtils.logError(ex);
                }
            } else {
                nlVhIdx = -1L;
            }
        } else {
            nlVhIdx = this.vhidx;
        }
        Receipt receipt = null;
        receipt = ((PaSales)this.paBody).doPayments.getPaymentDlg().isVisible() ? new Receipt(((PaSales)this.paBody).doPayments.getPaymentDlg(), StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), nlVhIdx, ownerWidx, reprint) : new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), nlVhIdx, ownerWidx, reprint);
        if (receipt.isValidReceipt()) {
            if (reprint && !Security.hasSecurity(11163L, this.getUser().getMemidx(), 0) && PayUtils.hasCreditNote(nlVhIdx)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Insufficient_security_to_reprint_credit_notes"), StoreParams.res.getString("Reprint"), -1, 1);
            }
            receipt.setPrintCustAddr(!reprint && ((PaSales)this.paBody).doPayments.isPrintingCustAddr());
            receipt.setPrintedByUser(this.getUser());
            boolean print = !PayUtils.isNonPrint(this.deliveryMethod);
            switch (nlTransType) {
                case 240: {
                    Element printCustCopyL = new Element("printCustCopy");
                    printCustCopyL.setAttribute("print", print ? "true" : "false");
                    this.person.addContent((Content)printCustCopyL);
                    receipt.PrintLayBy(this.person);
                    break;
                }
                case 241: {
                    Element printCustCopy = new Element("printCustCopy");
                    printCustCopy.setAttribute("print", print ? "true" : "false");
                    this.transRoot.addContent((Content)printCustCopy);
                    receipt.PrintLayBy(this.transRoot);
                    break;
                }
                case 242: {
                    Element printCustCopyP = new Element("printCustCopy");
                    printCustCopyP.setAttribute("print", print ? "true" : "false");
                    this.transRoot.addContent((Content)printCustCopyP);
                    receipt.PrintLayBy(this.transRoot);
                    break;
                }
                case 243: {
                    receipt.PrintSpecialOrder(this.person);
                    break;
                }
                case 245: {
                    receipt.PrintSpecialOrder(this.transRoot);
                    break;
                }
                case 244: {
                    receipt.PrintSpecialOrder(this.transRoot);
                    break;
                }
                case 714: {
                    receipt.PrintCustOrder(this.person);
                    break;
                }
                case 715: {
                    receipt.PrintCustOrder(this.transRoot);
                    break;
                }
                case 239: {
                    if (reprint && this.reservations.size() > 0) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("reprint_res_from_res_screen"), StoreParams.res.getString("Reprint"), -1, 1);
                        break;
                    }
                    receipt.PrintSale(this.person.getAttribute("peridx") != null ? this.person : null);
                    if (!((PaSales)this.paBody).doPayments.isPrintingGiftDocket()) break;
                    receipt.PrintGiftPurchDoc(this.person.getAttribute("peridx") != null ? this.person : null);
                    break;
                }
                case 556: {
                    receipt.PrintSale(this.transRoot != null && this.transRoot.getChild("cust") != null ? this.transRoot.getChild("cust") : this.transRoot);
                    break;
                }
                case 558: {
                    receipt.PrintSale(this.transRoot);
                    break;
                }
                case 614: {
                    if (reprint) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("reservation_is_complete_nothing_to_print"), StoreParams.res.getString("Reprint"), -1, 1);
                        break;
                    }
                    receipt.PrintReservation(this.person, true);
                    receipt.PrintReservation(this.person, false);
                    break;
                }
            }
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        receipt.close();
        if (lastTransRemoved) {
            this.transRoot.addContent((Content)lastTrans);
        }
        if (lastStylesRemoved) {
            this.transRoot.addContent(lastStyles);
        }
        if (lastPaymentsRemoved) {
            this.transRoot.addContent(lastPayments);
        }
    }

    @Override
    protected void setTransnum() {
        try {
            if (this.transType == 240) {
                this.transnum = PosUtils.padZeroes(this.sParams.getNextLayByNum("FrSales.setTransnum"), 8);
            } else if (this.transType == 243) {
                this.transnum = PosUtils.padZeroes(this.sParams.getNextSpecialOrderNum("FrSales.setTransnum"), 8);
            } else if (this.transType == 714) {
                this.transnum = PosUtils.padZeroes(this.sParams.getNextCustomerOrderNum("FrSales.setTransnum"), 8);
            } else if (this.transType == 614) {
                this.transnum = this.docknum;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public boolean reserveStk() {
        if (this.hasSecurity(11126L, 0)) {
            int nCheck = ((PaSales)this.paBody).tblStyles.checkTableForSpecialOrder();
            if (nCheck == 1 || nCheck == 3) {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (RewardsUtils.usingAp21RetailRewards() && ((PaSales)this.paBody).tblStyles.getLoyaltyTotal(787L) > 0.0) {
                DlgMessage.showMessage(this, SP.getRS("rewards_on_reservation"), SP.getRS("Error"), 0);
                return false;
            }
            if (((PaSales)this.paBody).tblStyles.checkTableForGiftVouchers()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("gift_vouchers_on_reservation"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
            if (RewardsUtils.usingAp21RetailRewards() && ((PaSales)this.paBody).tblStyles.getGifts().size() > 0) {
                DlgMessage.showMessage(this, SP.getRS("gifts_on_reservation"), SP.getRS("Error"), 0);
                return false;
            }
            if (((PaSales)this.paBody).tblStyles.checkForRecalledProduct()) {
                return false;
            }
            if (((PaSales)this.paBody).tblStyles.getQty() == 0.0 || ((PaSales)this.paBody).tblStyles.hasNegQtys()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("cannot_reserve_negative"), StoreParams.res.getString("reservation_failed"), 0);
                return false;
            }
            this.setTransType(614);
            boolean bComplete = this.completeTrans();
            if (!bComplete) {
                this.setTransType(239);
            }
            return bComplete;
        }
        DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        return false;
    }

    public boolean addReservation(SkuReservation reservation) {
        if (reservation.getPeridx() == 0L) {
            String msg = StoreParams.res.getString("res_cannot_load_cust_removed") + "\n";
            DlgMessage.showMessage(this, msg + StoreParams.res.getString("please_unreserve"), StoreParams.res.getString("Reservation_") + " " + reservation.getTransnum(), 0);
            return false;
        }
        for (int i = 0; i < this.reservations.size(); ++i) {
            if (this.reservations.elementAt(i).getVhidx() != reservation.getVhidx() || this.reservations.elementAt(i).getStyleLine().getSkuidx() != reservation.getStyleLine().getSkuidx()) continue;
            DlgMessage.showMessage(this, StoreParams.res.getString("res_already_added"), StoreParams.res.getString("Error"), 0);
            return false;
        }
        if (!((PaSales)this.paBody).tblStyles.isEditable()) {
            this.voidTrans(false);
        }
        if (!this.lockTransaction(reservation.getTransnum(), reservation.getTransnum(), 614)) {
            return false;
        }
        if (!reservation.isUpToDate(false)) {
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("reservation_modified"), "\n"), StoreParams.res.getString("Reservation_") + " " + reservation.getTransnum(), 0);
            return false;
        }
        if (this.person.getAttribute("peridx") != null) {
            if (!this.person.getAttribute("peridx").getValue().equals(reservation.getPerson().getAttribute("peridx").getValue())) {
                DlgMessage.showMessage(this, StoreParams.res.getString("diff_cust"), StoreParams.res.getString("Error"), 0);
                this.clearLock(reservation.getTransnum(), 614);
                return false;
            }
        } else {
            this.setPerson(reservation.getPerson(), true, false);
            this.addAllLoyaltyCards(true);
            this.changeSalesRep(reservation.getSalesRep().getPeridx());
        }
        ((PaSales)this.paBody).lFeedBack.setText(StoreParams.res.getString("Reservation_") + " R" + reservation.getStore().getStoreNo() + reservation.getTransnum());
        ((PaSales)this.paBody).tblStyles.addStyleLine(reservation.getStyleLine());
        this.reservations.add(reservation);
        this.setTransnum(reservation.getTransnum());
        this.setFromWidx(reservation.getStore().getWidx());
        return true;
    }

    @Override
    public void setNotes(Vector<NoteType> pnoteTypes) {
        Vector<NoteType> types = new Vector<NoteType>(pnoteTypes);
        if (this.person.getAttribute("peridx") != null) {
            types.addAll(this.perNoteTypes);
        }
        if (this.frameType == 10 && ((PaSales)this.paBody).tfCust.getidx() > 0L) {
            types.addAll(this.custNoteTypes);
        }
        super.setNotes(types);
    }

    @Override
    public void notesSet() {
        ((PaSales)this.paBody).lPerson.setForeground(this.getDefaultColor());
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType == null) continue;
            if (note.noteType.getTblidx() == 23L) {
                ((PaSales)this.paBody).lFeedBack.setForeground(this.notesColor);
                continue;
            }
            if (note.noteType.getTblidx() == 12L) {
                ((PaSales)this.paBody).lPerson.setForeground(this.notesColor);
                continue;
            }
            if (note.noteType.getTblidx() != 3L) continue;
            ((PaSales)this.paBody).lCustDets.setForeground(this.notesColor);
        }
    }

    protected void setPaymentDate() {
        java.sql.Date startDate = new java.sql.Date(new Date().getTime());
        PosDateFormatter.truncateTime(startDate);
        PosDateFormatter.truncateTime(this.dueDate);
        this.nextPayDate = this.sParams.getPDueDate(this.dateCalc, startDate);
        if (this.nextPayDate != null && this.dueDate != null && this.nextPayDate.getTime() > this.dueDate.getTime()) {
            this.nextPayDate.setTime(this.dueDate.getTime());
        }
    }

    public void changeLayByDates(java.sql.Date pThisPayDate, java.sql.Date pFinalPayDate) {
        block41: {
            if (!this.sParams.checkIConn()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                return;
            }
            PosDateFormatter origThisPayDate = new PosDateFormatter(null, 3, 3, 0);
            PosDateFormatter origFinalPayDate = new PosDateFormatter(null, 3, 3, 0);
            PayUtils.getLaybyDates(this.transRoot, origThisPayDate, origFinalPayDate);
            try {
                Attribute dateAtt;
                Throwable throwable;
                Timestamp tThisPayDue;
                Timestamp tFinalPayDue;
                block42: {
                    tFinalPayDue = new Timestamp(pFinalPayDate.getTime());
                    tThisPayDue = new Timestamp(pThisPayDate.getTime());
                    if (origThisPayDate.getTime() == tThisPayDue.getTime() && origFinalPayDate.getTime() == tFinalPayDue.getTime()) break block41;
                    SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("setlbdates", tFinalPayDue + "," + tThisPayDue + "," + this.getUser().getMemidx() + "," + this.transnum + "," + this.getFromWidx()).getXML();
                    if (SP.sParams.root == null) break block41;
                    throwable = null;
                    try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT MAX(LBIDX) FROM LAYBY_PAYDUEDATES WHERE FROM_WIDX = " + this.getFromWidx() + " AND TRANS_NUMBER = " + PosUtils.StringToSqlString(this.transnum));){
                        String sLBIdx;
                        if (!sql.next() || (sLBIdx = sql.getString(1)) == null) break block42;
                        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("UPDATE LAYBY_PAYDUEDATES SET PAYMENT_DUE = ?, UPDT = CURRENT_TIMESTAMP, UPMEMIDX = ?, MODIFIED = 1  WHERE LBIDX = ?");){
                            prepStmt.setTimestamp(1, tThisPayDue);
                            prepStmt.setLong(2, this.getUser().getMemidx());
                            prepStmt.setLong(3, PosUtils.longVal(sLBIdx));
                            prepStmt.executeUpdate();
                            this.sParams.yTabInsert("LAYBY_PAYDUEDATES", "LBIDX", sLBIdx);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                throwable = null;
                try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET LAYBY_DUE = ? WHERE FROM_WIDX = ? AND TR_TYPE IN (240,241,242) AND TRANS_NUMBER = ?");){
                    prepStmt.setTimestamp(1, tFinalPayDue);
                    prepStmt.setLong(2, this.getFromWidx());
                    prepStmt.setString(3, this.transnum);
                    prepStmt.executeUpdate();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                Element dateEle = this.transRoot.getChild("layby_payduedates");
                if (dateEle != null) {
                    dateEle.getAttribute("payment_due").setValue(tThisPayDue.toString());
                }
                if ((dateAtt = this.transRoot.getAttribute("layby_due")) != null) {
                    dateAtt.setValue(tFinalPayDue.toString());
                }
                this.dueDate = pFinalPayDate;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    protected void kitEntryDebtor() {
        if (!this.hasSecurity(11133L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else if (this.transRoot == null) {
            DlgMessage.showMessage(this, StoreParams.res.getString("enter_cust"), StoreParams.res.getString("no_cust"), 2);
            this.setFocus();
        } else {
            List kits = this.transRoot.getChildren("kit");
            Object[] kitNames = new String[kits.size()];
            String kitName = null;
            for (int i = 0; i < kitNames.length; ++i) {
                kitNames[i] = ((Element)kits.get(i)).getAttribute("title").getValue();
            }
            if (kits.size() > 1) {
                kitName = (String)DlgList.showDialog(this, StoreParams.res.getString("Select_kit"), StoreParams.res.getString("Kit_Order_Entry"), kitNames, kitNames[0]);
            } else if (kits.size() == 1) {
                kitName = kitNames[0];
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_kit"), StoreParams.res.getString("Kit_Order_Entry"), 1);
            }
            if (kitName != null) {
                Kit kit = null;
                for (int i = 0; i < kits.size(); ++i) {
                    if (!((Element)kits.get(i)).getAttribute("title").getValue().equals(kitName)) continue;
                    kit = new Kit(this, PosUtils.longVal(((Element)kits.get(i)).getAttribute("idx").getValue()), kitName, Kit.KitType.WHOLESALE);
                    if (kit.loadFromHeadOffice(this.getUser().getMemidx())) break;
                    return;
                }
                Vector<Sku> skus = new Vector<Sku>();
                Object[] objs = new Object[]{kitName};
                DlgKitEntry dlgKit = new DlgKitEntry((PosFrame)this, MessageFormat.format(StoreParams.res.getString("Kit_Order_Entry_"), objs), true, kit, skus);
                dlgKit.setVisible(true);
                for (int i = 0; i < skus.size(); ++i) {
                    Sku sku = skus.elementAt(i);
                    StyleLine style = new StyleLine(sku.idx, sku.getQty(), this.sParams);
                    style.setOrigQty(0.0);
                    if (!style.styledesc.equals(sku.clr.name)) {
                        style.changeStyleDescription(sku.clr.name);
                    }
                    style.setPrice(sku.getPrice());
                    style.setOrigPrice(sku.getOrigPrice());
                    style.setTaxPer(sku.clr.style.taxPer);
                    int row = ((PaSales)this.paBody).tblStyles.addStyleLine(style);
                    if (sku.clr.style.disc != 0.0) {
                        ((PaSales)this.paBody).tblStyles.setDisc(557L, sku.clr.style.disc, row, true, false, -1L, 0L, MultiLineDisc.MessageCode.NORMAL);
                    }
                    style.setDebtorAccountSale(true);
                    ((PaSales)this.paBody).tfCust.setEnabled(false);
                }
            }
        }
    }

    protected void kitEntryCustOrder() {
        if (!this.hasSecurity(11133L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        } else if (((PaSales)this.paBody).checkChangeOrder(this.transType)) {
            Vector<Kit> kits = Kit.loadKitList(this, SP.sParams.getStoreCustidx(), Kit.KitType.RETAIL);
            Kit kit = null;
            if (kits.size() > 1) {
                kit = (Kit)DlgList.showDialog(this, StoreParams.res.getString("Select_kit"), StoreParams.res.getString("Kit_Order_Entry"), kits.toArray(), kits.elementAt(0));
            } else if (kits.size() == 1) {
                kit = kits.elementAt(0);
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("no_kit"), StoreParams.res.getString("Kit_Order_Entry"), 1);
            }
            if (kit != null) {
                kit.loadFromDatabase();
                Vector<Sku> skus = new Vector<Sku>();
                Object[] objs = new Object[]{kit.toString()};
                DlgKitEntry dlgKit = new DlgKitEntry((PosFrame)this, MessageFormat.format(StoreParams.res.getString("Kit_Order_Entry_"), objs), true, kit, skus);
                dlgKit.setVisible(true);
                for (int i = 0; i < skus.size(); ++i) {
                    Sku sku = skus.elementAt(i);
                    StyleLine style = new StyleLine(sku.idx, sku.getQty(), this.sParams, SP.sParams.bUsingSOHInCustOrders);
                    style.setOrigQty(0.0);
                    ((PaSales)this.paBody).tblStyles.addStyleLine(style);
                }
            }
        }
    }

    @Override
    public void functionMenuUnhandledActionPerformed(int menuSelection) {
        switch (menuSelection) {
            case 23: {
                if (!this.isLoggedIn(true)) {
                    return;
                }
                this.promptForLoyaltyAmounts(true, false);
                break;
            }
            case 25: {
                if (!this.isLoggedIn(true)) {
                    return;
                }
                this.promptForRewardsGift(true);
            }
        }
    }

    public void promptForLoyaltyAmounts(boolean showMessages, boolean ignoreAlreadyAdded) {
        if (this.person == null || this.person.getAttribute("peridx") == null) {
            if (showMessages) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Person_Attached_Message"), StoreParams.res.getString("No_Person_Attached"), -1, 0);
            }
            return;
        }
        boolean usingRewards = RewardsUtils.usingAp21RetailRewards();
        boolean hasRewardsAccount = usingRewards && this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE;
        boolean usingCapillaryRedemption = RewardsUtils.usingCapillaryRewards();
        if (!(usingRewards || this.canAttachedPersonHaveManualLoyalties() || usingCapillaryRedemption)) {
            if (showMessages) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Manual_Loyalty_Not_Found_Message"), StoreParams.res.getString("Manual_Loyalty_Not_Found"), -1, 0);
            }
            return;
        }
        if (usingRewards) {
            if (SP.sParams.checkIConn()) {
                if (!hasRewardsAccount) {
                    if (showMessages) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("No_Rewards_Account_Message"), StoreParams.res.getString("No_Rewards_Account"), -1, 0);
                    }
                    return;
                }
                Currency programCurrency = this.rewardsApiManager.getAccount().getRewardsProgram().getCurrency();
                if (!programCurrency.getIdx().equals(SP.sParams.storeCurrency.getIdx())) {
                    if (showMessages) {
                        DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Rewards_Cannot_Redeem_Amount_Currency"), programCurrency.getCode()), SP.getRS("Rewards_Cannot_Redeem_Title"), -1, 0);
                    }
                    return;
                }
            } else {
                if (showMessages) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Rewards_Offline"), StoreParams.res.getString("Error"), -1, 0);
                }
                return;
            }
        }
        if (TransTypes.isLayby(this.transType)) {
            if (showMessages) {
                if (usingRewards) {
                    DlgMessage.showMessage(this, SP.getRS("rewards_on_layby"), SP.getRS("Error"), 0);
                } else {
                    DlgMessage.showMessage(this, SP.getRS("Manual_Loyalty_Cant_Be_Changed_Message"), SP.getRS("Manual_Loyalty_Cant_Be_Changed"), -1, 0);
                }
            }
            return;
        }
        if (TransTypes.isSpecialOrder(this.transType)) {
            if (showMessages) {
                if (usingRewards) {
                    DlgMessage.showMessage(this, SP.getRS("rewards_on_special_order"), SP.getRS("Error"), 0);
                } else {
                    DlgMessage.showMessage(this, SP.getRS("Manual_Loyalty_Cant_Be_Changed_Message"), SP.getRS("Manual_Loyalty_Cant_Be_Changed"), -1, 0);
                }
            }
            return;
        }
        if (usingCapillaryRedemption && !usingRewards) {
            this.attachedLoyaltyCards.promptForCapillaryLoyaltyOverrides(this, this.person, ignoreAlreadyAdded);
        } else {
            this.attachedLoyaltyCards.promptForLoyaltyOverrides(this, this.person, ignoreAlreadyAdded);
        }
        this.refreshTransaction();
    }

    public void promptForRewardsGift(boolean showMessages) {
        boolean hasRewardsAccount;
        if (this.person == null || this.person.getAttribute("peridx") == null) {
            if (showMessages) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_Person_Attached_Message"), StoreParams.res.getString("No_Person_Attached"), -1, 0);
            }
            return;
        }
        boolean usingRewards = RewardsUtils.usingAp21RetailRewards();
        boolean bl = hasRewardsAccount = usingRewards && this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE;
        if (usingRewards) {
            if (SP.sParams.checkIConn()) {
                if (!hasRewardsAccount) {
                    if (showMessages) {
                        DlgMessage.showMessage(this, StoreParams.res.getString("No_Rewards_Account_Message"), StoreParams.res.getString("No_Rewards_Account"), -1, 0);
                    }
                    return;
                }
                Currency programCurrency = this.rewardsApiManager.getAccount().getRewardsProgram().getCurrency();
                if (!programCurrency.getIdx().equals(SP.sParams.storeCurrency.getIdx())) {
                    if (showMessages) {
                        DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("Rewards_Cannot_Redeem_Gift_Currency"), programCurrency.getCode()), SP.getRS("Rewards_Cannot_Redeem_Title"), -1, 0);
                    }
                    return;
                }
            } else {
                if (showMessages) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("Gift_Offline"), StoreParams.res.getString("Error"), -1, 0);
                }
                return;
            }
        }
        if (TransTypes.isLayby(this.transType)) {
            if (showMessages) {
                DlgMessage.showMessage(this, SP.getRS("gifts_on_layby"), SP.getRS("Error"), 0);
            }
            return;
        }
        if (TransTypes.isSpecialOrder(this.transType)) {
            if (showMessages) {
                DlgMessage.showMessage(this, SP.getRS("gifts_on_special_order"), SP.getRS("Error"), 0);
            }
            return;
        }
        GiftSku selectedGift = this.attachedLoyaltyCards.promptForRewardsGift(this, this.person);
        if (selectedGift != null && selectedGift.getSkuidx() > 0L) {
            StyleLine giftLine = new StyleLine(selectedGift.getSkuidx(), 1.0, this.sParams, this.frameType == 12 && this.sParams.bUsingSOHInCustOrders);
            giftLine.setOrigQty(0.0);
            giftLine.setGift(selectedGift.getGift());
            int newRow = ((PaSales)this.paBody).tblStyles.addStyleLine(giftLine);
            ((PaSales)this.paBody).tblStyles.setDisc(786L, 100.0, newRow, true, false, -1L, 0L, MultiLineDisc.MessageCode.NORMAL, 0L, false, selectedGift.getGift().getName());
        }
        this.updatePersonDisplayText();
        this.refreshTransaction();
    }

    public Element getPersonByLoyalty(String cardNo) {
        Element loyaltyPerson = null;
        cardNo = PosUtils.loyaltyCardNoPrefixToUpperCase(cardNo);
        String data = cardNo + "@" + this.sParams.getStoreIdx() + "@" + this.sParams.sValidLoyaltyIdxs;
        if (this.sParams.checkIConn()) {
            loyaltyPerson = this.sParams.OnlineQueryProvider.getOnlineQuery("loyalty", data).getXML();
        } else {
            try {
                loyaltyPerson = XMLLocal.getElement(this.sParams.conn, "loyalty", data);
            }
            catch (Exception e) {
                PosUtils.logError(e);
                loyaltyPerson = null;
            }
        }
        return loyaltyPerson;
    }

    public boolean addLoyalty(String cardNo) {
        return this.addLoyalty(cardNo, null);
    }

    public boolean addLoyalty(String cardNo, Element loyaltyPerson) {
        if (this.attachedLoyaltyCards.contains(cardNo = PosUtils.loyaltyCardNoPrefixToUpperCase(cardNo))) {
            return false;
        }
        if (this.getPerson().getAttribute("peridx") == null) {
            if (loyaltyPerson == null) {
                loyaltyPerson = this.getPersonByLoyalty(cardNo);
            }
            if (loyaltyPerson != null && loyaltyPerson.getAttribute("peridx") != null) {
                this.setPerson(loyaltyPerson, true, SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.SHOW_PERSON_MAINT_ON_LOYALTY_SCAN));
            }
        }
        boolean loyaltyAdd = false;
        if (this.getPerson().getAttribute("peridx") != null) {
            List loyaltys = this.getPerson().getChildren("perloyalty");
            boolean loyaltyFound = false;
            boolean expired = false;
            PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
            for (int cnt = 0; cnt < loyaltys.size(); ++cnt) {
                Reference loyaltyRef;
                Element loyalty = (Element)loyaltys.get(cnt);
                if (!cardNo.equals(loyalty.getAttribute("cardno").getValue())) continue;
                if (loyalty.getAttribute("expiry") != null && !loyalty.getAttribute("expiry").getValue().equals("")) {
                    try {
                        dateFormatter.setTimestampInternal(loyalty.getAttribute("expiry").getValue());
                        Timestamp today = new Timestamp(new Date().getTime());
                        PosDateFormatter.truncateTime(today);
                        PosDateFormatter.truncateTime(dateFormatter.getTimestamp());
                        if (today.getTime() > dateFormatter.getTime()) {
                            expired = true;
                            Object[] objs = new Object[]{cardNo, dateFormatter.toString()};
                            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("This_discount_card"), objs), StoreParams.res.getString("Expired_card"), 1);
                        }
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                        return false;
                    }
                }
                if (expired || !((PaSales)this.paBody).tblStyles.canAddLoyaltyDisc(loyaltyRef = new Reference(366L, loyalty.getText(), false))) continue;
                if (!RewardsUtils.usingAp21RetailRewards()) {
                    OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
                    if (setup.isUsingLoyaltyApi(loyaltyRef.getIdx())) {
                        try {
                            double balance = 0.0;
                            double tierMinimumSpend = 0.0;
                            String balanceText = "";
                            this.rewardsApiManager = RewardsApiFactory.getApiManager();
                            if (this.rewardsApiManager.requestBalance(cardNo, XMLUtils.getLongValue(this.person, "peridx"))) {
                                balance = this.rewardsApiManager.getBalance();
                                balanceText = SP.sParams.currFormat.format(balance);
                                tierMinimumSpend = this.rewardsApiManager.getTierMinimumSpend();
                            } else {
                                balanceText = SP.getRS("Offline");
                            }
                            this.loyaltySpendText = MessageFormat.format(SP.getRS("omneo_loyalty_spend_text"), PersonUtils.getPerName(this.person), balanceText);
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                    } else if (loyalty.getAttribute("ltot") != null) {
                        double histTot = Math.floor(PosUtils.doubleValInternal(loyalty.getAttribute("ltot").getValue()));
                        this.loyaltySpendText = MessageFormat.format(SP.getRS("Standard_loyalty_spend_text"), loyaltyRef.getName(), PersonUtils.getPerName(this.person), new DecimalFormat("#,##0").format(histTot));
                    }
                }
                loyaltyAdd = true;
                loyaltyFound = true;
                this.updatePersonDisplayText();
            }
            if (!loyaltyFound) {
                if (!expired) {
                    DlgMessage.showMessage(this, StoreParams.res.getString("This_loyalty_card_is1"), StoreParams.res.getString("Invalid_card"), 1);
                }
                return false;
            }
        } else {
            DlgMessage.showMessage(this, StoreParams.res.getString("This_loyalty_card_is1"), StoreParams.res.getString("Invalid_card"), 1);
        }
        if (loyaltyAdd) {
            this.attachedLoyaltyCards.add(this, this.person, cardNo);
            ((PaSales)this.paBody).update();
        }
        return loyaltyAdd;
    }

    private void loadRetailRewards() {
        if (RewardsUtils.usingAp21RetailRewards()) {
            try {
                String balanceText = "";
                this.rewardsApiManager = RewardsApiFactory.getApiManager();
                if (!this.sParams.checkIConn()) {
                    balanceText = SP.getRS("Offline");
                } else if (this.rewardsApiManager.loadAccount(XMLUtils.getLongValue(this.person, "peridx")) && this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE) {
                    Currency programCurrency = this.rewardsApiManager.getAccount().getRewardsProgram().getCurrency();
                    if (programCurrency.getIdx().equals(SP.sParams.storeCurrency.getIdx())) {
                        balanceText = SP.sParams.storeCurrency.prependSymbol(SP.sParams.storeCurrency.formatDetail(this.rewardsApiManager.getBalance()));
                    }
                    this.attachedLoyaltyCards.addRetailRewards();
                }
                if (!StringUtils.isNullOrEmpty(balanceText)) {
                    this.loyaltySpendText = balanceText;
                }
                this.updatePersonDisplayText();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void updatePersonDisplayText() {
        if (RewardsUtils.usingAp21RetailRewards()) {
            if (this.getPerson().getAttribute("peridx") != null) {
                ((PaSales)this.paBody).lPerson.setText(PersonUtils.getPerName(this.person));
            } else {
                ((PaSales)this.paBody).lPerson.setText("");
            }
            if (this.loyaltySpendText != null && this.loyaltySpendText.length() > 0) {
                ((PaSales)this.paBody).lRewards.setText(this.loyaltySpendText);
                ((PaSales)this.paBody).lRewards.setVisible(true);
            } else {
                ((PaSales)this.paBody).lRewards.setVisible(false);
                ((PaSales)this.paBody).lGift.setVisible(false);
            }
            int availableGifts = 0;
            if (this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE && this.rewardsApiManager.getAccount().getRewardsProgram().getCurrency().getIdx().equals(SP.sParams.storeCurrency.getIdx())) {
                availableGifts = this.rewardsApiManager.getAccount().getAvailableGifts().size() - ((PaSales)this.paBody).tblStyles.getGifts().size();
            }
            if (availableGifts > 0) {
                ((PaSales)this.paBody).lGift.setText(String.valueOf(availableGifts));
                ((PaSales)this.paBody).lGift.setVisible(true);
            } else {
                ((PaSales)this.paBody).lGift.setVisible(false);
            }
            int availableCoupons = 0;
            if (this.rewardsApiManager.getAccount() != null && this.rewardsApiManager.getAccount().getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE && this.rewardsApiManager.getAccount().getRewardsProgram().getCurrency().getIdx().equals(SP.sParams.storeCurrency.getIdx())) {
                int numberOfCoupons;
                int n = numberOfCoupons = this.rewardsApiManager.getAccount().getAvailableCoupons() != null ? this.rewardsApiManager.getAccount().getAvailableCoupons().size() : 0;
                int n2 = ((PaSales)this.paBody).tblStyles.isCouponUsed() ? (numberOfCoupons > 0 ? numberOfCoupons - 1 : 0) : (availableCoupons = numberOfCoupons);
            }
            if (availableCoupons > 0) {
                ((PaSales)this.paBody).lCoupons.setText(String.valueOf(availableCoupons));
                ((PaSales)this.paBody).lCoupons.setVisible(true);
            } else {
                ((PaSales)this.paBody).lCoupons.setVisible(false);
            }
        } else {
            if (this.loyaltySpendText != null && this.loyaltySpendText.length() > 0) {
                ((PaSales)this.paBody).lPerson.setText(this.loyaltySpendText);
            } else if (this.getPerson().getAttribute("peridx") != null) {
                ((PaSales)this.paBody).lPerson.setText(PersonUtils.getPerName(this.person));
            } else {
                ((PaSales)this.paBody).lPerson.setText("");
            }
            ((PaSales)this.paBody).lRewards.setVisible(false);
            ((PaSales)this.paBody).lCoupons.setVisible(false);
            ((PaSales)this.paBody).lGift.setVisible(false);
        }
    }

    @Override
    public boolean checkExit() {
        if (this.editable && ((PaSales)this.paBody).tblStyles.model.getData().size() > 0) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaSales)this.paBody).tblStyles.RefreshImage();
    }

    @Override
    public void processLogin() {
        if (this.isLoggedIn(false)) {
            if (this.transRoot == null || !SalesRep.isSalesRepValid(this.salesRep)) {
                this.salesRep.setSalesRep(this.getUser());
            }
        } else {
            this.salesRep.clear();
        }
        this.manageSalesRepLabel();
    }

    public void manageSalesRepLabel() {
        if (this.salesRep != null && this.salesRep.getMemidx() > 0L) {
            ((PaSales)this.paBody).lSalesRep.setText(MessageFormat.format(StoreParams.res.getString("Sales_Rep_2"), this.salesRep));
        } else {
            ((PaSales)this.paBody).lSalesRep.setText(StoreParams.res.getString("Sales_Rep_1"));
        }
    }

    public void changeSalesRep(long npPeridx) {
        if (npPeridx > 0L) {
            if (PersonUtils.checkPersonExistsLocally(npPeridx)) {
                this.salesRep.setSalesRep(npPeridx, this.sParams);
            }
        } else {
            this.salesRep.clear();
        }
        this.manageSalesRepLabel();
    }

    public void changeSalesRep() {
        if (!this.hasSecurity(11148L, 0)) {
            DlgMessage.showMessage(this, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
            return;
        }
        SalesRep sRep = null;
        Vector<SalesRep> vReps = new Vector<SalesRep>();
        String sIdxs = null;
        try {
            int nCount = 0;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.SREPIDX, MAX(H.TRAND) FROM RET_TRANH H, PERSON P WHERE H.\"ACTIVE\" = 1 AND P.\"ACTIVE\" = 1 AND H.SREPIDX = P.PERIDX AND P.RETAIL_REP = 1 GROUP BY H.SREPIDX ORDER BY 2 DESC ");){
                while (sql.next() && (long)nCount < this.sParams.nMaxSalesReps) {
                    sIdxs = sIdxs == null ? sql.getString(1) : sIdxs + "," + sql.getString(1);
                    ++nCount;
                }
            }
            if (nCount > 0) {
                sql = new SqlQuery(this.sParams.conn, "SELECT M.MEMIDX, P.PERIDX, P.FIRSTNAME, P.SURNAME,  M.MEMNAME FROM MEMBER M, PERSON P WHERE M.\"ACTIVE\" = 1 AND M.MEMIDX = P.MEMIDX AND P.PERIDX IN (" + sIdxs + ") ORDER BY P.FIRSTNAME, P.SURNAME");
                var6_7 = null;
                try {
                    while (sql.next()) {
                        sRep = new SalesRep();
                        sRep.setSalesRep(sql.getLong(1), sql.getLong(2), sql.getString(3), sql.getString(4), sql.getString(5));
                        vReps.add(sRep);
                    }
                }
                catch (Throwable throwable) {
                    var6_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var6_7 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var6_7.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            Object[] sReps = null;
            if (vReps.size() == 0) {
                vReps.add(this.salesRep);
            }
            sReps = vReps.toArray();
            sRep = (SalesRep)DlgSalesReps.showDialog(this, StoreParams.res.getString("Select_Sales_Rep"), StoreParams.res.getString("Change_Sales_Rep"), sReps, sReps[0]);
            if (sRep != null) {
                this.salesRep.setSalesRep(sRep);
                this.manageSalesRepLabel();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public String getAttachedPersonEmail() {
        Element emailElement;
        if (this.person.getAttribute("peridx") != null && (emailElement = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.EMAIL)) != null) {
            return StringUtils.nullToEmpty(emailElement.getValue());
        }
        return null;
    }

    public String getAttachedPersonFirstname() {
        if (this.person.getAttribute("peridx") != null) {
            return PersonUtils.getPerFirstname(this.person);
        }
        return null;
    }

    public String getAttachedPersonSurname() {
        if (this.person.getAttribute("peridx") != null) {
            return PersonUtils.getPerSurname(this.person);
        }
        return null;
    }

    private void assignReceiptDeliveryMethod() {
        this.assignReceiptDeliveryMethod("");
    }

    private void assignReceiptDeliveryMethod(String existingEmail) {
        PayUtils.ReceiptDeliveryMethod deliveryMethod = PayUtils.ReceiptDeliveryMethod.PRINT_ONLY;
        String originalEmail = "";
        String originalPhone = "";
        String email = "";
        String phone = "";
        String country = "";
        boolean isGuestAccount = false;
        if (this.person.getAttribute("guest_account") != null) {
            isGuestAccount = this.person.getAttribute("guest_account").getValue().equals("1");
        }
        if (this.person.getAttribute("peridx") != null) {
            Element emailElement = PersonUtils.getPhone(this.person, PersonUtils.PhoneType.EMAIL);
            if (emailElement != null) {
                originalEmail = StringUtils.nullToEmpty(emailElement.getValue());
            }
            originalPhone = PersonUtils.getPhoneNum(this.person, PersonUtils.PhoneType.MAIN);
            if (this.person.getChild("locn") != null && this.person.getChild("locn").getAttribute("country") != null) {
                country = this.person.getChild("locn").getAttribute("country").getValue();
            }
        }
        if (!existingEmail.equals("")) {
            originalEmail = existingEmail;
        }
        boolean valid = false;
        while (!valid) {
            deliveryMethod = PayUtils.getReceiptDeliveryMethod(this, originalEmail, originalPhone, country);
            if (deliveryMethod == null) continue;
            email = PayUtils.getEmail();
            phone = PayUtils.getSms();
            valid = true;
        }
        try (PreparedStatement prepStmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANH SET DELIVERY_METHOD = ?, DELIVERY_EMAIL = ?, DELIVERY_PHONE = ? WHERE VHIDX = ?");){
            prepStmt.setInt(1, PayUtils.ReceiptDeliveryMethodToInt(deliveryMethod));
            prepStmt.setString(2, email);
            prepStmt.setString(3, phone);
            prepStmt.setLong(4, this.vhidx);
            prepStmt.executeUpdate();
            if (this.person.getAttribute("peridx") != null && !email.isEmpty() && !originalEmail.equals(email) && this.hasSecurity(11160L, 2) && !isGuestAccount && PersonCrypt.getInstance().keyExists() && this.sParams.checkIConn() && DlgMessage.showMessage(this, SP.getRS("Save_Email_Message"), SP.getRS("Save_Email_Title"), 0, 3) == 0) {
                Element personCheck = null;
                personCheck = this.sParams.OnlineQueryProvider.getOnlineQuery("update_email", this.sParams.getStoreIdx() + "," + this.person.getAttribute("peridx").getValue() + "," + email).getXML();
                String result = XMLUtils.getValue(personCheck, "result");
                if (result.equals("1")) {
                    SqlQuery.executeUpdate(SP.sParams.conn, " UPDATE PERSON SET EMAIL = ? WHERE PERIDX = ? ", PersonCrypt.getInstance().encryptValue(email), this.person.getAttribute("peridx").getValue());
                    PersonCrypt.getInstance().generateBlindIndexes(SP.sParams.conn, "EMAIL", this.person.getAttribute("peridx").getLongValue(), email, PersonCrypt.EMAIL_TRANSFORMS);
                } else if (result.equals("-1")) {
                    DlgMessage.showMessage(this, SP.getRS("Duplicate_Email_Error"), SP.getRS("Duplicate_Email_Error_Title"), -1, 2);
                } else {
                    DlgMessage.showMessage(this, SP.getRS("Save_Email_Error"), SP.getRS("Save_Email_Error_Title"), -1, 2);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.deliveryMethod = deliveryMethod;
    }

    public void setCompletingOrder(boolean completingOrder) {
        this.completingOrder = completingOrder;
    }

    @Override
    public void setTaxLookupDisabledForTransaction(boolean taxLookupDisabledForTransaction) {
        super.setTaxLookupDisabledForTransaction(taxLookupDisabledForTransaction);
        ((PaSales)this.paBody).tblStyles.setCanEditTax(!this.sParams.bUsingTaxLookup || this.isTaxLookupDisabled());
        if (taxLookupDisabledForTransaction) {
            long clientidx = this.person.getAttribute("peridx") != null ? PosUtils.longVal(this.person.getAttribute("peridx").getValue()) : 0L;
            PosUtils.logUserAction("DISABLE_TAX_LOOKUP_FOR_CURRENT_TRANSACTION", this.transType, this.vhidx, this.getUser().getMemidx(), clientidx, null);
        }
    }

    @Override
    public void setTaxLookupDisabledForSession(boolean taxLookupDisabledForSession) {
        if (this.getTaxLookupDisabledForSession() != taxLookupDisabledForSession) {
            if (taxLookupDisabledForSession && !Security.hasSecurity(this, 11167L, this.getUser().getMemidx(), 0, true)) {
                return;
            }
            long clientidx = this.person.getAttribute("peridx") != null ? PosUtils.longVal(this.person.getAttribute("peridx").getValue()) : 0L;
            PosUtils.logUserAction(taxLookupDisabledForSession ? "DISABLE_TAX_LOOKUP_FOR_TILL" : "ENABLE_TAX_LOOKUP_FOR_TILL", this.transType, this.vhidx, this.getUser().getMemidx(), clientidx, null);
        }
        super.setTaxLookupDisabledForSession(taxLookupDisabledForSession);
        ((PaSales)this.paBody).tblStyles.setCanEditTax(!this.sParams.bUsingTaxLookup || this.isTaxLookupDisabled());
    }

    public void setCouponCode(String couponCode) {
        if (!StringUtils.isNullOrEmpty(couponCode)) {
            if (!this.couponManager.tryRedeemCoupon(couponCode, XMLUtils.getValue(this.person, "peridx"), this.getUser().getMemidx())) {
                DlgMessage.showMessage(this, this.couponManager.getLastError(), SP.getRS("Coupons_DlgApplyCoupon_Title"), 0);
            }
        } else {
            this.couponManager.cancel(this.getUser().getMemidx());
        }
        ((PaSalesFoot)this.paFoot).lCoupon.setText(this.getCouponCode());
        this.refreshTransaction();
    }

    public Coupon getCoupon() {
        return this.couponManager.getCoupon();
    }

    public String getCouponCode() {
        if (this.couponManager.getCoupon() != null) {
            return StringUtils.nullToEmpty(this.couponManager.getCoupon().getCode());
        }
        return "";
    }

    public void setThirdPartyCouponCode(String couponCode) {
        if (!StringUtils.isNullOrEmpty(couponCode)) {
            this.couponManager.setThirdPartyCouponCode(couponCode);
        }
    }

    public HashMap<String, String> generatePromoEngineExtraProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("manual_loyalty_amounts", this.attachedLoyaltyCards.getManualLoyaltyAmountsXml());
        if (this.couponManager.getCoupon() != null && this.couponManager.getCoupon().getPromoIdx() > 0L) {
            result.put("coupon_promo_id", String.valueOf(this.couponManager.getCoupon().getPromoIdx()));
        }
        return result;
    }

    public boolean isExchange() {
        return this.frameType == 1 && ((PaSales)this.paBody).tblStyles.isExchange();
    }

    private boolean prepareOwnerDocket(long ownerWidx) {
        if (ownerWidx > 0L && ownerWidx != SP.sParams.getStoreIdx() && StringUtils.isNullOrEmpty(this.ownerDocketNumber)) {
            try {
                this.ownerDocketNumber = OmniChannel.getDocketNumber(SP.sParams.conn, ownerWidx);
            }
            catch (TranslatedException e) {
                DlgMessage.showMessage(this, e.getMessage(), SP.getRS("Error"), 0);
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean prepareOwnerSaleDocket() {
        if (((PaSales)this.paBody).tblStyles.getPickUpQty() > 0.0) {
            return this.prepareOwnerDocket(this.getOwnerWidx());
        }
        return true;
    }

    public boolean prepareOwnerReturnDocket() {
        return this.prepareOwnerDocket(this.getReturnWidx());
    }

    public String encodeDocketNumber() {
        long returnWidx;
        if (this.transType == 239 && this.isReturningSale() && !StringUtils.isNullOrEmpty(this.ownerDocketNumber) && (returnWidx = this.getReturnWidx()) != this.sParams.getStoreIdx()) {
            return OmniChannel.encodeDocketNumber(returnWidx, this.ownerDocketNumber);
        }
        if (!StringUtils.isNullOrEmpty(this.docknum)) {
            return "D" + this.sParams.getStore().getStoreNo() + this.docknum;
        }
        return "";
    }

    public String generateExternalReference() {
        if (this.externalReference != null) {
            return this.externalReference;
        }
        if (this.vhidx == -1L) {
            throw new IllegalStateException("VHIDX not set");
        }
        this.externalReference = this.sParams.getStore().getStoreNo() + "-" + this.extRefDateFormat.format(new Date()) + "-" + String.valueOf(this.vhidx);
        return this.externalReference;
    }

    public void reassignDespatchLocation() {
        if (this.isLoggedIn(true)) {
            PaSales panel = (PaSales)this.paBody;
            if (this.isCustOrderOnHold()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Cannot_Reassign_On_Hold_Order"), StoreParams.res.getString("Error"), 1);
                return;
            }
            if (this.transType != 715) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Cant_reassign_new_orders"), StoreParams.res.getString("Error"), 0);
                return;
            }
            if (this.isRefundFloorToDoorOrder() && this.getFromWidx() != this.sParams.getStoreIdx()) {
                DlgMessage.showMessage(this, StoreParams.res.getString("refund_floor_to_door_change"), StoreParams.res.getString("Stop"), 2);
                return;
            }
            if (!panel.checkChangeOrder(this.transType)) {
                return;
            }
            Security.OverrideUser overrideUser = new Security.OverrideUser();
            if (this.despatchInfo.getDespatchType() != DespatchInfo.DespatchType.STORE_DESPATCH) {
                if (!Security.hasSecurity(this, 11177L, this.getUser().getMemidx(), 2, true, overrideUser)) {
                    DlgMessage.showMessage(this, SP.getRS("Insufficient_security_reassign_customer_pickup_order"), SP.getRS("Insufficient_security"), -1, 0);
                    return;
                }
                if (((PaSales)this.paBody).tblStyles.isFullyPacked()) {
                    DlgMessage.showMessage(this, SP.getRS("Cannot_reassign_fully_packed_pickup_order"), SP.getRS("Stop"), -1, 1);
                    return;
                }
                if (((PaSales)this.paBody).tblStyles.getCustOrdPackedQty() > 0) {
                    if (overrideUser.getUser() != null) {
                        if (!Security.hasSecurity(this, 11178L, overrideUser.getUser().getMemidx(), 2, false)) {
                            DlgMessage.showMessage(this, SP.getRS("Insufficient_security_reassign_partially_packed_pickup_order"), SP.getRS("Insufficient_security"), -1, 0);
                            return;
                        }
                    } else if (!Security.hasSecurity(this, 11178L, this.getUser().getMemidx(), 2, true, overrideUser)) {
                        DlgMessage.showMessage(this, SP.getRS("Insufficient_security_reassign_partially_packed_pickup_order"), SP.getRS("Insufficient_security"), -1, 0);
                        return;
                    }
                }
            }
            if (this.vhidx == -1L) {
                DlgMessage.showMessage(this, StoreParams.res.getString("No_order_loaded_details"), StoreParams.res.getString("No_order_loaded"), 0);
                return;
            }
            if (this.custOrderComplete) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Order_completed_details"), StoreParams.res.getString("Order_completed"), 0);
                return;
            }
            if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ORDER_REASSIGNMENT_REASON_REQUIRED)) {
                DlgReassignOrderReasons dlgReassignOrderReasons = new DlgReassignOrderReasons(this, ((PaSales)this.paBody).tblStyles.getStyleLines(), StoreParams.res.getString("Confirm_Reassign_Order"), true, this.vhidx, this.getUser());
                dlgReassignOrderReasons.setVisible(true);
            } else {
                long memidx = overrideUser.getUser() == null ? this.getUser().getMemidx() : overrideUser.getUser().getMemidx();
                DlgRejectOrderConfirmation reassignDlg = new DlgRejectOrderConfirmation(this, StoreParams.res.getString("Confirm_Reassign_Order_Title"), true, this.vhidx, memidx, this.despatchInfo.getDespatchType() != DespatchInfo.DespatchType.STORE_DESPATCH);
                reassignDlg.setVisible(true);
            }
        }
    }

    public void removeTax() {
        if (this.isLoggedIn(true)) {
            Security.OverrideUser overrideUser = new Security.OverrideUser();
            if (!Security.hasSecurity(this, 11175L, this.getUser().getMemidx(), 2, true, overrideUser)) {
                return;
            }
            if (this.frameType == 12 && this.transRoot != null) {
                DlgMessage.showMessage(this, SP.getRS("Remove_tax_on_existing_order"), SP.getRS("Error"), 0);
                return;
            }
            if (this.person.getAttribute("peridx") == null) {
                this.attachPerson("", false);
            }
            if (this.person.getAttribute("peridx") != null) {
                ((PaSales)this.paBody).tblStyles.removeTax();
            }
        }
    }

    public boolean reassignItemsForRefund() {
        if (this.from_widx == this.sParams.getStoreIdx()) {
            return true;
        }
        StringBuilder queryParas = new StringBuilder();
        queryParas.append(this.vhidx < 0L ? "" : String.valueOf(this.vhidx));
        queryParas.append("@");
        queryParas.append(this.transRoot.getAttribute("sordidx") != null ? this.transRoot.getAttribute("sordidx").getValue() : "");
        queryParas.append("@");
        queryParas.append(this.getUser().getMemidx());
        queryParas.append("@");
        StringBuilder qtys = new StringBuilder();
        StyleTable tbl = ((PaSales)this.paBody).tblStyles;
        boolean firstRow = true;
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            StyleLine line;
            if (!(tbl.model.getItemAt(i) instanceof StyleLine) || !((line = (StyleLine)tbl.model.getItemAt(i)).getQty(3) < 0.0)) continue;
            if (firstRow) {
                firstRow = false;
            } else {
                queryParas.append(",");
                qtys.append(",");
            }
            if (line.getPosVshidx() != -1L) {
                queryParas.append(line.getPosVshidx());
            } else if (line.getSozdidx() != -1L) {
                queryParas.append(line.getSozdidx());
            }
            qtys.append(line.getQty(3) * -1.0);
        }
        if (qtys.length() <= 0) {
            return false;
        }
        queryParas.append("@");
        queryParas.append(qtys.toString());
        queryParas.append("@");
        queryParas.append(this.transRoot.getAttributeValue("last_updated"));
        this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("reassign_items_for_refund", queryParas.toString()).getXML();
        if (this.sParams.root != null && this.sParams.root.getName() == "tran") {
            String newDocket = this.sParams.root.getAttribute("docket_number").getValue();
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("trans", this.sParams.getStore().getStoreNo() + newDocket).getXML();
            if (this.sParams.root != null) {
                Element newTran = new Element("transaction");
                this.copyElementChildren(this.sParams.root, newTran);
                this.voidTrans(false);
                this.populate(newTran);
                for (int i = 0; i < tbl.getRowCount(); ++i) {
                    if (!(tbl.model.getItemAt(i) instanceof StyleLine)) continue;
                    StyleLine line = (StyleLine)tbl.model.getItemAt(i);
                    line.setQty(0.0);
                }
                return true;
            }
        }
        return false;
    }

    private void copyElementChildren(Element from, Element to) {
        List contents = from.getChildren();
        while (contents.size() > 0) {
            to.addContent((Content)((Element)((Element)contents.get(0)).detach()));
        }
        List attributes = from.getAttributes();
        while (attributes.size() > 0) {
            to.setAttribute(((Attribute)attributes.get(0)).detach());
        }
    }

    public boolean issueNewGV(String modifiedSKUValueList) {
        boolean issuedGv;
        block66: {
            issuedGv = false;
            try {
                if (this.transType == 239) {
                    try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT COALESCE(PARLNKIDX,0) FROM SYSPARAM WHERE PARIDX = 758");){
                        if (sql.next()) {
                            this.bPrintPromoVoucher = sql.getBoolean(1);
                        }
                    }
                    if (!this.bPrintPromoVoucher) break block66;
                    String peridx = "";
                    if (this.person.getAttribute("peridx") != null) {
                        peridx = this.person.getAttribute("peridx").getValue();
                    }
                    String skuprice = "";
                    if (!modifiedSKUValueList.equals("")) {
                        skuprice = modifiedSKUValueList;
                    } else {
                        String sqlQuery = "select skuidx skuidx, sum(net) net from ( select d.skuidx, sum(d.net) net \r\nfrom ret_trand d \r\nwhere d.vhidx = " + this.vhidx + " and d.active = 1 and d.line_type = 0\r\ngroup by d.skuidx\r\nunion\r\nselect k.skuidx, sum(d.net) net\r\nfrom ret_trand d, ret_trand k\r\nwhere d.vhidx =  " + this.vhidx + "  and k.vhidx =  " + this.vhidx + "  and d.line_type in(0,2,3,6,7) \r\nand d.active = 1 and k.active = 1 and k.vshidx = d.from_vshidx\r\ngroup by k.skuidx)\r\ngroup by skuidx";
                        try (SqlQuery sql = new SqlQuery(this.sParams.conn, sqlQuery);){
                            while (sql.next()) {
                                skuprice = skuprice + sql.getString(1) + "@" + sql.getString(2) + "@";
                            }
                        }
                    }
                    if (StringUtils.isNullOrEmpty(skuprice)) break block66;
                    skuprice = skuprice.substring(0, skuprice.length() - 1);
                    Element root = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_promo_voucher", SP.sParams.getStoreIdx() + "," + peridx + "," + this.vhidx + "," + skuprice).getXML();
                    if (root == null || root.getAttribute("number") == null) break block66;
                    String sHOGvcnIdx = root.getAttribute("gvcnidx").getValue();
                    String sVoucherNumber = root.getAttribute("number").getValue();
                    String sPromoHeading = root.getAttribute("promoheading").getValue();
                    double sValue = 0.0;
                    String sVoucherPin = root.getAttribute("pin").getValue();
                    String sExpiryDate = "";
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    PosDateFormatter dateFormatter = new PosDateFormatter(null);
                    try {
                        sValue = root.getAttribute("value").getDoubleValue();
                        Date date = df.parse(root.getAttribute("expirydate").getValue());
                        Timestamp sq = new Timestamp(date.getTime());
                        dateFormatter.setFormat(3, 3, 0);
                        dateFormatter.setTimestamp(sq);
                        sExpiryDate = dateFormatter.toString();
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    String sql1 = "INSERT INTO online_q_promo_voucher_res (vhidx, VoucherNumber, VoucherHeading, moneyValue, VoucherPin, ExpiryDate, usedamount) VALUES (?, ?, ?, ?, ?, ?, ?)";
                    try (PreparedStatement pstmt = this.sParams.conn.prepareStatement(sql1);){
                        pstmt.setLong(1, this.vhidx);
                        pstmt.setString(2, sVoucherNumber);
                        pstmt.setString(3, sPromoHeading);
                        pstmt.setDouble(4, sValue);
                        pstmt.setString(5, sVoucherPin);
                        pstmt.setString(6, root.getAttribute("expirydate").getValue());
                        pstmt.setInt(7, 0);
                        pstmt.executeUpdate();
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    String sql2 = "INSERT INTO GVCN_MAINT(GVCNIDX, HO_GVCNIDX, num, type, amt, used_amt, Expiry_date, orig_expiry_date, ISSUE_VHIDX, issued_widx, issued_date, posted, PIN, ACTIVE) VALUES (?, ?, ?, 0, ?, 0, ?, ?, ?, ?, CURRENT_TIMESTAMP, 0, ?, 1)";
                    try (PreparedStatement pstmt = this.sParams.conn.prepareStatement(sql2);){
                        pstmt.setLong(1, this.sParams.nextVal("XGVCN_MAINT"));
                        pstmt.setString(2, sHOGvcnIdx);
                        pstmt.setString(3, sVoucherNumber);
                        pstmt.setDouble(4, sValue);
                        pstmt.setString(5, root.getAttribute("expirydate").getValue());
                        pstmt.setString(6, root.getAttribute("expirydate").getValue());
                        pstmt.setLong(7, this.vhidx);
                        pstmt.setLong(8, this.sParams.getStoreIdx());
                        pstmt.setString(9, sVoucherPin);
                        pstmt.executeUpdate();
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                    }
                    issuedGv = true;
                    break block66;
                }
                issuedGv = true;
            }
            catch (Exception e) {
                try {
                    if (!this.sParams.conn.getAutoCommit()) {
                        PosUtils.releaseTrans(this.sParams.conn);
                    }
                }
                catch (SQLException e1) {
                    PosUtils.logError(e1);
                }
                PosUtils.logError(e);
                return false;
            }
        }
        return issuedGv;
    }
}

