/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import jpos.DlgDummyPrinter;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PaStkTake;
import jpos.PaTransferFoot;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.basscom.utils.Utils;

public class FrStkTake
extends PosFrame {
    private boolean completing = false;
    private long peridx;
    private long memidx;
    protected boolean oldTrans = false;

    public FrStkTake(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 5, 11120L, psParams, StoreParams.res.getString("Stock_Take"));
        this.paBody = new PaStkTake(this);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaTransferFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaStkTake)this.paBody).tfBarcode.requestFocus();
            ((PaTransferFoot)this.paFoot).bComplete.setEnabled(true);
        }
    }

    @Override
    protected void setTransType() {
        this.transType = 247;
    }

    @Override
    public boolean validateTrans() {
        this.revalidateBarcodes();
        if (!this.checkLocks()) {
            return false;
        }
        if (!((PaStkTake)this.paBody).validateTrans()) {
            return false;
        }
        Object[] objs = new Object[]{"\n"};
        return DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Are_you_sure_you_want"), objs), StoreParams.res.getString("Complete_Stock_Take"), 0, 3) == 0;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            this.save();
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1, DOCKET_NUMBER = " + PosUtils.StringToSqlString(this.docknum) + ", TRAND = current_timestamp WHERE VHIDX = " + this.vhidx);
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.vhidx);
            ((PaStkTake)this.paBody).clear();
            this.vhidx = -1L;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    public void getCurrentVhidx() {
        try {
            int activeFlag = this.getUser().isTraningUser() ? -1 : 1;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.VHIDX FROM RET_TRANH H WHERE H.\"ACTIVE\" = " + activeFlag + " AND H.COMPLETE = 0 AND H.TR_TYPE = 247");){
                if (sql.next()) {
                    this.vhidx = sql.getLong(1);
                    ((PaStkTake)this.paBody).populate(this.vhidx);
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public long startStkTake() {
        try {
            int activeFlag = this.getUser().isTraningUser() ? -1 : 1;
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRAND,  SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, COMPLETE, TILL_NUMBER, SALE_DATE ) VALUES( " + this.vhidx + ", " + this.transType + ", " + activeFlag + ", " + this.sParams.getStoreIdx() + ", current_timestamp,  " + this.peridx + "," + this.memidx + "," + this.peridx + "," + this.memidx + ", 0, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", TRUNC_DATE(current_timestamp))");
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return -1L;
        }
        return this.vhidx;
    }

    @Override
    public void voidTrans(boolean logout) {
        if (((PaTransferFoot)this.paFoot).bVoid.isEnabled() && (!logout || this.isLoggedIn(!logout))) {
            if (!this.oldTrans) {
                if (!this.checkLocks()) {
                    return;
                }
                if (((PaStkTake)this.paBody).tblLocns.model.data.size() > 0) {
                    Object[] objs = new Object[]{"\n", "\n"};
                    if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("void_stktake"), objs), StoreParams.res.getString("Void_Transaction"), 0, 2) != 0) {
                        return;
                    }
                }
                if (this.vhidx != -1L) {
                    try (Statement stmt = this.sParams.conn.createStatement();){
                        stmt.executeUpdate("UPDATE RET_TRANH SET \"ACTIVE\" = 0 WHERE VHIDX = " + this.vhidx);
                        this.vhidx = -1L;
                    }
                    catch (SQLException e) {
                        PosUtils.logError(e);
                        return;
                    }
                }
            }
            this.oldTrans = false;
            super.voidTrans(logout);
            ((PaStkTake)this.paBody).clear();
            ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
            if (this.isLoggedIn(false)) {
                this.getCurrentVhidx();
                boolean[] formSec = this.getSecurity(this.secidx);
                this.setEditable(formSec[2]);
                ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
                ((PaTransferFoot)this.paFoot).bVoid.setEnabled(formSec[2]);
            }
        }
    }

    @Override
    public void delLines() {
        if (((PaTransferFoot)this.paFoot).bDelete.isEnabled()) {
            ((PaStkTake)this.paBody).delStylelines();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 115 && !e.isAltDown()) {
            ((PaStkTake)this.paBody).bOwnTill.doClick();
        } else if (e.getKeyCode() == 116) {
            ((PaStkTake)this.paBody).bInsert.doClick();
        } else if (e.getKeyCode() == 73 && e.isAltDown()) {
            ((PaStkTake)this.paBody).bImport.doClick();
        } else if (e.getKeyCode() == 117) {
            ((PaStkTake)this.paBody).bDelete.doClick();
            this.setFocus();
        } else if (e.getKeyCode() == 118) {
            ((PaStkTake)this.paBody).bAllTills.doClick();
        } else if (e.getKeyCode() == 119) {
            ((PaTransferFoot)this.paFoot).bSave.doClick();
            this.setFocus();
        } else if (e.getKeyCode() == 80 && e.isAltDown()) {
            if (this.vhidx == -1L && ((PaStkTake)this.paBody).tblLocns.getSelectedRow() > -1) {
                this.setCursor(StoreParams.waitCursor);
                this.printReceipt(true);
                this.setCursor(StoreParams.normalCursor);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusText(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaTransferFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaTransferFoot)this.paFoot).statusBar.reset();
    }

    public boolean save() {
        ((PaStkTake)this.paBody).stopEditing();
        if (((PaTransferFoot)this.paFoot).bSave.isEnabled()) {
            Cursor curs = this.getCursor();
            this.setCursor(StoreParams.waitCursor);
            try {
                if (this.vhidx == -1L) {
                    this.getCurrentVhidx();
                    if (this.vhidx == -1L) {
                        this.startStkTake();
                    }
                }
                ((PaStkTake)this.paBody).db_save(this.vhidx);
            }
            catch (Exception e) {
                PosUtils.logError(e);
                return false;
            }
            ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
            this.setCursor(curs);
            this.revalidateBarcodes();
            return true;
        }
        return true;
    }

    @Override
    public boolean populate(String docket) {
        try {
            if (docket.length() < 4) {
                DlgMessage.showMessage(this, StoreParams.res.getString("wrong_length_doc"), StoreParams.res.getString("Error_loading"), 0);
                return false;
            }
            super.voidTrans(false);
            ((PaStkTake)this.paBody).clear();
            ((PaStkTake)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            ((PaStkTake)this.paBody).lFeedBack.setText(StoreParams.res.getString("Docket_") + " D" + docket);
            ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
            ((PaTransferFoot)this.paFoot).bVoid.setEnabled(true);
            this.oldTrans = true;
            String storenum = docket.substring(0, 3);
            String docknum = docket.substring(3);
            boolean ok = false;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.VHIDX FROM RET_TRANH H, WHSE W WHERE W.WIDX = H.WIDX AND DOCKET_NUMBER = " + PosUtils.StringToSqlString(docknum) + " AND W.STORENO = " + PosUtils.StringToSqlString(storenum) + " AND H.TR_TYPE = 247");){
                if (sql.next()) {
                    this.vhidx = sql.getLong(1);
                    ok = true;
                }
            }
            if (ok) {
                ((PaStkTake)this.paBody).populate(this.vhidx);
                this.addNotes(this.noteTypes, Note.getNotes(this.vhidx, "RET_TRANH", this.sParams.conn));
                this.setEditable(false);
            } else {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
            }
            return ok;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    @Override
    public boolean isVoid() {
        return ((PaStkTake)this.paBody).tblLocns.getRowCount() == 0 && ((PaStkTake)this.paBody).tblStyles.getRowCount() == 0;
    }

    @Override
    protected void setEditable(boolean editable) {
        ((PaTransferFoot)this.paFoot).bComplete.setEnabled(editable);
        ((PaTransferFoot)this.paFoot).bDelete.setEnabled(editable);
        ((PaTransferFoot)this.paFoot).bSave.setEnabled(editable);
        ((PaStkTake)this.paBody).bInsert.setEnabled(editable);
        ((PaStkTake)this.paBody).bDelete.setEnabled(editable);
        ((PaStkTake)this.paBody).tblStyles.setEditable(editable);
        ((PaStkTake)this.paBody).tblLocns.setEditable(editable);
    }

    @Override
    public void printReceipt(boolean reprint) {
        if (reprint && ((PaStkTake)this.paBody).tblLocns.getSelectedRow() > -1) {
            this.save();
            Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Report"), false, this.sParams.getDocketConnection(), this.vhidx, false);
            ((PaStkTake)this.paBody).printLocnReport(receipt);
        } else if (reprint) {
            DlgMessage.showMessage(this, StoreParams.res.getString("Select_Locn"), StoreParams.res.getString("Location"), 1);
        }
    }

    @Override
    protected void setTransnum() {
        this.transnum = null;
    }

    @Override
    protected void updateSec(boolean[] formSec) {
        if (this.isLoggedIn(false)) {
            this.peridx = this.getUser().getPeridx();
            this.memidx = this.getUser().getMemidx();
        }
        this.save();
        ((PaStkTake)this.paBody).clear();
        this.vhidx = -1L;
        if (this.isLoggedIn(false)) {
            this.oldTrans = false;
            ((PaStkTake)this.paBody).bOwnTill.setSelected(true);
            ((PaStkTake)this.paBody).bAllTills.setSelected(false);
            this.getCurrentVhidx();
            this.setEditable(formSec[2]);
            ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
            ((PaTransferFoot)this.paFoot).bVoid.setEnabled(formSec[2]);
        } else {
            this.setEditable(true);
            ((PaTransferFoot)this.paFoot).bSave.setEnabled(false);
            ((PaTransferFoot)this.paFoot).bVoid.setEnabled(true);
        }
    }

    @Override
    public boolean completeTrans() {
        if (!this.oldTrans && this.isLoggedIn(true)) {
            if (this.completing) {
                return false;
            }
            this.completing = true;
            try {
                if (this.getUser().isTraningUser()) {
                    if (this.validateTrans()) {
                        new DlgDummyPrinter(this, StoreParams.res.getString("Printing_Receipt"), false);
                        ((PaStkTake)this.paBody).clear();
                        this.voidTrans(true);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = super.completeTrans();
                return bl;
            }
            finally {
                this.completing = false;
            }
        }
        return false;
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaStkTake)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    protected boolean checkStkTake() {
        try {
            Object[] objs;
            int voided = -1;
            int completed = -1;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT \"ACTIVE\", COMPLETE FROM RET_TRANH WHERE VHIDX = " + this.vhidx);){
                if (sql.next()) {
                    voided = sql.getInt(1);
                    completed = sql.getInt(2);
                }
            }
            if (voided == 0) {
                objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("voided_stktake"), objs), StoreParams.res.getString("Stop"), 0);
                this.paHead.logoff(true);
                return false;
            }
            if (completed > 0 && !this.oldTrans) {
                objs = new Object[]{"\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("completed_stktake"), objs), StoreParams.res.getString("Stop"), 0);
                this.paHead.logoff(true);
                return false;
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        return true;
    }

    private boolean checkLocks() {
        try {
            String locks = "";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT COALESCE(LOCATION, 'NOT SPECIFIED'), NOTES3 FROM RET_STTH WHERE COALESCE(NOTES3, " + PosUtils.StringToSqlString(this.sParams.tillnum) + ") != " + PosUtils.StringToSqlString(this.sParams.tillnum) + " AND \"ACTIVE\" != 0 AND VHIDX = " + this.vhidx);){
                while (sql.next()) {
                    locks = locks + sql.getString(1) + " - " + sql.getString(2);
                }
            }
            if (!locks.equals("")) {
                Object[] objs = new Object[]{"\n", locks, "\n"};
                DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("locked_locns"), objs), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
        return true;
    }

    protected void removeLocks() {
        try (Statement stmt = this.sParams.conn.createStatement();){
            stmt.executeUpdate("UPDATE RET_STTH SET NOTES3 = NULL WHERE NOTES3 = " + PosUtils.StringToSqlString(this.sParams.tillnum));
        }
        catch (SQLException ex) {
            PosUtils.logError(ex);
        }
    }

    @Override
    public void dispose() {
        this.removeLocks();
        super.dispose();
    }

    @Override
    public boolean checkExit() {
        if (((PaTransferFoot)this.paFoot).bSave.isEnabled()) {
            return super.checkExit();
        }
        return true;
    }

    @Override
    public void refreshImage() {
        ((PaStkTake)this.paBody).tblStyles.RefreshImage();
    }

    public void revalidateBarcodes() {
        if (this.vhidx > -1L) {
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_STTD D SET D.SKUIDX = (SELECT K.SKUIDX FROM BARCODE B, SKU K WHERE K.SKUIDX = B.SKUIDX AND B.CODE = D.LINE_CODE AND K.\"ACTIVE\" = 1) WHERE D.LINE_CODE IS NOT NULL AND D.SKUIDX IS NULL AND D.VHIDX = " + this.vhidx);
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public void revalidateBarcodesSaveAndRefresh() {
        if (this.vhidx > -1L && this.save()) {
            this.revalidateBarcodes();
            ((PaStkTake)this.paBody).clear();
            ((PaStkTake)this.paBody).populate(this.vhidx);
        }
    }

    @Override
    public void processLogin() {
    }
}

