/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.List;
import jpos.DlgMessage;
import jpos.Note;
import jpos.PaPCFoot;
import jpos.PaWithDrawal;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.Tender;
import jpos.basscom.utils.Utils;
import jpos.tillbalance.TillBalanceUtils;
import org.jdom.Element;

public class FrWithDrawal
extends PosFrame {
    private boolean bCompleting = false;

    public FrWithDrawal(PosMenuController pmenu, StoreParams psParams) {
        super(pmenu, null, 7, 1043L, psParams, StoreParams.res.getString("Expenses_Withdrawal"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() {
        this.paBody = new PaWithDrawal(this.sParams);
        this.contentPane.add((Component)this.paBody, "Center");
        this.paFoot = new PaPCFoot(this);
        this.contentPane.add((Component)this.paFoot, "South");
        this.voidTrans(false);
    }

    @Override
    public void setFocus() {
        if (this.isLoggedIn(false)) {
            ((PaWithDrawal)this.paBody).tfAmt.requestFocus();
        }
    }

    @Override
    protected void setTransType() {
        this.transType = 546;
    }

    @Override
    public boolean validateTrans() {
        if (!TillBalanceUtils.canTrade()) {
            DlgMessage.showMessage(this, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        double amountRnd = ((PaWithDrawal)this.paBody).payType.roundAmt(((PaWithDrawal)this.paBody).tfAmt.getDouble());
        if (amountRnd != ((PaWithDrawal)this.paBody).tfAmt.getDouble()) {
            ((PaWithDrawal)this.paBody).tfAmt.setText(amountRnd);
        }
        if (((PaWithDrawal)this.paBody).tfAmt.getDouble() <= 0.0) {
            DlgMessage.showMessage(this, StoreParams.res.getString("enter_amt"), StoreParams.res.getString("Stop"), 0);
            this.setFocus();
            return false;
        }
        if (((PaWithDrawal)this.paBody).tfAmt.getDouble() > 9.99999999E8) {
            DlgMessage.showMessage(this, StoreParams.res.getString("value_too_large"), StoreParams.res.getString("Stop"), 0);
            this.setFocus();
            return false;
        }
        return true;
    }

    @Override
    public boolean completeTrans(boolean pcomplete) {
        try {
            PosUtils.startTrans(this.sParams.conn);
            this.vhidx = this.sParams.nextVal("XRET_TRANH");
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate(" INSERT INTO RET_TRANH(VHIDX, TR_TYPE, \"ACTIVE\", WIDX, TRAND,  TILL_NUMBER, STAFF_SALE_FLAG, NOTES1, SREPIDX, MEMBER_GENERATEDIDX, TRANSSREPIDX, TRANSMEMIDX, DOCKET_NUMBER, COMPLETE, SALE_DATE) VALUES( " + this.vhidx + ", " + this.transType + ", 1, " + this.sParams.getStoreIdx() + ", CURRENT_TIMESTAMP,  " + PosUtils.StringToSqlString(this.sParams.tillnum) + ", 0, " + PosUtils.StringToSqlString(((PaWithDrawal)this.paBody).tpNotes.getText()) + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + this.getUser().getPeridx() + ", " + this.getUser().getMemidx() + ", " + (this.docknum == null ? "null" : PosUtils.StringToSqlString(this.docknum)) + ", 0, TRUNC_DATE(current_timestamp))");
            }
            Utils.CopyLikeReferences(this.sParams.conn, 18L, "WHSE", "WIDX", this.sParams.getStoreIdx(), 23L, "RET_TRANH", "VHIDX", this.vhidx);
            Tender withDrawalOffs = new Tender(548L, PosUtils.doubleValFormatted(((PaWithDrawal)this.paBody).tfAmt.getText()), this.sParams);
            withDrawalOffs.db_insert_tender();
            Tender withDrawal = new Tender(SP.getCashPayType(), PosUtils.doubleValFormatted(((PaWithDrawal)this.paBody).tfAmt.getText()) * -1.0, this.sParams);
            withDrawal.db_insert_tender();
            try (Statement stmt = this.sParams.conn.createStatement();){
                stmt.executeUpdate("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = " + this.sParams.currVal("XRET_TRANH") + ";");
            }
            this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + this.sParams.currVal("XRET_TRANH"));
            PosUtils.endTrans(this.sParams.conn);
            return true;
        }
        catch (Exception e) {
            PosUtils.releaseTrans(this.sParams.conn);
            PosUtils.logError(e);
            return false;
        }
    }

    @Override
    public void delLines() {
    }

    @Override
    public void voidTrans(boolean logout) {
        if (!logout || this.isLoggedIn(!logout)) {
            ((PaWithDrawal)this.paBody).tpNotes.setText("");
            ((PaWithDrawal)this.paBody).tfAmt.setText("");
            ((PaWithDrawal)this.paBody).lFeedBack.setText("");
            ((PaWithDrawal)this.paBody).lFeedBack.setForeground(this.getDefaultColor());
            super.voidTrans(logout);
        }
    }

    @Override
    public void setStatusText(String msg) {
        ((PaPCFoot)this.paFoot).statusBar.setText(msg);
    }

    @Override
    public void setStatusMsg(String msg) {
        ((PaPCFoot)this.paFoot).statusBar.setMessage(msg);
    }

    @Override
    public void resetStatus() {
        ((PaPCFoot)this.paFoot).statusBar.reset();
    }

    @Override
    public boolean isVoid() {
        return ((PaWithDrawal)this.paBody).tfAmt.getDouble() == 0.0 && ((PaWithDrawal)this.paBody).tpNotes.getText().equals("");
    }

    @Override
    protected void setEditable(boolean peditable) {
        super.setEditable(peditable);
        ((PaWithDrawal)this.paBody).tpNotes.setEditable(this.editable);
        ((PaWithDrawal)this.paBody).tfAmt.setEditable(this.editable);
        ((PaPCFoot)this.paFoot).bComplete.setEnabled(this.editable);
    }

    @Override
    public boolean populate(Element trans) {
        try {
            if (super.populate(trans)) {
                String storeno = trans.getAttribute("widx") != null ? this.sParams.getStore(trans.getAttribute("widx").getLongValue()).getStoreNo() : "000";
                ((PaWithDrawal)this.paBody).lFeedBack.setText(StoreParams.res.getString("Docket_") + " D" + storeno + this.docknum);
                if (trans.getAttribute("notes1") != null) {
                    ((PaWithDrawal)this.paBody).tpNotes.setText(trans.getAttribute("notes1").getValue());
                }
                List payments = trans.getChild("payments").getChildren("tender");
                for (int i = 0; i < payments.size(); ++i) {
                    if (((Element)payments.get(i)).getAttribute("payment_typeidx").getLongValue() != 548L) continue;
                    ((PaWithDrawal)this.paBody).tfAmt.setText(((Element)payments.get(i)).getText());
                }
                this.setEditable(false);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.voidTrans(false);
            return false;
        }
        return true;
    }

    @Override
    public void printReceipt(boolean reprint) {
        Receipt receipt = new Receipt(this, StoreParams.res.getString("Printing_Receipt"), false, this.sParams.getDocketConnection(), this.vhidx, reprint);
        if (receipt.isValidReceipt()) {
            receipt.PrintWithDrawal();
        } else {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("Unable_retrieve"), objs), StoreParams.res.getString("Error"), 0);
        }
        receipt.close();
    }

    @Override
    protected void setTransnum() {
        this.transnum = null;
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        return true;
    }

    @Override
    protected void updateSec(boolean[] formSec) {
    }

    @Override
    public void notesSet() {
        for (int i = 0; i < this.notes.size(); ++i) {
            Note note = (Note)this.notes.elementAt(i);
            if (note.noteType.getTblidx() != 23L) continue;
            ((PaWithDrawal)this.paBody).lFeedBack.setForeground(this.notesColor);
        }
    }

    @Override
    public boolean checkExit() {
        return true;
    }

    @Override
    public void refreshImage() {
    }

    @Override
    public void processLogin() {
    }

    @Override
    public boolean completeTrans() {
        boolean bResult = false;
        if (!this.bCompleting) {
            this.bCompleting = true;
            bResult = super.completeTrans();
            if (bResult) {
                this.voidTrans(false);
            }
            this.bCompleting = false;
        }
        return bResult;
    }
}

