/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import jpos.StringUtils;

public class Link {
    private URI uri;
    private String displayText;
    private boolean visited = false;

    public Link() {
    }

    public Link(String text) {
        this.setDisplayText(text);
    }

    public Link(String text, String uri) {
        this.setDisplayText(text);
        this.setURI(uri);
    }

    public void setDisplayText(String text) {
        this.displayText = text;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.visited = false;
    }

    public URI setURI(String uri) {
        URI link = null;
        try {
            if (!StringUtils.isNullOrEmpty(uri)) {
                link = URI.create(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setURI(link);
        return link;
    }

    public String getDisplayText() {
        return StringUtils.nullToEmpty(this.displayText);
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isValid() {
        return this.uri != null;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public boolean open() {
        if (Link.open(this.uri)) {
            this.visited = true;
            return true;
        }
        return false;
    }

    public void clear() {
        this.uri = null;
        this.displayText = "";
        this.visited = false;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public static boolean open(URI uri) {
        if (uri != null && Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

