/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DlgClock;
import jpos.DlgMessage;
import jpos.DlgSignIn;
import jpos.FadeLabel;
import jpos.FadeListener;
import jpos.FrSales;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.Settings;
import jpos.SignInSettings;
import jpos.StoreParams;
import jpos.User;
import jpos.crypt.PersonCrypt;
import jpos.custorder.OrdersToPackPanel;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelHeading;
import jpos.ui.LabelStrong;
import jpos.ui.LabelSubHeading;
import jpos.ui.NotificationLabel;

public class PaHead
extends JPanel
implements AutoCloseable {
    public OrdersToPackPanel panelOutstandingOrders;
    public DialogButton signInButton = new DialogButton("");
    private LabelStrong lLogedInUser = new LabelStrong();
    private LabelHeading lTitle = new LabelHeading();
    private LabelSubHeading lStoreInfo = new LabelSubHeading();
    private JLabel lLogo = new JLabel();
    private JLabel lBorder = new JLabel();
    private FadeLabel lStatusOnline = new FadeLabel(2000);
    private FadeLabel lStatusOffline = new FadeLabel(2000);
    private NotificationLabel lNotification = new NotificationLabel(400, 40);
    private JLayeredPane layeredPane = new JLayeredPane();
    private LabelSubHeading lTrain = new LabelSubHeading();
    private boolean bOnlineIconSet = false;
    private boolean bOfflineIconSet = false;
    PosFrame frParent;
    StoreParams sParams;

    public PaHead(PosFrame pfrParent, String title) {
        try {
            this.frParent = pfrParent;
            this.sParams = this.frParent.sParams;
            this.jbInit();
            this.setTitle(title);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void setTitle(String title) {
        this.lTitle.setText(title);
    }

    public String getTitle() {
        return this.lTitle.getText();
    }

    public void loginWithFingerprint(String sMemid) {
        if (sMemid == null || sMemid.length() == 0) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("fingerprint_not_recognised"));
        } else {
            this.login(sMemid, "", true);
        }
        this.frParent.processLogin();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.layeredPane.setLayout(new GridBagLayout());
        this.lNotification.setHorizontalTextPosition(0);
        this.lNotification.addFadeListener(new FadeListener(){

            @Override
            public void onShow() {
                PaHead.this.signInButton.setEnabled(false);
                PaHead.this.panelOutstandingOrders.setButtonsEnabled(false);
            }

            @Override
            public void onHide() {
                PaHead.this.signInButton.setEnabled(true);
                PaHead.this.panelOutstandingOrders.setButtonsEnabled(true);
            }
        });
        this.signInButton.setIcon(new ImageIcon(SP.sParams.imagepath + "sign_in_small.png"));
        this.signInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PaHead.this.frParent.isLoggedIn(false)) {
                    PaHead.this.frParent.clearLastLoggedInUser();
                    PaHead.this.logoff(true);
                } else {
                    PaHead.this.signIn();
                }
            }
        });
        this.signInButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PaHead.this.signInButton_keyPressed(e);
            }
        });
        ImageIcon originalLogo = new ImageIcon(this.sParams.imagepath + Settings.getScreenImage());
        ImageIcon scaledLogo = null;
        scaledLogo = originalLogo.getIconWidth() <= 150 && originalLogo.getIconHeight() <= 150 ? originalLogo : (originalLogo.getIconWidth() > originalLogo.getIconHeight() ? new ImageIcon(originalLogo.getImage().getScaledInstance(150, -1, 4)) : new ImageIcon(originalLogo.getImage().getScaledInstance(-1, 150, 4)));
        this.lLogo.setIcon(scaledLogo);
        this.lStoreInfo.setText(this.sParams.getStore().getName());
        this.lLogo.setHorizontalAlignment(2);
        this.lLogo.setVerticalAlignment(1);
        this.lBorder.setBorder(BorderFactory.createEtchedBorder());
        this.lStatusOnline.setHorizontalAlignment(4);
        this.lStatusOffline.setHorizontalAlignment(4);
        this.lStatusOnline.setIcon(new ImageIcon(this.sParams.imagepath + "statuson.png"));
        this.lStatusOffline.setIcon(new ImageIcon(this.sParams.imagepath + "statusoff.png"));
        this.lTrain.setForeground(Colours.RED);
        this.lTrain.setText(StoreParams.res.getString("train_mode"));
        this.lTrain.setVisible(false);
        this.panelOutstandingOrders = new OrdersToPackPanel(this.frParent);
        mainPanel.add((Component)this.panelOutstandingOrders, new GridBagConstraints(0, 0, 5, 3, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.lBorder, new GridBagConstraints(0, 0, 5, 3, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel signInPanel = new JPanel(new GridBagLayout());
        signInPanel.add((Component)this.lLogedInUser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        signInPanel.add((Component)this.signInButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)signInPanel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 0, 0, 18), 0, 0));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)this.lTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
        titlePanel.add((Component)this.lStoreInfo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)titlePanel, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 18, 0, new Insets(10, 15, 0, 0), 0, 0));
        mainPanel.add((Component)this.lLogo, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 1, new Insets(15, 15, 10, 0), 0, 0));
        mainPanel.add((Component)this.lTrain, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.lStatusOnline, new GridBagConstraints(4, 2, 1, 1, 0.0, 2.0, 12, 0, new Insets(10, 10, 10, 20), 0, 0));
        mainPanel.add((Component)this.lStatusOffline, new GridBagConstraints(4, 2, 1, 1, 0.0, 2.0, 12, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.layeredPane.setLayer(this.lNotification, JLayeredPane.POPUP_LAYER);
        this.layeredPane.add((Component)this.lNotification, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layeredPane.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.layeredPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateSignInState();
    }

    public void setLabelsForScanning(String ltxt) {
        if (SignInSettings.getInstance().isUsernameOnly()) {
            this.lLogedInUser.setText(ltxt);
        }
    }

    public void setFocus() {
        this.signInButton.requestFocusInWindow();
    }

    private void updateSignInState() {
        if (this.frParent.isLoggedIn(false)) {
            this.lLogedInUser.setText(this.frParent.getUser().getLoginName());
            this.signInButton.setText(SP.getRS("Sign_Out"));
        } else {
            this.lLogedInUser.setText("");
            this.signInButton.setText(SP.getRS("Sign_In"));
        }
    }

    public void logoff() {
        this.logoff(false);
    }

    public void logoff(boolean promptforSignIn) {
        this.frParent.getUser().invalidate();
        this.frParent.removeClockOffMenu();
        this.frParent.updateSec(new boolean[]{false, false, false, false});
        this.frParent.menuFunc.remove(this.frParent.menuClockOffAll);
        this.lTrain.setVisible(false);
        this.setFocus();
        this.updateSignInState();
        if (promptforSignIn) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaHead.this.signIn();
                }
            });
        }
    }

    public void logoff(long memidx) {
        if (this.frParent.getUser().getMemidx() == memidx) {
            this.logoff(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signIn() {
        while (true) {
            DlgSignIn signInDlg = null;
            try {
                signInDlg = new DlgSignIn(this.frParent);
                User user = signInDlg.getValidatedUser();
                if (user == null) {
                    boolean bl = false;
                    return bl;
                }
                if (Security.hasSecurity(this.frParent.secidx, user.getMemidx(), 0)) {
                    this.frParent.setUser(user);
                    if (!this.processLogin()) continue;
                    PersonCrypt.getInstance().setRequestOfflineKey(true);
                    PersonCrypt.getInstance().acquireKey(this.frParent);
                    if (this.frParent instanceof FrSales) {
                        FrSales frSales = (FrSales)this.frParent;
                        frSales.loadAttachPersonDlg();
                    }
                    boolean bl = true;
                    return bl;
                }
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
                continue;
            }
            finally {
                if (signInDlg == null) continue;
                signInDlg.dispose();
                continue;
            }
            break;
        }
    }

    public boolean login(User user) {
        boolean bResult = this.login(user.getMemName(), user.getMemPass(), user.isFingerprintLogin());
        this.frParent.processLogin();
        return bResult;
    }

    private boolean login(String name, String pass, boolean fingerprintLogin) {
        if (this.frParent.getUser().attemptLogin(name, pass, this.frParent.secidx, !fingerprintLogin && !SignInSettings.getInstance().isUsernameOnly(), fingerprintLogin)) {
            return this.processLogin();
        }
        if (this.frParent.getUser().getMemidx() > -1L && !this.frParent.getUser().hasLoginSec()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Insufficient_security"), -1, 0);
        }
        this.updateSignInState();
        return false;
    }

    private boolean processLogin() {
        if (this.frParent.getUser().requireClockOn()) {
            new DlgClock(this.frParent, StoreParams.res.getString("Clock_On"), true, this.frParent.getUser());
        }
        this.frParent.removeClockOffMenu();
        if (this.hasSecurity(11121L, 0)) {
            this.frParent.menuFunc.add((Component)this.frParent.menuClockOffAll, 0);
        }
        if (this.frParent.getUser().clockedOn()) {
            this.frParent.addClockOffMenu(this.frParent.getUser().getLoginName());
        }
        if (this.frParent.isLoggedIn(false)) {
            if (this.frParent.getUser().isTraningUser()) {
                this.lTrain.setVisible(true);
            }
            this.frParent.updateSec(this.frParent.getUser().getSecurity(this.frParent.secidx));
            this.frParent.processLogin();
            this.frParent.setFocus();
            this.updateSignInState();
            return true;
        }
        this.updateSignInState();
        return false;
    }

    private void signInButton_keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 10 && e.getKeyCode() != 32 && !this.frParent.isLoggedIn(false)) {
            this.frParent.keyPressed(e);
        }
    }

    public boolean voidTrans(boolean logout) {
        if (logout && SignInSettings.getInstance().isAutoSignOutAfterTransactionEnabled()) {
            this.logoff(true);
            return true;
        }
        return false;
    }

    protected boolean hasSecurity(long secidx, int secLevel) {
        return this.frParent.getUser().hasSecurity(secidx, secLevel);
    }

    protected boolean[] getSecurity(long secidx) {
        return this.frParent.getUser().getSecurity(secidx);
    }

    protected long clockOff() {
        long memidx = this.frParent.getUser().getMemidx();
        new DlgClock(this.frParent, StoreParams.res.getString("Clock_Off"), true, this.frParent.getUser());
        if (!this.frParent.isLoggedIn(false)) {
            this.logoff(true);
            return memidx;
        }
        return -1L;
    }

    public void setStatus(boolean online) {
        if (online) {
            if (!this.bOnlineIconSet) {
                this.lStatusOffline.fadeOut();
                this.lStatusOnline.fadeIn();
                this.bOnlineIconSet = true;
                this.bOfflineIconSet = false;
            }
        } else if (!this.bOfflineIconSet) {
            this.lStatusOnline.fadeOut();
            this.lStatusOffline.fadeIn();
            this.bOnlineIconSet = false;
            this.bOfflineIconSet = true;
        }
    }

    public void showSuccessMessage(String text) {
        this.lNotification.showSuccess(this, text);
    }

    public void showErrorMessage(String text) {
        this.lNotification.showError(this, text);
    }

    @Override
    public void close() {
        if (this.panelOutstandingOrders != null) {
            this.panelOutstandingOrders.close();
        }
    }
}

