/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jpos.DecimalField;
import jpos.Discount;
import jpos.DlgAddBagPrompt;
import jpos.DlgDisc;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.OmniChannel;
import jpos.PaSalesFoot;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SalesRep;
import jpos.Security;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.TransTypes;
import jpos.XMLUtils;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.swing.event.BSearchListener;
import jpos.basscom.swing.event.BValidateListener;
import jpos.coupons.DlgApplyCoupon;
import jpos.custorder.CurrentOrder;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DeliveryInfoDlg;
import jpos.custorder.DeliveryMethods;
import jpos.custorder.DespatchFactory;
import jpos.custorder.DespatchInfo;
import jpos.custorder.DlgBookingSummary;
import jpos.custorder.DlgCancelItems;
import jpos.custorder.DlgDeliveryOptions;
import jpos.custorder.DlgPacking;
import jpos.custorder.DlgShipCurrent;
import jpos.custorder.IDespatcher;
import jpos.custorder.scanpack.DlgScanPack;
import jpos.pay.DoPayments;
import jpos.person.PersonDlgProxy;
import jpos.pointspartner.PointsPartner;
import jpos.rewards.RewardsUtils;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.searchfields.TransactionSearchField;
import jpos.tillbalance.TillBalanceUtils;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import jpos.voucher.VoucherGatewayManager;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PaSales
extends JPanel {
    boolean hasDeliveryMethods = DeliveryMethods.deliveryMethodsExist();
    boolean orderLocked = false;
    boolean orderModified = false;
    boolean searchingCustomer = false;
    boolean paidWithOpenpay = false;
    long lastId = 0L;
    DoPayments doPayments;
    SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String barcode = "";
            try (SqlQuery sql = new SqlQuery(PaSales.this.sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB WHERE DB.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    barcode = sql.getString(1);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            PaSales.this.tfBarcode.clear();
            PaSales.this.tfBarcode.setText(barcode);
            PaSales.this.insertStyleLineLater(barcode);
        }
    };
    ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(PaSales.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM SKU K, DEFAULT_BARCODE DB WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String barcode = sql.getString(2);
                    if (sql.next()) {
                        PaSales.this.tfSize.search(this.getidx(), PaSales.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaSales.this.tfBarcode.clear();
                        PaSales.this.tfBarcode.setText(barcode);
                        PaSales.this.insertStyleLineLater(barcode);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaSales.this.frParent.isLoggedIn(true) && !PaSales.this.processing) {
                PaSales.this.checkTransactionForOpenPayPayments();
                if (PaSales.this.paidWithOpenpay) {
                    DlgMessage.showMessage(PaSales.this.frParent, StoreParams.res.getString("Openpay_Exchange_Denied_Error"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                PaSales.this.search = true;
                if (this.getText().equals(StoreParams.invalidBarcode)) {
                    this.setText("");
                }
                super.actionSearch();
                this.requestFocus();
                this.selectAll();
                PaSales.this.search = false;
            }
        }

        @Override
        public void actionValidate() {
            block32: {
                if (!PaSales.this.search) {
                    return;
                }
                PaSales.this.search = false;
                if (!this.getText().equals(StoreParams.invalidBarcode)) {
                    super.actionValidate();
                }
                try (SqlQuery sqlClr = new SqlQuery(PaSales.this.sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (!sqlClr.next()) break block32;
                    long clridx = sqlClr.getLong(1);
                    String clrname = sqlClr.getString(2);
                    if (sqlClr.next()) {
                        PaSales.this.tfClr.search(this.getidx(), this.getText());
                        break block32;
                    }
                    try (SqlQuery sqlBarcode = new SqlQuery(PaSales.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM SKU K, DEFAULT_BARCODE DB WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                        if (sqlBarcode.next()) {
                            String barcode = sqlBarcode.getString(2);
                            if (sqlBarcode.next()) {
                                PaSales.this.tfSize.search(clridx, this.getText(), clrname);
                            } else {
                                PaSales.this.tfBarcode.clear();
                                this.setText(barcode);
                                PaSales.this.insertStyleLineLater(barcode);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    private boolean processing = false;
    BJTextField tfHeldSales = new BJTextField();
    TransactionSearchField tfSecSearch = new TransactionSearchField();
    public StyleTable tblStyles;
    private TotalsTable tblTotals;
    private double totalNet;
    protected JPanel pOSBalance = new JPanel();
    protected DecimalField tfOSBalance;
    private LabelSubHeading lOSBalance = new LabelSubHeading();
    DlgDisc dlgDisc;
    JPanel panelPerson = new JPanel(new GridBagLayout());
    LabelSubHeading lPerson = new LabelSubHeading();
    LabelSubHeading lRewards = new LabelSubHeading();
    LabelSubHeading lGift = new LabelSubHeading();
    LabelSubHeading lCoupons = new LabelSubHeading();
    GridBagLayout gridBagLayout = new GridBagLayout();
    boolean cancLayby = false;
    boolean cancSpecialOrder = false;
    LabelSubHeading lFeedBack = new LabelSubHeading();
    PosFrame frParent;
    LabelSubHeading lSalesRep = new LabelSubHeading();
    StyleLine OldLBSOCancFee = null;
    LabelSubHeading lCust = new LabelSubHeading();
    LabelSubHeading lCustDets = new LabelSubHeading();
    public HintTextField tfCust = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE);
    private SearchPanel custSearchPanel = new SearchPanel(this.tfCust);
    boolean crDolChecked = false;
    StringField tfCustOrderNum = new StringField(30, TouchTextField.FontSize.LARGE);
    LabelSubHeading lCustOrderNum = new LabelSubHeading();
    StoreParams sParams;

    public PaSales(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.doPayments = new DoPayments((FrSales)this.frParent);
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected void jbInit() throws Exception {
        this.tblStyles = new StyleTable(this.frParent, null);
        GridBagConstraints panelOSBalanceConstraints = new GridBagConstraints(4, 5, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints lOSBalanceConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(1, 0, 5, 10), 0, 0);
        GridBagConstraints tfOSBalanceConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 5, 10), 0, 0);
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (PaSales.this.frParent.frameType) {
                    case 1: {
                        switch (col) {
                            case 0: {
                                return StoreParams.totalText;
                            }
                            case 4: {
                                return new PosDouble(PaSales.this.tblStyles.getQtyIgnoreFees());
                            }
                            case 10: {
                                return new PosDouble(PaSales.this.tblStyles.getDisc());
                            }
                            case 11: {
                                return new PosDouble(PaSales.this.tblStyles.getDue());
                            }
                        }
                        return "";
                    }
                    case 10: {
                        switch (col) {
                            case 0: {
                                return StoreParams.totalText;
                            }
                            case 4: {
                                return new PosDouble(PaSales.this.tblStyles.getQty());
                            }
                            case 6: {
                                return new PosDouble(PaSales.this.tblStyles.getDisc());
                            }
                            case 7: {
                                return new PosDouble(PaSales.this.tblStyles.getDue());
                            }
                        }
                        return "";
                    }
                    case 12: {
                        switch (col) {
                            case 0: {
                                return StoreParams.totalText;
                            }
                            case 4: {
                                return new PosDouble(PaSales.this.tblStyles.getOutstandingQty());
                            }
                            case 6: {
                                return new PosDouble(PaSales.this.tblStyles.getOutstandingPackedQty());
                            }
                            case 7: {
                                return new PosDouble(PaSales.this.tblStyles.getTakenQty());
                            }
                            case 8: {
                                return new PosDouble(PaSales.this.tblStyles.getPickUpQty());
                            }
                            case 12: {
                                return new PosDouble(PaSales.this.tblStyles.getDisc());
                            }
                            case 13: {
                                return new PosDouble(PaSales.this.tblStyles.getDue());
                            }
                        }
                        return "";
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        if (this.frParent.frameType == 10) {
            v.add(this.tfCust);
            v.add(this.tfCustOrderNum);
            v.add(this.tfBarcode);
            v.add(this.tblStyles);
            v.add(this.frParent.paHead.signInButton);
        }
        if (this.frParent.frameType == 12) {
            v.add(this.tfBarcode);
            v.add(this.tfCustOrderNum);
            v.add(this.tblStyles);
            v.add(this.tfBarcode);
            v.add(this.frParent.paHead.signInButton);
        } else {
            v.add(this.tfBarcode);
            v.add(this.tblStyles);
            v.add(this.tfBarcode);
            v.add(this.frParent.paHead.signInButton);
        }
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.tblStyles.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PaSales.this.update();
            }
        });
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaSales.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaSales.this.tfBarcode_actionPerformed(e);
            }
        });
        this.setPreferredSize(new Dimension(787, 271));
        this.lPerson.setLabelWidth(250);
        this.lPerson.setHorizontalAlignment(4);
        this.lPerson.setVerticalAlignment(0);
        this.lRewards.setVisible(false);
        this.lRewards.setIcon(new ImageIcon(SP.sParams.imagepath + "RewardsIconSmall.png"));
        this.lRewards.setVerticalAlignment(0);
        this.lRewards.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((FrSales)PaSales.this.frParent).promptForLoyaltyAmounts(true, false);
            }
        });
        this.lGift.setVisible(false);
        this.lGift.setIcon(new ImageIcon(SP.sParams.imagepath + "GiftIconSmall.png"));
        this.lGift.setVerticalAlignment(0);
        this.lGift.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((FrSales)PaSales.this.frParent).promptForRewardsGift(true);
            }
        });
        this.lCoupons.setVisible(false);
        this.lCoupons.setIcon(new ImageIcon(SP.sParams.imagepath + "CouponIconSmall.png"));
        this.lCoupons.setVerticalAlignment(0);
        this.lCoupons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FrSales sales = (FrSales)PaSales.this.frParent;
                if (sales.isLoggedIn(true)) {
                    DlgApplyCoupon couponDlg = new DlgApplyCoupon(sales, sales.getCouponCode());
                    couponDlg.setVisible(true);
                    if (couponDlg.getAccepted() && !couponDlg.getCode().trim().equalsIgnoreCase(sales.getCouponCode())) {
                        sales.setCouponCode(couponDlg.getCode());
                    }
                }
                sales.setFocus();
            }
        });
        this.lFeedBack.setLabelWidth(400);
        this.lSalesRep.setHorizontalAlignment(4);
        this.pOSBalance.setLayout(this.gridBagLayout);
        this.pOSBalance.setVisible(false);
        this.tfOSBalance = new DecimalField(this.sParams.storeCurrency);
        this.tfOSBalance.setEnabled(false);
        this.tfOSBalance.setFieldWidth(110);
        this.lOSBalance.setHorizontalAlignment(4);
        this.lOSBalance.setText(StoreParams.res.getString("OSBalance") + " ");
        this.panelPerson.add((Component)this.lPerson, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.panelPerson.add((Component)this.lCoupons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.panelPerson.add((Component)this.lGift, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.panelPerson.add((Component)this.lRewards, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.tfClr, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(2, 2, 2, 1, 3.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.tfSecSearch, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.panelPerson, new GridBagConstraints(4, 2, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 3, 6, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 6, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lSalesRep, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.tfSecSearch.setVisible(false);
        if (this.frParent.frameType == 10) {
            this.lCust.setText(StoreParams.res.getString("Customer") + " ");
            this.lCustDets.setHorizontalAlignment(4);
            this.tfCust.setFieldWidth(140);
            this.tfCustOrderNum.setFieldWidth(140);
            this.lCustOrderNum.setText(StoreParams.res.getString("Customer_Order_") + " ");
            this.tfCust.addBSearchListener(new BSearchListener(){

                @Override
                public void actionSearch() {
                    PaSales.this.tfCust_actionSearch();
                }

                @Override
                public void actionShiftSearch() {
                }
            });
            this.tfCust.addBValidateListener(new BValidateListener(){

                @Override
                public void actionValidate() {
                    PaSales.this.tfCust_actionSearch();
                }
            });
            this.tfCust.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    PaSales.this.tfCust_focusGained(e);
                }
            });
            this.add((Component)this.lCust, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.custSearchPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.lCustOrderNum, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.tfCustOrderNum, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.lCustDets, new GridBagConstraints(4, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 10), 0, 0));
            this.tfCust.setCache(this.sParams.cacher, this.sParams.iconn, 421L, "561", "", "C.\"ACTIVE\"=1 AND C.CUSTIDX NOT IN (SELECT CUSTIDX FROM WHSE_CUST)");
            this.tfCust.setSearchKey(123);
            this.tfCust.searchWithEnter(true);
            this.tblStyles.setEditable(false);
            this.tfSecSearch.setCache(this.sParams.cacher, this.sParams.iconn, 461L, "601,602,603", "", "A.FAMT-A.FPAID>0 AND H.TR_TYPE = 556" + this.sParams.sWhseRefSecWhereRETAIL);
        } else if (this.frParent.frameType == 12) {
            if (!this.hasDeliveryMethods || !SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CREATE_FLOOR_TO_DOOR_ORDERS)) {
                this.tfCustOrderNum.setFieldWidth(140);
                this.lCustOrderNum.setText(StoreParams.res.getString("Reference_") + " ");
                this.add((Component)this.lCustOrderNum, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.add((Component)this.tfCustOrderNum, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            this.add((Component)this.tfHeldSales, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
            this.tfHeldSales.setCache(this.sParams.cacher, 622L, "887,888,889,890,891,892", "", "H.COMPLETE = 0 AND NOT EXISTS (SELECT 1 FROM RET_TRANP P WHERE P.VHIDX = H.VHIDX) AND H.TR_TYPE = 714");
            this.tfHeldSales.setVisible(false);
            this.tfSecSearch.hideSearchCols(new String[]{"'O' || W.STORENO || H.DOCKET_NUMBER", "R.CODE"});
            this.tfSecSearch.setSearchOrderBy("DESC");
            this.add((Component)this.pOSBalance, panelOSBalanceConstraints);
            this.pOSBalance.add((Component)this.lOSBalance, lOSBalanceConstraints);
            this.pOSBalance.add((Component)this.tfOSBalance, tfOSBalanceConstraints);
        } else if (this.frParent.frameType == 1) {
            this.add((Component)this.tfHeldSales, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
            this.tfHeldSales.setCache(this.sParams.cacher, 622L, "887,888,889,890,891,892", "", "H.COMPLETE = 0 AND NOT EXISTS (SELECT 1 FROM RET_TRANP P WHERE P.VHIDX = H.VHIDX) AND H.TR_TYPE IN (239, 240, 243)");
            this.tfSecSearch.hideSearchCols(new String[]{"'L' || W.STORENO || H.TRANS_NUMBER", "R.CODE"});
            this.tfSecSearch.setSearchOrderBy("DESC");
            this.tfHeldSales.setVisible(false);
            this.tfSecSearch.setTitleExt("- " + StoreParams.res.getString("Layby"));
            this.add((Component)this.pOSBalance, panelOSBalanceConstraints);
            this.pOSBalance.add((Component)this.lOSBalance, lOSBalanceConstraints);
            this.pOSBalance.add((Component)this.tfOSBalance, tfOSBalanceConstraints);
        }
        this.tfClr.setVisible(false);
        this.tfSize.setVisible(false);
    }

    protected void checkTransactionForOpenPayPayments() {
        if (this.lastId > 0L) {
            this.paidWithOpenpay = false;
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT (1) FROM RET_TRANP WHERE PAYMENT_TYPEIDX = 850 AND VHIDX = " + this.lastId);){
                if (sql.next()) {
                    this.paidWithOpenpay = true;
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    private void insertStyleLineLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaSales.this.insertStyleLine(barcode);
                PaSales.this.tfBarcode.requestFocus();
                PaSales.this.tfBarcode.selectAll();
            }
        });
    }

    private boolean insertStyleLine(String barcode) {
        PointsPartner match;
        if (!this.frParent.isLoggedIn(true)) {
            this.tfBarcode.clear();
            return false;
        }
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        this.checkTransactionForOpenPayPayments();
        if (this.paidWithOpenpay) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Openpay_Exchange_Denied_Error"), StoreParams.res.getString("Error"), 0);
            return false;
        }
        FrSales frSales = (FrSales)this.frParent;
        if (!barcode.equals("") && !barcode.equals(StoreParams.invalidBarcode) && PosUtils.isProductBarcode(barcode)) {
            if (TransTypes.isSpecialOrder(this.frParent.transType) && !this.tblStyles.canEditSpecialOrder()) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("cant_modify_special_orders"), objs), StoreParams.res.getString("Stop"), 0);
                this.tfBarcode.clear();
                return false;
            }
            if (((FrSales)this.frParent).isRefundFloorToDoorOrder()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("cannot_insert_item_on_refund_order"), StoreParams.res.getString("Stop"), 0);
                this.tfBarcode.clear();
                return false;
            }
            if (((FrSales)this.frParent).isWebOrderUpdate()) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("cannot_insert_item_on_existing_web_order"), "\n"), SP.getRS("Stop"), 0);
                this.tfBarcode.clear();
                return false;
            }
            if (((FrSales)this.frParent).isCustOrderOnHold()) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(SP.getRS("Cannot_insert_item_on_hold_order"), "\n"), SP.getRS("Stop"), 0);
                this.tfBarcode.clear();
                return false;
            }
            if (!this.checkChangeOrder(this.frParent.transType)) {
                this.tfBarcode.clear();
                return false;
            }
            if (this.tblStyles.addEAN(barcode, true, this.frParent.frameType != 10) == -1) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.clear();
            return true;
        }
        if (barcode != "" && !barcode.equals(StoreParams.invalidBarcode) && VoucherGatewayManager.getInstance().isValidGatewayVoucher(barcode)) {
            if (this.tblStyles.addEAN(barcode, true, this.frParent.frameType != 10) == -1) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.clear();
            return true;
        }
        if (barcode.length() > 3 && barcode.substring(0, 1).toUpperCase().equals("L") && this.frParent.vhidx == -1L) {
            if (this.frParent.frameType == 10) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            if (TransTypes.isSpecialOrder(this.frParent.transType) && !this.tblStyles.canEditSpecialOrder()) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            if (!this.checkChangeOrder(this.frParent.transType)) {
                this.tfBarcode.clear();
                return false;
            }
            Element person = frSales.getPersonByLoyalty(barcode);
            if (!XMLUtils.hasValue(person, "peridx")) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            frSales.person = new Element("person");
            frSales.clearAttachedLoyaltyCards();
            this.tblStyles.removeAllLoyalyDiscounts();
            frSales.addLoyalty(barcode, person);
            if (frSales.getPerson().getAttribute("peridx") != null) {
                frSales.addAllLoyaltyCards(false);
                this.tblStyles.beginUpdate();
                this.tblStyles.endUpdate();
            }
            this.tfBarcode.clear();
            return true;
        }
        if (barcode.length() > 2 && barcode.substring(0, 1).toUpperCase().equals("D")) {
            if (!frSales.populate(barcode.substring(1), false)) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.clear();
            return true;
        }
        if (barcode.length() > 1 && barcode.substring(0, 1).toUpperCase().equals("I") && !barcode.equals(StoreParams.invalidBarcode)) {
            if (!frSales.populate(barcode.substring(1), true, false)) {
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.clear();
            return true;
        }
        if (!(this.frParent.frameType != 1 && this.frParent.frameType != 12 || this.frParent.vhidx != -1L && this.frParent.docknum != null || barcode.equals("") || barcode.equals(StoreParams.invalidBarcode) || (match = frSales.pointsPartners.getPartnerFromBarcode(barcode)) == null)) {
            StringBuilder message = new StringBuilder();
            if (!frSales.pointsPartners.setMembership(match, barcode, message)) {
                this.frParent.paHead.showErrorMessage(message.toString());
                this.tfBarcode.setText(StoreParams.invalidBarcode);
                this.tfBarcode.selectAll();
                return false;
            }
            this.tfBarcode.clear();
            this.frParent.paHead.showSuccessMessage(message.toString());
            return true;
        }
        this.tfBarcode.setText(StoreParams.invalidBarcode);
        this.tfBarcode.selectAll();
        return false;
    }

    protected void tfBarcode_actionPerformed(ActionEvent e) {
        this.frParent.setCursor(StoreParams.waitCursor);
        if (this.insertStyleLine(this.tfBarcode.getText())) {
            this.tfBarcode.requestFocus();
            this.tfBarcode.selectAll();
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    protected void update() {
        double due = this.totalNet;
        this.totalNet = this.tblStyles.getRowCount() > 0 ? this.tblStyles.getDue() : 0.0;
        if (this.frParent.transType == 239 && this.frParent.transType != 558) {
            this.tblStyles.checkShowSpecialOrderCols();
        }
        if (TransTypes.isSpecialOrder(this.frParent.transType) && this.frParent.docknum != null) {
            this.tblStyles.setEditSpecialOrder(false);
        } else {
            this.tblStyles.setEditSpecialOrder(true);
        }
        if (due != this.totalNet) {
            if (this.frParent.transType == 242 && due != 0.0) {
                this.frParent.setTransType(241);
            } else if (this.frParent.transType == 245 && due != 0.0) {
                this.frParent.setTransType(244);
            }
            if (this.frParent.transType == 242 || this.frParent.transType == 241) {
                this.tblStyles.setReason("568");
            }
            if (this.frParent.transType == 245 || this.frParent.transType == 244) {
                this.tblStyles.setReason("644");
            }
            this.lastId = 0L;
            this.paidWithOpenpay = false;
            if (this.tblStyles.getRowCount() > 0) {
                this.lastId = this.frParent.getVhidx();
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bLayBy.setText(StoreParams.res.getString("F6_New_Layby"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bLayBy.setMessage(StatusBar.status_LaybyNew);
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bSpecialOrder.setText(StoreParams.res.getString("F5_NewSpecialOrder"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bSpecialOrder.setMessage(StatusBar.status_SpecialOrderNew);
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bHold.setText(StoreParams.res.getString("Hold_Sale"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bHold.setMessage(StatusBar.status_HoldSale);
            } else {
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bLayBy.setText(StoreParams.res.getString("F6_Layby"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bLayBy.setMessage(StatusBar.status_LaybySearch);
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bSpecialOrder.setText(StoreParams.res.getString("F5_SpecialOrders"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bSpecialOrder.setMessage(StatusBar.status_SpecialOrderSearch);
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bHold.setText(StoreParams.res.getString("Recall_Sale"));
                ((PaSalesFoot)((FrSales)this.frParent).paFoot).bHold.setMessage(StatusBar.status_RecallSale);
            }
            ((FrSales)this.frParent).setReturnEnabled();
            if (((FrSales)this.frParent).lbsoComplete || ((FrSales)this.frParent).lbsoCancel) {
                this.tfOSBalance.setText(0.0);
            } else {
                this.tfOSBalance.setText(this.tblStyles.getDue() - ((FrSales)this.frParent).totPaidOrder);
            }
        }
    }

    protected void addDisc() {
        if (this.tblStyles.getRowCount() > 0 && this.dlgDisc == null) {
            Discount availableDisc;
            if (this.tblStyles.isEditing()) {
                this.tblStyles.getCellEditor().stopCellEditing();
            }
            StringBuffer discType = new StringBuffer();
            int styleCnt = 0;
            for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
                if (!(this.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                ++styleCnt;
            }
            if (styleCnt > 1) {
                this.dlgDisc = new DlgDisc(this.frParent, true, discType);
                this.dlgDisc.setVisible(true);
                this.dlgDisc = null;
            } else {
                discType.append("selected");
            }
            Vector<StyleLine> styleLines = new Vector<StyleLine>();
            if (discType.toString().equals("selected")) {
                int[] selRows = this.tblStyles.getSelectedRows();
                if (selRows.length == 0 && this.tblStyles.getRowCount() > 0) {
                    if (this.tblStyles.getItemAt(0) instanceof StyleLine) {
                        styleLines.add((StyleLine)this.tblStyles.getItemAt(0));
                    }
                } else {
                    for (int i = 0; i < selRows.length; ++i) {
                        if (!(this.tblStyles.getItemAt(selRows[i]) instanceof StyleLine)) continue;
                        styleLines.add((StyleLine)this.tblStyles.getItemAt(selRows[i]));
                    }
                }
            } else if (discType.toString().equals("all")) {
                for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
                    if (!(this.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                    styleLines.add((StyleLine)this.tblStyles.getItemAt(i));
                }
            } else {
                return;
            }
            Discount discReas = null;
            Security.OverrideUser overrideUser = new Security.OverrideUser();
            if (((FrSales)this.frParent).discTypes.size() > 1) {
                boolean extraWide = false;
                for (Discount d : ((FrSales)this.frParent).discTypes) {
                    if (!d.getNoFurtherDiscounts()) continue;
                    extraWide = true;
                    break;
                }
                Object[] discs = ((FrSales)this.frParent).discTypes.toArray();
                while ((discReas = (Discount)DlgList.showDialog(this.frParent, StoreParams.res.getString("sel_disc"), StoreParams.res.getString("Discount1"), discs, discs[0], extraWide)) != null && discReas.getManagerOnly() && !Security.hasSecurity(this.frParent, 11122L, this.frParent.getUser().getMemidx(), 0, true, overrideUser)) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Discount1"), -1, 0);
                }
            } else if (((FrSales)this.frParent).discTypes.size() == 1 && (!(availableDisc = ((FrSales)this.frParent).discTypes.elementAt(0)).getManagerOnly() || Security.hasSecurity(this.frParent, 11122L, this.frParent.getUser().getMemidx(), 0, true, overrideUser))) {
                discReas = availableDisc;
            }
            if (discReas == null) {
                return;
            }
            this.tblStyles.addDisc(discReas, styleLines, overrideUser.getUser() == null ? null : new SalesRep(overrideUser.getUser()));
            if (this.sParams.useDisplayDevice) {
                this.sParams.displayDevice.discountChange(this.tblStyles.getDisc());
            }
        }
    }

    protected Vector<Object> delLines() {
        return this.tblStyles.delLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layby() {
        this.processing = true;
        try {
            if (this.tblStyles.getQty() > 0.0) {
                if (this.tblStyles.isEditing()) {
                    this.tblStyles.getCellEditor().stopCellEditing();
                }
                if (!TillBalanceUtils.canTrade()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                int nCheck = this.tblStyles.checkTableForSpecialOrder();
                if (nCheck == 1 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                if (this.tblStyles.checkTableForGiftVouchers()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("gift_vouchers_on_layby"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                if (!((FrSales)this.frParent).lbsoCancel && !((FrSales)this.frParent).lbsoComplete && this.tblStyles.checkForRecalledProduct()) {
                    return;
                }
                if (RewardsUtils.usingAp21RetailRewards() && this.tblStyles.getLoyaltyTotal(787L) > 0.0) {
                    DlgMessage.showMessage(this.frParent, SP.getRS("rewards_on_layby"), SP.getRS("Error"), 0);
                    return;
                }
                if (RewardsUtils.usingAp21RetailRewards() && this.tblStyles.getGifts().size() > 0) {
                    DlgMessage.showMessage(this.frParent, SP.getRS("gifts_on_layby"), SP.getRS("Error"), 0);
                    return;
                }
                if (this.tblStyles.getDue() < this.sParams.getMinLbSale()) {
                    Object[] objs = new Object[]{this.sParams.storeCurrency.formatDetailNoScale(this.sParams.getMinLbSale())};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Layby_Minimum1"), objs), StoreParams.res.getString("Layby_Minimum"), 0);
                    return;
                }
                if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_BAGS) && this.frParent.transType != 242 && this.frParent.transType != 241 && !this.continueAfterBagPrompt()) {
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (((FrSales)this.frParent).getPerson().getAttribute("peridx") == null) {
                    ((FrSales)this.frParent).attachPerson("", false);
                    if (((FrSales)this.frParent).getPerson().getAttribute("peridx") == null) {
                        return;
                    }
                }
                if (this.tblStyles.getDue() < this.sParams.getMinLbSale()) {
                    Object[] objs = new Object[]{this.sParams.storeCurrency.formatDetailNoScale(this.sParams.getMinLbSale())};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Layby_Minimum1"), objs), StoreParams.res.getString("Layby_Minimum"), 0);
                    return;
                }
                if (((FrSales)this.frParent).getPerson().getAttribute("peridx") != null) {
                    double lbAdminFee = this.sParams.getLBAdminFee(this.tblStyles.getDue()) * -1.0;
                    if (lbAdminFee != 0.0) {
                        if (this.sParams.lbAdminFeeSku <= 0L) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("no_layby_admin_fee"), objs), StoreParams.res.getString("Error"), 0);
                            return;
                        }
                        StyleLine adminStyle = new StyleLine(this.sParams.lbAdminFeeSku, 1.0, this.sParams);
                        if (!adminStyle.isValid()) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("layby_admin_fee_not_exported"), objs), StoreParams.res.getString("Error"), 0);
                            return;
                        }
                    }
                    ((FrSales)this.frParent).updatePersonDisplayText();
                    if (this.frParent.transType != 242 && this.frParent.transType != 241) {
                        this.frParent.setTransType(240);
                        ((FrSales)this.frParent).setFromWidx(this.sParams.getStoreIdx());
                    }
                    this.lFeedBack.setText(StoreParams.res.getString("Layby"));
                    String title = StoreParams.res.getString("Layby");
                    ((FrSales)this.frParent).dueDate = this.sParams.getLDueDate(((FrSales)this.frParent).dateCalc);
                    if (((FrSales)this.frParent).nextPayDate == null) {
                        ((FrSales)this.frParent).setPaymentDate();
                    }
                    if (((FrSales)this.frParent).dueDate != null) {
                        PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(((FrSales)this.frParent).dueDate.getTime()), 3, 3, 0);
                        title = title + StoreParams.res.getString("_Due") + " " + dateFormatter.toString();
                    }
                    this.doPayments.setOrderDepositDets(this.tblStyles.getDue(), -lbAdminFee);
                    this.doPayments.doPayment(title, this.frParent.transType);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setTransType(239);
                    this.lFeedBack.setText("");
                }
            } else {
                ((FrSales)this.frParent).secSearch(240, "");
            }
        }
        finally {
            this.processing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void specialOrder() {
        this.processing = true;
        try {
            if (this.tblStyles.getQty() > 0.0) {
                if (!this.frParent.hasSecurity(11135L, 0)) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_create_special_orders_security"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                if (this.tblStyles.isEditing()) {
                    this.tblStyles.getCellEditor().stopCellEditing();
                }
                if (!TillBalanceUtils.canTrade()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                int nCheck = this.tblStyles.checkTableForSpecialOrder();
                if (nCheck == 0 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_special_order"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                if (this.tblStyles.checkTableForGiftVouchers()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("gift_vouchers_on_special_order"), StoreParams.res.getString("Error"), 0);
                    return;
                }
                if (!((FrSales)this.frParent).lbsoCancel && !((FrSales)this.frParent).lbsoComplete && this.tblStyles.checkForRecalledProduct()) {
                    return;
                }
                if (RewardsUtils.usingAp21RetailRewards() && this.tblStyles.getLoyaltyTotal(787L) > 0.0) {
                    DlgMessage.showMessage(this.frParent, SP.getRS("rewards_on_special_order"), SP.getRS("Error"), 0);
                    return;
                }
                if (RewardsUtils.usingAp21RetailRewards() && this.tblStyles.getGifts().size() > 0) {
                    DlgMessage.showMessage(this.frParent, SP.getRS("gifts_on_special_order"), SP.getRS("Error"), 0);
                    return;
                }
                if (((FrSales)this.frParent).getPerson().getAttribute("peridx") == null) {
                    ((FrSales)this.frParent).attachPerson("", false);
                    if (((FrSales)this.frParent).getPerson().getAttribute("peridx") == null) {
                        return;
                    }
                }
                if (((FrSales)this.frParent).getPerson().getAttribute("peridx") != null) {
                    double specialOrdAdminFee = this.sParams.getSpecOrdAdminFee(this.tblStyles.getDue()) * -1.0;
                    if (specialOrdAdminFee != 0.0) {
                        if (this.sParams.specOrdAdminFeeSku <= 0L) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("no_special_order_admin_fee"), objs), StoreParams.res.getString("Error"), 0);
                            return;
                        }
                        StyleLine adminStyle = new StyleLine(this.sParams.specOrdAdminFeeSku, 1.0, this.sParams);
                        if (!adminStyle.isValid()) {
                            Object[] objs = new Object[]{"\n"};
                            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("special_order_admin_fee_not_exported"), objs), StoreParams.res.getString("Error"), 0);
                            return;
                        }
                    }
                    ((FrSales)this.frParent).updatePersonDisplayText();
                    if (this.frParent.transType != 245 && this.frParent.transType != 244) {
                        this.frParent.setTransType(243);
                        ((FrSales)this.frParent).setFromWidx(this.sParams.getStoreIdx());
                    }
                    this.lFeedBack.setText(StoreParams.res.getString("SpecialOrder"));
                    String title = StoreParams.res.getString("SpecialOrder");
                    this.doPayments.setOrderDepositDets(this.tblStyles.getDue(), -specialOrdAdminFee);
                    this.doPayments.setXMLOldRetTranPs(null);
                    this.doPayments.doPayment(title, this.frParent.transType);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setTransType(239);
                    this.lFeedBack.setText("");
                }
            } else {
                ((FrSales)this.frParent).secSearch(243, "");
            }
        }
        finally {
            this.processing = false;
        }
    }

    protected void searchCustOrders() {
        ((FrSales)this.frParent).secSearch(714, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelLayby() {
        this.processing = true;
        try {
            if (!TillBalanceUtils.canTrade()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if ((this.frParent.transType == 242 || this.frParent.transType == 241) && ((FrSales)this.frParent).getFromWidx() != this.sParams.getStoreIdx()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("layby_cancel_message"), StoreParams.res.getString("layby_cancel_title"), 2);
                return;
            }
            if ((this.frParent.transType == 242 || this.frParent.transType == 241) && this.tblStyles.isEditable()) {
                double cancFee;
                if (this.tblStyles.isEditing()) {
                    this.tblStyles.getCellEditor().stopCellEditing();
                }
                double lbAdminFee = 0.0;
                StyleLine lbAdminFeeStyle = this.tblStyles.getStyle(this.sParams.lbAdminFeeSku);
                if (lbAdminFeeStyle != null) {
                    lbAdminFee = lbAdminFeeStyle.getNet();
                }
                double nPaid = 0.0;
                if (((FrSales)this.frParent).transRoot != null && ((FrSales)this.frParent).transRoot.getChildren("payments") != null) {
                    List oldTenders = ((FrSales)this.frParent).transRoot.getChildren("payments");
                    nPaid = this.getLBSOPaid(oldTenders);
                }
                if ((cancFee = this.sParams.getLBCancFee(this.tblStyles.getDue() - lbAdminFee) * -1.0) * -1.0 > nPaid) {
                    cancFee = nPaid * -1.0;
                }
                if (cancFee != 0.0) {
                    if (this.sParams.lbCancFeeSku <= 0L) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("no_layby_canc_fee"), objs), "Error", 0);
                        return;
                    }
                    StyleLine cancStyle = new StyleLine(this.sParams.lbCancFeeSku, 1.0, this.sParams);
                    if (!cancStyle.isValid()) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("layby_canc_fee_not_exported"), objs), "Error", 0);
                        return;
                    }
                }
                this.frParent.setCursor(StoreParams.waitCursor);
                this.cancLayby = true;
                ((FrSales)this.frParent).setLaybyCancelling(true);
                int transtype = this.frParent.transType;
                this.frParent.setTransType(241);
                this.tblStyles.setQtys(0.0);
                this.frParent.setCursor(StoreParams.normalCursor);
                this.doPayments.setOrderCancelDets(-cancFee, lbAdminFee, ((FrSales)this.frParent).transRoot);
                this.doPayments.doPayment(StoreParams.res.getString("Cancel_Layby"), this.frParent.transType);
                ((PaSales)this.frParent.paBody).tblStyles.setQtys();
                if (transtype != this.frParent.transType && this.frParent.transType == 241) {
                    this.frParent.setTransType(transtype);
                }
                this.cancLayby = false;
                ((FrSales)this.frParent).setLaybyCancelling(false);
                this.frParent.setFocus();
            }
        }
        finally {
            this.processing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSpecialOrder() {
        this.processing = true;
        try {
            if (!this.frParent.hasSecurity(11135L, 0)) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_cancel_special_orders_security"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if (!TillBalanceUtils.canTrade()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
                return;
            }
            if ((this.frParent.transType == 245 || this.frParent.transType == 244) && ((FrSales)this.frParent).getFromWidx() != this.sParams.getStoreIdx()) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("specialorder_cancel_message"), StoreParams.res.getString("specialorder_cancel_title"), 2);
                return;
            }
            if ((this.frParent.transType == 245 || this.frParent.transType == 244) && this.tblStyles.isEditable()) {
                double cancFee;
                if (this.tblStyles.isEditing()) {
                    this.tblStyles.getCellEditor().stopCellEditing();
                }
                double spAdminFee = 0.0;
                StyleLine spAdminFeeStyle = this.tblStyles.getStyle(this.sParams.specOrdAdminFeeSku);
                if (spAdminFeeStyle != null) {
                    spAdminFee = spAdminFeeStyle.getNet();
                }
                double nPaid = 0.0;
                if (((FrSales)this.frParent).transRoot != null && ((FrSales)this.frParent).transRoot.getChildren("payments") != null) {
                    List oldTenders = ((FrSales)this.frParent).transRoot.getChildren("payments");
                    nPaid = this.getLBSOPaid(oldTenders);
                }
                if ((cancFee = this.sParams.getSpecOrdCancFee(this.tblStyles.getDue() - spAdminFee) * -1.0) * -1.0 > nPaid) {
                    cancFee = nPaid * -1.0;
                }
                if (cancFee != 0.0) {
                    if (this.sParams.specOrdCancFeeSku <= 0L) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("no_special_order_canc_fee"), objs), StoreParams.res.getString("Error"), 0);
                        return;
                    }
                    StyleLine cancStyle = new StyleLine(this.sParams.specOrdCancFeeSku, 1.0, this.sParams);
                    if (!cancStyle.isValid()) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("special_order_canc_fee_not_exported"), objs), StoreParams.res.getString("Error"), 0);
                        return;
                    }
                }
                this.frParent.setCursor(StoreParams.waitCursor);
                this.cancSpecialOrder = true;
                int transtype = this.frParent.transType;
                this.frParent.setTransType(244);
                this.tblStyles.setQtys(0.0);
                this.frParent.setCursor(StoreParams.normalCursor);
                this.doPayments.setOrderCancelDets(-cancFee, spAdminFee, ((FrSales)this.frParent).transRoot);
                this.doPayments.doPayment(StoreParams.res.getString("Cancel_Special_Order"), this.frParent.transType);
                ((PaSales)this.frParent.paBody).tblStyles.setQtys();
                if (transtype != this.frParent.transType && this.frParent.transType == 244) {
                    this.frParent.setTransType(transtype);
                }
                this.cancSpecialOrder = false;
                this.frParent.setFocus();
            }
        }
        finally {
            this.processing = false;
        }
    }

    protected double getLBSOPaid(List<?> oldTenders) {
        double nPayAmt = 0.0;
        Iterator<?> payments = oldTenders.iterator();
        while (payments.hasNext()) {
            try {
                Element nextPayments = (Element)payments.next();
                for (Element nextTender : nextPayments.getChildren()) {
                    Attribute rcidx = nextTender.getAttribute("payment_typeidx");
                    long nPayType = 0L;
                    if (rcidx != null) {
                        nPayType = rcidx.getLongValue();
                    }
                    if (nPayType == 456L || nPayType == 457L || nPayType == 642L || nPayType == 643L || nPayType == 647L) continue;
                    nPayAmt += PosUtils.doubleValInternal(nextTender.getText());
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return nPayAmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void payment() {
        this.processing = true;
        this.orderLocked = false;
        this.orderModified = false;
        try {
            int nCheck;
            String currentOrderTimeStamp;
            FrSales frSales;
            block151: {
                block152: {
                    block150: {
                        frSales = (FrSales)this.frParent;
                        currentOrderTimeStamp = this.GetCurrentOrderTimeStamp();
                        if (!TillBalanceUtils.canTrade()) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
                            return;
                        }
                        if (!SalesRep.isSalesRepValid(frSales.salesRep)) {
                            DlgMessage.showMessage(this.frParent, SP.getRS("invalid_sales_rep"), SP.getRS("Stop"), 0);
                            return;
                        }
                        boolean itemBought = false;
                        for (StyleLine sl : this.tblStyles.getStyleLines()) {
                            if (!(sl.getQty() > 0.0)) continue;
                            itemBought = true;
                            break;
                        }
                        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_FOR_BAGS) && this.frParent.transType == 239 && itemBought && !this.continueAfterBagPrompt()) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (frSales.frameType != 12 && frSales.frameType != 10 && this.tblStyles.getRowCount() == 0 && this.frParent.docknum == null) {
                            if (frSales.getPerson().getAttribute("peridx") == null) {
                                long startVhidx = this.frParent.vhidx;
                                frSales.attachPerson(StoreParams.res.getString("AccountPerson"), false);
                                if (frSales.getPerson().getAttribute("peridx") == null || this.frParent.vhidx != startVhidx) {
                                    this.frParent.setCursor(StoreParams.normalCursor);
                                    this.frParent.setFocus();
                                    return;
                                }
                            }
                            if (!frSales.isAccountCustomer()) {
                                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("not_account_customer"), StoreParams.res.getString("Stop"), 0);
                                return;
                            }
                            String title = StoreParams.res.getString("AccountPayment");
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.doPayments.setPaymentDue(0.0);
                            this.doPayments.setXMLOldRetTranPsNull();
                            this.doPayments.doPayment(title, this.frParent.transType);
                            if (this.frParent.frameType != 1) return;
                            this.frParent.setTransType(239);
                            return;
                        }
                        if (this.tblStyles.allZeroQtys()) {
                            if (this.frParent.docknum == null) return;
                        }
                        this.frParent.setCursor(StoreParams.waitCursor);
                        if (this.tblStyles.isEditing()) {
                            this.tblStyles.getCellEditor().stopCellEditing();
                        }
                        if ((this.frParent.transType == 239 && this.frParent.docknum == null || (TransTypes.isLayby(this.frParent.transType) || TransTypes.isSpecialOrder(this.frParent.transType) || TransTypes.isCustOrder(this.frParent.transType)) && !frSales.lbsoCancel && !frSales.lbsoComplete) && this.tblStyles.checkForRecalledProduct()) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (this.tblStyles.checkForGiftVouchersWithZeroPrice()) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("GiftVoucherZeroPrice"), StoreParams.res.getString("Stop"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        nCheck = this.tblStyles.checkTableForSpecialOrder();
                        if (this.frParent.transType != 239) break block150;
                        if (nCheck == 1 || nCheck == 3) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Stop"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (frSales.isExchange() && this.doPayments.hasAfterpayHistory(frSales.transRoot)) {
                            DlgMessage.showMessage(this.frParent, SP.getRS("afterpay_no_exchange"), SP.getRS("Payment"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.FORCE_CUSTOMER_ENTRY_FOR_RETURNS) && this.tblStyles.hasNegQtys() && frSales.getPerson().getAttribute("peridx") == null) {
                            long startVhidx = this.frParent.vhidx;
                            frSales.attachPerson("", true);
                            if (frSales.getPerson().getAttribute("peridx") == null || this.frParent.vhidx != startVhidx) {
                                this.frParent.setCursor(StoreParams.normalCursor);
                                this.frParent.setFocus();
                                return;
                            }
                        }
                        if (this.sParams.promptForPerson == 1L && (this.frParent.vhidx == -1L || this.frParent.docknum == null) && frSales.getPerson().getAttribute("peridx") == null) {
                            long startVhidx = this.frParent.vhidx;
                            frSales.attachPerson("", false);
                            if (this.frParent.vhidx != startVhidx) {
                                this.frParent.setCursor(StoreParams.normalCursor);
                                this.frParent.setFocus();
                                return;
                            }
                        }
                        break block151;
                    }
                    if (this.frParent.transType != 714) break block152;
                    if (frSales.getPerson().getAttribute("peridx") == null) {
                        long startVhidx = this.frParent.vhidx;
                        frSales.attachPerson("", false);
                        if (frSales.getPerson().getAttribute("peridx") == null || this.frParent.vhidx != startVhidx) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                    }
                    if (this.hasDeliveryMethods && SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CREATE_FLOOR_TO_DOOR_ORDERS)) {
                        if (frSales.getPerson() != null && !frSales.deliveryInfo.isUserEdited()) {
                            frSales.deliveryInfo.populateFromPerson(frSales.getPerson());
                        }
                        DlgDeliveryOptions typeDlg = new DlgDeliveryOptions(this.frParent, frSales.deliveryInfo, this.tblStyles.getOutstandingStockedQty());
                        typeDlg.setVisible(true);
                        boolean result = typeDlg.getResult();
                        if (!result) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (frSales.deliveryInfo.getDeliveryOption() != DeliveryInfo.DeliveryOptions.SPLIT && !this.getShipFromLocation(frSales)) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                    } else {
                        frSales.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP);
                    }
                    if (frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP || frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT) {
                        if (!this.pack()) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (!this.getShipFromLocation(frSales)) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                    } else {
                        this.tblStyles.clearPacked();
                    }
                    if (frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT) {
                        block149: {
                            int totalOutstQty = this.tblStyles.getOutstandingStockedQty();
                            int deliverQty = totalOutstQty - this.tblStyles.getPickupStockedQty();
                            try {
                                Throwable throwable;
                                DeliveryInfoDlg deliveryInfoDlg;
                                block147: {
                                    block148: {
                                        deliveryInfoDlg = new DeliveryInfoDlg(this.frParent, frSales.deliveryInfo, deliverQty, totalOutstQty);
                                        throwable = null;
                                        deliveryInfoDlg.setVisible(true);
                                        boolean result2 = deliveryInfoDlg.getResult();
                                        if (result2) break block147;
                                        this.frParent.setCursor(StoreParams.normalCursor);
                                        this.frParent.setFocus();
                                        if (deliveryInfoDlg == null) return;
                                        if (throwable == null) break block148;
                                        try {
                                            deliveryInfoDlg.close();
                                            return;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                            return;
                                        }
                                    }
                                    deliveryInfoDlg.close();
                                    return;
                                }
                                if (deliveryInfoDlg == null) break block149;
                                if (throwable != null) {
                                    try {
                                        deliveryInfoDlg.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    break block149;
                                } else {
                                    deliveryInfoDlg.close();
                                }
                                break block149;
                                catch (Throwable throwable4) {
                                    try {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        if (deliveryInfoDlg == null) throw throwable5;
                                        if (throwable == null) {
                                            deliveryInfoDlg.close();
                                            throw throwable5;
                                        }
                                        try {
                                            deliveryInfoDlg.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                PosUtils.logError(e);
                            }
                        }
                        this.addFreight(frSales.deliveryInfo.getDeliveryMethod().getPrice().doubleValue());
                    }
                    break block151;
                }
                if (this.frParent.transType == 715) {
                    long ownerWidx = frSales.getOwnerWidx();
                    if (ownerWidx > 0L && ownerWidx != this.sParams.getStoreIdx() && !OmniChannel.warehouseExistsLocally(ownerWidx)) {
                        DlgMessage.showMessage(this.frParent, SP.getRS("Owner_Not_Exists_Local"), SP.getRS("Error"), 0);
                        this.frParent.setCursor(StoreParams.normalCursor);
                        this.frParent.setFocus();
                        return;
                    }
                    if (frSales.isRefundFloorToDoorOrder()) {
                        if (!this.cancelItems()) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (this.tblStyles.getStockedOutstandingQty() == 0.0) {
                            this.tblStyles.cancelNonStocked();
                        }
                        if (!frSales.reassignItemsForRefund()) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                    } else if (frSales.getFromWidx() == this.sParams.getStoreIdx() && !this.pack()) {
                        this.frParent.setCursor(StoreParams.normalCursor);
                        this.frParent.setFocus();
                        return;
                    }
                }
            }
            if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.AUTO_PROMPT_FOR_LOYALTY_AMOUNT)) {
                frSales.promptForLoyaltyAmounts(false, true);
            }
            if (RewardsUtils.usingAp21RetailRewards() && (this.frParent.transType == 239 || this.frParent.transType == 714) && frSales.getPerson().getAttribute("peridx") != null) {
                int availableGifts = 0;
                if (frSales.rewardsApiManager.getAccount() != null) {
                    availableGifts = frSales.rewardsApiManager.getAccount().getAvailableGifts().size() - this.tblStyles.getGifts().size();
                }
                if (availableGifts > 0 && DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Gift_Available"), StoreParams.res.getString("Gift_Available_Title"), 0, 1) == 0) {
                    frSales.promptForRewardsGift(true);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
            }
            frSales.attachedLoyaltyCards.requestRewardsRedemption(frSales);
            if (!this.tblStyles.externalTaxLookup(true)) {
                this.frParent.setCursor(StoreParams.normalCursor);
                this.frParent.setFocus();
                return;
            }
            double due = this.tblStyles.getDue();
            if ((this.frParent.transType == 239 || this.frParent.transType == 714) && due > 0.0 && frSales.pointsPartners.isAlwaysPrompt() && (this.frParent.vhidx == -1L || this.frParent.docknum == null) && frSales.pointsPartners.getCurrentPartner() == null) {
                frSales.pointsPartners.promptForMembershipNumber(frSales);
            }
            String title = StoreParams.res.getString("Payment");
            double lbsoAdminFee = 0.0;
            if (TransTypes.isLayby(this.frParent.transType)) {
                if (nCheck == 1 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (this.tblStyles.checkTableForGiftVouchers()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("gift_vouchers_on_layby"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                StyleLine lbAdminFeeStyle = this.tblStyles.getStyle(this.sParams.lbAdminFeeSku);
                if (lbAdminFeeStyle != null) {
                    lbsoAdminFee = lbAdminFeeStyle.getNet();
                }
                title = StoreParams.res.getString("Layby");
                if (!frSales.lbsoComplete) {
                    if (frSales.dueDate != null) {
                        PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(frSales.dueDate.getTime()), 3, 3, 0);
                        title = title + StoreParams.res.getString("_Due") + " " + dateFormatter.toString();
                    }
                    if (frSales.nextPayDate == null) {
                        frSales.setPaymentDate();
                    }
                }
                if (!this.tblStyles.isEditable() && this.OldLBSOCancFee != null) {
                    due = this.OldLBSOCancFee.getNet();
                }
            } else if (TransTypes.isSpecialOrder(this.frParent.transType)) {
                if (nCheck == 0 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_special_order"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (this.tblStyles.checkTableForGiftVouchers()) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("gift_vouchers_on_special_order"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                StyleLine specOrdAdminFeeStyle = this.tblStyles.getStyle(this.sParams.specOrdAdminFeeSku);
                if (specOrdAdminFeeStyle != null) {
                    lbsoAdminFee = specOrdAdminFeeStyle.getNet();
                }
                title = StoreParams.res.getString("SpecialOrder");
                if (!this.tblStyles.isEditable() && this.OldLBSOCancFee != null) {
                    due = this.OldLBSOCancFee.getNet();
                }
            } else if (this.frParent.frameType == 10) {
                if (nCheck == 1 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (this.frParent.docknum == null && this.tblStyles.checkForRecalledProduct()) {
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (frSales.getPerson().getAttribute("peridx") == null) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("enter_cust"), StoreParams.res.getString("no_cust"), 2);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (this.frParent.transnum == null) {
                    if (!this.refresh(true)) {
                        this.frParent.setCursor(StoreParams.normalCursor);
                        this.frParent.setFocus();
                        return;
                    }
                    due = this.tblStyles.getDue();
                }
            } else if (this.frParent.frameType == 12) {
                if (nCheck == 1 || nCheck == 3) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_sale"), StoreParams.res.getString("Stop"), 0);
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (this.frParent.docknum == null && this.tblStyles.checkForRecalledProduct()) {
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.frParent.setFocus();
                    return;
                }
                if (!frSales.isRefundFloorToDoorOrder()) {
                    if (frSales.despatchInfo != null && frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH) {
                        this.tblStyles.packNonStocked();
                    }
                    if (frSales.despatchInfo != null && frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH && this.tblStyles.getOutstandingQty() > 0.0) {
                        if (!this.checkChangeOrder(this.frParent.transType)) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        this.tblStyles.clearPickUp();
                        if (this.tblStyles.getCustOrdPackedStkQty() == 0) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Nothing_Packed"), StoreParams.res.getString("Stop"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (!this.frParent.getSecurity(2781L)[0] && this.tblStyles.getOutstandingPackedQty() != this.tblStyles.getOutstandingQty()) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Must_Pack_All"), StoreParams.res.getString("Stop"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        this.tblStyles.pickupRemaining();
                        IDespatcher despatcher = DespatchFactory.getDespatcher(String.valueOf(this.frParent.vhidx));
                        if (despatcher == null) {
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (!despatcher.hasCredentials()) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Despatch_Interface_Has_No_Credentials"), StoreParams.res.getString("Stop"), 0);
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        frSales.despatchInfo.setGoodsValue(this.tblStyles.getPickupDue());
                        frSales.despatchInfo.setNonStockedValue(this.tblStyles.getNonStockedDue());
                        frSales.despatchInfo.setFreightValue(this.tblStyles.getFreightValue());
                        DlgPacking dlgPacking = new DlgPacking(this.frParent, frSales.despatchInfo, despatcher);
                        dlgPacking.setVisible(true);
                        if (!frSales.despatchInfo.getDespatchSuccessful()) {
                            this.custOrderClearPickUp();
                            this.frParent.setCursor(StoreParams.normalCursor);
                            this.frParent.setFocus();
                            return;
                        }
                        if (despatcher.showBookingSummary()) {
                            DlgBookingSummary dlgBookingSummary = new DlgBookingSummary(this.frParent, frSales.despatchInfo, despatcher);
                            dlgBookingSummary.setVisible(true);
                        }
                        this.orderModified = true;
                    } else if (!frSales.isRefundFloorToDoorOrder() && frSales.despatchInfo != null && frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.CUSTOMER_PICKUP && frSales.despatchInfo.getTransactionModifiedStatus() == DespatchInfo.OrderModifiedStatus.ORDER_MODIFIED) {
                        DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Order_Modified_Message"), StoreParams.res.getString("Order_Modified"), 0);
                        this.frParent.voidTrans(false);
                        this.frParent.setCursor(StoreParams.normalCursor);
                        return;
                    }
                }
                title = StoreParams.res.getString("Customer_Order");
            }
            if (frSales.getCoupon() != null && !this.tblStyles.isCouponUsed()) {
                DlgMessage.showMessage(this.frParent, SP.getRS("Coupons_DidNotAffectTransaction_Text", "\n", frSales.getCoupon().getName(), frSales.getCoupon().getCode()), SP.getRS("Coupons_DidNotAffectTransaction_Title"), 2);
                frSales.setCouponCode("");
            }
            if (this.doPayments == null) {
                this.doPayments = new DoPayments(frSales);
            }
            this.frParent.setCursor(StoreParams.normalCursor);
            if (TransTypes.isLayby(this.frParent.transType) || TransTypes.isSpecialOrder(this.frParent.transType) || TransTypes.isCustOrder(this.frParent.transType)) {
                this.doPayments.setOrderPaymentDets(due, this.tblStyles.getPickupDue(), this.tblStyles.getTakenDue(), lbsoAdminFee, frSales.transRoot);
            } else {
                this.doPayments.setPaymentDue(due);
                if (!frSales.isRecallSale()) {
                    this.doPayments.setXMLOldRetTranPs(frSales.transRoot);
                }
            }
            if (this.sParams.useDisplayDevice && this.frParent.frameType == 1) {
                this.sParams.displayDevice.showPaymentTotal(this.tblStyles.getDisc(), due);
            }
            if (!this.doPayments.doPayment(title, this.frParent.transType)) return;
            if (this.sParams.useDisplayDevice && this.frParent.frameType == 1) {
                this.sParams.displayDevice.ambushNextWelcomeWithAThankyou();
            }
            if (this.frParent.frameType != 12) return;
            this.updateCustomerOrderModifiedStatus(currentOrderTimeStamp);
            return;
        }
        finally {
            this.processing = false;
        }
    }

    public String GetCurrentOrderTimeStamp() {
        FrSales frSales = (FrSales)this.frParent;
        CurrentOrder currentOrder = frSales.GetCurrentOrder();
        String currentTimestamp = currentOrder.Timestamp;
        return currentTimestamp;
    }

    public boolean LockOrder() {
        FrSales frSales = (FrSales)this.frParent;
        this.orderLocked = frSales.GetLock();
        return this.orderLocked;
    }

    public void addFreight(double amount) {
        long freightSku = PosUtils.getFreightSku();
        if (freightSku > 0L) {
            StyleLine freightLine = this.tblStyles.getStyle(freightSku);
            if (amount > 0.0) {
                if (freightLine == null) {
                    freightLine = new StyleLine(freightSku, 1.0, this.sParams);
                    this.tblStyles.addStyleLine(freightLine);
                }
                freightLine.setPrice(amount);
            } else if (freightLine != null) {
                this.tblStyles.deleteLine(freightLine);
            }
            this.tblStyles.beginUpdate();
            this.tblStyles.endUpdate();
        }
    }

    private void updateCustomerOrderModifiedStatus(String currentOrderTimeStamp) {
        FrSales frSales = (FrSales)this.frParent;
        DespatchInfo dispatchInfo = frSales.despatchInfo;
        long widx = frSales.getFromWidx();
        if (widx > 0L && dispatchInfo != null && dispatchInfo.getOriginalVhidx() > 0L && dispatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH || dispatchInfo.getDespatchType() == DespatchInfo.DespatchType.CUSTOMER_PICKUP) {
            String parameters = dispatchInfo.getOriginalVhidx() + "," + this.frParent.getUser().getMemidx() + "," + widx + ",";
            if (currentOrderTimeStamp != null && !currentOrderTimeStamp.isEmpty()) {
                parameters = parameters + currentOrderTimeStamp;
            }
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("corder_modified", parameters).getXML();
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANSales);
    }

    void tfCust_focusGained(FocusEvent e) {
        this.frParent.setStatusMsg(StatusBar.status_Cust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tfCust_actionSearch() {
        block44: {
            if (!this.searchingCustomer) {
                this.searchingCustomer = true;
                try {
                    if (this.tfCust.getidx() != -1L && this.tfCust.getidx() != 0L) {
                        this.lCustDets.setText(this.tfCust.getDesc());
                        this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("cust", this.tfCust.getidxStr()).getXML();
                        if (this.sParams.root == null) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                            this.frParent.voidTrans(false);
                            this.tfCust.requestFocus();
                            return;
                        }
                        Element cust = (Element)this.sParams.root.clone();
                        if (cust.getAttribute("custidx") == null) {
                            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("no_cust_dets"), StoreParams.res.getString("Error"), 0);
                            this.frParent.voidTrans(false);
                            break block44;
                        }
                        if (this.creditCheck(this.frParent, cust, true, true, false, 0.0)) {
                            Throwable throwable;
                            try {
                                throwable = null;
                                try (PersonDlgProxy permaint = new PersonDlgProxy(this.frParent, SP.getRS("Pickup_Person"), ((FrSales)this.frParent).getPerson(), this.frParent.getSecurity(11106L), new boolean[]{false, false, false, false}, this.tfCust.getidx(), false);){
                                    permaint.suppressOmneoPersonMaint(true);
                                    permaint.setVisible(true);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (Exception ex) {
                                PosUtils.logError(ex);
                            }
                            if (((FrSales)this.frParent).getPerson().getAttribute("peridx") == null) {
                                this.lCustDets.setText("");
                                this.tblStyles.setEditable(false);
                                this.tfCust.clear();
                                this.tfCust.requestFocus();
                                ((FrSales)this.frParent).transRoot = null;
                                break block44;
                            }
                            if (PosUtils.longVal(((FrSales)this.frParent).getPerson().getAttribute("peridx").getValue()) < -1L) {
                                try {
                                    throwable = null;
                                    try (Statement stmt = this.sParams.getStmt();){
                                        stmt.executeUpdate("UPDATE PERSON SET CUSTIDX = " + this.tfCust.getidx() + " WHERE PERIDX = " + ((FrSales)this.frParent).getPerson().getAttribute("peridx").getValue());
                                        cust.addContent((Content)((FrSales)this.frParent).getPerson());
                                    }
                                    catch (Throwable throwable3) {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                }
                                catch (SQLException e) {
                                    PosUtils.logError(e);
                                }
                            } else {
                                cust.addContent((Content)((FrSales)this.frParent).getPerson());
                            }
                            ((FrSales)this.frParent).setPerson(((FrSales)this.frParent).getPerson());
                            if (this.frParent.frameType != 10) {
                                ((FrSales)this.frParent).addAllLoyaltyCards(true);
                                this.tblStyles.beginUpdate();
                                this.tblStyles.endUpdate();
                            }
                            try {
                                for (int i = 0; i < ((FrSales)this.frParent).custNoteTypes.size(); ++i) {
                                    ((FrSales)this.frParent).custNoteTypes.elementAt(i).setKeyIdx(cust.getAttribute("custidx").getLongValue(), false);
                                }
                                this.frParent.addNotes(((FrSales)this.frParent).custNoteTypes, cust.getChildren("note"));
                            }
                            catch (DataConversionException e) {
                                PosUtils.logError(e);
                            }
                            this.frParent.setEditable(true);
                            ((FrSales)this.frParent).transRoot = cust;
                            break block44;
                        }
                        this.frParent.voidTrans(false);
                        break block44;
                    }
                    ((FrSales)this.frParent).setPerson(new Element("person"));
                    this.lCustDets.setText("");
                    this.tblStyles.setEditable(false);
                }
                finally {
                    this.searchingCustomer = false;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean creditCheck(Window parentWindow, Element root, boolean setDolChecked, boolean promptContinue, boolean bFromAccountPay, double nPurchaseVal) {
        String msgTitle = !promptContinue ? StoreParams.res.getString("Warning") : StoreParams.res.getString("Cannot_Continue");
        try {
            Object[] objs;
            if (root.getAttribute("suspord") != null) {
                if (root.getAttribute("suspord").getIntValue() == 2) {
                    if (bFromAccountPay) {
                        Object[] objs2 = new Object[]{"\n"};
                        DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cust_susp_perm"), objs2), StoreParams.res.getString("Cannot_Continue"), -1, 0);
                        return false;
                    }
                    Object[] objs3 = new Object[]{"\n"};
                    DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("ord_stat_susp_perm"), objs3), StoreParams.res.getString("Cannot_Continue"), -1, 0);
                    return false;
                }
                if (root.getAttribute("suspord").getIntValue() == 1) {
                    if (this.frParent.hasSecurity(2084L, 0) && promptContinue) {
                        if (bFromAccountPay) {
                            objs = new Object[]{"\n"};
                            if (DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("ord_stat_susp_continue"), objs), StoreParams.res.getString("Warning"), 2, 2) != 0) {
                                return false;
                            }
                        } else {
                            objs = new Object[]{"\n"};
                            if (DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("ord_stat_susp_continue"), objs), StoreParams.res.getString("Warning"), 2, 2) != 0) {
                                return false;
                            }
                        }
                    } else {
                        if (bFromAccountPay) {
                            Object[] objs4 = new Object[]{"\n"};
                            DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cust_susp"), objs4), StoreParams.res.getString("Cannot_Continue"), -1, 0);
                            return false;
                        }
                        Object[] objs5 = new Object[]{"\n"};
                        DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("ord_stat_susp_contact_ho"), objs5), msgTitle, -1, 0);
                        return false;
                    }
                }
            }
            if (!bFromAccountPay && root.getAttribute("suspdel") != null) {
                if (root.getAttribute("suspdel").getIntValue() == 2) {
                    objs = new Object[]{"\n"};
                    DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("del_stat_susp_perm"), objs), StoreParams.res.getString("Cannot_Continue"), -1, 0);
                    return false;
                }
                if (root.getAttribute("suspdel").getIntValue() == 1) {
                    if (this.frParent.hasSecurity(2084L, 0) && promptContinue) {
                        objs = new Object[]{"\n"};
                        if (DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("del_stat_susp_continue"), objs), StoreParams.res.getString("Warning"), 0, 2) != 0) {
                            return false;
                        }
                    } else {
                        objs = new Object[]{"\n"};
                        DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("del_stat_susp_contact_ho"), objs), msgTitle, -1, 0);
                        return false;
                    }
                }
            }
            if (root.getAttribute("crdol") != null && root.getAttribute("crdol").getDoubleValue() != 0.0) {
                if (bFromAccountPay) {
                    if (root.getAttribute("crdol").getDoubleValue() < root.getAttribute("balance").getDoubleValue() + nPurchaseVal) {
                        if (!this.frParent.hasSecurity(11136L, 0)) {
                            objs = new Object[]{"\n"};
                            DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_lim_exc_contact_ho"), objs), msgTitle, -1, 0);
                            return false;
                        }
                        if (this.frParent.hasSecurity(11149L, 0) ? DlgMessage.showMessage(parentWindow, StoreParams.res.getString("cust_bal_gr") + "\n" + StoreParams.res.getString("cust_bal") + " " + this.sParams.storeCurrency.formatDetailNoScale(root.getAttribute("balance").getDoubleValue() + nPurchaseVal) + "\n" + StoreParams.res.getString("cred_lim") + " " + this.sParams.storeCurrency.formatDetailNoScale(root.getAttribute("crdol").getDoubleValue()) + "\n" + StoreParams.res.getString("Continue_"), StoreParams.res.getString("Warning"), 0, 2) != 0 : DlgMessage.showMessage(parentWindow, StoreParams.res.getString("cust_bal_gr") + "\n" + StoreParams.res.getString("Continue_"), StoreParams.res.getString("Warning"), 0, 2) != 0) {
                            return false;
                        }
                    }
                } else if (root.getAttribute("crdol").getDoubleValue() < root.getAttribute("balance").getDoubleValue() && !this.crDolChecked) {
                    this.crDolChecked = setDolChecked;
                    if (this.frParent.hasSecurity(2084L, 0) && promptContinue) {
                        if (this.frParent.hasSecurity(11149L, 0) ? DlgMessage.showMessage(parentWindow, StoreParams.res.getString("cust_bal_gr") + "\n" + StoreParams.res.getString("cust_bal") + " " + this.sParams.storeCurrency.formatDetailNoScale(root.getAttribute("balance").getDoubleValue()) + "\n" + StoreParams.res.getString("cred_lim") + " " + this.sParams.storeCurrency.formatDetailNoScale(root.getAttribute("crdol").getDoubleValue()) + "\n" + StoreParams.res.getString("Continue_"), StoreParams.res.getString("Warning"), 0, 2) != 0 : DlgMessage.showMessage(parentWindow, StoreParams.res.getString("cust_bal_gr") + "\n" + StoreParams.res.getString("Continue_"), StoreParams.res.getString("Warning"), 0, 2) != 0) {
                            return false;
                        }
                    } else {
                        objs = new Object[]{"\n"};
                        DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_lim_exc_contact_ho"), objs), msgTitle, -1, 0);
                        return false;
                    }
                }
            }
            if (root.getAttribute("crday") == null) return true;
            if (bFromAccountPay) {
                if (this.frParent.hasSecurity(11137L, 0)) {
                    objs = new Object[]{"\n"};
                    if (DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_days_exc_continue"), objs), StoreParams.res.getString("Warning"), 0, 2) == 0) return true;
                    return false;
                }
                objs = new Object[]{"\n"};
                DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_days_exc_contact_ho"), objs), msgTitle, -1, 0);
                return false;
            }
            if (this.frParent.hasSecurity(2084L, 0) && promptContinue) {
                objs = new Object[]{"\n"};
                if (DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_days_exc_continue"), objs), StoreParams.res.getString("Warning"), 0, 2) == 0) return true;
                return false;
            }
            objs = new Object[]{"\n"};
            DlgMessage.showMessage(parentWindow, MessageFormat.format(StoreParams.res.getString("cred_days_exc_contact_ho"), objs), msgTitle, -1, 0);
            return false;
        }
        catch (DataConversionException e) {
            PosUtils.logError(e);
        }
        return true;
    }

    protected boolean refresh(boolean promptContinue) {
        if (!this.tblStyles.allZeroQtys()) {
            try {
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("price", this.tfCust.getidx() + "@" + this.frParent.getUser().getMemidx() + "@" + this.tblStyles.getIdxs(3)).getXML();
                if (this.sParams.root != null) {
                    List skus = this.sParams.root.getChild("prices").getChildren("sku");
                    for (int i = 0; i < skus.size(); ++i) {
                        Element sku = (Element)skus.get(i);
                        if (!this.tblStyles.setPriceDets(sku.getAttribute("skuidx").getLongValue(), sku.getAttribute("price") == null ? 0.0 : sku.getAttribute("price").getDoubleValue(), sku.getAttribute("orig_price") == null ? 0.0 : sku.getAttribute("orig_price").getDoubleValue(), sku.getAttribute("tax") == null ? 0.0 : sku.getAttribute("tax").getDoubleValue(), sku.getAttribute("discount") == null ? 0.0 : sku.getAttribute("discount").getDoubleValue(), true) || !(sku.getAttribute("price").getDoubleValue() > 0.0)) continue;
                        this.tfCust.setEnabled(false);
                    }
                    if (this.sParams.root.getAttribute("balance") != null) {
                        DecimalFormat df = new DecimalFormat("#");
                        df.setMaximumFractionDigits(4);
                        this.sParams.root.getAttribute("balance").setValue(df.format(this.sParams.root.getAttribute("balance").getDoubleValue() + this.tblStyles.getDue()));
                    }
                    if (!this.creditCheck(this.frParent, this.sParams.root, false, promptContinue, false, 0.0)) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("error_updating_price"), StoreParams.res.getString("Error"), 0);
                PosUtils.logError(e);
                return false;
            }
        }
        return true;
    }

    public boolean checkChangeOrder(int nType) {
        boolean canChange = true;
        if ((nType == 242 || nType == 245 || nType == 715) && ((FrSales)this.frParent).getFromWidx() != this.sParams.getStoreIdx()) {
            if (nType == 242) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("layby_change"), StoreParams.res.getString("Stop"), 2);
            } else if (nType == 245) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("specialorder_change"), StoreParams.res.getString("Stop"), 2);
            } else if (nType == 715) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("custorder_change"), StoreParams.res.getString("Stop"), 2);
            }
            canChange = false;
        }
        return canChange;
    }

    protected boolean cancelItems() {
        boolean result = true;
        DlgCancelItems dlgCancelItems = new DlgCancelItems(this.frParent, this.tblStyles.getStyleLines());
        if (dlgCancelItems.getRowCount() > 0) {
            dlgCancelItems.setVisible(true);
            if (!dlgCancelItems.getResult()) {
                result = false;
            }
        }
        this.tblStyles.model.fireTableDataChanged();
        return result;
    }

    protected boolean pack() {
        boolean result = true;
        FrSales frSales = (FrSales)this.frParent;
        if (this.frParent.transType == 714) {
            if (frSales.deliveryInfo.getDeliveryOption() == null) {
                frSales.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP);
            }
            if (frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY) {
                frSales.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.SPLIT);
            }
            boolean hideReference = !this.hasDeliveryMethods || !SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CREATE_FLOOR_TO_DOOR_ORDERS);
            DlgScanPack dlgScanPack = new DlgScanPack(this.frParent, this.tblStyles.getStyleLines(), frSales.deliveryInfo.getDeliveryOption(), true, hideReference);
            dlgScanPack.setCustomerReference(this.tfCustOrderNum.getText());
            if (dlgScanPack.getRowCount() > 0) {
                dlgScanPack.setVisible(true);
                if (frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP) {
                    this.tfCustOrderNum.setText(dlgScanPack.getCustomerReference());
                }
                if (dlgScanPack.isFullyPickedUp()) {
                    frSales.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP);
                }
                if (!dlgScanPack.getResult()) {
                    result = false;
                }
            }
        } else if (this.frParent.transType == 715) {
            DeliveryInfo.DeliveryOptions option = frSales.despatchInfo != null && frSales.despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH ? DeliveryInfo.DeliveryOptions.DELIVERY : DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP;
            DlgScanPack dlgScanPack = new DlgScanPack(this.frParent, this.tblStyles.getStyleLines(), option, false, true);
            if (dlgScanPack.getRowCount() > 0) {
                dlgScanPack.setVisible(true);
                if (!dlgScanPack.getResult()) {
                    result = false;
                }
            }
        }
        this.tblStyles.model.fireTableDataChanged();
        return result;
    }

    protected void history() {
        if (this.frParent.transType == 242 || this.frParent.transType == 241 || this.frParent.transType == 245 || this.frParent.transType == 244) {
            this.laybyHistory();
        }
        if (this.frParent.transType == 715) {
            this.custOrderHistory();
        } else if (this.frParent.transType == 239) {
            this.paymentHistory();
        }
    }

    protected void laybyHistory() {
        this.processing = true;
        try {
            if (((FrSales)this.frParent).nextPayDate == null) {
                ((FrSales)this.frParent).setPaymentDate();
            }
            double due = this.tblStyles.getDue();
            this.doPayments.doOrderHistory(((FrSales)this.frParent).editable && ((FrSales)this.frParent).getFromWidx() == SP.sParams.getStoreIdx(), ((FrSales)this.frParent).lbsoCancel, this.frParent.transType, due, ((FrSales)this.frParent).transRoot);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        finally {
            this.processing = false;
        }
    }

    protected void custOrderHistory() {
        this.processing = true;
        try {
            double due = this.tblStyles.getDue();
            this.doPayments.doOrderHistory(false, false, this.frParent.transType, due, ((FrSales)this.frParent).transRoot);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        finally {
            this.processing = false;
        }
    }

    protected void paymentHistory() {
        this.processing = true;
        try {
            double due = this.tblStyles.getDue();
            this.doPayments.doPaymentHistory(due, ((FrSales)this.frParent).transRoot);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        finally {
            this.processing = false;
        }
    }

    protected void custOrderCancelRemaining() {
        if (!TillBalanceUtils.canTrade()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("start_of_day_required_before_trading"), StoreParams.res.getString("Stop"), 0);
            return;
        }
        if (this.checkChangeOrder(this.frParent.transType)) {
            if (this.frParent.docknum == null) {
                this.frParent.voidTrans(false);
            } else if (DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Cancel_Remaining_Items_Message"), "\n"), StoreParams.res.getString("Cancel_Remaining_Items_Title"), 0, 3) == 0) {
                this.tblStyles.cancelRemaining();
                this.payment();
            }
        }
    }

    protected boolean custOrderPackRemaining() {
        if (this.checkChangeOrder(this.frParent.transType)) {
            this.tblStyles.packRemaining();
            return true;
        }
        return false;
    }

    protected boolean custOrderPickUpRemaining() {
        if (this.checkChangeOrder(this.frParent.transType)) {
            this.tblStyles.pickupRemaining();
            return true;
        }
        return false;
    }

    protected boolean custOrderClearPickUp() {
        if (this.checkChangeOrder(this.frParent.transType)) {
            this.tblStyles.clearPickUp();
            return true;
        }
        return false;
    }

    protected void printCustOrderPickList() {
        if (((FrSales)this.frParent).transRoot != null) {
            Receipt r1 = new Receipt(this.frParent, StoreParams.res.getString("Printing_Picklist"), false, this.sParams.getDocketConnection(), 0L, false);
            r1.printCustOrderPicklist(((FrSales)this.frParent).transRoot);
            r1.close();
        }
    }

    protected void reprintLabels() {
        IDespatcher despatcher;
        boolean result;
        if (((FrSales)this.frParent).despatchInfo != null && ((FrSales)this.frParent).despatchInfo.getDespatchType() == DespatchInfo.DespatchType.STORE_DESPATCH && !(result = (despatcher = DespatchFactory.getDespatcher()).reprintLabels(((FrSales)this.frParent).despatchInfo))) {
            DlgMessage.showMessage(this.frParent, despatcher.getPrintError(), SP.getRS("Reprint_Labels"), 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean continueAfterBagPrompt() {
        String ref = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.PROMPT_FOR_BAGS);
        ref = ref.replace('@', '=').trim();
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT STYLEIDX FROM STYLE WHERE ACTIVE = 1 AND " + ref);){
            Vector<Long> bagStyles = new Vector<Long>();
            while (sql.next()) {
                bagStyles.add(sql.getLong(1));
            }
            if (bagStyles.size() == 0) {
                boolean bl = true;
                return bl;
            }
            for (StyleLine sl : this.tblStyles.getStyleLines()) {
                if (!(sl.getQty() > 0.0) || !bagStyles.contains(sl.getStyleidx())) continue;
                boolean bl = true;
                return bl;
            }
            DlgAddBagPrompt addBag = new DlgAddBagPrompt((FrSales)this.frParent, bagStyles);
            addBag.setVisible(true);
            boolean bl = addBag.getContinueAfterDialog();
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.frParent.setCursor(StoreParams.normalCursor);
            this.frParent.setFocus();
            return false;
        }
    }

    private boolean getShipFromLocation(FrSales frSales) {
        if (!this.sParams.bShipFromCurrentStore || frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP) {
            return true;
        }
        if ((frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.DELIVERY || frSales.deliveryInfo.getDeliveryOption() == DeliveryInfo.DeliveryOptions.SPLIT) && this.sParams.bShipFromCurrentStore) {
            DlgShipCurrent shipCurrentDlg = new DlgShipCurrent(this.frParent, frSales.despatchInfo);
            shipCurrentDlg.setVisible(true);
            return shipCurrentDlg.getResult();
        }
        return false;
    }
}

