/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import jpos.ui.Colours;
import jpos.ui.Fonts;
import jpos.ui.TouchTextField;
import jpos.ui.UIConstants;

public class PosComboBox<T>
extends JComboBox<T> {
    private int fieldWidth = -1;
    private TouchTextField.FontSize fontSize = TouchTextField.FontSize.NORMAL;
    Color cOrigForegroundClr;
    private boolean layingOut = false;
    private int menuWidth = 0;

    public PosComboBox() {
        this(TouchTextField.FontSize.NORMAL);
    }

    public PosComboBox(TouchTextField.FontSize fontSize) {
        this.fontSize = fontSize;
        this.jbInit();
    }

    public PosComboBox(T[] objectArray) {
        super(objectArray);
        this.jbInit();
    }

    public PosComboBox(Vector<T> vector) {
        super(vector);
        this.jbInit();
    }

    public PosComboBox(ComboBoxModel<T> comboBoxModel) {
        super(comboBoxModel);
        this.jbInit();
    }

    private void jbInit() {
        if (this.fontSize == TouchTextField.FontSize.NORMAL) {
            this.setFont(Fonts.PlainText);
        } else {
            this.setFont(Fonts.H2);
        }
        this.setMaximumRowCount(10);
        ListCellRenderer renderer = this.getRenderer();
        if (renderer instanceof Component) {
            ((Component)((Object)renderer)).setPreferredSize(this.getPreferredSize());
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PosComboBox.this.setForeground(Colours.BLUE);
            }

            @Override
            public void focusLost(FocusEvent e) {
                PosComboBox.this.setForeground(PosComboBox.this.cOrigForegroundClr);
            }
        });
        this.cOrigForegroundClr = this.getForeground();
        this.defineListSelectioncolours();
    }

    private void defineListSelectioncolours() {
        Accessible child = this.getAccessibleContext().getAccessibleChild(0);
        if (child instanceof BasicComboPopup) {
            BasicComboPopup popup = (BasicComboPopup)child;
            JList<Object> list = popup.getList();
            list.setSelectionForeground(Colours.BLACK);
            list.setSelectionBackground(Colours.SELECTED_ROW);
        }
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.menuWidth > 0 ? this.menuWidth : this.getPreferredSize().width);
        }
        return dim;
    }

    public void setMenuWidth(int menuWidth) {
        this.menuWidth = menuWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.getFieldWidth() > -1) {
            d.width = this.getFieldWidth();
        }
        d.height = this.getFieldHeight();
        return d;
    }

    public int getFieldHeight() {
        return UIConstants.INPUT_HEIGHT;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }
}

