/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import jpos.Link;
import jpos.LinkStyle;
import jpos.PosDualValue;
import jpos.SP;
import jpos.ui.TouchTableCellRenderer;

public class PosRenderer
extends TouchTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private static final int ARRAY_SIZE = 34;
    private NumberFormat[] colNumFormats = new NumberFormat[34];
    private int[] colAlignments = new int[34];
    private NumberFormat format;
    private boolean printZero = true;
    private ImageIcon warningImage;
    private JTable parentTable;
    private int rolloverRow = -1;
    private int rolloverColumn = -1;
    public final Color defaultColour = this.getForeground();

    public PosRenderer(JTable parentTable) {
        Arrays.fill(this.colNumFormats, null);
        Arrays.fill(this.colAlignments, 2);
        this.warningImage = new ImageIcon(this.getScaledImage(new ImageIcon(SP.sParams.imagepath + "warn.gif").getImage(), 16, 16));
        this.parentTable = parentTable;
        if (this.parentTable != null) {
            parentTable.addMouseListener(this);
            parentTable.addMouseMotionListener(this);
        }
    }

    private Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    public void setPrintZero(boolean pprintZero) {
        this.printZero = pprintZero;
    }

    protected Object formatValue(Object value, boolean printZero) {
        try {
            if (this.format == null || value == null) {
                return value;
            }
            double numVal = this.format.parse(value.toString()).doubleValue();
            if (printZero || numVal != 0.0) {
                return this.format.format(numVal);
            }
            return "";
        }
        catch (ParseException e) {
            return value;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setIcon(null);
        if (value instanceof PosDualValue) {
            PosDualValue dual = (PosDualValue)value;
            if (!this.printZero && dual.doubleValue() == 0.0) {
                super.setValue(this.formatValue(dual.doubleValue(), this.printZero));
            } else {
                super.setValue(String.format("%s (%s)", this.formatValue(dual.doubleValue(), true), this.formatValue(dual.getOtherValue(), true)));
                if (dual.isWarning()) {
                    this.setIcon(this.warningImage);
                }
            }
        } else {
            super.setValue(this.formatValue(value, this.printZero));
        }
    }

    public void setColumnFormat(int col, NumberFormat pFormat, int alignMent) {
        this.colNumFormats[col] = pFormat;
        this.colAlignments[col] = alignMent;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Font font;
        this.format = this.colNumFormats[column];
        this.setHorizontalAlignment(this.colAlignments[column]);
        Component renComp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color c = this.getCellForegroundAt(value, row, column);
        if (!isSelected || c != null) {
            renComp.setForeground(c);
        }
        if ((font = this.getCellFontAt(value, row, column)) != null) {
            renComp.setFont(font);
        }
        if (value instanceof Link && ((Link)value).isValid() && renComp instanceof JLabel) {
            JLabel renLabel = (JLabel)renComp;
            LinkStyle style = row == this.rolloverRow && column == this.rolloverColumn ? LinkStyle.ACTIVE : (((Link)value).isVisited() ? LinkStyle.VISITED : LinkStyle.UNVISITED);
            renLabel.setText(style.format(renLabel.getText()));
        }
        return renComp;
    }

    public Color getCellForegroundAt(Object value, int row, int column) {
        return this.defaultColour;
    }

    public Font getCellFontAt(Object value, int row, int column) {
        return this.getFont();
    }

    public void copyContents(PosRenderer copyTo) {
        for (int i = 0; i < 34; ++i) {
            copyTo.setColumnFormat(i, this.colNumFormats[i], this.colAlignments[i]);
        }
        copyTo.setPrintZero(this.printZero);
    }

    private void updateRolloverColumn(MouseEvent e) {
        if (this.parentTable != null) {
            int row = this.parentTable.rowAtPoint(e.getPoint());
            int col = this.parentTable.columnAtPoint(e.getPoint());
            if (row != this.rolloverRow || col != this.rolloverColumn) {
                this.rolloverRow = row;
                this.rolloverColumn = col;
                this.parentTable.repaint();
                if (this.rolloverRow > -1 && this.rolloverColumn > -1) {
                    Cursor currentCursor = this.parentTable.getCursor();
                    Object cellVal = this.parentTable.getModel().getValueAt(row, col);
                    if (cellVal instanceof Link && ((Link)cellVal).isValid()) {
                        if (currentCursor == null || currentCursor.getType() == 0) {
                            this.parentTable.setCursor(new Cursor(12));
                        }
                    } else if (currentCursor != null && currentCursor.getType() == 12) {
                        this.parentTable.setCursor(new Cursor(0));
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateRolloverColumn(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateRolloverColumn(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.parentTable != null) {
            this.rolloverRow = -1;
            this.rolloverColumn = -1;
            this.parentTable.repaint();
            Cursor currentCursor = this.parentTable.getCursor();
            if (currentCursor != null && currentCursor.getType() == 12) {
                this.parentTable.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.parentTable != null) {
            Object cellValue;
            int row = this.parentTable.rowAtPoint(e.getPoint());
            int col = this.parentTable.columnAtPoint(e.getPoint());
            if (row > -1 && col > -1 && (cellValue = this.parentTable.getModel().getValueAt(row, col)) instanceof Link) {
                ((Link)cellValue).open();
                this.parentTable.repaint();
            }
        }
    }
}

