/*
 * Decompiled with CFR 0.152.
 */
package jpos.Promotions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jpos.PosUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DataSetHelper {
    private static String baseDataSet = null;

    public static Document createNewDataset() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(DataSetHelper.getBaseDataSet().getBytes());
        return builder.parse(inputStream);
    }

    public static Document getDatasetFromXml(String xmlString) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes());
        return builder.parse(inputStream);
    }

    private static String getBaseDataSet() {
        if (baseDataSet == null) {
            try {
                StringBuffer fileData = new StringBuffer();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileData.getClass().getResource("/jpos/Promotions/dataset.xml").openStream()));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        fileData.append(line);
                        fileData.append("\n");
                    }
                    baseDataSet = fileData.toString();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return baseDataSet;
    }

    public static Node addNode(Node parent, String name, String value) {
        Node node = parent.appendChild(parent.getOwnerDocument().createElement(name));
        if (value != null && value.length() > 0) {
            node.appendChild(parent.getOwnerDocument().createTextNode(value));
        }
        return node;
    }

    public static void addAttribute(Node node, String name, String value) {
        Attr attr = node.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(value == null ? "" : value);
        node.getAttributes().setNamedItem(attr);
    }

    public static String getXmlStringFromXmlDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter out = new StringWriter(0);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            return out.getBuffer().toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

