/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jpos.DlgMessage;
import jpos.DlgSecurityOverride;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.User;

public class Security {
    public static final int READ = 0;
    public static final int ADD = 1;
    public static final int EDIT = 2;
    public static final int DELETE = 3;
    public static final int SALES = 11102;
    public static final int TRANSFERS = 11103;
    public static final int STAFF_SETUP = 11104;
    public static final int LOYALTY = 11106;
    public static final int EXPENSE_TRANS = 1043;
    public static final int DEBTOR_SALE = 11112;
    public static final int EOD_SHOW_TILL_VAR = 11116;
    public static final int OVERRIDE_PRICE = 11117;
    public static final int RECEIPT_ALL = 11118;
    public static final int STOCK_ENQUIRY = 11119;
    public static final int STOCK_TAKE = 11120;
    public static final int CLOCK_OFF_ALL = 11121;
    public static final int MANAGER_DISCOUNT = 11122;
    public static final int TILL_BALANCE = 11123;
    public static final int REPRINT = 11124;
    public static final int RESERVATIONS = 11126;
    public static final int OVERRIDE_FLOOR = 11127;
    public static final int OVERRIDE_CHANGE = 11128;
    public static final int OVERRIDE_LAYBYFEE = 11129;
    public static final int OPEN_TILL = 11130;
    public static final int CHANGE_LAYBY_DATES = 11131;
    public static final int TRANSFER_SEARCH = 11132;
    public static final int KIT_ENTRY = 11133;
    public static final int EFT = 11134;
    public static final int PROCESS_HELD = 2084;
    public static final int SPECIAL_ORDERS = 11135;
    public static final int OVERRIDE_CREDIT_LIMIT = 11136;
    public static final int OVERRIDE_CREDIT_DAYS = 11137;
    public static final int REDUCE_DEPOSIT_VALUE = 11138;
    public static final int RETURN_TO_SUPPLIER = 11139;
    public static final int ADHOC_RECEIPTS = 11140;
    public static final int FINGERPRINT_LOGIN = 11141;
    public static final int PURCH_ORDERS_SEARCH = 11147;
    public static final int CHANGE_ORIG_SALES_REP = 11148;
    public static final int ACCOUNT_BALANCE = 11149;
    public static final int SEARCH_INCOMING_TRANSFER_REQ = 11150;
    public static final int ACCESS_HISTORY_ALL_STORES = 11151;
    public static final int BUDGETS = 11152;
    public static final int TRANSFER_REQUESTS = 11153;
    public static final int RECEIPT_ITEMS_NOT_ON_PURCHASE_ORDER = 11154;
    public static final int RECEIPT_ITEMS_NOT_ON_TRANSFER = 12606;
    public static final int GIFT_VOUCHER_BALANCE_ENQUIRY = 11155;
    public static final int CUST_ORDERS = 11156;
    public static final int CANCEL_TRANSFERS = 11157;
    public static final int CREDIT_NOTE_ENQUIRY = 11158;
    public static final int OVER_RECEIPT_STOCK = 11159;
    public static final int POS_PERSON_MAINTENANCE = 11160;
    public static final int QUICK_RECEIPTS = 11161;
    public static final int TURN_OFF_PROMOTIONS = 11162;
    public static final int REPRINT_CREDIT_NOTES = 11163;
    public static final int STOCK_ADJUSTMENT = 11164;
    public static final int MANAGER_LOYALTY = 11165;
    public static final int MODIFY_TAX_EXEMPTION_STATUS = 11166;
    public static final int DISABLE_TAX_LOOKUP = 11167;
    public static final int CREATE_FLOOR_TO_DOOR_ORDERS = 11170;
    public static final int SHOW_TRANS_PENDING_IN_STK_ENQUIRY = 11171;
    public static final int OVERRIDE_SLA_DESPATCH_PREVENTION = 11172;
    public static final int ALLOW_MANUAL_PACKING_OF_CUST_ORDERS = 11173;
    public static final int REMOVE_TAX = 11175;
    public static final int PROCESS_DOCKET_PRESENT_RETURNS = 11183;
    public static final int PROCESS_NON_DOCKET_RETURNS = 11184;
    public static final int PARTIAL_DESPATCH_FROM_STORE = 2781;
    public static final int CHANGE_PERSON_ON_EXISTING_TRANSACTION = 12625;
    public static final int VIEW_PLANNED_TRANSFERS = 2786;
    public static final int RETAIL_REWARDS = 2783;
    public static final int ALLOW_PICKUP_ORDER_REASSIGNMENT = 11177;
    public static final int REASSIGN_PARTIALLY_PACKED_PICKUP_ORDER = 11178;
    public static final int REWARDS_HISTORY_ADJUSTMENT = 11179;
    public static final int AP21_INSIGHT = 11180;
    public static final int REWARDS_ASSIGNMENT = 11181;
    public static final int ALLOW_OVER_TRANSFER_FOR_TRANSFER_OUT = 12641;

    public static boolean[] getSecurity(long secidx, long memidx) {
        boolean[] security = new boolean[]{false, false, false, false};
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT DISTINCT GS.\"READ\", GS.\"WRITE\", GS.EDIT, GS.DEL FROM GRPSEC GS, GRPMEM GM WHERE GM.MEMIDX = ? AND GM.GRPIDX = GS.GRPIDX AND GS.SECIDX = ? ORDER BY GS.\"READ\" DESC, GS.\"WRITE\" DESC, GS.EDIT DESC, GS.DEL DESC");){
            stmt.setLong(1, memidx);
            stmt.setLong(2, secidx);
            try (ResultSet result = stmt.executeQuery();){
                while (!(!result.next() || security[0] && security[1] && security[2] && security[3])) {
                    if (!security[0]) {
                        security[0] = PosUtils.booleanVal(result.getString(1));
                    }
                    if (!security[1]) {
                        security[1] = PosUtils.booleanVal(result.getString(2));
                    }
                    if (!security[2]) {
                        security[2] = PosUtils.booleanVal(result.getString(3));
                    }
                    if (security[3]) continue;
                    security[3] = PosUtils.booleanVal(result.getString(4));
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSecurity(PosFrame parent, long secidx, long memidx, int secLevel, boolean overridable, OverrideUser overrideUser) {
        if (Security.hasSecurity(secidx, memidx, secLevel)) {
            return true;
        }
        if (!overridable) {
            return false;
        }
        while (true) {
            DlgSecurityOverride securityOverrideDialog = null;
            try {
                securityOverrideDialog = new DlgSecurityOverride(parent);
                if (securityOverrideDialog.getValidatedUser() == null) {
                    boolean bl = false;
                    return bl;
                }
                long overrideMemidx = securityOverrideDialog.getValidatedUser().getMemidx();
                if (Security.hasSecurity(secidx, overrideMemidx, secLevel)) {
                    Security.logSecurityOverride(memidx, overrideMemidx, secidx);
                    if (overrideUser != null) {
                        overrideUser.setOverrideUser(secidx, secLevel, securityOverrideDialog.getValidatedUser());
                    }
                    boolean bl = true;
                    return bl;
                }
                DlgMessage.showMessage(parent, StoreParams.res.getString("no_security"), StoreParams.res.getString("Security_Override"), -1, 0);
                continue;
            }
            finally {
                if (securityOverrideDialog == null) continue;
                securityOverrideDialog.dispose();
                continue;
            }
            break;
        }
    }

    public static boolean hasSecurity(PosFrame parent, long secidx, long memidx, int secLevel, boolean overridable) {
        return Security.hasSecurity(parent, secidx, memidx, secLevel, overridable, null);
    }

    public static boolean hasSecurity(long secidx, long memidx, int secLevel) {
        if (secLevel < 0 || secLevel > 3) {
            return false;
        }
        boolean security = false;
        String column = null;
        switch (secLevel) {
            case 0: {
                column = "GS.\"READ\"";
                break;
            }
            case 1: {
                column = "GS.\"WRITE\"";
                break;
            }
            case 2: {
                column = "GS.EDIT";
                break;
            }
            case 3: {
                column = "GS.DEL";
            }
        }
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT DISTINCT 1 FROM GRPSEC GS, GRPMEM GM WHERE GM.MEMIDX = ? AND GM.GRPIDX = GS.GRPIDX AND GS.SECIDX = ? AND " + column + " = 1 ");){
            stmt.setLong(1, memidx);
            stmt.setLong(2, secidx);
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    security = true;
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return security;
    }

    private static void logSecurityOverride(long loggedInMemidx, long overrideMemidx, long secidx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO SECURITY_OVERRIDE_LOG (LOGIDX, TILL_NUMBER, SECIDX, LOGGED_IN_MEMIDX, OVERRIDE_MEMIDX, LOG_TIME) VALUES (?, ?, ?, ?, ?, CURRENT_TIMESTAMP)");){
            stmt.setLong(1, SP.sParams.nextVal("XSECURITY_OVERRIDE_LOG"));
            stmt.setString(2, SP.sParams.tillnum);
            stmt.setLong(3, secidx);
            stmt.setLong(4, loggedInMemidx);
            stmt.setLong(5, overrideMemidx);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFeatureOn(Connection con, long secidx) {
        try (SqlQuery sql = new SqlQuery(con, "SELECT 1 FROM GRPSEC WHERE SECIDX = " + secidx + " AND \"READ\" = 1");){
            if (!sql.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public static class OverrideUser {
        private User user;
        private long securityIdx;
        private int securityLevel;

        public User getUser() {
            return this.user;
        }

        public long getSecurityIdx() {
            return this.securityIdx;
        }

        public int getSecurityLevel() {
            return this.securityLevel;
        }

        private void setOverrideUser(long secIdx, int secLevel, User user) {
            this.securityIdx = secIdx;
            this.securityLevel = secLevel;
            this.user = user;
        }
    }
}

