/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jpos.PosDateFormatter;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;

public class SkuPrice {
    private long skuidx = 0L;
    private double price = 0.0;
    private double priceBeforeOverride = 0.0;
    private double origPrice = 0.0;
    private double previousPrice = 0.0;
    private double lowestPriceForPeriod = 0.0;
    private boolean stopDiscountsMarkdown = false;
    private boolean stopDiscountsClr = false;
    private long mkdMsgidx = 0L;
    private String mkdMsg = "";
    private boolean printOrigPrice = false;
    private boolean priceLoaded = false;
    private boolean previousPriceLoaded = false;
    private boolean origPriceLoaded = false;
    private boolean stopDiscountsClrLoaded = false;
    private boolean priceOverridden = false;
    private boolean origPriceOverridden = false;
    private String lastPriceDateLoaded = "";
    private String previousPriceDate = "";
    private String lastLowPricePeriod = "";

    public SkuPrice(long skuidx) {
        this.skuidx = skuidx;
    }

    public SkuPrice() {
        this(0L);
    }

    private void loadPrice() {
        this.loadPrice(null);
    }

    private void loadPrice(Timestamp priceLookupDate) {
        try {
            if (priceLookupDate == null) {
                priceLookupDate = new Timestamp(new Date().getTime());
            }
            PosDateFormatter formatter = new PosDateFormatter(priceLookupDate, 3, 3, 0);
            if (this.priceLoaded && this.lastPriceDateLoaded.equals(formatter.toStringInternal())) {
                return;
            }
            String dateSql = "CAST('" + formatter.toStringInternal() + "' AS DATE)";
            if (!this.priceOverridden) {
                this.price = 0.0;
            }
            this.stopDiscountsMarkdown = false;
            this.mkdMsgidx = 0L;
            this.mkdMsg = "";
            this.printOrigPrice = false;
            this.previousPriceDate = "";
            this.previousPriceLoaded = false;
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT P.PRICE, P.POS_STOPDISC_FLAG, P.POS_MKDMSGIDX, M.MSG, M.ORIG_FLAG, CAST(DFROM - 1 AS DATE) AS PREV_PRICE_DATE FROM SKU K, CLR C, SKU_PRICE P LEFT JOIN POS_MKDMSG M ON P.POS_MKDMSGIDX = M.MKDIDX WHERE K.SKUIDX = P.SKUIDX AND K.SKUIDX = " + this.skuidx + " AND K.CLRIDX = C.CLRIDX AND COALESCE(CAST(P.DFROM AS DATE), " + dateSql + ") <= " + dateSql + " AND COALESCE(CAST(P.DTO AS DATE), " + dateSql + ") >= " + dateSql + " ORDER BY \"LEVEL\", COALESCE(DFROM, CAST('1000-01-01 00:00:00' AS TIMESTAMP)) DESC, COALESCE(DTO, CAST('9999-01-01 00:00:00' AS TIMESTAMP))");){
                if (sql.next()) {
                    if (!this.priceOverridden) {
                        this.price = sql.getDouble(1);
                    }
                    this.priceBeforeOverride = sql.getDouble(1);
                    this.stopDiscountsMarkdown = sql.getBoolean(2);
                    this.mkdMsgidx = sql.getLong(3);
                    this.mkdMsg = sql.getString(4);
                    this.printOrigPrice = sql.getBoolean(5);
                    this.previousPriceDate = sql.getString("PREV_PRICE_DATE");
                }
            }
            this.priceLoaded = true;
            this.lastPriceDateLoaded = formatter.toStringInternal();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void loadOrigPrice() {
        block15: {
            try {
                if (this.origPriceLoaded || this.origPriceOverridden) break block15;
                this.origPrice = 0.0;
                try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT P.PRICE FROM SKU_PRICE P WHERE P.SKUIDX = " + this.skuidx + " AND P.DFROM IS NULL AND P.DTO IS NULL");){
                    if (sql.next()) {
                        this.origPrice = sql.getDouble(1);
                    }
                }
                this.origPriceLoaded = true;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void loadPreviousPrice(Timestamp priceLookupDate) {
        try {
            this.loadPrice(priceLookupDate);
            if (this.previousPriceLoaded) {
                return;
            }
            this.previousPrice = this.price;
            if (!StringUtils.isNullOrEmpty(this.previousPriceDate)) {
                String dateSql = "CAST('" + this.previousPriceDate + "' AS DATE)";
                try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT P.PRICE FROM SKU_PRICE P WHERE P.SKUIDX = " + this.skuidx + " AND COALESCE(CAST(P.DFROM AS DATE), " + dateSql + ") <= " + dateSql + " AND COALESCE(CAST(P.DTO AS DATE), " + dateSql + ") >= " + dateSql + " ORDER BY P.\"LEVEL\", COALESCE(P.DFROM, CAST('1000-01-01 00:00:00' AS TIMESTAMP)) DESC, COALESCE(P.DTO, CAST('9999-01-01 00:00:00' AS TIMESTAMP))");){
                    if (sql.next()) {
                        this.previousPrice = sql.getDouble("PRICE");
                    }
                }
            }
            this.previousPriceLoaded = true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void loadStopDiscountsClr() {
        if (!this.stopDiscountsClrLoaded) {
            this.stopDiscountsClr = false;
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT COALESCE(C.MAX_POS_DISC, 100) FROM SKU K, CLR C WHERE K.SKUIDX = " + this.skuidx + " AND K.CLRIDX = C.CLRIDX ");){
                if (sql.next() && sql.getDouble(1) == 0.0) {
                    this.stopDiscountsClr = true;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            this.stopDiscountsClrLoaded = true;
        }
    }

    private void loadLowestPriceBetween(Timestamp startTime, Timestamp endTime, boolean excludePricesLowerThanEndPrice) {
        try {
            Serializable from;
            if (startTime == null) {
                startTime = new Timestamp(new Date().getTime());
            }
            if (endTime == null) {
                endTime = new Timestamp(new Date().getTime());
            }
            PosDateFormatter formatter = new PosDateFormatter(null, 3, 3, 0);
            formatter.setTimestamp(startTime);
            String period = formatter.toStringInternal();
            String startDateSql = "CAST('" + formatter.toStringInternal() + "' AS DATE)";
            Date startDate = new SimpleDateFormat("yyyy-MM-dd").parse(formatter.toStringInternal());
            formatter.setTimestamp(endTime);
            period = period + " to " + formatter.toStringInternal() + excludePricesLowerThanEndPrice;
            String endDateSql = "CAST('" + formatter.toStringInternal() + "' AS DATE)";
            Date endDate = new SimpleDateFormat("yyyy-MM-dd").parse(formatter.toStringInternal());
            if (this.lastLowPricePeriod.equals(period)) {
                return;
            }
            int level = 0;
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT \"LEVEL\" FROM SKU K, CLR C, SKU_PRICE P WHERE K.SKUIDX = P.SKUIDX AND K.SKUIDX = " + this.skuidx + " AND K.CLRIDX = C.CLRIDX AND COALESCE(CAST(P.DFROM AS DATE)," + endDateSql + ") <= " + endDateSql + " AND COALESCE(CAST(P.DTO AS DATE), " + endDateSql + ") >= " + endDateSql + " ORDER BY \"LEVEL\", COALESCE(DFROM, CAST('1000-01-01' AS TIMESTAMP)) DESC, COALESCE(DTO, CAST('9999-01-01' AS TIMESTAMP))");){
                if (sql.next()) {
                    level = sql.getInt("LEVEL");
                }
            }
            ArrayList<PricePeriod> markdownPeriods = new ArrayList<PricePeriod>();
            try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "WITH M AS (\tSELECT MINVALUE(CAST('1000-01-01' AS DATE), COALESCE( CAST(MIN(sp2.DFROM) -1 AS DATE), CAST('1000-01-01' AS DATE))) AS minDate  FROM SKU_PRICE sp2 WHERE sp2.skuidx = " + this.skuidx + " GROUP BY sp2.skuidx),A AS ( \tSELECT P.PRICE, COALESCE(CAST(P.DFROM AS DATE), M.MinDate) AS FROM_DATE, \tCOALESCE( \t\t(SELECT MIN(COALESCE(CAST(sP.DFROM -1 AS DATE), M.MinDate)) FROM SKU_PRICE sp \t\t WHERE skuidx = " + this.skuidx + " AND sp.DFROM > COALESCE(P.DFROM, CAST(M.MinDate AS TIMESTAMP)) \t\t AND sp.DTO IS NULL), " + endDateSql + " + 1) AS TO_DATE \tFROM SKU K, CLR C, SKU_PRICE P, M \tWHERE K.SKUIDX = P.SKUIDX AND K.SKUIDX = " + this.skuidx + " AND K.CLRIDX = C.CLRIDX \tAND P.\"LEVEL\" = " + level + " AND P.DTO IS NULL) SELECT * FROM A WHERE (A.FROM_DATE BETWEEN " + startDateSql + " AND " + endDateSql + "\tOR A.TO_DATE BETWEEN " + startDateSql + " AND " + endDateSql + "\tOR (A.FROM_DATE < + " + startDateSql + " AND A.TO_DATE > " + endDateSql + ") ) ORDER BY A.FROM_DATE");){
                while (sql.next()) {
                    from = sql.getDate("FROM_DATE");
                    Date to = sql.getDate("TO_DATE");
                    if (((Date)from).before(startDate)) {
                        from = new Date(startDate.getTime());
                    }
                    if (to.after(endDate)) {
                        to = new Date(endDate.getTime());
                    }
                    markdownPeriods.add(new PricePeriod((Date)from, to, sql.getDouble("PRICE")));
                }
            }
            ArrayList<PricePeriod> salePeriods = new ArrayList<PricePeriod>();
            SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT P.PRICE, CAST(P.DFROM AS DATE) AS FROM_DATE, CAST(P.DTO AS DATE) AS TO_DATE FROM SKU K, CLR C, SKU_PRICE P WHERE K.SKUIDX = P.SKUIDX AND K.SKUIDX = " + this.skuidx + " AND K.CLRIDX = C.CLRIDX AND P.\"LEVEL\" = " + level + " AND P.DFROM IS NOT NULL AND P.DTO IS NOT NULL AND (  P.DFROM BETWEEN " + startDateSql + " AND " + endDateSql + " OR P.DTO BETWEEN " + startDateSql + " AND " + endDateSql + "\tOR (P.DFROM < + " + startDateSql + " AND P.DTO > " + endDateSql + ") ) ORDER BY P.DFROM");
            from = null;
            try {
                while (sql.next()) {
                    salePeriods.add(new PricePeriod(sql.getDate("FROM_DATE"), sql.getDate("TO_DATE"), sql.getDouble("PRICE")));
                }
            }
            catch (Throwable to) {
                from = to;
                throw to;
            }
            finally {
                if (sql != null) {
                    if (from != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable to) {
                            ((Throwable)from).addSuppressed(to);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            if (markdownPeriods.size() > 0) {
                for (PricePeriod s : salePeriods) {
                    ArrayList<PricePeriod> updatedPeriods;
                    for (int i = 0; i < markdownPeriods.size(); i += updatedPeriods.size()) {
                        PricePeriod m = (PricePeriod)markdownPeriods.remove(i);
                        updatedPeriods = this.removeSalePeriodFromMarkdownPeriod(s, m);
                        markdownPeriods.addAll(i, updatedPeriods);
                    }
                }
            }
            Double endPrice = null;
            if (excludePricesLowerThanEndPrice) {
                PricePeriod lastPeriod;
                if (salePeriods.size() > 0 && ((lastPeriod = (PricePeriod)salePeriods.get(salePeriods.size() - 1)).fromDate.equals(endDate) || lastPeriod.toDate.equals(endDate) || lastPeriod.fromDate.before(endDate) && lastPeriod.toDate.after(endDate))) {
                    endPrice = lastPeriod.price;
                }
                if (endPrice == null && markdownPeriods.size() > 0 && ((lastPeriod = (PricePeriod)markdownPeriods.get(markdownPeriods.size() - 1)).fromDate.equals(endDate) || lastPeriod.toDate.equals(endDate) || lastPeriod.fromDate.before(endDate) && lastPeriod.toDate.after(endDate))) {
                    endPrice = lastPeriod.price;
                }
            }
            Double minPrice = null;
            for (PricePeriod p : markdownPeriods) {
                if (endPrice != null && !(p.price > endPrice)) continue;
                minPrice = minPrice == null ? p.price : Math.min(minPrice, p.price);
            }
            for (PricePeriod p : salePeriods) {
                if (endPrice != null && !(p.price > endPrice)) continue;
                minPrice = minPrice == null ? p.price : Math.min(minPrice, p.price);
            }
            this.lowestPriceForPeriod = minPrice == null ? 0.0 : minPrice;
            this.lastLowPricePeriod = period;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private ArrayList<PricePeriod> removeSalePeriodFromMarkdownPeriod(PricePeriod salePeriod, PricePeriod markdownPeriod) {
        ArrayList<PricePeriod> updatedMarkdownPeriods = new ArrayList<PricePeriod>();
        if (salePeriod.fromDate.after(markdownPeriod.toDate) || salePeriod.toDate.before(markdownPeriod.fromDate)) {
            updatedMarkdownPeriods.add(markdownPeriod);
        } else if (!this.leq(salePeriod.fromDate, markdownPeriod.fromDate) || !this.geq(salePeriod.toDate, markdownPeriod.toDate)) {
            if (this.leq(salePeriod.fromDate, markdownPeriod.fromDate)) {
                updatedMarkdownPeriods.add(new PricePeriod(this.AddDays(salePeriod.toDate, 1L), markdownPeriod.toDate, markdownPeriod.price));
            } else if (this.geq(salePeriod.toDate, markdownPeriod.toDate)) {
                updatedMarkdownPeriods.add(new PricePeriod(markdownPeriod.fromDate, this.AddDays(salePeriod.fromDate, -1L), markdownPeriod.price));
            } else {
                updatedMarkdownPeriods.add(new PricePeriod(markdownPeriod.fromDate, this.AddDays(salePeriod.fromDate, -1L), markdownPeriod.price));
                updatedMarkdownPeriods.add(new PricePeriod(this.AddDays(salePeriod.toDate, 1L), markdownPeriod.toDate, markdownPeriod.price));
            }
        }
        return updatedMarkdownPeriods;
    }

    private boolean geq(Date d1, Date d2) {
        return d1.after(d2) || d1.equals(d2);
    }

    private boolean leq(Date d1, Date d2) {
        return d1.before(d2) || d1.equals(d2);
    }

    private Date AddDays(Date d1, long days) {
        long millisecondsPerDay = 86400000L;
        return new Date(d1.getTime() + days * millisecondsPerDay);
    }

    public long getSkuidx() {
        return this.skuidx;
    }

    public double getPrice() {
        this.loadPrice();
        return this.price;
    }

    public double getPrice(Timestamp priceDate) {
        this.loadPrice(priceDate);
        return this.price;
    }

    public double getPriceBeforeAnyOverride() {
        this.loadPrice();
        return this.priceBeforeOverride;
    }

    public double getPreviousPrice() {
        this.loadPreviousPrice(null);
        return this.previousPrice;
    }

    public double getPreviousPrice(Timestamp priceDate) {
        this.loadPreviousPrice(priceDate);
        return this.previousPrice;
    }

    public double getOrigPrice() {
        this.loadOrigPrice();
        return this.origPrice;
    }

    public double getLowestPriceBetween(Timestamp startDate, Timestamp endDate, boolean excludePricesLowerThanEndPrice) {
        this.loadLowestPriceBetween(startDate, endDate, excludePricesLowerThanEndPrice);
        return this.lowestPriceForPeriod;
    }

    public boolean stopDiscountsMarkdown() {
        this.loadPrice();
        return this.stopDiscountsMarkdown;
    }

    public boolean stopDiscountsClr() {
        this.loadStopDiscountsClr();
        return this.stopDiscountsClr;
    }

    public String getMkdMsg() {
        this.loadPrice();
        return this.mkdMsg;
    }

    public long getMkdMsgidx() {
        this.loadPrice();
        return this.mkdMsgidx;
    }

    public boolean getPrintOrigPrice() {
        this.loadPrice();
        return this.printOrigPrice;
    }

    public void setPrice(double price) {
        this.priceOverridden = true;
        this.price = price;
    }

    public void setOrigPrice(double origPrice) {
        this.origPriceOverridden = true;
        this.origPrice = origPrice;
    }

    private class PricePeriod {
        private Date fromDate;
        private Date toDate;
        private double price;

        public PricePeriod(Date fromDate, Date toDate, double price) {
            this.fromDate = fromDate;
            this.toDate = toDate;
            this.price = price;
        }
    }
}

