/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.StringUtils;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.components.VisibleRowTable;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.swing.FocusTraversalPolicy;
import jpos.basscom.utils.TypConv;
import jpos.basscom.utils.Utils;
import jpos.ui.DialogButton;
import jpos.ui.TouchTable;
import jpos.ui.TouchTableCellRenderer;
import jpos.ui.TouchTextField;

public class searchFrame
extends JDialog
implements KeyEventDispatcher {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    private int recordsToFetch = 40;
    private Cacher cacher = null;
    private ToServ toserv = null;
    private String searchHandle = null;
    private String mandTable;
    private String fromTable;
    private String where;
    private boolean bOK = false;
    private long cacheidx;
    private Hashtable<String, Hashtable<String, String>> colAttr = new Hashtable();
    private Hashtable<String, Hashtable<String, String>> dataSet = new Hashtable();
    private int nextRec = 0;
    private int colCount;
    private StringBuffer slWhere = new StringBuffer("");
    private BJTextField bjField;
    private boolean endReached;
    private String sOldCode;
    private String sOldDesc;
    private int gLast = 0;
    private int nLast = 0;
    private int nFirst = 0;
    private int nOrderByCol = 1;
    private String orderByDir = "ASC";
    private String codeSqlColumn = null;
    private String othersSqlColumn = null;
    private String titleExt = "";
    private String[] hideCols;
    private String[] sortCols;
    private TableColumn column = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private TouchTextField jTextField1 = new TouchTextField();
    private TouchTextField jTextField2 = new TouchTextField();
    public JPanel centerPanel = new JPanel();
    public JPanel southPanel = new JPanel();
    public JPanel northPanel = new JPanel();
    private boolean firstTime = true;
    private boolean multi = true;
    private int selectedCol = -1;
    private int selectedRow = -1;
    private SearchTableModel tableModel = new SearchTableModel();
    private VisibleRowTable tableScrollPane = new VisibleRowTable(this.tableModel);
    private DialogButton okButton = new DialogButton(res.getString("Ok"));
    private DialogButton cancelButton = new DialogButton(res.getString("Cancel"));
    private String customNoDataMessage = null;
    private boolean suppressNoDataMessage = false;

    public Hashtable<String, Hashtable<String, String>> getDataSet() {
        return this.dataSet;
    }

    public searchFrame(BJTextField bjField, Cacher cacher, ToServ toserv, long cacheidx, String mandTable, String fromTable, String where, Window parent, String titleExt, String[] hideCols, boolean bMulti, String spOrderByDir, String customNoDataMessage, boolean suppressNoDataMessage) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.hideCols = hideCols;
            this.bjField = bjField;
            this.cacher = cacher;
            this.cacheidx = cacheidx;
            this.toserv = toserv;
            this.mandTable = mandTable;
            this.fromTable = fromTable;
            this.where = where;
            this.titleExt = titleExt;
            this.multi = bMulti;
            this.orderByDir = spOrderByDir;
            this.okButton.setText(res.getString("Ok"));
            this.cancelButton.setText(res.getString("Cancel"));
            this.customNoDataMessage = customNoDataMessage;
            this.suppressNoDataMessage = suppressNoDataMessage;
            this.initUI();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public TouchTable getTable() {
        return this.tableScrollPane.table;
    }

    public Hashtable<String, Hashtable<String, String>> getColumnAttributes() {
        return this.colAttr;
    }

    private String getRealColumnName(int col) {
        Hashtable<String, String> colsHash = this.colAttr.get(col + "");
        return colsHash != null && colsHash.get("COLNAME") != null ? colsHash.get("COLNAME") : "";
    }

    private boolean isAggregateColumn(int col) {
        String colName = this.getRealColumnName(col).toUpperCase();
        return colName.contains("SUM(") || colName.contains("AVG(") || colName.contains("COUNT(") || colName.contains("MAX(") || colName.contains("MIN(");
    }

    private String getColumnSort(int col) {
        Hashtable<String, String> colsHash = this.colAttr.get(col + "");
        return colsHash != null && colsHash.get("COLSORT") != null ? colsHash.get("COLSORT") : "";
    }

    private boolean UsrPopulate() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.slWhere.setLength(0);
        if (this.firstTime & this.multi && this.jTextField1.getText().length() > 0 & this.jTextField1.getText().indexOf(",") > 0) {
            this.slWhere.append(this.codeSqlColumn + " IN (" + this.quoteSplit(this.jTextField1.getText()) + ")");
            this.recordsToFetch = 1024;
        }
        if (this.slWhere.length() == 0) {
            if (this.jTextField1.getText().length() > 0) {
                this.slWhere.append(" UPPER(" + this.codeSqlColumn + ") LIKE UPPER (" + Utils.StrToDBX(this.jTextField1.getText() + "%") + ")");
            }
            if (this.jTextField2.getText().length() > 0) {
                StringTokenizer st = new StringTokenizer(this.jTextField2.getText(), " ");
                int nCount = 0;
                while (st.hasMoreTokens()) {
                    if (nCount == 0) {
                        if (this.slWhere.length() > 0) {
                            this.slWhere.append(" AND ");
                        }
                        this.slWhere.append("(");
                    }
                    if (nCount > 0) {
                        this.slWhere.append(" AND ");
                    }
                    this.slWhere.append(" UPPER(" + this.othersSqlColumn + ") LIKE UPPER (" + Utils.StrToDBX("%" + st.nextToken() + "%") + ")");
                    ++nCount;
                }
                if (nCount > 0) {
                    this.slWhere.append(")");
                }
            }
        }
        this.tableScrollPane.table.getSelectionModel().clearSelection();
        this.tableModel.fireTableRowsDeleted(0, this.gLast);
        this.tableModel.getFirstBlock();
        if (this.multi & this.dataSet.size() > 0 & this.firstTime & this.jTextField1.getText().length() > 0 & this.jTextField1.getText().indexOf(",") > -1) {
            this.tableScrollPane.table.getSelectionModel().setSelectionInterval(0, this.dataSet.size() - 1);
            this.jTextField1.setText("");
        } else if (this.dataSet.size() > 0) {
            this.tableScrollPane.table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.dataSet.size() == 1 && this.firstTime && !this.multi && !this.bjField.getShowSearchForOneResult()) {
            this.ok();
            return false;
        }
        if (this.dataSet.size() == 0 && this.firstTime && !this.multi) {
            if (!this.suppressNoDataMessage) {
                DlgMessage.showMessage(this, StringUtils.nullOrEmptyToValue(this.customNoDataMessage, res.getString("No_Data_Found")), this.getTitle(), 1);
            }
            this.fini();
            return false;
        }
        return true;
    }

    private void initUI() throws Exception {
        int loop;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        if (this.cacher == null) {
            this.closeSearch();
            this.dispose();
            return;
        }
        if (!this.loadCache()) {
            this.closeSearch();
            this.dispose();
            return;
        }
        this.tableScrollPane.setHorizontalScrollBarPolicy(30);
        this.colCount = this.colAttr.size();
        this.codeSqlColumn = this.getRealColumnName(1);
        String tochar = "TO_CHAR(";
        String tochar_bracket = ")";
        if (this.toserv == null) {
            tochar = "";
            tochar_bracket = "";
        }
        this.othersSqlColumn = "";
        for (loop = 2; loop <= this.colCount; ++loop) {
            if (this.isAggregateColumn(loop)) continue;
            if (this.othersSqlColumn.length() > 0) {
                this.othersSqlColumn = this.othersSqlColumn + " || ";
            }
            this.othersSqlColumn = this.othersSqlColumn + "COALESCE(" + tochar + this.getRealColumnName(loop) + tochar_bracket + ", '')";
        }
        this.sortCols = new String[this.colCount];
        for (loop = 0; loop < this.colCount; ++loop) {
            this.sortCols[loop] = this.getColumnSort(loop + 1);
            if (this.sortCols[loop] == null) {
                this.sortCols[loop] = "0";
            }
            if (!this.sortCols[loop].equals("0")) continue;
            this.sortCols[loop] = "UPPER(" + this.getRealColumnName(loop + 1) + ")";
        }
        if (this.colCount == 0) {
            this.closeSearch();
            this.dispose();
        }
        this.getContentPane().setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                searchFrame.this.this_windowClosing(e);
                searchFrame.this.dispose();
            }
        });
        String sCacheName = this.cacher.getCacheName(this.toserv, this.cacheidx);
        if (sCacheName == null) {
            this.closeSearch();
            this.dispose();
            return;
        }
        this.setTitle(res.getString("Search") + " " + sCacheName + " " + this.titleExt);
        this.jTextField1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                searchFrame.this.sOldCode = new String(searchFrame.this.jTextField1.getText());
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (searchFrame.this.jTextField1.getText().compareTo(searchFrame.this.sOldCode) != 0) {
                    searchFrame.this.UsrPopulate();
                }
            }
        });
        this.jTextField2.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                searchFrame.this.sOldDesc = new String(searchFrame.this.jTextField2.getText());
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (searchFrame.this.jTextField2.getText().compareTo(searchFrame.this.sOldDesc) != 0) {
                    searchFrame.this.UsrPopulate();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchFrame.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchFrame.this.okButton_actionPerformed(e);
            }
        });
        this.northPanel.setLayout(new GridBagLayout());
        this.southPanel.setLayout(new GridBagLayout());
        this.southPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.southPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.jTextField1, new GridBagConstraints(0, 0, 1, 1, 0.13, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.northPanel.add((Component)this.jTextField2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.tableScrollPane, "Center");
        this.jTextField1.setText(this.bjField.getText());
        this.tableScrollPane.table.setRequestFocusEnabled(true);
        this.tableModel.fireTableStructureChanged();
        if (!this.UsrPopulate()) {
            return;
        }
        this.tableScrollPane.table.setAutoResizeMode(4);
        if (this.hideCols != null && this.hideCols.length > 0) {
            for (int loop2 = 1; loop2 <= this.colCount; ++loop2) {
                this.markHide(this.getRealColumnName(loop2), loop2 - 1);
            }
        }
        this.setColWidths();
        this.tableScrollPane.table.sizeColumnsToFit(-1);
        if (!this.multi) {
            this.tableScrollPane.table.setSelectionMode(0);
        }
        this.tableScrollPane.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                searchFrame.this.rowFocus(e);
            }
        });
        this.tableScrollPane.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && searchFrame.this.selectedCol > -1 && searchFrame.this.selectedRow > -1 && ((searchFrame)searchFrame.this).tableScrollPane.table.isCellEditable(searchFrame.this.selectedRow, searchFrame.this.selectedCol)) {
                    searchFrame.this.toggleCheckbox(searchFrame.this.selectedRow, searchFrame.this.selectedCol);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    searchFrame.this.ok();
                }
            }
        });
        this.tableScrollPane.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                searchFrame.this.rowClick(e);
            }
        });
        this.tableScrollPane.table.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                searchFrame.this.columnClick(e);
            }
        });
        this.tableScrollPane.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    searchFrame.this.ok();
                } else if (e.getKeyCode() == 27) {
                    searchFrame.this.fini();
                } else if (e.getKeyCode() == 83 && e.isAltDown()) {
                    new FocusRequester(searchFrame.this.jTextField1);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!((searchFrame)searchFrame.this).tableScrollPane.table.hasFocus()) {
                    searchFrame.this.this_keyPressed(e);
                }
            }
        });
        this.tableScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int lastdata;
                int bottom = searchFrame.this.tableScrollPane.getBottomVisibleRow();
                if (bottom > (lastdata = searchFrame.this.dataSet.size()) - searchFrame.this.tableScrollPane.getVisibleRows() - 5) {
                    searchFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    searchFrame.this.tableModel.getNextBlock();
                    searchFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.tableScrollPane.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = ((searchFrame)searchFrame.this).tableScrollPane.table.convertColumnIndexToView(((searchFrame)searchFrame.this).tableScrollPane.table.columnAtPoint(e.getPoint())) + 1;
                if (((searchFrame)searchFrame.this).tableScrollPane.table.isCellEditable(0, col - 1)) {
                    if (searchFrame.this.dataSet != null) {
                        String newVal = null;
                        for (int i = 0; i < searchFrame.this.dataSet.size(); ++i) {
                            Hashtable cols = (Hashtable)searchFrame.this.dataSet.get(String.valueOf(i + 1));
                            if (i == 0) {
                                newVal = cols.get("col" + col) != null && ((String)cols.get("col" + col)).equals("true") ? "false" : "true";
                            }
                            cols.put("col" + col, newVal);
                        }
                    }
                } else {
                    if (col == searchFrame.this.nOrderByCol) {
                        if (searchFrame.this.orderByDir.equals("ASC")) {
                            searchFrame.this.orderByDir = "DESC";
                        } else {
                            searchFrame.this.orderByDir = "ASC";
                        }
                    } else {
                        searchFrame.this.orderByDir = "ASC";
                    }
                    searchFrame.this.nOrderByCol = col;
                    searchFrame.this.UsrPopulate();
                }
            }
        });
        if (this.firstTime) {
            this.firstTime = false;
            if (this.dataSet.size() > 0 & !this.multi) {
                this.requestFocus(this.tableScrollPane.table, 0, 0);
            }
        }
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.jTextField1);
        v.add(this.jTextField2);
        FocusTraversalPolicy ftp = new FocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.initCustomisedUI();
        PosUtils.centreWindow(this);
        this.setVisible(true);
    }

    private void rowClick(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.selectedRow = lsm.getMinSelectionIndex();
        }
    }

    private void columnClick(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.selectedCol = lsm.getMinSelectionIndex();
        }
    }

    private void toggleCheckbox(int row, int col) {
        if (col > -1 && row > -1 && this.tableScrollPane.table.isCellEditable(row, col)) {
            if (this.tableScrollPane.table.getValueAt(row, col).equals("true")) {
                this.tableScrollPane.table.setValueAt("false", row, col);
            } else {
                this.tableScrollPane.table.setValueAt("true", row, col);
            }
        }
    }

    public boolean loadCache() {
        this.cacher.loadCacheSql(this.toserv, this.cacheidx, this.mandTable, this.fromTable, this.where);
        return this.cacher.getColAttribs(this.toserv, this.cacheidx, this.colAttr);
    }

    public void initCustomisedUI() {
    }

    public boolean this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.ok();
        } else if (e.getKeyCode() == 27) {
            this.fini();
        } else if (e.getKeyCode() == 83 && e.isAltDown()) {
            new FocusRequester(this.jTextField1);
        } else if (e.getKeyCode() == 38) {
            if (this.tableScrollPane.table.getSelectedRow() > 0) {
                if (!this.multi) {
                    this.tableScrollPane.table.changeSelection(this.tableScrollPane.table.getSelectedRow() - 1, this.tableScrollPane.table.getSelectedColumn(), true, false);
                } else {
                    this.tableScrollPane.table.setRowSelectionInterval(this.tableScrollPane.table.getSelectedRow() - 1, this.tableScrollPane.table.getSelectedRow() - 1);
                }
            }
        } else if (e.getKeyCode() == 40 && this.tableScrollPane.table.getSelectedRow() < this.tableScrollPane.table.getRowCount() - 1) {
            if (!this.multi) {
                this.tableScrollPane.table.changeSelection(this.tableScrollPane.table.getSelectedRow() + 1, this.tableScrollPane.table.getSelectedColumn(), true, false);
            } else {
                this.tableScrollPane.table.setRowSelectionInterval(this.tableScrollPane.table.getSelectedRow() + 1, this.tableScrollPane.table.getSelectedRow() + 1);
            }
        }
        return true;
    }

    private void markHide(String colName, int columnNum) {
        this.column = this.tableScrollPane.table.getColumnModel().getColumn(columnNum);
        if (Arrays.binarySearch(this.hideCols, colName) > -1) {
            this.column.setMaxWidth(0);
            this.column.setMinWidth(0);
            this.column.setWidth(0);
            this.column.setPreferredWidth(0);
        }
    }

    public double getColumnWidth(int col) {
        Hashtable<String, String> colsHash = this.colAttr.get(col + 1 + "");
        return colsHash != null && colsHash.get("COLWIDTH") != null ? TypConv.toDouble(colsHash.get("COLWIDTH")) : 0.0;
    }

    public int getColumnAlign(int col) {
        Hashtable<String, String> colsHash = this.colAttr.get(col + 1 + "");
        return colsHash != null && colsHash.get("COLALIGN") != null ? TypConv.toInt(colsHash.get("COLALIGN")) : 0;
    }

    private void setColWidths() {
        Dimension screenSize;
        double scWidth;
        int tabWidth = 0;
        int codeWidth = 0;
        int dpi = 110;
        for (int i = 0; i < this.colCount; ++i) {
            this.column = this.tableScrollPane.table.getColumnModel().getColumn(i);
            if (this.column.getPreferredWidth() <= 0) continue;
            double setWidth = this.getColumnWidth(i);
            if (setWidth == 0.0) {
                setWidth = 1.0;
            }
            int actualWidth = (int)(setWidth * (double)dpi);
            this.column.setPreferredWidth(actualWidth);
            int colAlign = this.getColumnAlign(i);
            TouchTableCellRenderer ren = new TouchTableCellRenderer();
            if (colAlign == 0) {
                ren.setHorizontalAlignment(2);
            } else if (colAlign == 1) {
                ren.setHorizontalAlignment(4);
            } else if (colAlign == 2) {
                ren.setHorizontalAlignment(0);
            }
            this.column.setCellRenderer(ren);
            tabWidth += actualWidth;
            if (i != 0) continue;
            codeWidth = actualWidth;
            this.jTextField1.setFieldWidth(actualWidth - 2);
        }
        this.jTextField2.setFieldWidth(tabWidth - codeWidth);
        if (tabWidth < 384) {
            tabWidth = 384;
        }
        if ((scWidth = (double)(tabWidth + 30)) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            scWidth = screenSize.getWidth();
        }
        this.setSize(new Dimension((int)scWidth, 600));
    }

    private void rowFocus(ListSelectionEvent e) {
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.ok();
    }

    private void ok() {
        if (this.bOK) {
            return;
        }
        int row = this.tableScrollPane.table.getSelectedRow();
        StringBuffer idxs = new StringBuffer("");
        StringBuffer codes = new StringBuffer("");
        StringBuffer descs = new StringBuffer("");
        if (row > -1) {
            this.bOK = true;
            idxs.append((String)this.tableModel.getValueAt(row, -1));
            codes.append((String)this.tableModel.getValueAt(row, 0));
            descs.append((String)this.tableModel.getValueAt(row, 1));
            if (this.multi) {
                int[] rowSel = this.tableScrollPane.table.getSelectedRows();
                int selCount = this.tableScrollPane.table.getSelectedRowCount();
                for (int n = 1; n < selCount; ++n) {
                    idxs.append("," + (String)this.tableModel.getValueAt(rowSel[n], -1));
                    codes.append("," + (String)this.tableModel.getValueAt(rowSel[n], 0));
                    descs.append("," + (String)this.tableModel.getValueAt(rowSel[n], 1));
                }
            }
            this.bjField.setFromSearch(idxs.toString(), codes.toString(), descs.toString(), this);
            this.fini();
        }
    }

    void fini() {
        this.closeSearch();
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.fini();
    }

    void this_windowClosing(WindowEvent e) {
        this.closeSearch();
    }

    void closeSearch() {
        this.bjField.searchFinished();
        if (this.tableModel != null) {
            this.tableModel.clearHandle();
        }
        if (this.toserv != null) {
            this.toserv.setSearchurl(false);
        }
        this.dataSet.clear();
    }

    public String quoteSplit(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        StringBuffer s = new StringBuffer("");
        while (st.hasMoreTokens()) {
            if (s.length() > 0) {
                s.append("," + Utils.StrToDBX(st.nextToken()));
                continue;
            }
            s.append(Utils.StrToDBX(st.nextToken()));
        }
        return s.toString();
    }

    public final void requestFocus(JTable table, int row, int column) {
        table.requestFocus();
        table.setRowSelectionInterval(row, row);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    @Override
    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }

    class FocusRequester
    implements Runnable {
        private Component comp;

        public FocusRequester(Component comp) {
            this.comp = comp;
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
        }

        @Override
        public void run() {
            this.comp.requestFocus();
            searchFrame.this.jTextField1.select(0, searchFrame.this.jTextField1.getText().length());
        }
    }

    class SearchTableModel
    extends AbstractTableModel {
        SearchTableModel() {
        }

        @Override
        public int getColumnCount() {
            return searchFrame.this.colCount;
        }

        @Override
        public int getRowCount() {
            return searchFrame.this.dataSet.size();
        }

        @Override
        public String getColumnName(int col) {
            Hashtable colsHash = (Hashtable)searchFrame.this.colAttr.get(String.valueOf(col + 1));
            return colsHash != null && colsHash.get("COLTITLE") != null ? (String)colsHash.get("COLTITLE") : "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (searchFrame.this.dataSet != null && searchFrame.this.dataSet.size() > 0) {
                Hashtable cols = (Hashtable)searchFrame.this.dataSet.get(row + 1 + "");
                return StringUtils.nullToEmpty((String)cols.get("col" + (col + 1)));
            }
            return "0";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Hashtable cols;
            if (row >= this.getRowCount() || col >= this.getColumnCount()) {
                return;
            }
            if (searchFrame.this.dataSet != null && searchFrame.this.dataSet.size() > 0 && (cols = (Hashtable)searchFrame.this.dataSet.get(String.valueOf(row + 1))) != null) {
                cols.put("col" + (col + 1), value.toString());
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Hashtable colsHash = (Hashtable)searchFrame.this.colAttr.get(String.valueOf(col + 1));
            return colsHash != null && colsHash.get("EDITABLE") != null && ((String)colsHash.get("EDITABLE")).equals("true");
        }

        public void clearHandle() {
            if (searchFrame.this.searchHandle != null) {
                searchFrame.this.cacher.clearQH(searchFrame.this.searchHandle, searchFrame.this.toserv);
                searchFrame.this.searchHandle = null;
            }
        }

        public void getFirstBlock() {
            searchFrame.this.endReached = false;
            searchFrame.this.gLast = 0;
            this.clearHandle();
            searchFrame.this.dataSet.clear();
            searchFrame.this.nextRec = 0;
            searchFrame.this.searchHandle = searchFrame.this.cacher.getQueryHandler(searchFrame.this.toserv, searchFrame.this.cacheidx, searchFrame.this.mandTable, searchFrame.this.fromTable, searchFrame.this.where);
            if (searchFrame.this.searchHandle == null) {
                searchFrame.this.recordsToFetch = 40;
                searchFrame.this.endReached = true;
                return;
            }
            if (!searchFrame.this.cacher.startSearch(searchFrame.this.searchHandle, searchFrame.this.toserv, searchFrame.this.cacheidx, searchFrame.this.recordsToFetch, searchFrame.this.slWhere.toString(), searchFrame.this.dataSet, searchFrame.this.sortCols[searchFrame.this.nOrderByCol - 1] + " " + searchFrame.this.orderByDir)) {
                searchFrame.this.recordsToFetch = 40;
                searchFrame.this.endReached = true;
                return;
            }
            searchFrame.this.recordsToFetch = 40;
            this.popVector();
        }

        public void popVector() {
            searchFrame.this.nLast = searchFrame.this.dataSet.size();
            searchFrame.this.nFirst = searchFrame.this.nextRec;
            if (searchFrame.this.nLast >= searchFrame.this.nextRec) {
                this.fireTableRowsInserted(searchFrame.this.nFirst, searchFrame.this.nLast);
            }
            searchFrame.this.gLast = searchFrame.this.nLast;
            searchFrame.this.nextRec = searchFrame.this.nLast + 1;
        }

        public void getNextBlock() {
            if (searchFrame.this.bOK) {
                return;
            }
            if (searchFrame.this.endReached) {
                return;
            }
            boolean gotmore = searchFrame.this.cacher.getNextBlock(searchFrame.this.searchHandle, searchFrame.this.toserv, searchFrame.this.cacheidx, searchFrame.this.dataSet, searchFrame.this.nextRec);
            if (!gotmore) {
                searchFrame.this.endReached = true;
                return;
            }
            if (searchFrame.this.dataSet.size() < searchFrame.this.nextRec) {
                searchFrame.this.endReached = true;
                return;
            }
            this.popVector();
        }
    }
}

