/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import jpos.basscom.utils.CryptoUtils;
import jpos.basscom.utils.Utils;

public class AuthenticationToken {
    private static final byte[] encodingKey = new byte[]{84, -114, 46, -44, 102, -70, 93, 87, -68, 95, 101, 31, 68, 42, 2, -103};
    private static final byte[] authKey = new byte[]{-23, 126, -67, -126, -67, -65, 33, -18, 20, 52, 106, -75, 25, 74, -126, -108, 21, 111, 13, -76, 83, 36, 40, 119, 101, -127, 40, -67, 32, 75, -88, 77};
    private boolean initialised;
    private String proxyName;
    private String proxyPassword;
    private static final int SIGNATURE_LENGTH = 32;
    private static final CryptoUtils.AESKey tokenKey = new CryptoUtils.AESKey(encodingKey, authKey);

    public boolean initialise(String memberName, String memberPassword) {
        this.reset();
        if (memberName == null || memberName.isEmpty()) {
            return false;
        }
        try {
            this.proxyPassword = AuthenticationToken.generateProxyPass(memberPassword);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return false;
        }
        if (this.proxyPassword.length() > 30) {
            this.proxyPassword = this.proxyPassword.substring(0, 30);
        }
        this.proxyName = memberName.replaceAll("[^a-zA-Z0-9_]", "_").toUpperCase(Locale.ROOT);
        this.initialised = true;
        return true;
    }

    public boolean initialiseFromToken(String token) {
        this.reset();
        if (token == null || token.isEmpty()) {
            return false;
        }
        try {
            String plainText = new String(CryptoUtils.decryptAES(Base64.getDecoder().decode(token), tokenKey, 32), StandardCharsets.UTF_8);
            String[] strArray = plainText.split(";");
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            for (int i = 0; i < strArray.length; ++i) {
                String[] keyValue = strArray[i].split("=");
                tokenMap.put(URLDecoder.decode(keyValue[0], StandardCharsets.UTF_8.name()), URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8.name()));
            }
            if (!tokenMap.containsKey("proxyName") || ((String)tokenMap.get("proxyName")).toString().isEmpty() || !tokenMap.containsKey("proxyPassword") || ((String)tokenMap.get("proxyPassword")).toString().isEmpty()) {
                return false;
            }
            this.proxyName = ((String)tokenMap.get("proxyName")).toString();
            this.proxyPassword = ((String)tokenMap.get("proxyPassword")).toString();
            this.initialised = true;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String generateToken() {
        try {
            String token = String.format("proxyName=%s;proxyPassword=%s", this.proxyName != null ? URLEncoder.encode(this.proxyName, StandardCharsets.UTF_8.name()) : "", this.proxyPassword != null ? URLEncoder.encode(this.proxyPassword, StandardCharsets.UTF_8.name()) : "");
            return Base64.getEncoder().encodeToString(CryptoUtils.encryptAES(token.getBytes(StandardCharsets.UTF_8), tokenKey, 32));
        }
        catch (Exception e) {
            Utils.logError(e);
            return "";
        }
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void reset() {
        this.initialised = false;
        this.proxyName = null;
        this.proxyPassword = null;
    }

    private static String generateProxyPass(String memberPass) throws InvalidKeyException, NoSuchAlgorithmException {
        if (memberPass == null) {
            memberPass = "";
        }
        return Base64.getEncoder().encodeToString(CryptoUtils.hmac256GenerateHash(tokenKey.getAuthKey(), memberPass.getBytes(StandardCharsets.UTF_8))).replace('/', '-');
    }
}

