/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.JDialog;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.RestRequest;
import jpos.SP;
import jpos.browser.BrowserControl;
import jpos.capillary.CapillaryCustomer;
import jpos.capillary.CapillaryLoyaltySetup;
import jpos.capillary.CapillaryResult;
import jpos.capillary.CapillaryUtils;
import jpos.logging.RollingLog;

public class DlgCapillaryPerson
extends JDialog
implements AutoCloseable,
KeyEventDispatcher {
    private String baseUrl;
    private BrowserControl browserControl;
    private String username;
    private String password;
    private long peridx;
    private String externalId;
    private String docketNumber;
    private String custJson;
    private CapillaryCustomer customer;
    private PosFrame parent;
    private boolean failedToLoad = false;
    private boolean personSelected = false;

    public DlgCapillaryPerson(PosFrame parent) {
        super(parent, SP.getRS("Loading_dots"), true);
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DlgCapillaryPerson.this.setVisible(false);
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        CapillaryLoyaltySetup setup = new CapillaryLoyaltySetup();
        this.baseUrl = RestRequest.formatBaseURL(setup.getPersonScreenUrl());
        this.username = setup.getUsername();
        this.password = CapillaryUtils.getMd5Password(setup.getPassword());
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.CONFIG, String.format("Capillary PersonScreen URL : %s", setup.getPersonScreenUrl()));
        RollingLog.log(RollingLog.LogType.CAPILLARY, Level.CONFIG, String.format("Capillary LoayalityAPI URL : %s", setup.getLoyaltyApiUrl()));
        this.browserControl = new BrowserControl();
        this.browserControl.getBrowser().set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
            JsObject value = (JsObject)params.frame().executeJavaScript("window");
            value.putProperty("storeportal", (Object)new JavaBridge());
            return InjectJsCallback.Response.proceed();
        }));
        this.browserControl.getBrowser().navigation().on(FrameLoadFailed.class, event -> {
            if (event.frame().isMain()) {
                this.failedToLoad = true;
                this.setVisible(false);
            }
        });
        this.browserControl.getBrowser().on(TitleChanged.class, event -> this.setTitle(event.browser().title()));
        this.add(this.browserControl);
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setSize((int)((double)screenSize.width * 0.8), screenSize.height);
        this.browserControl.initialiseSplitterPosition(screenSize.height);
        PosUtils.centreWindow(this);
    }

    public void setPersonFromAp21(long peridx) {
        this.peridx = peridx;
        this.externalId = CapillaryUtils.getCardNumberFromDatabase(this.peridx);
    }

    private void setPersonFromCapillary(String externalId) {
        this.externalId = externalId;
        this.peridx = CapillaryUtils.getPeridxFromDatabase(externalId);
        if (this.peridx < 0L) {
            this.personSelected = false;
            DlgMessage.showMessage(this, SP.getRS("capillary_failed_GetExternalId"), SP.getRS("capillary_failed_title"), 0);
        } else {
            this.personSelected = true;
        }
    }

    private void setPersonFromCapillaryCust(String custJson) {
        CapillaryResult capillaryResult = CapillaryUtils.loadCapillaryResult(custJson);
        if (capillaryResult == null) {
            this.personSelected = false;
            DlgMessage.showMessage(this, SP.getRS("capillary_failed_GetCustomer"), SP.getRS("capillary_failed_title"), 0);
            return;
        }
        if (!capillaryResult.response.status.success) {
            this.personSelected = false;
            DlgMessage.showMessage(this, capillaryResult.response.status.message, SP.getRS("capillary_failed_title"), 0);
            return;
        }
        this.customer = CapillaryUtils.getCapillaryCustomer(capillaryResult);
        this.externalId = this.customer.getExternalId();
        this.peridx = CapillaryUtils.getPeridxFromDatabase(this.externalId);
        if (this.peridx < 0L) {
            this.personSelected = false;
            DlgMessage.showMessage(this, SP.getRS("capillary_failed_GetExternalId"), SP.getRS("capillary_failed_title"), 0);
        } else {
            this.personSelected = true;
            DlgMessage.showMessage(this, "Capillary external ID has been sent to Ap21 POS: ID = " + this.externalId);
        }
    }

    private void setPersonFromCapillaryCustNew(String custJson) {
        CapillaryResult capillaryResult = CapillaryUtils.loadCapillaryResult(custJson);
        if (capillaryResult == null) {
            this.personSelected = false;
            DlgMessage.showMessage(this, SP.getRS("capillary_failed_GetCustomer"), SP.getRS("capillary_failed_title"), 0);
            return;
        }
        if (!capillaryResult.response.status.success) {
            this.personSelected = false;
            DlgMessage.showMessage(this, capillaryResult.response.status.message, SP.getRS("capillary_failed_title"), 0);
            return;
        }
        this.customer = CapillaryUtils.getCapillaryCustomer(capillaryResult);
        this.externalId = this.customer.getExternalId();
        this.peridx = CapillaryUtils.getPeridxFromDatabase(this.externalId);
        if (this.peridx < 0L) {
            this.personSelected = false;
            DlgMessage.showMessage(this, SP.getRS("capillary_failed_GetExternalId"), SP.getRS("capillary_failed_title"), 0);
        }
    }

    public long getPersonId() {
        return this.peridx;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getDocketNumber() {
        return this.docketNumber;
    }

    public String getCustomerJson() {
        return this.custJson;
    }

    public CapillaryCustomer getCapillaryCustomer() {
        this.setPersonFromCapillaryCustNew(this.custJson);
        return this.customer;
    }

    public void loadPage() {
        String url = this.baseUrl;
        url = url + "?till=" + this.username;
        url = url + "&password=" + this.password;
        this.browserControl.loadURL(url);
    }

    public boolean hasFailedToLoad() {
        return this.failedToLoad;
    }

    public boolean isPersonSelected() {
        return this.personSelected;
    }

    @Override
    public void close() throws Exception {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    public class JavaBridge {
        @JsAccessible
        public void memberProfile_addToSale(String externalId) {
            DlgCapillaryPerson.this.setPersonFromCapillary(externalId);
            DlgCapillaryPerson.this.setVisible(false);
        }

        @JsAccessible
        public void memberProfile_returnToPOS() {
            DlgCapillaryPerson.this.setVisible(false);
        }

        @JsAccessible
        public void memberProfile_loadTransaction(String externalId, String transactionId) {
            DlgCapillaryPerson.this.docketNumber = transactionId;
            DlgCapillaryPerson.this.setPersonFromCapillary(externalId);
            DlgCapillaryPerson.this.setVisible(false);
        }

        @JsAccessible
        public void memberProfile_loadNewCustomer(String customerJson) {
            RollingLog.log(RollingLog.LogType.CAPILLARY, Level.CONFIG, String.format("Cap Cust response : %s", customerJson));
            DlgCapillaryPerson.this.custJson = customerJson;
        }
    }
}

