/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import jpos.DlgReason;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosMenuController;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.StyleLine;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.User;
import jpos.custorder.DespatchInfo;
import jpos.custorder.Product;
import jpos.ui.DialogButton;
import org.jdom.Element;

public class DlgReassignOrderReasons
extends PosDialog {
    private long vhidx;
    private User user;
    private boolean hasRejectedOrder = false;
    private boolean isFromOrderList = false;
    public DespatchInfo despatchInfo = new DespatchInfo();
    GridBagLayout gridBagLayout = new GridBagLayout();
    PosScrollPane scrollPane = new PosScrollPane();
    DialogButton bReassign = new DialogButton("");
    DialogButton bCancel = new DialogButton("");
    PosTable tblProductDetails;
    private TotalsTable tblTotals;
    private List<StyleLine> styleLines;
    public static final int REASSIGN_REASONS = 462;
    public static final int POS_FREE_STOCK_FORMULA_ID = 22;
    public static final String YES_NOTES_MANDATORY = "Yes";
    private static final int TOT_TABLE_TOTAL_ROW = 0;
    private static final int COL_PRODUCT_DETAILS = 0;
    private static final int COL_QUANTITY = 1;
    private static final int COL_FREE_STOCK = 2;
    private static final int COL_PRICE = 3;
    private static final int NUM_COLUMNS = 4;

    public DlgReassignOrderReasons(PosFrame frame, List<StyleLine> styleLines, String title, boolean modal, long vhidx, User user) {
        super(frame, title, modal);
        this.styleLines = styleLines;
        this.vhidx = vhidx;
        this.user = user;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    public DlgReassignOrderReasons(PosFrame frame, String title, boolean modal, long vhidx, User user) {
        super(frame, title, modal);
        this.isFromOrderList = true;
        this.vhidx = vhidx;
        this.styleLines = this.getStyleLines();
        this.user = user;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    void jbInit() throws Exception {
        this.setMinimumSize(new Dimension(800, 600));
        JPanel panelFooter = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        this.getContentPane().setLayout(this.gridBagLayout);
        this.tblProductDetails = new PosTable(this, new ProductDetailsModel(this.styleLines));
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblProductDetails.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row == 0) {
                    if (col == 3) {
                        return new PosDouble(((ProductDetailsModel)DlgReassignOrderReasons.this.tblProductDetails.getModel()).getColumnTotal(col));
                    }
                    if (col == 0) {
                        return StoreParams.res.getString("Total");
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return 1;
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblProductDetails, totalsTableModel);
        this.tblProductDetails.getColumnModel().getColumn(0).setMinWidth(300);
        this.tblProductDetails.getColumnModel().getColumn(1).setMinWidth(80);
        this.tblProductDetails.getColumnModel().getColumn(2).setMinWidth(80);
        this.tblProductDetails.getColumnModel().getColumn(3).setMinWidth(80);
        this.bReassign.setText(StoreParams.res.getString("Reassign"));
        this.bReassign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReassignOrderReasons.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReassignOrderReasons.this.cancelDialog();
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(800, 26));
        this.scrollPane.setPreferredSize(new Dimension(800, 200));
        this.getContentPane().add((Component)panelBody, new GridBagConstraints(0, 0, 3, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelBody.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 3, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelBody.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)panelFooter, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
        panelFooter.add((Component)this.bReassign, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        panelFooter.add((Component)this.bCancel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.scrollPane.getViewport().add((Component)this.tblProductDetails, null);
        PosUtils.centreWindow(this);
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.dispose();
        StringBuffer reasonIdx = new StringBuffer("-1");
        StringBuffer notes = new StringBuffer();
        DlgReason reason = new DlgReason(PosMenuController.getInstance().getOpenFrame(), SP.getRS("Reassign_Order_Reason"), true, 462L, reasonIdx, notes, true, "", 250, SystemSettings.getInstance().getText(SystemSettings.SystemSetting.ORDER_REASSIGNMENT_REASON_REQUIRED).equalsIgnoreCase(YES_NOTES_MANDATORY), false);
        reason.setVisible(true);
        if (!reasonIdx.toString().equals("-1")) {
            Security.OverrideUser overrideUser = new Security.OverrideUser();
            long memidx = overrideUser.getUser() == null ? this.user.getMemidx() : overrideUser.getUser().getMemidx();
            this.frParent.setCursor(StoreParams.waitCursor);
            if (((FrSales)this.frParent).isLoggedIn(false)) {
                HashMap<String, Object> payload = new HashMap<String, Object>();
                payload.put("vhidx", this.vhidx);
                payload.put("memidx", memidx);
                payload.put("widx", this.sParams.getStoreIdx());
                payload.put("reason_rcidx", reasonIdx);
                payload.put("reason_notes", notes);
                payload.put("products", ((ProductDetailsModel)this.tblProductDetails.getModel()).getProducts());
                if (((FrSales)this.frParent).rejectCustOrder(payload)) {
                    if (this.isFromOrderList) {
                        this.hasRejectedOrder = true;
                    } else {
                        ((FrSales)this.frParent).voidTrans(false);
                    }
                    this.frParent.setCursor(StoreParams.normalCursor);
                    this.dispose();
                    return;
                }
            }
            this.frParent.setCursor(StoreParams.normalCursor);
        }
    }

    private List<StyleLine> getStyleLines() {
        Vector<StyleLine> result = new Vector<StyleLine>();
        if (this.vhidx > 0L && this.sParams.checkIConn()) {
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("transaction_skus", this.vhidx + "").getXML();
            if (this.sParams.root != null && this.sParams.root.getName().equals("transaction_skus") && this.sParams.root.getChildren().size() > 0) {
                for (int i = 0; i < this.sParams.root.getChildren().size(); ++i) {
                    Element element0 = (Element)this.sParams.root.getChildren().get(i);
                    StyleLine newLine = new StyleLine(Long.parseLong(element0.getAttribute("skuidx").getValue()), Integer.parseInt(element0.getAttribute("qty").getValue()), SP.sParams, SP.sParams.bUsingSOHInCustOrders);
                    newLine.setPrice(new PosDouble(element0.getAttribute("price").getValue()).doubleValue());
                    result.add(newLine);
                }
            }
        }
        return result;
    }

    public boolean getHasRejectedOrder() {
        return this.hasRejectedOrder;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    private class ProductDetailsModel
    extends AbstractTableModel {
        Vector<Product> products = new Vector();

        public ProductDetailsModel(List<StyleLine> lines) {
            this.products = this.getProductList(lines);
        }

        @Override
        public int getRowCount() {
            return this.products.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return StoreParams.res.getString("Product_Details");
                }
                case 1: {
                    return StoreParams.res.getString("Quantity");
                }
                case 2: {
                    return StoreParams.res.getString("Free_Stock");
                }
                case 3: {
                    return StoreParams.res.getString("Price");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.products.elementAt(rowIndex).getTitle();
                }
                case 1: {
                    return (int)this.products.elementAt(rowIndex).getQuantity();
                }
                case 2: {
                    return (int)this.products.elementAt(rowIndex).getFreeStock();
                }
                case 3: {
                    return new PosDouble(this.products.elementAt(rowIndex).getPrice());
                }
            }
            return "";
        }

        public double getColumnTotal(int col) {
            double totalPrice = 0.0;
            for (Product product : this.products) {
                totalPrice += product.getPrice();
            }
            return totalPrice;
        }

        private Vector<Product> getProductList(List<StyleLine> styleLines) {
            Vector<Product> result = new Vector<Product>();
            for (StyleLine line : styleLines) {
                double outstandingToPacked = line.getQty() - line.getPackedQty();
                if (line.getStkFlag() != 1 || !(outstandingToPacked > 0.0)) continue;
                if (DlgReassignOrderReasons.this.isFromOrderList) {
                    result.add(new Product(outstandingToPacked, line.getFullSkuDescription(), line.getPrice(), String.valueOf(line.getSkuidx()), "", "", line.getStockQuantity(22)));
                    continue;
                }
                result.add(new Product(outstandingToPacked, line.getFullSkuDescription(), line.getNet(), String.valueOf(line.getSkuidx()), "", "", line.getStockQuantity(22)));
            }
            return result;
        }

        public Vector<Product> getProducts() {
            return this.products;
        }
    }
}

