/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.SqlQuery;

public class ServiceLevelAgreement {
    private long slaidx;
    private String code;
    private String name;
    private int warningMins = -1;
    private int criticalMins = -1;
    private int overdueMins = -1;
    private boolean priorityFlag = false;
    private int orderCutoffHour = -1;
    private int despatchCutoffhour = -1;
    private int despatchResumeHour = -1;
    private int daysPriorToExpectedDateToCutoffDespatch = -1;
    private List<DayOfWeek> courierPickupDays;
    private int softCutoffHour = -1;
    private int hardCutoffHour = -1;
    private boolean rejectOrderOnMissedPickup = false;
    private String cutoffWarningMessage;

    public ServiceLevelAgreement(long slaidx) {
        this.slaidx = slaidx;
        this.loadFromDatabase();
    }

    private void loadFromDatabase() {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT R.CODE, R.NAME, COALESCE(P.WARNING_MINUTES, -1) as WARNING_MINUTES, COALESCE(P.CRITICAL_MINUTES, -1) as CRITICAL_MINUTES, COALESCE(P.OVERDUE_MINUTES, -1) as OVERDUE_MINUTES, P.PRIORITY_FLAG, COALESCE(P.CUTOFF_HOUR, -1) as CUTOFF_HOUR, COALESCE(P.DESP_CUTOFF_HOUR, -1) as DESP_CUTOFF_HOUR, COALESCE(P.DESP_RESUME_HOUR, -1) as DESP_RESUME_HOUR, COALESCE(P.CUTOFF_DAYS, -1) as CUTOFF_DAYS, P.PICKUP_DAYS, COALESCE(P.SOFT_CUTOFF, -1) as SOFT_CUTOFF, COALESCE(P.HARD_CUTOFF, -1) as HARD_CUTOFF, P.REMOVE_ORDER_ON_MISS_PICKUP, P.CUTOFF_WARNING_MESSAGE FROM SLA_PARAMETERS P LEFT JOIN REFCODE R ON R.RCIDX = P.SLA_IDX WHERE P.SLA_IDX = " + this.slaidx);){
            if (query.next()) {
                this.code = query.getString("CODE");
                this.name = query.getString("NAME");
                this.warningMins = query.getInt("WARNING_MINUTES");
                this.criticalMins = query.getInt("CRITICAL_MINUTES");
                this.overdueMins = query.getInt("OVERDUE_MINUTES");
                this.priorityFlag = query.getBoolean("PRIORITY_FLAG");
                this.orderCutoffHour = query.getInt("CUTOFF_HOUR");
                this.despatchCutoffhour = query.getInt("DESP_CUTOFF_HOUR");
                this.despatchResumeHour = query.getInt("DESP_RESUME_HOUR");
                this.daysPriorToExpectedDateToCutoffDespatch = query.getInt("CUTOFF_DAYS");
                this.softCutoffHour = query.getInt("SOFT_CUTOFF");
                this.hardCutoffHour = query.getInt("HARD_CUTOFF");
                this.rejectOrderOnMissedPickup = query.getBoolean("REMOVE_ORDER_ON_MISS_PICKUP");
                this.cutoffWarningMessage = query.getString("CUTOFF_WARNING_MESSAGE");
                if (query.getString("PICKUP_DAYS") != null && !query.getString("PICKUP_DAYS").isEmpty()) {
                    this.courierPickupDays = new ArrayList<DayOfWeek>();
                    for (String day : query.getString("PICKUP_DAYS").split(",")) {
                        this.courierPickupDays.add(DayOfWeek.of(Integer.valueOf(day)));
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private boolean isInsideDespatchHours() {
        if (this.despatchCutoffhour < 0 || this.despatchResumeHour < 0) {
            return true;
        }
        Date now = new Date();
        Calendar cutoff = Calendar.getInstance();
        cutoff.setTime(now);
        cutoff.set(11, this.despatchCutoffhour);
        cutoff.set(12, 0);
        cutoff.set(13, 0);
        cutoff.set(14, 0);
        Calendar resume = Calendar.getInstance();
        resume.setTime(cutoff.getTime());
        resume.set(11, this.despatchResumeHour);
        if (this.despatchCutoffhour > this.despatchResumeHour) {
            resume.add(5, 1);
        }
        return now.getTime() < cutoff.getTime().getTime() || now.getTime() >= resume.getTime().getTime();
    }

    public boolean authoriseDespatch(PosFrame parent) {
        if (!this.isInsideDespatchHours()) {
            do {
                DlgMessage dlgMessage = new DlgMessage(parent, SP.getRS("Outside_Despatch_Hours_Title"), MessageFormat.format(SP.getRS("Outside_Despatch_Hours_Message"), this.name, this.format24To12Hour(this.despatchCutoffhour), this.format24To12Hour(this.despatchResumeHour)), 2, 2);
                dlgMessage.getOkButton().setText(SP.getRS("Continue_Booking"));
                dlgMessage.setCloseAction(2);
                int response = dlgMessage.showMessage();
                if (response == 0) continue;
                return false;
            } while (!Security.hasSecurity(parent, 11172L, parent.getUser().getMemidx(), 2, true));
            return true;
        }
        return true;
    }

    public String format24To12Hour(int hour) {
        if (hour < 0 || hour > 23) {
            return "";
        }
        if (hour < 12) {
            if (hour == 0) {
                hour = 12;
            }
            return MessageFormat.format(SP.getRS("Hour_AM"), String.valueOf(hour));
        }
        if (hour > 12) {
            hour -= 12;
        }
        return MessageFormat.format(SP.getRS("Hour_PM"), String.valueOf(hour));
    }

    public static LocalDate getDespatchCutoffDate(ServiceLevelAgreement sla, LocalDate expectedDeliveryDate) {
        if (expectedDeliveryDate == null) {
            return null;
        }
        if (sla.courierPickupDays == null || sla.courierPickupDays.isEmpty()) {
            return null;
        }
        if (sla.daysPriorToExpectedDateToCutoffDespatch == 0 && sla.courierPickupDays.contains(expectedDeliveryDate.getDayOfWeek())) {
            return expectedDeliveryDate;
        }
        LocalDate cutOffDate = null;
        int dayCount = 1;
        int pickupDayCount = 0;
        do {
            if (sla.courierPickupDays.contains((cutOffDate = expectedDeliveryDate.minusDays(dayCount)).getDayOfWeek())) {
                ++pickupDayCount;
            }
            ++dayCount;
        } while (pickupDayCount < sla.daysPriorToExpectedDateToCutoffDespatch || sla.daysPriorToExpectedDateToCutoffDespatch == 0 && pickupDayCount < 1);
        return cutOffDate;
    }

    public LocalDate getDespatchCutoffDate(LocalDate expectedDeliveryDate) {
        return ServiceLevelAgreement.getDespatchCutoffDate(this, expectedDeliveryDate);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getWarningMins() {
        return this.warningMins;
    }

    public int getCriticalMins() {
        return this.criticalMins;
    }

    public int getOverdueMins() {
        return this.overdueMins;
    }

    public boolean isPriorityFlag() {
        return this.priorityFlag;
    }

    public int getOrderCutoffHour() {
        return this.orderCutoffHour;
    }

    public int getDespatchCutoffhour() {
        return this.despatchCutoffhour;
    }

    public int getDespatchResumeHour() {
        return this.despatchResumeHour;
    }

    public boolean getRejectOrderOnMissedPickup() {
        return this.rejectOrderOnMissedPickup;
    }

    public String getCutoffWarningMessage() {
        return this.cutoffWarningMessage;
    }

    public int getSoftCufoffHour() {
        return this.softCutoffHour;
    }

    public int getHardCutoffHour() {
        return this.hardCutoffHour;
    }
}

