/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import jpos.SP;
import jpos.custorder.outstanding.CustomerOrder;
import jpos.custorder.outstanding.IOrderCellValue;

public enum CustomerOrderTableColumn implements IOrderCellValue
{
    IconTimer(0, SP.getRS("CustOrderTableCol_IconTimer"), 250, true, o -> o.getTimerString()),
    OrderType(1, SP.getRS("CustOrderTableCol_OrderType"), 150, true, o -> o.getOrderTypeString()),
    SLA(2, SP.getRS("CustOrderTableCol_SLA"), 200, true, o -> o.getSLA()),
    Status(3, SP.getRS("CustOrderTableCol_Status"), 150, true, o -> o.getOrderStatusString()),
    Pick(4, SP.getRS("CustOrderTableCol_Pick"), 50, false, o -> ""),
    OrderDate(5, SP.getRS("CustOrderTableCol_OrderDate"), 100, true, o -> o.getOrderDateString()),
    CustOrderNum(6, SP.getRS("CustOrderTableCol_CustOrderNum"), 150, true, o -> o.getCustOrderNum()),
    DocketNum(7, SP.getRS("CustOrderTableCol_DocketNum"), 150, true, o -> o.getDocketNum()),
    TransactionNum(8, SP.getRS("CustOrderTableCol_TransactionNum"), 150, true, o -> o.getTransNum()),
    Carrier(9, SP.getRS("CustOrderTableCol_Carrier"), 200, true, o -> o.getCarrier()),
    ServiceType(10, SP.getRS("CustOrderTableCol_ServiceType"), 200, true, o -> o.getServiceType()),
    Customer(11, SP.getRS("CustOrderTableCol_Customer"), 200, true, o -> o.getCustomer()),
    Phone(12, SP.getRS("CustOrderTableCol_Phone"), 150, true, o -> o.getPhone()),
    Email(13, SP.getRS("CustOrderTableCol_Email"), 200, true, o -> o.getEmail()),
    Quantity(14, SP.getRS("CustOrderTableCol_Quantity"), 100, true, o -> Long.toString(o.getQtyToPack()));

    private int id;
    private String name;
    private int width;
    private boolean resizable;
    private IOrderCellValue func;

    private CustomerOrderTableColumn(int id, String name, int width, boolean resizable, IOrderCellValue func) {
        this.id = id;
        this.name = name;
        this.width = width;
        this.resizable = resizable;
        this.func = func;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public Object getValue(CustomerOrder order) {
        return this.func.getValue(order);
    }

    public static CustomerOrderTableColumn getById(int id) {
        for (CustomerOrderTableColumn col : CustomerOrderTableColumn.values()) {
            if (col.getId() != id) continue;
            return col;
        }
        return null;
    }
}

