/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jpos.StringUtils;
import jpos.custorder.outstanding.CustomerOrder;
import jpos.custorder.outstanding.CustomerOrderTableColumn;
import jpos.custorder.outstanding.OrderTypeString;

public class CustomerOrderTableModel
extends AbstractTableModel {
    List<CustomerOrder> orders = new ArrayList<CustomerOrder>();
    List<OrderPickPair> visibleOrders = new ArrayList<OrderPickPair>();
    List<CustomerOrderTableColumn> columns = new ArrayList<CustomerOrderTableColumn>();
    String previousFilter = "";

    @Override
    public int getRowCount() {
        return this.visibleOrders.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this.getColumnType(col) == CustomerOrderTableColumn.Pick) {
            return Boolean.class;
        }
        if (this.getColumnType(col) == CustomerOrderTableColumn.IconTimer) {
            return OrderTypeString.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.getColumnType(col) == CustomerOrderTableColumn.Pick;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.visibleOrders.size() || row < 0) {
            return "";
        }
        CustomerOrderTableColumn column = this.getColumnType(col);
        if (column == null) {
            return "";
        }
        if (column == CustomerOrderTableColumn.Pick) {
            return this.visibleOrders.get(row).getValue();
        }
        CustomerOrder order = this.visibleOrders.get(row).getKey();
        if (order != null) {
            if (column == CustomerOrderTableColumn.IconTimer) {
                return new OrderTypeString(order.getOrderType(), column.getValue(order).toString(), order.getUrgency());
            }
            return column.getValue(order);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.getColumnType(col) == CustomerOrderTableColumn.Pick && row >= 0 || row < this.visibleOrders.size() && value instanceof Boolean) {
            this.visibleOrders.get(row).setValue((Boolean)value);
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public String getColumnName(int col) {
        CustomerOrderTableColumn column = this.getColumnType(col);
        return column != null ? column.getName() : "";
    }

    public CustomerOrderTableColumn getColumnType(int col) {
        if (col >= this.columns.size() || col < 0) {
            return null;
        }
        return this.columns.get(col);
    }

    public void addOrder(CustomerOrder order) {
        this.orders.add(order);
        this.resetFilter();
    }

    public void removeOrder(CustomerOrder order) {
        this.orders.remove(order);
        this.visibleOrders.remove(order);
        this.resetFilter();
    }

    public void addOrders(List<CustomerOrder> orders, boolean overwrite) {
        if (overwrite) {
            this.orders = new ArrayList<CustomerOrder>(orders);
        } else {
            this.orders.addAll(orders);
        }
        this.resetFilter();
    }

    public void addColumn(CustomerOrderTableColumn column) {
        boolean pickExists;
        boolean bl = pickExists = !this.columns.isEmpty() && this.columns.get(this.columns.size() - 1) == CustomerOrderTableColumn.Pick;
        if (!pickExists) {
            this.columns.add(column);
        } else if (column != CustomerOrderTableColumn.Pick) {
            this.columns.add(this.columns.size() - 1, column);
        } else {
            return;
        }
        this.fireTableStructureChanged();
    }

    public CustomerOrder getOrder(int row) {
        if (row >= this.visibleOrders.size() || row < 0) {
            return null;
        }
        return this.visibleOrders.get(row).getKey();
    }

    public int getOrderRow(CustomerOrder order) {
        for (int i = 0; i < this.visibleOrders.size(); ++i) {
            if (this.visibleOrders.get(i).getKey() != order) continue;
            return i;
        }
        return -1;
    }

    public List<String> getOrderDocketsToPrint() {
        List<CustomerOrder> orders = this.getOrdersToPrint();
        ArrayList<String> dockets = new ArrayList<String>();
        for (CustomerOrder order : orders) {
            String docket = order.getDocketNum();
            if (docket.startsWith("D")) {
                docket = docket.substring(1);
            }
            if (docket.length() <= 0) continue;
            dockets.add(docket);
        }
        return dockets;
    }

    public List<CustomerOrder> getOrdersToPrint() {
        ArrayList<CustomerOrder> orders = new ArrayList<CustomerOrder>();
        for (OrderPickPair orderPick : this.visibleOrders) {
            CustomerOrder order = orderPick.getKey();
            if (order == null || !orderPick.getValue().booleanValue()) continue;
            orders.add(order);
        }
        return orders;
    }

    public boolean isPrintColumnVisible() {
        return this.columns.indexOf(CustomerOrderTableColumn.Pick) > -1;
    }

    private void resetFilter() {
        this.visibleOrders.clear();
        for (CustomerOrder order : this.orders) {
            this.visibleOrders.add(new OrderPickPair(order));
        }
        this.fireTableDataChanged();
    }

    public void filter(String searchString) {
        if ((searchString = StringUtils.nullToEmpty(searchString).trim().toUpperCase()).isEmpty()) {
            this.resetFilter();
        } else if (this.previousFilter.isEmpty() || !searchString.contains(this.previousFilter)) {
            this.applyFilter(searchString, false);
        } else if (searchString.startsWith(this.previousFilter)) {
            String[] words = searchString.split("\\s+");
            if (words.length > 0) {
                this.applyFilter(words[words.length - 1], true);
            }
        } else {
            this.applyFilter(searchString, true);
        }
        this.previousFilter = searchString;
    }

    private void applyFilter(String searchString, boolean onExistingFilter) {
        if (onExistingFilter) {
            Iterator<OrderPickPair> iterator = this.visibleOrders.iterator();
            while (iterator.hasNext()) {
                OrderPickPair orderPick = iterator.next();
                if (orderPick.getKey().search(searchString)) continue;
                iterator.remove();
            }
        } else {
            this.visibleOrders.clear();
            for (CustomerOrder order : this.orders) {
                if (!order.search(searchString)) continue;
                this.visibleOrders.add(new OrderPickPair(order));
            }
        }
        this.fireTableDataChanged();
    }

    private static class OrderPickPair
    implements Map.Entry<CustomerOrder, Boolean> {
        CustomerOrder order;
        boolean pick;

        @Override
        public CustomerOrder getKey() {
            return this.order;
        }

        @Override
        public Boolean getValue() {
            return this.pick;
        }

        @Override
        public Boolean setValue(Boolean value) {
            if (this.pick == value) {
                return false;
            }
            this.pick = value;
            return true;
        }

        public OrderPickPair(CustomerOrder order) {
            this.order = order;
            this.pick = false;
        }
    }
}

