/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.scanpack;

import java.awt.Window;
import java.util.List;
import jpos.PosTable;
import jpos.StyleLine;
import jpos.custorder.scanpack.ScanPackResult;
import jpos.custorder.scanpack.ScanPackTableModel;

public class ScanPackTable
extends PosTable {
    ScanPackTableModel model;

    public ScanPackTable(Window parent, ScanPackTableModel model) {
        super(parent, model);
        this.model = model;
        this.init();
    }

    private void init() {
        int width = this.model.showPackColumn() ? 80 : 0;
        this.getColumnModel().getColumn(1).setPreferredWidth(width);
        this.getColumnModel().getColumn(1).setMinWidth(width);
        this.getColumnModel().getColumn(1).setMaxWidth(width);
        width = this.model.showPickupColumn() ? 80 : 0;
        this.getColumnModel().getColumn(2).setPreferredWidth(width);
        this.getColumnModel().getColumn(2).setMinWidth(width);
        this.getColumnModel().getColumn(2).setMaxWidth(width);
        width = this.model.showCancelColumn() ? 80 : 0;
        this.getColumnModel().getColumn(3).setPreferredWidth(width);
        this.getColumnModel().getColumn(3).setMinWidth(width);
        this.getColumnModel().getColumn(3).setMaxWidth(width);
        this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
        this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerCenterRen);
        this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerCenterRen);
        this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerCenterRen);
        this.renderer.setColumnFormat(0, null, 2);
        this.renderer.setColumnFormat(1, null, 0);
        this.renderer.setColumnFormat(2, null, 0);
        this.renderer.setColumnFormat(3, null, 0);
    }

    public void populate(List<StyleLine> styleLines) {
        this.model.populate(styleLines);
    }

    public ScanPackResult packSku(long skuidx) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        return this.model.packSku(skuidx);
    }

    public int packRemaining() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        return this.model.packRemaining();
    }

    public int pickupRemaining() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        return this.model.pickupRemaining();
    }

    public boolean isFullyPacked() {
        int rowCount;
        int totalPacked = this.model.getTotalPacked();
        return totalPacked == (rowCount = this.model.getRowCount());
    }

    public boolean isPartiallyPacked() {
        int totalPacked = this.model.getTotalPacked();
        int rowCount = this.model.getRowCount();
        return totalPacked > 0 && totalPacked != rowCount;
    }

    public boolean isFullyPickedUp() {
        return this.model.getTotalPickup() == this.model.getRowCount();
    }

    public int cancelRemaining() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        return this.model.cancelRemaining();
    }

    public void undoCancel() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.undoCancel();
    }

    public void unpackAll() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.unpackAll();
    }

    public boolean isFullyCancelled() {
        return this.model.getTotalCancelled() == this.model.getRowCount();
    }

    public boolean getHasCustomisation() {
        return this.model.getHasCustomisation();
    }
}

