/*
 * Decompiled with CFR 0.152.
 */
package jpos.kleber;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import jpos.RestRequest;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.logging.RollingLog;
import org.apache.http.client.config.RequestConfig;

public class KleberApi {
    public static final String METHOD_PARAM = "Method";
    public static final String REQUEST_KEY_PARAM = "RequestKey";
    public static final String REQUEST_ID_PARAM = "RequestId";
    public static final String DEPARTMENT_CODE_PARAM = "DepartmentCode";
    public static final String OUTPUT_FORMAT_PARAM = "OutputFormat";
    public static final String EMAIL_ADDRESS_PARAM = "EmailAddress";
    public static final String PHONE_NUMBER_PARAM = "PhoneNumber";
    public static final String PHONE_NUMBER_TIMEOUT_PARAM = "TimeOut";
    public static final String ADDRESS_LINE_PARAM = "AddressLine";
    public static final String ADDRESS_LINE_1_PARAM = "AddressLine1";
    public static final String ADDRESS_LINE_2_PARAM = "AddressLine2";
    public static final String LOCALITY_PARAM_NZ = "Suburb";
    public static final String LOCALITY_PARAM_AU_AND_INT = "Locality";
    public static final String POSTCODE_PARAM = "Postcode";
    public static final String STATE_PARAM_INT = "StateProvince";
    public static final String STATE_PARAM_AU = "State";
    public static final String STATE_PARAM_NZ = "TownCityMailtown";
    public static final String RESULT_LIMIT_PARAM = "ResultLimit";
    public static final String COUNTRY_CODE_PARAM = "DisplayOnlyCountryCode";
    public static final String SEARCH_COUNTRY_CODE = "SearchCountryCode";
    public static final String RECORD_ID_PARAM = "RecordId";
    public static final String LANGUAGE_PARAM = "LanguagePreference";
    public static final String DEPARTMENT_CODE = "POS";
    public static final String JSON_FORMAT = "json";
    public static final String PHONE_NUMBER_TIMEOUT = "5";
    public static final String RESULT_LIMIT = "7";
    public static final String ENDPOINT = "/KleberWebService/DtKleberService.svc/ProcessQueryStringRequest";
    public static final String EMAIL_VERIFICATION_METHOD = "DataTools.Verify.Email.BriteVerify.VerifyEmail";
    public static final String PHONE_VERIFICATION_METHOD = "DataTools.Verify.PhoneNumber.Equifax.VerifyPhoneNumberIsConnected";
    public static final String AU_PAF_SEARCH = "DataTools.Capture.Address.Predictive.AuPaf.SearchAddress";
    public static final String NZ_AD_SEARCH = "DataTools.Capture.Address.Predictive.Nzad.SearchAddress";
    public static final String UK_PAF_SEARCH = "DataTools.Capture.Address.Predictive.UkPaf.SearchAddress";
    public static final String CA_PAF_SEARCH = "DataTools.Capture.Address.Predictive.CaPaf.SearchAddress";
    public static final String INT_PCA_SEARCH = "DataTools.Capture.Address.Predictive.IntPca.SearchAddress";
    public static final String AU_PAF_RETRIEVE = "DataTools.Capture.Address.Predictive.AuPaf.RetrieveAddress";
    public static final String NZ_AD_RETRIEVE = "DataTools.Capture.Address.Predictive.Nzad.RetrieveAddress";
    public static final String CA_PAF_RETRIEVE = "DataTools.Capture.Address.Predictive.CaPaf.RetrieveAddress";
    public static final String UK_PAF_RETRIEVE = "DataTools.Capture.Address.Predictive.UkPaf.RetrieveAddress";
    public static final String INT_PCA_RETRIEVE = "DataTools.Capture.Address.Predictive.IntPca.RetrieveAddress";
    public static final String AU_PAF_REPAIR = "DataTools.Repair.Address.AuPaf.RepairAddress";
    public static final String NZ_PAF_VERIFY = "DataTools.Verify.Address.NzPaf.VerifyAddress";
    public static final String INT_GDC_VERIFY = "DataTools.Verify.Address.IntGdc.VerifyAddress";
    public static final int TIMEOUT = 10000;
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CHARSET_UTF8 = "utf-8";
    private String apiUrl;

    public KleberApi(String apiUrl) {
        this.apiUrl = RestRequest.formatBaseURL(apiUrl) + ENDPOINT;
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.EmailResult> validateEmail(String email, String requestKey) throws KleberApiException {
        Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", EMAIL_VERIFICATION_METHOD);
        params.put(EMAIL_ADDRESS_PARAM, email);
        return this.apiGet(KleberModels.DtResponse.EmailResult.class, params);
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.PhoneResult> validatePhone(String phone, String requestKey) throws KleberApiException {
        Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", PHONE_VERIFICATION_METHOD);
        params.put(PHONE_NUMBER_TIMEOUT_PARAM, PHONE_NUMBER_TIMEOUT);
        params.put(PHONE_NUMBER_PARAM, phone);
        return this.apiGet(KleberModels.DtResponse.PhoneResult.class, params);
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult> searchAddress(String addressLine, String countryCode, String requestKey) throws KleberApiException {
        switch (countryCode) {
            case "AU": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", AU_PAF_SEARCH);
                params.put(ADDRESS_LINE_PARAM, addressLine);
                params.put(RESULT_LIMIT_PARAM, RESULT_LIMIT);
                return this.ConvertToAddressSearchResult(this.apiGet(KleberModels.DtResponse.AuPafSearchResult.class, params));
            }
            case "NZ": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", NZ_AD_SEARCH);
                params.put(ADDRESS_LINE_PARAM, addressLine);
                params.put(RESULT_LIMIT_PARAM, RESULT_LIMIT);
                return this.ConvertToAddressSearchResult(this.apiGet(KleberModels.DtResponse.NzAdSearchResult.class, params));
            }
            case "CA": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", CA_PAF_SEARCH);
                params.put(ADDRESS_LINE_PARAM, addressLine);
                params.put(RESULT_LIMIT_PARAM, RESULT_LIMIT);
                return this.apiGet(KleberModels.DtResponse.AddressSearchResult.class, params);
            }
            case "GB": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", UK_PAF_SEARCH);
                params.put(ADDRESS_LINE_PARAM, addressLine);
                params.put(RESULT_LIMIT_PARAM, RESULT_LIMIT);
                return this.apiGet(KleberModels.DtResponse.AddressSearchResult.class, params);
            }
        }
        Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", INT_PCA_SEARCH);
        params.put(ADDRESS_LINE_PARAM, addressLine);
        params.put(RESULT_LIMIT_PARAM, RESULT_LIMIT);
        params.put(SEARCH_COUNTRY_CODE, countryCode);
        return this.apiGet(KleberModels.DtResponse.AddressSearchResult.class, params);
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressRetrieveResult> retrieveAddress(String recordId, String requestKey) throws KleberApiException {
        if (recordId.startsWith("AuPaf")) {
            Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", AU_PAF_RETRIEVE);
            params.put(RECORD_ID_PARAM, recordId);
            return this.ConvertToAddressRetrieveResult(this.apiGet(KleberModels.DtResponse.AuPafRetrieveResult.class, params));
        }
        if (recordId.startsWith("Nzad")) {
            Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", NZ_AD_RETRIEVE);
            params.put(RECORD_ID_PARAM, recordId);
            return this.ConvertToAddressRetrieveResult(this.apiGet(KleberModels.DtResponse.NzAdRetrieveResult.class, params));
        }
        if (recordId.startsWith("CaPaf")) {
            Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", CA_PAF_RETRIEVE);
            params.put(RECORD_ID_PARAM, recordId);
            return this.ConvertToAddressRetrieveResult(this.apiGet(KleberModels.DtResponse.CaPafRetrieveResult.class, params));
        }
        if (recordId.startsWith("UkPaf")) {
            Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", UK_PAF_RETRIEVE);
            params.put(RECORD_ID_PARAM, recordId);
            return this.ConvertToAddressRetrieveResult(this.apiGet(KleberModels.DtResponse.UkPafRetrieveResult.class, params));
        }
        if (recordId.startsWith("IntPca")) {
            Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", INT_PCA_RETRIEVE);
            params.put(RECORD_ID_PARAM, recordId);
            return this.ConvertToAddressRetrieveResult(this.apiGet(KleberModels.DtResponse.IntPcaRetrieveResult.class, params));
        }
        return null;
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> verifyAddress(KleberModels.DtResponse.Address req, String countryCode, String requestKey) throws KleberApiException {
        switch (countryCode) {
            case "AU": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", AU_PAF_REPAIR);
                params.put(ADDRESS_LINE_1_PARAM, req.AddressLine1);
                params.put(ADDRESS_LINE_2_PARAM, req.AddressLine2);
                params.put(LOCALITY_PARAM_AU_AND_INT, req.City);
                params.put(POSTCODE_PARAM, req.Postcode);
                params.put(STATE_PARAM_AU, req.State);
                return this.ConvertToAddressVerifyResult(this.apiGet(KleberModels.DtResponse.AuPafRepairResult.class, params));
            }
            case "NZ": {
                Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", NZ_PAF_VERIFY);
                params.put(ADDRESS_LINE_1_PARAM, req.AddressLine1);
                params.put(ADDRESS_LINE_2_PARAM, req.AddressLine2);
                params.put(LOCALITY_PARAM_NZ, req.City);
                params.put(POSTCODE_PARAM, req.Postcode);
                params.put(STATE_PARAM_NZ, req.State);
                return this.ConvertToAddressVerifyResult(this.apiGet(KleberModels.DtResponse.NzPafVerifyResult.class, params));
            }
        }
        Map<String, String> params = KleberApi.getBaseParameters(requestKey, "", INT_GDC_VERIFY);
        params.put(ADDRESS_LINE_1_PARAM, req.AddressLine1);
        params.put(ADDRESS_LINE_2_PARAM, req.AddressLine2);
        params.put(LOCALITY_PARAM_AU_AND_INT, req.City);
        params.put(POSTCODE_PARAM, req.Postcode);
        params.put(STATE_PARAM_INT, req.State);
        params.put(COUNTRY_CODE_PARAM, countryCode);
        return this.ConvertToAddressVerifyResult(this.apiGet(KleberModels.DtResponse.IntGdcVerifyResult.class, params));
    }

    private <T extends KleberModels.DtResponse.AuNzSearchResult> KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult> ConvertToAddressSearchResult(KleberModels.KleberResponse<T> searchResult) {
        KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult> response = new KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult>(searchResult);
        searchResult.DtResponse.Result.forEach(x -> response.DtResponse.Result.add(x.toAddressSearchResult()));
        return response;
    }

    private <T extends KleberModels.DtResponse.AddressResult> KleberModels.KleberResponse<KleberModels.DtResponse.AddressRetrieveResult> ConvertToAddressRetrieveResult(KleberModels.KleberResponse<T> retrieveResult) {
        KleberModels.KleberResponse<KleberModels.DtResponse.AddressRetrieveResult> response = new KleberModels.KleberResponse<KleberModels.DtResponse.AddressRetrieveResult>(retrieveResult);
        retrieveResult.DtResponse.Result.forEach(x -> response.DtResponse.Result.add(x.toAddressRetrieveResult()));
        return response;
    }

    private <T extends KleberModels.DtResponse.VerifyResult> KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> ConvertToAddressVerifyResult(KleberModels.KleberResponse<T> retrieveResult) {
        KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> response = new KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult>(retrieveResult);
        retrieveResult.DtResponse.Result.forEach(x -> response.DtResponse.Result.add(x.toAddressVerifyResult()));
        return response;
    }

    private static Map<String, String> getBaseParameters(String requestKey, String requestId, String method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(REQUEST_KEY_PARAM, requestKey);
        params.put(REQUEST_ID_PARAM, requestId);
        params.put(METHOD_PARAM, method);
        params.put(DEPARTMENT_CODE_PARAM, DEPARTMENT_CODE);
        params.put(OUTPUT_FORMAT_PARAM, JSON_FORMAT);
        return params;
    }

    private static Map<String, String> getBaseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", CONTENT_TYPE_JSON);
        headers.put("Accept-Charset", CHARSET_UTF8);
        return headers;
    }

    private <T> KleberModels.KleberResponse<T> apiGet(Class<T> parameterType, Map<String, String> params) throws KleberApiException {
        RestRequest.Response resp;
        RestRequest rest = new RestRequest();
        RequestConfig.Builder config = RequestConfig.custom().setSocketTimeout(10000);
        rest.setConfig(config.build());
        KleberModels.Log log = new KleberModels.Log(params.get(METHOD_PARAM));
        log.setRequest(RestRequest.generateURL(this.apiUrl, params));
        try {
            resp = rest.get(this.apiUrl, params, KleberApi.getBaseHeaders());
            log.setResponse(resp.Content, resp.StatusCode);
        }
        catch (IOException e) {
            log.setException(e);
            throw new KleberApiException(e.getMessage(), e);
        }
        finally {
            RollingLog.log(RollingLog.LogType.KLEBER, Level.INFO, log.toString());
        }
        Gson gson = new Gson();
        if (resp.isSuccess()) {
            return (KleberModels.KleberResponse)gson.fromJson(resp.Content, TypeToken.getParameterized(KleberModels.KleberResponse.class, (Type[])new Type[]{parameterType}).getType());
        }
        KleberModels.ErrorResponse error = !resp.Content.isEmpty() ? (KleberModels.ErrorResponse)gson.fromJson(resp.Content, KleberModels.ErrorResponse.class) : new KleberModels.ErrorResponse("", "", "", resp.StatusCode);
        throw new KleberApiException(error.message);
    }
}

