/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import jpos.DlgMessage;
import jpos.PosComboBox;
import jpos.PosDateField;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.SearchProvider;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.swing.BJTableSel;
import jpos.basscom.swing.BJTextField;
import jpos.labelprinting.ILabelDialog;
import jpos.labelprinting.LabelDialogType;
import jpos.labelprinting.LabelEnums;
import jpos.labelprinting.LabelFormat;
import jpos.labelprinting.LabelFormats;
import jpos.labelprinting.PrinterLabel;
import jpos.labelprinting.PrinterLabelFactory;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.ui.BorderVerifier;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.ProgressPanel;
import jpos.ui.TouchTextField;
import jpos.ui.UIConstants;
import org.jdom.Attribute;
import org.jdom.Element;

public class BulkLabelPrintDlg
extends PosDialog
implements ILabelDialog {
    private LabelDialogType nextDialog = LabelDialogType.NONE;
    private ToServ toserv = null;
    private Cacher cacher;
    private String baseMarkdownWhere;
    private ProgressPanel progressPanel = new ProgressPanel(true);
    private LabelSubHeading labelHeading;
    private LabelNormal labelPriceDate;
    private LabelNormal labelFormat;
    private LabelNormal labelPriceBy;
    private LabelNormal labelMarkdown;
    private LabelNormal labelQty;
    private LabelNormal labelExtra;
    private PosComboBox<LabelFormat> cmbFormat = new PosComboBox<LabelFormat>(new LabelFormats());
    private PosComboBox<LabelEnums.PriceBy> cmbPriceBy = new PosComboBox<LabelEnums.PriceBy>(LabelEnums.PriceBy.values());
    private PosComboBox<LabelEnums.PrintLevel> cmbPrintLevel = new PosComboBox();
    private PosScrollPane selectionsScroll = new PosScrollPane();
    private BJTableSel selectionsTable = new BJTableSel(0);
    private BJTextField searchField = new BJTextField();
    private BJTextField markdownSearchField = new BJTextField();
    private PosDateField priceDate;
    private TouchTextField quantityField;
    private TouchTextField extraField;
    private BorderVerifier verifierMarkdown;
    private BorderVerifier verifierDate;
    private BorderVerifier verifierQty;
    private BorderVerifier verifierExtra;
    private DialogButton singleButton;
    private DialogButton printButton;
    private DialogButton closeButton;

    public BulkLabelPrintDlg(PosFrame parentFrame) {
        super(parentFrame, StoreParams.res.getString("Label_Print_Bulk"), true);
        try {
            this.initialiseScreen();
            this.pack();
            PosUtils.centreWindow(this);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void initialiseScreen() {
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelContent = new JPanel(new GridBagLayout());
        JPanel panelQty = new JPanel(new GridBagLayout());
        JPanel panelPriceByExtra = new JPanel(new GridBagLayout());
        JPanel panelExtra = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.labelHeading = new LabelSubHeading(this.getTitle());
        this.labelPriceDate = new LabelNormal(SP.getRS("Label_Print_Price_Date"));
        this.labelPriceDate.setVisible(false);
        this.labelPriceBy = new LabelNormal(SP.getRS("Label_Print_Bulk_Price_By"));
        this.labelFormat = new LabelNormal(SP.getRS("Label_Print_Format"));
        this.labelQty = new LabelNormal(SP.getRS("Label_Printing_Quantity"));
        this.labelExtra = new LabelNormal(SP.getRS("Label_Print_Bulk_Over_Print"));
        this.labelMarkdown = new LabelNormal(SP.getRS("Label_Print_Bulk_Markdown"));
        if (this.cmbFormat.getItemCount() > 0) {
            this.cmbFormat.setSelectedIndex(0);
        }
        if (this.cmbFormat.getItemCount() <= 1) {
            this.labelFormat.setVisible(false);
            this.cmbFormat.setVisible(false);
        }
        this.cmbFormat.setFieldWidth(140);
        this.cmbFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.populatePrintLevels();
            }
        });
        this.cmbPriceBy.setSelectedItem((Object)LabelEnums.PriceBy.MARKDOWN_START);
        this.cmbPriceBy.setFieldWidth(140);
        this.cmbPriceBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.configurePriceByExtraFields((LabelEnums.PriceBy)((Object)BulkLabelPrintDlg.this.cmbPriceBy.getSelectedItem()));
            }
        });
        this.cmbPrintLevel.setFieldWidth(140);
        this.cmbPrintLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.controlExtraFieldDisplay();
            }
        });
        this.priceDate = new PosDateField(this);
        this.priceDate.setFieldWidth(100);
        SearchPanel priceDateSearchPanel = new SearchPanel(this.priceDate, SearchButton.SearchIcon.CALENDAR);
        this.priceDate.setValue(new Timestamp(new Date().getTime()));
        this.priceDate.setVisible(false);
        this.quantityField = new TouchTextField("");
        this.quantityField.setFieldWidth(100);
        this.quantityField.setDocument(PosUtils.createIntegerValidationDocument(false));
        this.quantityField.setHorizontalAlignment(4);
        this.quantityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BulkLabelPrintDlg.this.quantityField.selectAll();
            }
        });
        this.quantityField.setText("1");
        this.extraField = new TouchTextField("");
        this.extraField.setFieldWidth(100);
        this.extraField.setDocument(PosUtils.createIntegerValidationDocument(false));
        this.extraField.setHorizontalAlignment(4);
        this.extraField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BulkLabelPrintDlg.this.extraField.selectAll();
            }
        });
        this.toserv = new ToServ(this.sParams.conn);
        this.toserv.setSearchProvider(new SearchProvider(this.sParams));
        this.cacher = new Cacher(1L, this.sParams.conn);
        StringBuilder sb = new StringBuilder();
        sb.append("STORE1.WIDX = ");
        sb.append(this.sParams.getStoreIdx());
        sb.append(" AND SYSDATE < COALESCE(M.EFF_DATE_TO, M.EFF_DATE_FROM) + 30");
        sb.append(" AND EXISTS (SELECT 1 FROM RET_MKD_NEGSELLS WHERE MKDIDX = M.MKDIDX AND PRSCIDX = STORE1.PRICESCHEME)");
        this.baseMarkdownWhere = sb.toString();
        this.markdownSearchField.setCache(this.cacher, this.toserv, 3L, "", "WHSE STORE1", this.baseMarkdownWhere);
        this.markdownSearchField.setEditMsgToParent(false);
        this.markdownSearchField.setShowSearchForOneResult(true);
        this.markdownSearchField.setFieldWidth(100);
        SearchPanel markdownSearchPanel = new SearchPanel(this.markdownSearchField);
        this.selectionsScroll.getViewport().add((Component)this.selectionsTable, null);
        this.selectionsTable.setEditMsgToParent(false);
        this.selectionsTable.setToServ(this.toserv);
        this.selectionsTable.setConnection(this.sParams.conn);
        this.selectionsTable.setSearchField(this.searchField);
        this.searchField.setVisible(false);
        this.selectionsTable.setCacher(this.cacher);
        this.selectionsTable.setUsingLongName(true);
        this.selectionsTable.addCache(775L, "STYLE", "", "STYLEIDX", "", "BITAND(S.USAGE,32)=32 " + SP.sParams.sExcludeDefSkusWhere);
        this.selectionsTable.addCache(681L, "C", "", "COLOURIDX", "", "C.TUNIDX IS NULL");
        String[] refParamGrps = StringUtils.nullToEmpty(SystemSettings.getInstance().getText(SystemSettings.SystemSetting.LABEL_PRINTING)).split(",");
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT R.RG_ORD, R.TBLIDX FROM REFTBL R WHERE R.TBLIDX IN (99,21) AND R.RGIDX = ? ORDER BY R.TBLIDX DESC");){
            for (String rgIdxString : refParamGrps) {
                long rgIdx = PosUtils.longVal(rgIdxString);
                if (rgIdx <= 0L) continue;
                stmt.setLong(1, rgIdx);
                try (ResultSet result = stmt.executeQuery();){
                    if (!result.next()) continue;
                    if (result.getInt("TBLIDX") == 99) {
                        this.selectionsTable.addRefGrp(rgIdx, "STYLE", "Style", "REF" + result.getString("RG_ORD"), result.getInt("TBLIDX"), this.sParams.getStoreIdx());
                        continue;
                    }
                    if (result.getInt("TBLIDX") != 21) continue;
                    this.selectionsTable.addRefGrp(rgIdx, "C", "Colour", "REF" + result.getString("RG_ORD"), result.getInt("TBLIDX"), this.sParams.getStoreIdx());
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.selectionsTable.setRowSelectionInterval(0, 0);
        this.selectionsScroll.setPreferredSize(new Dimension(650, UIConstants.TABLE_ROW_HEIGHT * (Math.min(this.selectionsTable.getRowCount(), 5) + 1) + 2));
        this.selectionsTable.hideColumn(BJTableSel.TableColumn.FROM);
        this.selectionsTable.hideColumn(BJTableSel.TableColumn.TO);
        this.selectionsTable.hideColumn(BJTableSel.TableColumn.NULLS);
        this.verifierDate = new BorderVerifier((JComponent)this.priceDate){

            @Override
            public boolean isValid(JComponent input) {
                if (BulkLabelPrintDlg.this.cmbPriceBy.getSelectedItem() == LabelEnums.PriceBy.CUSTOM) {
                    return super.isValid(input);
                }
                return true;
            }
        };
        this.verifierQty = new BorderVerifier((JComponent)this.quantityField){

            @Override
            public boolean isValid(JComponent input) {
                long qty = PosUtils.longVal(((JTextField)input).getText());
                return qty > 0L && qty <= 100L;
            }
        };
        this.verifierMarkdown = new BorderVerifier((JComponent)this.markdownSearchField){

            @Override
            public boolean isValid(JComponent input) {
                if (BulkLabelPrintDlg.this.cmbPriceBy.getSelectedItem() == LabelEnums.PriceBy.MARKDOWN_START || BulkLabelPrintDlg.this.cmbPriceBy.getSelectedItem() == LabelEnums.PriceBy.MARKDOWN_END) {
                    return ((BJTextField)input).getidx() > 0L;
                }
                return true;
            }
        };
        this.verifierExtra = new BorderVerifier((JComponent)this.extraField){

            @Override
            public boolean isValid(JComponent input) {
                if (BulkLabelPrintDlg.this.cmbPrintLevel.getSelectedItem() == LabelEnums.PrintLevel.STOCK_UNIT) {
                    long percent = PosUtils.longVal(((JTextField)input).getText());
                    return percent >= 0L && percent <= 100L;
                }
                return true;
            }
        };
        this.singleButton = new DialogButton("");
        this.singleButton.setText(StoreParams.res.getString("Label_Print_Single_Button"));
        this.singleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.nextDialog = LabelDialogType.SINGLE;
                BulkLabelPrintDlg.this.cancelDialog();
            }
        });
        this.printButton = new DialogButton("");
        this.printButton.setText(StoreParams.res.getString("Alt+P_Print"));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.print();
            }
        });
        this.closeButton = new DialogButton("");
        this.closeButton.setText(StoreParams.res.getString("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkLabelPrintDlg.this.cancelDialog();
            }
        });
        panelMain.add((Component)panelContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 20), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(10, 20, 10, 20), 0, 0));
        this.getContentPane().add(panelMain);
        panelContent.add((Component)this.labelHeading, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.singleButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.labelFormat, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add(this.cmbFormat, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)this.labelPriceBy, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add(this.cmbPriceBy, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panelContent.add((Component)new JLabel(), new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        panelPriceByExtra.add((Component)this.labelPriceDate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelPriceByExtra.add((Component)priceDateSearchPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panelPriceByExtra.add((Component)this.labelMarkdown, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelPriceByExtra.add((Component)markdownSearchPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panelContent.add((Component)panelPriceByExtra, new GridBagConstraints(3, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 20, 0, 0), 0, 0));
        panelContent.add((Component)this.searchField, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.selectionsScroll, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panelContent.add((Component)this.labelQty, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panelQty.add((Component)this.quantityField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelQty.add(this.cmbPrintLevel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panelContent.add((Component)panelQty, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 0), 0, 0));
        panelExtra.add((Component)this.labelExtra, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelExtra.add((Component)this.extraField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panelContent.add((Component)panelExtra, new GridBagConstraints(3, 5, 2, 1, 0.0, 0.0, 13, 0, new Insets(20, 20, 0, 0), 0, 0));
        panelFooter.add((Component)this.printButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        panelFooter.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panelContent.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        panelFooter.add((Component)this.progressPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.configurePriceByExtraFields((LabelEnums.PriceBy)((Object)this.cmbPriceBy.getSelectedItem()));
        this.populatePrintLevels();
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.cmbFormat);
        tabOrder.add(this.cmbPriceBy);
        tabOrder.add(this.markdownSearchField);
        tabOrder.add(this.priceDate);
        tabOrder.add(this.selectionsTable);
        tabOrder.add(this.quantityField);
        tabOrder.add(this.cmbPrintLevel);
        tabOrder.add(this.extraField);
        tabOrder.add(this.printButton);
        tabOrder.add(this.closeButton);
        tabOrder.add(this.progressPanel.getAbortButton());
        tabOrder.add(this.singleButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
    }

    private void configurePriceByExtraFields(LabelEnums.PriceBy priceBy) {
        switch (priceBy) {
            case MARKDOWN_START: 
            case MARKDOWN_END: {
                this.labelPriceDate.setVisible(false);
                this.priceDate.setVisible(false);
                this.labelMarkdown.setVisible(true);
                this.markdownSearchField.setVisible(true);
                this.markdownSearchField.setWhere(this.baseMarkdownWhere + (priceBy == LabelEnums.PriceBy.MARKDOWN_END ? " AND M.EFF_DATE_TO IS NOT NULL" : ""));
                break;
            }
            case CUSTOM: {
                this.labelPriceDate.setVisible(true);
                this.priceDate.setVisible(true);
                this.labelMarkdown.setVisible(false);
                this.markdownSearchField.setVisible(false);
                break;
            }
            default: {
                this.labelPriceDate.setVisible(false);
                this.priceDate.setVisible(false);
                this.labelMarkdown.setVisible(false);
                this.markdownSearchField.setVisible(false);
            }
        }
        this.markdownSearchField.clear();
        this.verifierMarkdown.resetBorder();
        this.priceDate.setValue(new Timestamp(new Date().getTime()));
        this.verifierDate.resetBorder();
    }

    private Vector<PrinterLabel> executeReport(LabelFormat format, int qtyPerUnit, float extraFactor, Timestamp priceDate) throws PrinterLabelFactory.ReportException {
        this.selectionsTable.extract(0);
        String sqlWhere = StringUtils.nullToEmpty(this.selectionsTable.getWhere());
        Long mkdIdx = this.markdownSearchField.getidx();
        if (mkdIdx > 0L) {
            sqlWhere = (!StringUtils.isNullOrEmpty(sqlWhere) ? sqlWhere + " AND " : "") + "P.SKUIDX IN (SELECT COLUMN_VALUE FROM TABLE(MarkDown.GetAffectedSkuIdxs(" + mkdIdx + ", " + this.sParams.getStoreIdx() + ")))";
        }
        LabelEnums.PrintLevel level = this.cmbPrintLevel.getSelectedItem() != null ? (LabelEnums.PrintLevel)((Object)this.cmbPrintLevel.getSelectedItem()) : LabelEnums.PrintLevel.SKU;
        return PrinterLabelFactory.executeBulkLabelReport(format, priceDate, qtyPerUnit, level, extraFactor, sqlWhere, this.frParent.getUser().getMemidx());
    }

    private void writeToDisk(final Vector<PrinterLabel> labels, final long labelCount) {
        this.printButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.singleButton.setEnabled(false);
        this.progressPanel.executeTask(new SwingWorker<Long, Void>(){
            private LabelCount printCount = new LabelCount();
            private boolean showErrorMsg = false;
            private Exception exception = null;

            @Override
            public Long doInBackground() {
                this.setProgress(0);
                for (PrinterLabel label : labels) {
                    block5: {
                        if (this.isCancelled()) break;
                        try {
                            if (!label.writeLabelToFile()) {
                                this.showErrorMsg = true;
                            }
                            break block5;
                        }
                        catch (Exception e) {
                            this.exception = e;
                        }
                        break;
                    }
                    if (label.isCounted()) {
                        this.printCount.addToCount(label.getPrintQuantity());
                    }
                    this.setProgress((int)((double)this.printCount.getCount() / (double)labelCount * 100.0));
                }
                return this.printCount.getCount();
            }

            @Override
            public void done() {
                boolean success = true;
                if (this.exception != null || this.showErrorMsg || this.isCancelled()) {
                    success = false;
                    if (this.exception != null) {
                        PosUtils.logError(this.exception);
                    }
                    if (this.showErrorMsg) {
                        DlgMessage.showMessage(BulkLabelPrintDlg.this, SP.getRS("Label_Print_Failed_to_Print"), SP.getRS("Error"), 0);
                    }
                }
                BulkLabelPrintDlg.this.progressPanel.markAsFinished(success);
                StringBuilder printedMessage = new StringBuilder();
                if (this.printCount.getCount() == 1L) {
                    printedMessage.append(MessageFormat.format(StoreParams.res.getString("Label_Print_X_label_sent_to_printer"), this.printCount.getCount()));
                } else if (this.printCount.getCount() > 0L) {
                    printedMessage.append(MessageFormat.format(StoreParams.res.getString("Label_Print_X_labels_sent_to_printer"), this.printCount.getCount()));
                }
                if (printedMessage.length() > 0) {
                    DlgMessage.showMessage(BulkLabelPrintDlg.this, printedMessage.toString(), BulkLabelPrintDlg.this.getTitle(), 1);
                }
                BulkLabelPrintDlg.this.printButton.setEnabled(true);
                BulkLabelPrintDlg.this.closeButton.setEnabled(true);
                BulkLabelPrintDlg.this.singleButton.setEnabled(true);
            }
        });
    }

    private void print() {
        Vector<PrinterLabel> labels;
        this.progressPanel.reset();
        if (!this.verifyAll()) {
            return;
        }
        Timestamp date = null;
        switch ((LabelEnums.PriceBy)((Object)this.cmbPriceBy.getSelectedItem())) {
            case MARKDOWN_START: 
            case MARKDOWN_END: {
                Attribute dateAttr;
                Element markdown = this.sParams.OnlineQueryProvider.getOnlineQuery("markdown", this.markdownSearchField.getidxStr()).getXML();
                if (markdown != null && (dateAttr = markdown.getAttribute(this.cmbPriceBy.getSelectedItem() == LabelEnums.PriceBy.MARKDOWN_START ? "date_from" : "date_after")) != null) {
                    this.priceDate.getDateFormatter().setTimestampInternal(dateAttr.getValue());
                    date = this.priceDate.getDateFormatter().getTimestamp();
                }
                if (date != null) break;
                DlgMessage.showMessage(this, SP.getRS("Label_Print_Bulk_Error_Markdown"), SP.getRS("Error"), 0);
                return;
            }
            case CUSTOM: {
                date = this.priceDate.getValue();
                break;
            }
            default: {
                date = new Timestamp(new Date().getTime());
            }
        }
        if (date == null) {
            DlgMessage.showMessage(this, SP.getRS("Label_Print_Bulk_Error_Date"), SP.getRS("Error"), 0);
            return;
        }
        int qty = PosUtils.intVal(this.quantityField.getText());
        float extraPercent = this.cmbPrintLevel.getSelectedItem() == LabelEnums.PrintLevel.STOCK_UNIT ? (float)PosUtils.longVal(this.extraField.getText()) / 100.0f : 0.0f;
        try {
            labels = this.executeReport((LabelFormat)this.cmbFormat.getSelectedItem(), qty, 1.0f + extraPercent, date);
        }
        catch (PrinterLabelFactory.ReportException e) {
            if (e.getCause() != null) {
                PosUtils.logError(e.getCause());
            }
            DlgMessage.showMessage(this, e.getMessage(), SP.getRS("Error"), 0);
            return;
        }
        LabelCount labelCount = new LabelCount(labels);
        if (labelCount.getCount() == 0L) {
            DlgMessage.showMessage(this, SP.getRS("Label_Print_Bulk_No_Labels", this.getTitle()));
            return;
        }
        if (DlgMessage.showMessage(this, SP.getRS("Label_Print_Bulk_Confirm", labelCount.getCount()), SP.getRS("Confirm"), 0, 3) != 0) {
            return;
        }
        this.writeToDisk(labels, labelCount.getCount());
    }

    private boolean verifyAll() {
        boolean valid = true;
        StringBuilder error = new StringBuilder();
        if (!this.verifierDate.verify()) {
            error.append(SP.getRS("Label_Print_Bulk_Enter_Date"));
            valid = false;
        }
        if (!this.verifierMarkdown.verify()) {
            if (!valid) {
                error.append('\n');
            }
            error.append(SP.getRS("Label_Print_Bulk_Enter_Markdown"));
            valid = false;
        }
        if (!this.verifierQty.verify()) {
            if (!valid) {
                error.append('\n');
            }
            if (PosUtils.longVal(this.quantityField.getText()) > 100L) {
                error.append(SP.getRS("Label_Print_Max_Quantity"));
            } else {
                error.append(SP.getRS("Label_Print_Enter_Quantity"));
            }
            valid = false;
        }
        if (!this.verifierExtra.verify()) {
            if (!valid) {
                error.append('\n');
            }
            error.append(SP.getRS("Label_Print_Bulk_Invalid_Percent"));
            valid = false;
        }
        if (!valid) {
            DlgMessage.showMessage(this, error.toString(), SP.getRS("Error"), 0);
        }
        return valid;
    }

    @Override
    public void cancelDialog() {
        this.progressPanel.cancelTask();
        this.dispose();
    }

    @Override
    public void okDialog() {
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 80 && e.isAltDown() && this.printButton.isEnabled()) {
            this.printButton.doClick();
            return true;
        }
        return false;
    }

    private void populatePrintLevels() {
        this.cmbPrintLevel.removeAllItems();
        if (this.cmbFormat.getSelectedItem() != null) {
            LabelFormat format = (LabelFormat)this.cmbFormat.getSelectedItem();
            for (LabelEnums.PrintLevel level : format.getPrintLevels()) {
                this.cmbPrintLevel.addItem(level);
            }
        }
        if (this.cmbPrintLevel.getItemCount() == 0) {
            this.cmbPrintLevel.addItem(LabelEnums.PrintLevel.SKU);
        }
        this.cmbPrintLevel.setSelectedIndex(0);
        this.controlExtraFieldDisplay();
    }

    private void controlExtraFieldDisplay() {
        if (this.cmbPrintLevel.getSelectedItem() != null) {
            LabelEnums.PrintLevel level = (LabelEnums.PrintLevel)((Object)this.cmbPrintLevel.getSelectedItem());
            if (level == LabelEnums.PrintLevel.STOCK_UNIT) {
                this.labelExtra.setVisible(true);
                this.extraField.setVisible(true);
            } else {
                this.labelExtra.setVisible(false);
                this.extraField.setText("");
                this.extraField.setVisible(false);
                this.verifierExtra.resetBorder();
            }
        }
    }

    @Override
    public LabelDialogType getNextDialogType() {
        return this.nextDialog;
    }

    @Override
    public void showDialog() {
        this.setVisible(true);
    }

    private static class LabelCount {
        long count = 0L;

        private LabelCount() {
        }

        private LabelCount(Vector<PrinterLabel> labels) {
            for (PrinterLabel label : labels) {
                if (!label.isCounted()) continue;
                this.addToCount(label.getPrintQuantity());
            }
        }

        private void addToCount(long count) {
            this.count += count;
        }

        private long getCount() {
            return this.count;
        }
    }
}

