/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.io.FileNotFoundException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SkuPrice;
import jpos.labelprinting.LabelWriter;
import jpos.labelprinting.PcxImage;
import jpos.labelprinting.PrinterLabel;

public class SkuLabel
extends PrinterLabel {
    private long skuidx;
    private String styleCode;
    private String colourCode;
    private String colourName;
    private String sizeValue;
    private String styleName;
    private String defaultBarcode;
    private double origPrice = 0.0;
    private double price = 0.0;
    private Vector<NameValuePair> lowPriceValues = new Vector();
    private double previousPrice = 0.0;
    private PcxImage labelLogoImage;
    private Timestamp priceDate;
    private boolean detailsLoaded = false;
    private SkuPrice skuPrice;

    public SkuLabel(long skuidx, String styleCode, String colourCode, String colourName, String sizeValue, String styleName, String defaultBarcode, Timestamp priceDate) {
        this.skuidx = skuidx;
        this.styleCode = styleCode;
        this.colourCode = colourCode;
        this.colourName = colourName;
        this.sizeValue = sizeValue;
        this.styleName = styleName;
        this.defaultBarcode = defaultBarcode;
        this.priceDate = priceDate;
    }

    @Override
    public boolean writeLabelToFile() {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        String template = this.getLabelFormat().getTemplate(this.price < this.origPrice);
        this.loadTemplateSpecificDetails(template);
        LabelWriter writer = new LabelWriter(template);
        writer.setEscapeStrings(SP.sParams.getEscapeLabelPrintStrings());
        writer.addValue("BARCODE", this.defaultBarcode);
        if (this.defaultBarcode.equals("")) {
            writer.addValue("EAN13_NO_CHECKDIGIT", "");
            writer.addValue("EAN13_CHECK_DIGIT", "");
        } else {
            writer.addValue("EAN13_NO_CHECKDIGIT", this.defaultBarcode.substring(0, Math.min(12, this.defaultBarcode.length())));
            writer.addValue("EAN13_CHECK_DIGIT", this.defaultBarcode.substring(this.defaultBarcode.length() - 1));
        }
        writer.addValue("STYLE_CODE", this.styleCode);
        writer.addValue("STYLE_NAME", this.styleName);
        writer.addValue("COLOUR_CODE", this.colourCode);
        writer.addValue("COLOUR_NAME", this.colourName);
        writer.addValue("SIZE_VALUE", this.sizeValue);
        writer.addValue("PRICE", PosDouble.valueOf(this.price).toString());
        PosDateFormatter dateFormatter = new PosDateFormatter(this.priceDate);
        dateFormatter.setFormat(3, 0);
        writer.addValue("PRICE_DATE", dateFormatter.toString());
        writer.addValue("ORIG_PRICE", PosDouble.valueOf(this.origPrice).toString());
        writer.addValue("PREVIOUS_PRICE", PosDouble.valueOf(this.previousPrice).toString());
        for (NameValuePair pair : this.lowPriceValues) {
            writer.addValue(pair.getName(), PosDouble.valueOf(pair.getValue()).toString());
        }
        if (this.labelLogoImage != null) {
            writer.addValue("IMAGE_WIDTH", String.valueOf(this.labelLogoImage.getWidth()));
            writer.addValue("IMAGE_HEIGHT", String.valueOf(this.labelLogoImage.getHeight()));
            writer.addValue("IMAGE_LINE", String.valueOf(this.labelLogoImage.getTotalBytesPerLine()));
            writer.addValue("IMAGE_SIZE", String.valueOf(this.labelLogoImage.getTotalByteCount()));
            writer.addValue("IMAGE_DATA", String.valueOf(PcxImage.getByteArrayAsHexString(this.labelLogoImage.getImageData())));
        }
        return writer.sendLabelToDestination(this.getPrintQuantity());
    }

    public long getSkuidx() {
        return this.skuidx;
    }

    public String getStyleCode() {
        return this.styleCode;
    }

    public String getColourCode() {
        return this.colourCode;
    }

    public String getColourName() {
        return this.colourName;
    }

    public String getSizeValue() {
        return this.sizeValue;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getDefaultBarcode() {
        return this.defaultBarcode;
    }

    public double getOrigPrice() {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        return this.origPrice;
    }

    public void setOrigPrice(double origPrice) {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        this.origPrice = origPrice;
    }

    public double getPrice() {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        return this.price;
    }

    public void setPrice(double price) {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        this.price = price;
    }

    public double getPreviousPrice() {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        return this.previousPrice;
    }

    public void setPreviousPrice(double previousPrice) {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        this.previousPrice = previousPrice;
    }

    public PcxImage getLabelLogoImage() {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        return this.labelLogoImage;
    }

    public void loadDetails() {
        this.skuPrice = new SkuPrice(this.skuidx);
        this.price = this.skuPrice.getPrice(this.priceDate);
        this.origPrice = this.skuPrice.getOrigPrice();
        this.previousPrice = this.skuPrice.getPreviousPrice(this.priceDate);
        this.loadLabelImage(SP.sParams.imagepath + Settings.getLabelLogoImage());
        this.detailsLoaded = true;
    }

    private void loadTemplateSpecificDetails(String template) {
        if (!this.detailsLoaded) {
            this.loadDetails();
        }
        Calendar cal = Calendar.getInstance();
        Matcher matcher = Pattern.compile("\\{(([0-9]+)_MONTH_LOW_PRICE)\\}", 2).matcher(template);
        while (matcher.find()) {
            boolean keyExists = false;
            for (NameValuePair pair : this.lowPriceValues) {
                if (!pair.getName().equalsIgnoreCase(matcher.group(1))) continue;
                keyExists = true;
                break;
            }
            if (keyExists) continue;
            cal.setTime(this.priceDate);
            cal.add(2, -1 * Integer.parseInt(matcher.group(2)));
            this.lowPriceValues.add(new NameValuePair(matcher.group(1), this.skuPrice.getLowestPriceBetween(new Timestamp(cal.getTimeInMillis()), this.priceDate, true)));
        }
    }

    private void loadLabelImage(String labelLogoImageFileName) {
        try {
            this.labelLogoImage = new PcxImage(labelLogoImageFileName);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public boolean isCounted() {
        return true;
    }

    private class NameValuePair {
        private String name;
        private double value;

        public NameValuePair(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }
    }
}

