/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.FrSales;
import jpos.PosUtils;
import jpos.SP;
import jpos.ui.StatusButton;
import jpos.ui.TouchTextField;

public abstract class PayDialog
extends JDialog
implements KeyEventDispatcher {
    protected boolean isRunning = false;
    public FrSales frSales = null;
    protected JPanel panelAll = new JPanel();
    protected boolean result;
    int kedCount = 0;
    protected static final int PAD0 = 0;
    protected static final int PAD1 = 5;
    protected static final int PAD2 = 10;
    protected static final int PAD3 = 20;
    Component initComp;
    private boolean stealthModeDone = false;

    public PayDialog(Frame parentFrame, String title) {
        super(parentFrame, title, true);
        if (parentFrame instanceof FrSales) {
            this.frSales = (FrSales)parentFrame;
        }
        this.jbInit();
    }

    private void jbInit() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PayDialog.this.cancelDialog();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PayDialog.this.setLastAction();
                PayDialog.this.thisKeyPressed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PayDialog.this.setLastAction();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PayDialog.this.setLastAction();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (PayDialog.this.initComp != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (PayDialog.this.initComp != null) {
                                PayDialog.this.initComp.requestFocusInWindow();
                            }
                        }
                    });
                }
            }
        });
    }

    public void setAmtFieldProp(TouchTextField tf) {
        tf.setFieldWidth(160);
    }

    public void setDateFieldProp(TouchTextField tf) {
        tf.setFieldWidth(110);
    }

    public void setOkButton(StatusButton bOk) {
        bOk.setText(SP.getRS("ok"));
        bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PayDialog.this.isRunning && PayDialog.this.isVisible()) {
                    PayDialog.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PayDialog.this.okDialog();
                            PayDialog.this.isRunning = false;
                        }
                    });
                }
            }
        });
    }

    public void setCancelButton(StatusButton bCancel) {
        bCancel.setText(SP.getRS("cancel"));
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PayDialog.this.isRunning && PayDialog.this.isVisible()) {
                    PayDialog.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PayDialog.this.cancelDialog();
                            PayDialog.this.isRunning = false;
                        }
                    });
                }
            }
        });
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive() && this.isVisible()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (!this.initDialog()) {
                return;
            }
            this.result = false;
            FocusTraversalPolicy ftp = this.getFocusTraversalPolicy();
            this.initComp = ftp.getInitialComponent(this);
            if (this.kedCount == 0) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
                ++this.kedCount;
            }
        } else {
            try {
                if (this.kedCount > 0) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                    --this.kedCount;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.stealthModeDone && this.inStealthMode()) {
            if (visible) {
                this.stealthModeAction();
            }
        } else {
            super.setVisible(visible);
        }
    }

    public boolean initDialog() {
        PosUtils.centreWindow(this);
        return true;
    }

    protected synchronized boolean thisKeyPressed(KeyEvent e) {
        boolean actionPerformed = this.myKeyPressed(e);
        if (!actionPerformed) {
            if (e.getKeyCode() == 112 && SP.sParams != null) {
                SP.sParams.runHelp();
                actionPerformed = true;
            } else if (e.getKeyCode() == 27) {
                this.cancelDialog();
                actionPerformed = true;
            } else if (e.getKeyCode() == 10) {
                this.okDialog();
                actionPerformed = true;
            }
        }
        return actionPerformed;
    }

    protected void setLastAction() {
        if (this.frSales != null) {
            this.frSales.setLastAction();
        }
    }

    public void cancelDialog() {
        this.result = false;
        this.setVisible(false);
    }

    public void okDialog() {
        this.result = true;
        this.setVisible(false);
    }

    public boolean getResult() {
        return this.result;
    }

    protected abstract boolean myKeyPressed(KeyEvent var1);

    protected boolean inStealthMode() {
        return false;
    }

    protected void stealthModeAction() {
    }

    public void setStealthModeDone(boolean stealthModeDone) {
        this.stealthModeDone = stealthModeDone;
    }
}

