/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Color;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.PosDateFormatter;
import jpos.SP;
import jpos.pay.PayType;
import jpos.pay.RetTranP;
import jpos.ui.Colours;

public class PayHistTM
extends AbstractTableModel {
    private Vector<RetTranP> vRetTranPs = new Vector();
    static final int COL_DATE = 0;
    static final int COL_TENDER = 1;
    static final int COL_DETAILS = 2;
    static final int COL_AMT = 3;
    static final int COL_COUNT = 4;

    public void setRetTranPs(Vector<RetTranP> pvRetTranPs) {
        this.vRetTranPs = pvRetTranPs;
        this.fireTableDataChanged();
    }

    public Vector<RetTranP> getRetTranPs() {
        return this.vRetTranPs;
    }

    public double getTotal() {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            total += this.vRetTranPs.get(line).getAmount();
        }
        return PayType.roundDec(total);
    }

    @Override
    public int getRowCount() {
        return this.vRetTranPs.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.vRetTranPs.size() | row < 0) {
            return "";
        }
        RetTranP payment = this.vRetTranPs.get(row);
        switch (col) {
            case 0: {
                return new PosDateFormatter(payment.tranDate == null ? new Timestamp(new Date().getTime()) : new Timestamp(payment.tranDate.getTime()), 3, 3, 0);
            }
            case 1: {
                return payment.getPayType().code;
            }
            case 2: {
                return payment.getTMDetails();
            }
            case 3: {
                return payment.getTMAmount();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return SP.getRS("date");
            }
            case 1: {
                return SP.getRS("tender");
            }
            case 2: {
                return SP.getRS("details");
            }
            case 3: {
                return SP.getRS("amount");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return PosDateFormatter.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Color getDisplayForegroundAt(Object value, int row, int column) {
        return Colours.BLACK;
    }

    public void appendPayment(RetTranP pmt) {
        this.vRetTranPs.add(pmt);
    }

    public void deleteRow(int row) {
        this.vRetTranPs.remove(row);
    }

    public void deleteAllRows() {
        this.vRetTranPs.removeAllElements();
    }

    public RetTranP getPayment(int line) {
        return this.vRetTranPs.get(line);
    }

    public Color getForground(int line) {
        Color c = null;
        if (this.vRetTranPs.get(line).isChange() || this.vRetTranPs.get(line).isRounding()) {
            c = Colours.RED;
        }
        return c;
    }
}

