/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import bass.eftpos.TransactionMode;
import java.awt.Color;
import java.awt.Window;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.PosUtils;
import jpos.SP;
import jpos.basscom.IntBuffer;
import jpos.pay.PayType;
import jpos.pay.RetTranP;
import jpos.pay.eftpos.EftposUtils;
import jpos.ui.Colours;

public class PaymentTM
extends AbstractTableModel {
    private Vector<RetTranP> vRetTranPs = new Vector();
    static final int COL_STATUS = 0;
    static final int COL_TENDER = 1;
    static final int COL_DETAILS = 2;
    static final int COL_AMT = 3;
    static final int COL_COUNT = 4;

    @Override
    public int getRowCount() {
        return this.vRetTranPs.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.vRetTranPs.size() | row < 0) {
            return "";
        }
        RetTranP payment = this.vRetTranPs.get(row);
        switch (col) {
            case 0: {
                return new Integer(payment.getEFTStatus());
            }
            case 1: {
                String tender = payment.getPayType().code;
                if (payment.getEftMode() == TransactionMode.MOTO) {
                    tender = tender + MessageFormat.format(" ({0})", SP.getRS("TransactionMode_MOTO_Short"));
                }
                return tender;
            }
            case 2: {
                return payment.getTMDetails();
            }
            case 3: {
                return payment.getTMAmount();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return SP.getRS("tender");
            }
            case 2: {
                return SP.getRS("details");
            }
            case 3: {
                return SP.getRS("amount");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<Object> dataType = super.getColumnClass(column);
        if (column == 3) {
            dataType = Float.class;
        }
        return dataType;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Color getDisplayForegroundAt(Object value, int row, int column) {
        return Colours.BLACK;
    }

    public void appendPayment(RetTranP pmt) {
        this.vRetTranPs.add(pmt);
        this.fireTableRowsInserted(this.vRetTranPs.size() - 1, this.vRetTranPs.size() - 1);
    }

    public void deleteChgRnd() {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP pmt = this.getRetTranP(line);
            if (pmt.getPayType().isEFT && pmt.getEFTStatus() == 3 || !pmt.isChange() && !pmt.isRounding()) continue;
            this.deleteRow(line);
        }
    }

    public double getTotal(PayType pPayType) {
        return this.getTotal(pPayType.idx);
    }

    public double getTotal(long pPayType) {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP rtp = this.getRetTranP(line);
            if (rtp.getPayType().idx != pPayType) continue;
            total += rtp.getAmount();
        }
        return PayType.roundDec(total);
    }

    public double getTotalCashout() {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP rtp = this.getRetTranP(line);
            if (!rtp.getPayType().isEFT) continue;
            total += rtp.getCashout();
        }
        return PayType.roundDec(total);
    }

    public double getTotalNoChange(PayType pPayType) {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP rtp = this.getRetTranP(line);
            if (rtp.getPayType() != pPayType || rtp.isChange()) continue;
            total += rtp.getAmount();
        }
        return PayType.roundDec(total);
    }

    public double getTotalNoChange() {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            RetTranP rtp = this.getRetTranP(line);
            if (rtp.isChange() || rtp.isRounding()) continue;
            total += rtp.getAmount();
        }
        return PayType.roundDec(total);
    }

    public double getTotal() {
        double total = 0.0;
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            total += this.getRetTranP(line).getAmount();
        }
        return PayType.roundDec(total);
    }

    public boolean getAccountLineExists() {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            if (!this.getRetTranP((int)line).getPayType().isAccount) continue;
            return true;
        }
        return false;
    }

    public boolean getEFTLineExists() {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            if (!this.getRetTranP((int)line).getPayType().isEFT) continue;
            return true;
        }
        return false;
    }

    public boolean getPayTypeLineExists(long payTypeIdx) {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            if (this.getRetTranP((int)line).getPayType().idx != payTypeIdx) continue;
            return true;
        }
        return false;
    }

    public boolean getWalletPayLineExists() {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            if (!this.getRetTranP((int)line).getPayType().isEftposWltPay) continue;
            return true;
        }
        return false;
    }

    public void deleteRow(int row) {
        this.vRetTranPs.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void deleteRow(RetTranP pRetTranP) {
        for (int line = this.getRowCount() - 1; line >= 0; --line) {
            if (this.getRetTranP(line) != pRetTranP) continue;
            this.vRetTranPs.remove(line);
            this.fireTableRowsDeleted(line, line);
            break;
        }
    }

    public void deleteAllRows() {
        this.vRetTranPs.removeAllElements();
        this.fireTableDataChanged();
    }

    public boolean dbInsertRetTranPs(Window parent, Connection con, long pVHIdx, IntBuffer sequence) {
        boolean success = true;
        for (int row = 0; row < this.vRetTranPs.size(); ++row) {
            if (this.vRetTranPs.get(row).dbInsert(parent, con, pVHIdx, sequence)) continue;
            success = false;
        }
        return success;
    }

    public boolean dbUpdateRetTranPs(Window parent, Connection con, long pVHIdx) {
        boolean bOk = false;
        IntBuffer sequence = new IntBuffer();
        StringBuffer validVSHIdxs = new StringBuffer();
        for (int row = 0; row < this.vRetTranPs.size(); ++row) {
            sequence.setValue(row + 100);
            RetTranP retTranP = this.vRetTranPs.get(row);
            if (retTranP.vshIdx.isNull() ? !retTranP.dbInsert(parent, con, pVHIdx, sequence) : !retTranP.dbUpdate(parent, con, sequence)) {
                return false;
            }
            if (row == 0) {
                validVSHIdxs.append(retTranP.vshIdx);
                continue;
            }
            validVSHIdxs.append("," + retTranP.vshIdx);
        }
        EftposUtils.debugPoint(parent, "Deactivating removed payments...");
        EftposUtils.debugPoint(parent, PosUtils.getDatabaseColumnAsText(SP.sParams.conn, "RET_TRANP", "VSHIDX", "VHIDX = " + pVHIdx + " and VSHIDX not in(" + validVSHIdxs.toString() + ") and SEQUENCE_NUMBER > 99"));
        try (PreparedStatement stmt = con.prepareStatement("UPDATE RET_TRANP SET \"ACTIVE\" = 0 WHERE VHIDX = ? and VSHIDX not in(" + validVSHIdxs.toString() + ") and SEQUENCE_NUMBER > 99");){
            stmt.setLong(1, pVHIdx);
            stmt.execute();
            bOk = true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return bOk;
    }

    public RetTranP getRetTranP(int line) {
        return this.vRetTranPs.get(line);
    }

    public Vector<RetTranP> getRetTranPs() {
        return this.vRetTranPs;
    }

    public void setRetTranPs(Vector<RetTranP> v) {
        this.vRetTranPs = v;
    }

    public Color getForground(int line) {
        Color c = null;
        try {
            RetTranP retTranP;
            if (line >= 0 && line < this.getRowCount() && ((retTranP = this.vRetTranPs.get(line)).isChange() || retTranP.isRounding() || retTranP.getPayType().idx == 647L)) {
                c = Colours.RED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }
}

