/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.SocketTimeoutException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.kleber.KleberUtils;
import jpos.pay.PayUtils;
import jpos.person.Country;
import jpos.person.PhoneNumberField;
import jpos.ui.FormButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.LabelSubHeadingStrong;
import jpos.ui.TouchToggleButton;
import jpos.ui.ValidationIconPanel;

public class ReceiptDeliveryMethodDlg
extends PosDialog {
    private int MAX_FIELD_LENGTH = 250;
    private JPanel panel = new JPanel();
    private TouchToggleButton bPrint = new TouchToggleButton();
    private TouchToggleButton bEmail = new TouchToggleButton();
    private StringField tfEmail = new StringField(250);
    private ValidationIconPanel paEmail = new ValidationIconPanel(this.tfEmail);
    private TouchToggleButton bSMS = new TouchToggleButton();
    private PhoneNumberField tfSMS = new PhoneNumberField(new Country("", ""), this.MAX_FIELD_LENGTH, true){

        @Override
        public void validationPassed() {
            if (ReceiptDeliveryMethodDlg.this.paSMS != null) {
                ReceiptDeliveryMethodDlg.this.paSMS.clear();
            }
        }

        @Override
        public void validationFailed(String message) {
            if (ReceiptDeliveryMethodDlg.this.paSMS != null) {
                ReceiptDeliveryMethodDlg.this.paSMS.showError(message);
            }
        }
    };
    private ValidationIconPanel paSMS = new ValidationIconPanel(this.tfSMS);
    private FormButton bOk = new FormButton("", this);
    private LabelSubHeading lableTitle = new LabelSubHeading();
    private LabelSubHeadingStrong errLabel = new LabelSubHeadingStrong();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private String emailAddress;
    private String phoneNumber;
    private String originalEmailAddress;
    private String originalPhoneNumber;
    private Country country;
    private PayUtils.ReceiptDeliveryMethod deliveryMethod = PayUtils.ReceiptDeliveryMethod.EMAIL_ONLY;

    public ReceiptDeliveryMethodDlg(PosFrame frame, PayUtils.ReceiptDeliveryMethod defaultDeliveryMethod, boolean emailActive, boolean smsActive, String origEmail, String origPhone, String country) {
        super(frame, SP.getRS("Receipt_Delivery_Method_Title"), true);
        this.setCancelOnEscape(false);
        this.setDefaultCloseOperation(0);
        try {
            this.Init(defaultDeliveryMethod, emailActive, smsActive, origEmail, origPhone, country);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 118) {
            this.bEmail.doClick();
        } else if (e.getKeyCode() == 119) {
            this.bSMS.doClick();
        } else if (e.getKeyCode() == 120) {
            this.bPrint.doClick();
        } else if (e.getKeyCode() == 121) {
            this.bOk.doClick();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void okDialog() {
        if (this.validateText()) {
            this.emailAddress = this.tfEmail.getText();
            this.phoneNumber = this.tfSMS.getText();
            this.phoneNumber = this.tfSMS.formatThenCleanTextPhoneNumber(this.tfSMS.getPhoneNumberWithInternationalPrefix(this.phoneNumber));
            if (this.frParent instanceof FrSales) {
                ((FrSales)this.frParent).setFilledEmail("");
            }
            this.dispose();
        }
    }

    @Override
    public void cancelDialog() {
    }

    void Init(PayUtils.ReceiptDeliveryMethod defaultDeliveryMethod, boolean emailActive, boolean smsActive, String origEmail, String origPhone, String cntry) throws Exception {
        this.country = cntry == null || cntry.trim().isEmpty() ? PosUtils.getCountryOfOrigin() : new Country(cntry);
        this.panel.setLayout(this.gridBagLayout);
        this.bEmail.setVisible(emailActive);
        this.bEmail.setText(SP.getRS("F7_Email"));
        this.bEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptDeliveryMethodDlg.this.tfEmail.setEnabled(ReceiptDeliveryMethodDlg.this.bEmail.isSelected());
            }
        });
        this.bSMS.setVisible(smsActive);
        this.bSMS.setText(SP.getRS("F8_SMS"));
        this.bSMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptDeliveryMethodDlg.this.tfSMS.setEnabled(ReceiptDeliveryMethodDlg.this.bSMS.isSelected());
            }
        });
        this.bPrint.setText(SP.getRS("F9_Print"));
        this.tfEmail.setHint(SP.getRS("Email_Address"));
        this.tfEmail.setFieldWidth(400);
        this.tfEmail.setEnabled(false);
        this.tfEmail.setText(origEmail);
        this.tfEmail.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReceiptDeliveryMethodDlg.this.validateEmail(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReceiptDeliveryMethodDlg.this.validateEmail(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReceiptDeliveryMethodDlg.this.validateEmail(false);
            }
        });
        this.paEmail.setVisible(emailActive);
        this.originalEmailAddress = this.tfEmail.getText();
        this.tfSMS.setHint(SP.getRS("Phone"));
        this.tfSMS.setFieldWidth(400);
        this.tfSMS.setEnabled(false);
        this.tfSMS.setText(origPhone);
        this.tfSMS.setCountryCode(this.country);
        this.paSMS.setVisible(smsActive);
        this.originalPhoneNumber = this.tfSMS.getText();
        this.bOk.setText(SP.getRS("F10_Proceed"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptDeliveryMethodDlg.this.okDialog();
            }
        });
        this.lableTitle.setText(SP.getRS("Receipt_Delivery_Method_Message"));
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.add((Component)this.bEmail, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 10, 5), 0, 0));
        this.panel.add((Component)this.paEmail, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 10, 15), 0, 0));
        this.panel.add((Component)this.bSMS, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 10, 5), 0, 0));
        this.panel.add((Component)this.paSMS, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 10, 0, new Insets(15, 5, 10, 15), 0, 0));
        this.panel.add((Component)this.bPrint, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 5, 5), 0, 0));
        this.panel.add((Component)this.bOk, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 15, 15), 0, 0));
        this.panel.add((Component)this.lableTitle, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 10, 10), 0, 0));
        this.pack();
        PosUtils.centreWindow(this);
        switch (defaultDeliveryMethod) {
            case EMAIL_ONLY: {
                this.bEmail.doClick();
                break;
            }
            case EMAIL_AND_PRINT: {
                this.bPrint.doClick();
                this.bEmail.doClick();
                break;
            }
            case PRINT_ONLY: {
                this.bPrint.doClick();
                break;
            }
            case SMS_ONLY: {
                this.bSMS.doClick();
                break;
            }
            case EMAIL_AND_SMS: {
                this.bSMS.doClick();
                this.bEmail.doClick();
                break;
            }
            case SMS_AND_PRINT: {
                this.bSMS.doClick();
                this.bPrint.doClick();
                break;
            }
            case EMAIL_AND_SMS_AND_PRINT: {
                this.bEmail.doClick();
                this.bSMS.doClick();
                this.bPrint.doClick();
            }
        }
        this.deliveryMethod = defaultDeliveryMethod;
        this.setVisible(true);
    }

    public PayUtils.ReceiptDeliveryMethod getDeliveryMethod() {
        boolean email = this.bEmail.isSelected();
        boolean phone = this.bSMS.isSelected();
        boolean print = this.bPrint.isSelected();
        if (email && phone && print) {
            return PayUtils.ReceiptDeliveryMethod.EMAIL_AND_SMS_AND_PRINT;
        }
        if (email && phone && !print) {
            return PayUtils.ReceiptDeliveryMethod.EMAIL_AND_SMS;
        }
        if (email && !phone && !print) {
            this.phoneNumber = "";
            return PayUtils.ReceiptDeliveryMethod.EMAIL_ONLY;
        }
        if (email && !phone && print) {
            this.phoneNumber = "";
            return PayUtils.ReceiptDeliveryMethod.EMAIL_AND_PRINT;
        }
        if (!email && phone && !print) {
            this.emailAddress = "";
            return PayUtils.ReceiptDeliveryMethod.SMS_ONLY;
        }
        if (!email && phone && print) {
            this.emailAddress = "";
            return PayUtils.ReceiptDeliveryMethod.SMS_AND_PRINT;
        }
        if (!email && !phone && print) {
            this.phoneNumber = "";
            this.emailAddress = "";
            return PayUtils.ReceiptDeliveryMethod.PRINT_ONLY;
        }
        return null;
    }

    private boolean validateText() {
        if (!(this.bEmail.isSelected() || this.bSMS.isSelected() || this.bPrint.isSelected())) {
            DlgMessage.showMessage(this, "Please select a receipt method", "Receipt required", -1, 0);
            return false;
        }
        boolean validEmail = true;
        if (this.bEmail.isVisible() && this.bEmail.isSelected() && !(validEmail = this.validateEmail(true))) {
            return false;
        }
        boolean validPhone = true;
        if (this.bSMS.isVisible() && this.bSMS.isSelected()) {
            validPhone = this.validatePhone(true);
        }
        return validEmail && validPhone;
    }

    private boolean validateEmail(boolean doKleber) {
        KleberUtils kleber;
        boolean bOk = true;
        String email = this.tfEmail.getText();
        if (email.isEmpty() || email.length() == 0 || email.length() > this.MAX_FIELD_LENGTH) {
            bOk = false;
        }
        if (bOk && doKleber && !StringUtils.isNullOrEmpty(this.originalEmailAddress) && this.originalEmailAddress.equalsIgnoreCase(email)) {
            doKleber = false;
        }
        if ((kleber = KleberUtils.getInstance(this.sParams)).isEmailValidationEnabled() && doKleber && bOk) {
            KleberModels.DtResponse response;
            block14: {
                response = null;
                try {
                    response = kleber.ValidateEmail((String)this.tfEmail.getText()).DtResponse;
                }
                catch (KleberApiException e) {
                    if (e.getCause() instanceof SocketTimeoutException) {
                        if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Email_Verify_Failure"), StoreParams.res.getString("Kleber_Timeout"), 0, 3) != 0) {
                            bOk = false;
                        }
                    }
                    if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Email_Verify_Failure"), StoreParams.res.getString("Kleber_Connection_Failed"), 0, 3) == 0) break block14;
                    bOk = false;
                }
            }
            if (response != null && response.ResultCount > 0 && !((KleberModels.DtResponse.EmailResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.EmailResult.EmailStatusCode.Valid) && !((KleberModels.DtResponse.EmailResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.EmailResult.EmailStatusCode.AcceptAll)) {
                if (((KleberModels.DtResponse.EmailResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.EmailResult.EmailStatusCode.Unknown)) {
                    bOk = DlgMessage.showMessage(this, StringUtils.isNullOrEmpty(response.ErrorMessage) ? StoreParams.res.getString("Kleber_Email_Verify_Failure") : response.ErrorMessage, StoreParams.res.getString("Kleber_Cannot_Verify_Email_Address"), 0, 3, 1) == 0;
                } else {
                    DlgMessage.showMessage(this, ((KleberModels.DtResponse.EmailResult)response.Result.get((int)0)).StatusDescription, StoreParams.res.getString("Stop"), 0);
                    bOk = false;
                }
            }
        } else if (!this.sParams.getEmailValidator().validate(email)) {
            bOk = false;
        }
        if (!bOk) {
            this.tfEmail.requestFocusInWindow();
            this.paEmail.showError();
        } else {
            this.paEmail.clear();
        }
        return bOk;
    }

    private boolean validatePhone(boolean doKleber) {
        KleberUtils kleber;
        boolean bOk = true;
        String sms = this.tfSMS.getText();
        if (sms.isEmpty() || sms.length() == 0 || sms.length() > this.MAX_FIELD_LENGTH) {
            bOk = false;
        }
        if (bOk && doKleber && !StringUtils.isNullOrEmpty(this.originalPhoneNumber) && this.originalPhoneNumber.equalsIgnoreCase(sms)) {
            doKleber = false;
        }
        if ((kleber = KleberUtils.getInstance(this.sParams)).isPhoneValidationEnabled() && doKleber && bOk) {
            KleberModels.DtResponse response;
            block13: {
                response = null;
                try {
                    response = kleber.ValidatePhone((String)this.tfSMS.getText(), (String)this.country.getCode()).DtResponse;
                }
                catch (KleberApiException e) {
                    if (e.getCause() instanceof SocketTimeoutException) {
                        if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Phone_Verify_Failure"), StoreParams.res.getString("Kleber_Timeout"), 0, 3) != 0) {
                            bOk = false;
                        }
                    }
                    if (DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Kleber_Phone_Verify_Failure"), StoreParams.res.getString("Kleber_Connection_Failed"), 0, 3) == 0) break block13;
                    bOk = false;
                }
            }
            if (response != null && response.ResultCount > 0 && !((KleberModels.DtResponse.PhoneResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.PhoneResult.PhoneStatusCode.Connected) && !((KleberModels.DtResponse.PhoneResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.PhoneResult.PhoneStatusCode.InternalSystemError)) {
                if (((KleberModels.DtResponse.PhoneResult)response.Result.get((int)0)).StatusCode.equals((Object)KleberModels.DtResponse.PhoneResult.PhoneStatusCode.Indeterminate)) {
                    bOk = DlgMessage.showMessage(this, StringUtils.isNullOrEmpty(response.ErrorMessage) ? StoreParams.res.getString("Kleber_Phone_Verify_Failure") : response.ErrorMessage, StoreParams.res.getString("Kleber_Cannot_Verify_Phone_Number"), 0, 3, 1) == 0;
                } else {
                    DlgMessage.showMessage(this, ((KleberModels.DtResponse.PhoneResult)response.Result.get((int)0)).StatusDescription, StoreParams.res.getString("Stop"), 0);
                    bOk = false;
                }
            }
        } else {
            bOk = this.tfSMS.getText() == null || this.tfSMS.getText().isEmpty() ? false : this.tfSMS.isValidNumber();
        }
        if (!bOk) {
            this.paSMS.showError();
        } else {
            this.paSMS.clear();
        }
        return bOk;
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public String getSms() {
        return this.phoneNumber;
    }
}

