/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import bass.eftpos.ETran;
import bass.eftpos.StringUtils;
import bass.eftpos.TransactionMode;
import java.awt.Frame;
import java.awt.Window;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import javax.swing.JDialog;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.XMLUtils;
import jpos.basscom.IntBuffer;
import jpos.basscom.LongBuffer;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.pay.PaymentDlg;
import jpos.pay.afterpay.AfterpayGateway;
import jpos.pay.afterpay.AfterpayTran;
import jpos.pay.braintree.Braintree;
import jpos.pay.braintree.BraintreeTran;
import jpos.pay.eftpos.EFTDlg;
import jpos.pay.eftpos.EftposUtils;
import jpos.pay.openpay.DlgOpenpayCustomerId;
import jpos.pay.openpay.DlgOriginalPaymentRefOpenpay;
import jpos.pay.openpay.DlgWaitingForConfirmationOpenpay;
import jpos.pay.openpay.Openpay;
import jpos.pay.openpay.OpenpayTran;
import jpos.pay.paypal.Paypal;
import jpos.pay.paypal.PaypalTran;
import jpos.pay.qantas.Qantas;
import jpos.pay.qantas.QantasTransaction;
import jpos.pay.zip.DlgOriginalPaymentRef;
import jpos.pay.zip.DlgShopInStore;
import jpos.pay.zip.DlgWaitingForConfirmation;
import jpos.pay.zip.ZipPay;
import jpos.pay.zip.ZipPayTran;
import jpos.pay.zip.ZipStatus;
import jpos.voucher.CreditNoteAdapter;
import jpos.voucher.CreditNoteIssueAdapter;
import jpos.voucher.CreditNoteLoadAdapter;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.GatewayVoucherTran;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherAdapter;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherLoadAdapter;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;
import jpos.voucher.vii.ViiGateway;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class RetTranP {
    private int status;
    private TransactionMode eftMode = null;
    private boolean isChange;
    private boolean isRounding;
    private PayType payType;
    private double amount;
    private double cashout;
    public double allowedChangeAmount = 0.0;
    public double maxAmount = 0.0;
    private String sEFTdeclinedMsg;
    int sequenceNumber;
    Timestamp tranDate = null;
    StringBuffer paymentRef1 = new StringBuffer();
    StringBuffer authorisedBy = new StringBuffer();
    private VoucherAdapter voucherAdapter;
    private CreditNoteAdapter creditNoteAdapter;
    private String paymentNumber;
    public LongBuffer vshIdx = new LongBuffer();
    public LongBuffer vhIdx = new LongBuffer();
    private RetTranP reversingRetTranP = null;
    RetTranP origRetTranP = null;
    ETran eftposTran;
    private FrSales frParent;
    private String cardType = "";
    public static final int STATUS_NULL = 0;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_INCOMPLETE = 2;
    public static final int STATUS_OK = 3;
    public static final int STATUS_DECLINED = 4;
    public static final int STATUS_UNKNOWN_STATE = 5;
    public static final int ADYEN_API_FAILED_STATE = 6;

    public RetTranP(PayType pPayType, double pAmount) {
        this.status = pPayType.isEFT ? 1 : 0;
        this.payType = pPayType;
        this.amount = this.payType.roundAmt(pAmount);
        this.isChange = false;
        this.isRounding = false;
    }

    public void setPayType(PayType payType) {
        this.payType = payType;
    }

    public PayType getPayType() {
        return this.payType;
    }

    public void setChange() {
        this.isChange = true;
    }

    public boolean isChange() {
        return this.isChange;
    }

    public void setParent(FrSales parent) {
        this.frParent = parent;
    }

    public void setEFTStatus(int pEFTStatus) {
        this.status = pEFTStatus;
    }

    public void setEFTTran(ETran eTran) {
        this.eftposTran = eTran;
    }

    public int getEFTStatus() {
        return this.status;
    }

    public void setReversingRetTranP(RetTranP pReversingRetTranP) {
        this.reversingRetTranP = pReversingRetTranP;
    }

    public RetTranP getReversingRetTranP() {
        return this.reversingRetTranP;
    }

    public void setRounding() {
        this.isRounding = true;
    }

    public boolean isRounding() {
        return this.isRounding;
    }

    public double getMaxChangePayment(double pRndError, double pAvailableChange) {
        double nRetVal;
        if (this.payType.round) {
            pAvailableChange += pRndError;
            pAvailableChange = PayType.roundDec(pAvailableChange);
        }
        double d = nRetVal = this.getPayType().maxPayment.isNotNull() && this.getPayType().maxPayment.doubleValue() < this.allowedChangeAmount ? this.getPayType().maxPayment.doubleValue() : this.allowedChangeAmount;
        if (nRetVal > pAvailableChange) {
            nRetVal = pAvailableChange;
        }
        return this.getPayType().roundAmt(nRetVal);
    }

    public void setEFT(double pCashout) {
        this.cashout = pCashout;
    }

    public void setRef1(String pTransNumber) {
        if (pTransNumber != null) {
            this.paymentRef1.replace(0, this.paymentRef1.length(), pTransNumber);
        }
    }

    public void setVoucherAdapter(VoucherAdapter voucherAdapter) {
        this.voucherAdapter = voucherAdapter;
    }

    public void setCreditNoteAdapter(CreditNoteAdapter creditNoteAdapter) {
        this.creditNoteAdapter = creditNoteAdapter;
    }

    public void setAuthorisedBy(String pAuthorisedBy) {
        this.authorisedBy.replace(0, this.authorisedBy.length(), pAuthorisedBy);
    }

    public void setPaymentNum(String pVoucherNum) {
        this.paymentNumber = pVoucherNum;
    }

    public String getPaymentNum() {
        return this.paymentNumber;
    }

    public void setEFTDeclined(String spMsg) {
        this.status = 4;
        this.sEFTdeclinedMsg = spMsg;
    }

    public PosDouble getTMAmount() {
        return this.isRounding || this.isChange || this.payType.idx == 647L ? new PosDouble(this.payType.roundAmt(-this.amount)) : new PosDouble(this.amount);
    }

    public String getCardType() {
        if (this.payType.idx == 848L || this.payType.idx == 847L) {
            if (this.eftposTran != null && !StringUtils.isNullOrEmpty((String)this.eftposTran.getCardType())) {
                return this.eftposTran.getCardType();
            }
            if (this.origRetTranP != null && this.origRetTranP.eftposTran != null && !StringUtils.isNullOrEmpty((String)this.origRetTranP.eftposTran.getCardType())) {
                return this.origRetTranP.eftposTran.getCardType();
            }
        }
        return this.cardType;
    }

    public void setCardType(String pCardType) {
        this.cardType = pCardType;
    }

    public String getTMDetails() {
        String tmDetails = "";
        if (this.payType.isEFT) {
            tmDetails = (this.cashout == 0.0 ? "" : SP.getRS("cashout") + "=" + new PosDouble(this.cashout).toString() + " ") + this.getEFTStatusDesc();
        } else if (this.payType.idx == 795L || this.payType.idx == 850L) {
            tmDetails = this.getEFTStatusDesc();
        } else if (this.isRounding) {
            tmDetails = SP.getRS("rounding");
        } else if (this.isChange) {
            tmDetails = SP.getRS("change");
        } else if (this.paymentNumber != null && this.paymentNumber.length() > 0) {
            tmDetails = this.payType.isVoucher ? (this.voucherAdapter == null || this.voucherAdapter.getVoucher() == null ? this.paymentNumber : this.voucherAdapter.getVoucher().getVoucherType().toString() + " " + this.voucherAdapter.getVoucher().getDisplayNumber() + " " + this.voucherAdapter.getVoucher().getVoucherType().getBalanceRulesText()) : this.paymentNumber;
        }
        if (this.cardType.length() > 0) {
            tmDetails = this.cardType + (tmDetails.length() > 0 ? "; " : " ") + tmDetails;
        }
        return tmDetails;
    }

    public String getEFTStatusDesc() {
        if (this.status == 1) {
            return SP.getRS("pending");
        }
        if (this.status == 3) {
            return SP.getRS("approved");
        }
        if (this.status == 2) {
            return SP.getRS("in_progress");
        }
        if (this.status == 4) {
            if (this.getPayType().idx == 795L) {
                return ((ZipPayTran)this.getETran()).getZipStatusDesc();
            }
            return SP.getRS("declined") + " - " + this.sEFTdeclinedMsg;
        }
        if (this.status == 0) {
            return "";
        }
        return "";
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double pAmount) {
        this.amount = this.payType.roundAmt(pAmount);
    }

    public double getCashout() {
        return this.cashout;
    }

    public void setCashout(double pCashout) {
        this.cashout = this.payType.roundAmt(pCashout);
    }

    public RetTranP(Element parent, Element tender) throws DataConversionException, Exception {
        if (parent.getAttribute("trand") != null) {
            PosDateFormatter dateFormatter = new PosDateFormatter(null, 3, 3, 0);
            try {
                dateFormatter.setTimestampInternal(parent.getAttribute("trand").getValue());
                this.tranDate = new Timestamp(dateFormatter.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.amount = PosUtils.doubleValInternal(tender.getText());
        this.payType = PayTypes.getPayType(tender.getAttribute("payment_typeidx").getLongValue());
        if (tender.getAttribute("vouch_typeidx") != null && this.payType.isVoucher && tender.getAttribute("payment_number") != null) {
            this.voucherAdapter = new VoucherLoadAdapter();
            this.voucherAdapter.processNumber(tender.getAttribute("payment_number").getValue());
        } else {
            this.voucherAdapter = null;
        }
        if (this.payType.isCreditNote && tender.getAttribute("payment_number") != null) {
            this.creditNoteAdapter = new CreditNoteLoadAdapter();
            this.creditNoteAdapter.processNumber(tender.getAttribute("payment_number").getValue());
        } else {
            this.creditNoteAdapter = null;
        }
        if (tender.getAttribute("payment_number") != null) {
            this.paymentNumber = tender.getAttribute("payment_number").getValue();
        }
        if (tender.getAttribute("cashout_amount") != null) {
            this.cashout = PosUtils.doubleValInternal(tender.getAttribute("cashout_amount").getValue());
        }
        this.cardType = XMLUtils.getValue(tender, "eftpos_cardtype");
        if (this.payType.isEFT && XMLUtils.getValue(tender, "eftpos_provider").equalsIgnoreCase("Adyen")) {
            this.eftposTran = new ETran("", this.amount < 0.0, Math.abs(this.amount), this.cashout, SP.sParams.storeCurrency.getCode(), "'");
            this.eftposTran.setPaymentGWProvider(XMLUtils.getValue(tender, "eftpos_provider"));
            this.eftposTran.setCardType(XMLUtils.getValue(tender, "eftpos_cardtype"));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setSpayGateway(XMLUtils.getValue(tender, "spay_gateway"));
        }
        if (this.payType.idx == 776L) {
            this.eftposTran = new AfterpayTran(this.amount < 0.0, Math.abs(this.amount));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setReference(XMLUtils.getValue(tender, "eftpos_reference"));
        }
        if (this.payType.idx == 795L) {
            this.eftposTran = new ZipPayTran(this.amount < 0.0, Math.abs(this.amount));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setReference(XMLUtils.getValue(tender, "eftpos_reference"));
        }
        if (this.payType.idx == 850L) {
            this.eftposTran = new OpenpayTran(this.amount < 0.0, Math.abs(this.amount));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setReference(XMLUtils.getValue(tender, "eftpos_reference"));
        }
        if (this.payType.idx == 847L) {
            this.eftposTran = new PaypalTran(this.amount < 0.0, Math.abs(this.amount));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setReference(XMLUtils.getValue(tender, "eftpos_reference"));
            this.eftposTran.setCardType(XMLUtils.getValue(tender, "eftpos_cardtype"));
        }
        if (this.payType.idx == 848L) {
            this.eftposTran = new BraintreeTran(this.amount < 0.0, Math.abs(this.amount));
            this.eftposTran.setStan(XMLUtils.getValue(tender, "eftpos_stan"));
            this.eftposTran.setReference(XMLUtils.getValue(tender, "eftpos_reference"));
            this.eftposTran.setCardType(XMLUtils.getValue(tender, "eftpos_cardtype"));
        }
    }

    public boolean dbUpdate(Window parent, Connection pCon, IntBuffer pSequenceNumber) {
        boolean bOk = false;
        EftposUtils.debugPoint(parent, "Updating SEQ on RET_TRANP\nVSHIDX: " + this.vshIdx.longValue() + ", SEQ: " + pSequenceNumber.intValue());
        try (PreparedStatement stmt = pCon.prepareStatement("update RET_TRANP set SEQUENCE_NUMBER = ? where VSHIDX = ?");){
            stmt.setInt(1, pSequenceNumber.intValue());
            stmt.setLong(2, this.vshIdx.longValue());
            stmt.execute();
            bOk = true;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return bOk;
    }

    public boolean dbInsert(Window parent, Connection pCon, long pVHIdx, IntBuffer pSequenceNumber) {
        boolean bOk;
        block28: {
            bOk = false;
            Date expiryDate = null;
            try {
                if (this.amount == 0.0) break block28;
                this.sequenceNumber = pSequenceNumber.intValue();
                if (this.payType.isCreditNote && this.amount < 0.0) {
                    if (VoucherUtils.usingCreditNoteGiftCards()) {
                        FrSales frSales = ((PaymentDlg)parent).getParentFrame();
                        return frSales.addCreditNoteGiftVoucher(this.amount * -1.0);
                    }
                    this.creditNoteAdapter = new CreditNoteIssueAdapter();
                    this.paymentNumber = String.valueOf(SP.sParams.getNextCreditNum("RetTranP.dbInsert"));
                    this.creditNoteAdapter.processNumber(SP.sParams.getStore().getStoreNo() + this.paymentNumber);
                    expiryDate = this.creditNoteAdapter.getVoucher().getExpiryDate();
                } else if (this.payType.isViiRefundVoucher() && this.amount < 0.0) {
                    if (SP.sParams.checkIConn()) {
                        IVoucherGateway viiGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
                        if (viiGatewayCheck instanceof ViiGateway) {
                            ((ViiGateway)viiGatewayCheck).setisNameRequried(false);
                            FrSales frSales = ((PaymentDlg)parent).getParentFrame();
                            return frSales.addViiVoucherForRefund(this.amount * -1.0);
                        }
                        return false;
                    }
                    DlgMessage.showMessage(this.frParent, "Unable to issue Vii Gift Vouchers while POS is Offline.\nPlease wait for POS to come back online, or use alternative payment method.", "Error", 0);
                    return false;
                }
                this.vshIdx.setValue(SP.sParams.nextVal("XRET_TRANP"));
                this.vhIdx.setValue(pVHIdx);
                EftposUtils.debugPoint(parent, "Inserting into RET_TRANP\nVSHIDX: " + this.vshIdx.longValue());
                try (PreparedStatement stmt = pCon.prepareStatement("INSERT INTO RET_TRANP(VSHIDX, VHIDX, \"ACTIVE\", PAYMENT_AMOUNT, CASHOUT_AMOUNT, PAYMENT_NUMBER, PAYMENT_TYPEIDX, SEQUENCE_NUMBER, AUTHORISED_BY, EXPIRY_DATE, ORIG_EXPIRY_DATE, VOUCH_TYPEIDX, PAYMENT_REF1, CRDT) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");){
                    stmt.setLong(1, this.vshIdx.longValue());
                    stmt.setLong(2, this.vhIdx.longValue());
                    stmt.setInt(3, 1);
                    stmt.setDouble(4, this.amount);
                    stmt.setDouble(5, this.cashout);
                    if (this.paymentNumber != null && !this.paymentNumber.equals("")) {
                        stmt.setString(6, this.paymentNumber);
                    } else {
                        stmt.setNull(6, 12);
                    }
                    stmt.setLong(7, this.payType.idx);
                    stmt.setInt(8, this.sequenceNumber);
                    stmt.setString(9, this.authorisedBy.toString());
                    if (expiryDate != null) {
                        stmt.setDate(10, expiryDate);
                        stmt.setDate(11, expiryDate);
                    } else {
                        stmt.setNull(10, 91);
                        stmt.setNull(11, 91);
                    }
                    if (this.voucherAdapter != null && this.voucherAdapter.getVoucher() != null) {
                        stmt.setLong(12, this.voucherAdapter.getVoucher().getVoucherType().getRcidx());
                    } else {
                        stmt.setNull(12, 2);
                    }
                    stmt.setString(13, this.paymentRef1.toString());
                    this.tranDate = new Timestamp(new java.util.Date().getTime());
                    stmt.setTimestamp(14, this.tranDate);
                    stmt.executeUpdate();
                }
                if (this.payType.isVoucher && this.voucherAdapter != null && this.voucherAdapter.getVoucher() != null) {
                    this.voucherInsert(pCon, pVHIdx);
                }
                if (this.payType.isCreditNote && this.creditNoteAdapter != null && this.creditNoteAdapter.getVoucher() != null) {
                    this.creditNoteInsert(pCon, pVHIdx);
                }
                pSequenceNumber.setValue(this.sequenceNumber + 1);
                this.payType.addTotal(!this.isChange(), this.amount);
                bOk = true;
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
        return bOk;
    }

    private void voucherInsert(Connection con, long vhidx) {
        block34: {
            double originalAmount = 0.0;
            double usedAmount = 0.0;
            VoucherType.BalanceRules balanceRules = this.voucherAdapter.getVoucher().getVoucherType().getBalanceRules();
            if (balanceRules == VoucherType.BalanceRules.GIVE_CHANGE) {
                originalAmount = this.voucherAdapter.getVoucher().getOriginalAmount();
                usedAmount = this.amount;
            } else if (balanceRules == VoucherType.BalanceRules.RETAIN_VALUE) {
                originalAmount = this.voucherAdapter.getVoucher().getOriginalAmount();
                usedAmount = this.voucherAdapter.getVoucher().getUsedAmount() + this.amount;
            } else if (balanceRules == VoucherType.BalanceRules.WRITE_OFF) {
                if (this.voucherAdapter.getVoucher().getVoucherType().isIssueWithSale()) {
                    usedAmount = originalAmount = this.voucherAdapter.getVoucher().getOriginalAmount();
                } else {
                    originalAmount = this.amount;
                    usedAmount = this.amount;
                }
            }
            try {
                long gvcnidx = this.voucherAdapter.getVoucher().getGvcnidx();
                if (gvcnidx > -1L) {
                    try (PreparedStatement prepStmt = con.prepareStatement("UPDATE GVCN_MAINT SET PENDING_VHIDX = ?, PENDING_AMT = ?, PENDING_USED_AMT = ? WHERE GVCNIDX = ?");){
                        prepStmt.setLong(1, vhidx);
                        prepStmt.setDouble(2, originalAmount);
                        prepStmt.setDouble(3, usedAmount);
                        prepStmt.setLong(4, gvcnidx);
                        prepStmt.executeUpdate();
                        break block34;
                    }
                }
                try (PreparedStatement prepStmt = con.prepareStatement("INSERT INTO GVCN_MAINT(GVCNIDX, \"TYPE\", NUM, AMT, USED_AMT, ISSUE_VHIDX, LAST_REDEEMED_WIDX, LAST_REDEEMED_DATE, \"ACTIVE\") VALUES(?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, 1)");){
                    prepStmt.setLong(1, SP.sParams.nextVal("XGVCN_MAINT"));
                    prepStmt.setInt(2, 0);
                    prepStmt.setString(3, this.voucherAdapter.getVoucher().getNumber());
                    prepStmt.setDouble(4, originalAmount);
                    prepStmt.setDouble(5, usedAmount);
                    prepStmt.setLong(6, vhidx);
                    prepStmt.setLong(7, SP.sParams.getStoreIdx());
                    prepStmt.executeUpdate();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private void creditNoteInsert(Connection con, long vhidx) {
        block27: {
            try {
                long gvcnidx = this.creditNoteAdapter.getVoucher().getGvcnidx();
                if (gvcnidx > -1L && this.amount > 0.0) {
                    try (PreparedStatement prepStmt = con.prepareStatement("UPDATE GVCN_MAINT SET PENDING_VHIDX = ?, PENDING_USED_AMT = ? WHERE GVCNIDX = ?");){
                        prepStmt.setLong(1, vhidx);
                        prepStmt.setDouble(2, this.amount);
                        prepStmt.setLong(3, gvcnidx);
                        prepStmt.executeUpdate();
                        break block27;
                    }
                }
                if (gvcnidx != -1L || !(this.amount < 0.0)) break block27;
                try (PreparedStatement prepStmt = con.prepareStatement("INSERT INTO GVCN_MAINT(GVCNIDX, \"TYPE\", NUM, AMT, USED_AMT, EXPIRY_DATE, ORIG_EXPIRY_DATE, ISSUE_VHIDX, ISSUED_WIDX, ISSUED_DATE, \"ACTIVE\") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, 1)");){
                    prepStmt.setLong(1, SP.sParams.nextVal("XGVCN_MAINT"));
                    prepStmt.setInt(2, 1);
                    prepStmt.setString(3, this.creditNoteAdapter.getVoucher().getNumber());
                    prepStmt.setDouble(4, this.amount * -1.0);
                    prepStmt.setDouble(5, 0.0);
                    prepStmt.setDate(6, this.creditNoteAdapter.getVoucher().getExpiryDate());
                    prepStmt.setDate(7, this.creditNoteAdapter.getVoucher().getExpiryDate());
                    prepStmt.setLong(8, vhidx);
                    prepStmt.setLong(9, SP.sParams.getStoreIdx());
                    prepStmt.executeUpdate();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public boolean doEFT(JDialog pParent, StringBuffer retMessage) throws Exception {
        boolean bOk = false;
        boolean reversalMode = this.reversingRetTranP != null;
        try {
            if (this.getAmount() < 0.0) {
                double refundAmount = this.payType.roundAmt(-this.getAmount() + this.getCashout());
                double refundCashout = this.payType.roundAmt(-this.getCashout());
                String sDescription = reversalMode ? "Reversing " + this.reversingRetTranP.eftposTran.getCardType() + " (A/c " + this.reversingRetTranP.eftposTran.getAccountType() + ")  Payment of " + SP.sParams.storeCurrency.formatDetailNoScale(refundAmount) : "Refund of " + SP.sParams.storeCurrency.formatDetailNoScale(refundAmount);
                if (refundCashout != 0.0) {
                    sDescription = sDescription + ", Cashout " + SP.sParams.storeCurrency.formatDetailNoScale(refundCashout) + ", Total " + SP.sParams.storeCurrency.formatDetailNoScale(-this.getAmount());
                }
                if (this.eftposTran != null) {
                    this.eftposTran.setReference(String.valueOf(this.vshIdx.longValue()));
                    this.eftposTran.setRefund(true);
                    this.eftposTran.setDescription(sDescription);
                } else if (this.origRetTranP != null && this.origRetTranP.getETran() != null && this.origRetTranP.getETran().getPaymentGWProvider() != null && this.origRetTranP.getETran().getPaymentGWProvider().equalsIgnoreCase("adyen") && !this.origRetTranP.getETran().getPaymentGWProvider().equalsIgnoreCase(SP.sParams.eftpos.getProviderName())) {
                    this.eftposTran = this.origRetTranP.getETran();
                    this.eftposTran.setReference(String.valueOf(this.vshIdx.longValue()));
                    this.eftposTran.setRefund(true);
                    double newamount = (double)Math.round((refundAmount + this.cashout) * 100.0) / 100.0;
                    this.eftposTran.setAmount(newamount);
                    this.eftposTran.setCashout(0.0);
                    this.eftposTran.setCurrency(SP.sParams.storeCurrency.getCode());
                    this.eftposTran.setDescription(sDescription);
                } else {
                    this.eftposTran = new ETran(String.valueOf(this.vshIdx.longValue()), true, refundAmount, refundCashout, SP.sParams.storeCurrency.getCode(), sDescription);
                }
                if (SP.sParams.isEftposProviderAdyen()) {
                    if (reversalMode && this.reversingRetTranP.eftposTran != null) {
                        this.eftposTran.setOrigStan(this.reversingRetTranP.eftposTran.getStan());
                    } else if (this.origRetTranP != null && this.origRetTranP.getETran() != null && pParent instanceof PaymentDlg && !((PaymentDlg)pParent).getPaymentTM().getPayTypeLineExists(776L)) {
                        this.eftposTran.setOrigStan(this.origRetTranP.getETran().getStan());
                    }
                    if (this.payType.isEftposWltPay && !this.payType.wltPayCode.trim().isEmpty()) {
                        this.eftposTran.setCardType(this.payType.wltPayCode.trim());
                    }
                } else if (reversalMode && this.reversingRetTranP.eftposTran != null) {
                    this.eftposTran.setOrigStan(this.reversingRetTranP.eftposTran.getStan());
                    this.eftposTran.setOrigReference(this.reversingRetTranP.eftposTran.getReference());
                }
            } else {
                double eftAmount = this.payType.roundAmt(this.getAmount() - this.getCashout());
                double eftCashout = this.payType.roundAmt(this.getCashout());
                String sDescription = reversalMode ? "Reversing " + this.reversingRetTranP.eftposTran.getCardType() + " (A/c " + this.reversingRetTranP.eftposTran.getAccountType() + ")  Refund of " + SP.sParams.storeCurrency.formatDetailNoScale(eftAmount) : "Payment of " + SP.sParams.storeCurrency.formatDetailNoScale(eftAmount);
                if (this.getCashout() != 0.0) {
                    sDescription = sDescription + ", Cashout " + SP.sParams.storeCurrency.formatDetailNoScale(eftCashout) + ", Total " + SP.sParams.storeCurrency.formatDetailNoScale(this.getAmount());
                }
                this.eftposTran = new ETran(String.valueOf(this.vshIdx.longValue()), false, eftAmount, eftCashout, SP.sParams.storeCurrency.getCode(), sDescription);
                if (this.payType.isEftposWltPay && !this.payType.wltPayCode.trim().isEmpty()) {
                    this.eftposTran.setIsEftposWltPay(true);
                    this.eftposTran.setWltPayCode(this.payType.wltPayCode.trim());
                }
                if (reversalMode && this.reversingRetTranP.eftposTran != null) {
                    if (SP.sParams.isEftposProviderAdyen()) {
                        this.eftposTran.setOrigReference(this.reversingRetTranP.eftposTran.getReference());
                    } else {
                        this.eftposTran.setOrigStan(this.reversingRetTranP.eftposTran.getStan());
                        this.eftposTran.setOrigReference(this.reversingRetTranP.eftposTran.getReference());
                    }
                }
            }
            if (this.eftMode != null) {
                this.eftposTran.setMode(this.eftMode);
            }
            EftposUtils.debugPoint(pParent, "Inserting into EFTPOS_INCOMPLETE_DET table\nVSHIDX: " + this.vshIdx.longValue());
            String requestId = SP.sParams.eftpos.getUniqueRequestId();
            try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Insert into EFTPOS_INCOMPLETE_DET(VSHIDX, TILL_NUMBER, CRDT, REQUEST_ID, REVERSING_VSHIDX) values (?, ?, CURRENT_TIMESTAMP, ?, ?)");){
                stmt.setLong(1, this.vshIdx.longValue());
                stmt.setString(2, SP.sParams.tillnum);
                stmt.setString(3, requestId);
                if (this.reversingRetTranP != null) {
                    stmt.setLong(4, this.reversingRetTranP.vshIdx.longValue());
                } else {
                    stmt.setNull(4, 4);
                }
                stmt.execute();
            }
            this.eftposTran.setRequestId(requestId);
            stmt = SP.sParams.conn.prepareStatement("UPDATE RET_TRANP SET EFTPOS_ATTEMPTS = COALESCE(EFTPOS_ATTEMPTS,0) + 1 WHERE VSHIDX = ? RETURNING EFTPOS_ATTEMPTS");
            eftCashout = null;
            try {
                stmt.setLong(1, this.vshIdx.longValue());
                try (ResultSet results = stmt.executeQuery();){
                    if (results.next()) {
                        this.eftposTran.setAttemptCount(results.getInt(1));
                    }
                }
            }
            catch (Throwable results) {
                eftCashout = results;
                throw results;
            }
            finally {
                if (stmt != null) {
                    if (eftCashout != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable results) {
                            eftCashout.addSuppressed(results);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            if (!SP.sParams.conn.getAutoCommit()) {
                PosUtils.endTrans(SP.sParams.conn);
            }
            if (!bOk) {
                EftposUtils.debugPoint(pParent, "Sending request to pinpad\n" + this.eftposTran.toString());
                EftposUtils.logInfo(SP.sParams.conn, Long.toString(this.vshIdx.longValue()), EftposUtils.Action.REQUEST, this.eftposTran.getDescription());
                this.eftposTran.setInReversalMode(reversalMode);
                if (this.eftposTran.getPaymentGWProvider() != null && this.eftposTran.getPaymentGWProvider().equalsIgnoreCase("adyen") && !this.eftposTran.getPaymentGWProvider().equalsIgnoreCase(SP.sParams.eftpos.getProviderName())) {
                    EftposUtils.debugPoint(pParent, "Initiating Adyen Transaction Refunding process via Non Adyen device");
                    String pspReference = this.eftposTran.getStan().substring(1, this.eftposTran.getStan().length());
                    String sPayGw = this.eftposTran.getSpayGateway();
                    String refAmount = String.valueOf(Math.abs(this.amount));
                    String origAmount = String.valueOf(Math.abs(this.origRetTranP.amount));
                    EftposUtils.debugPoint(pParent, "Passing pspReference : " + pspReference);
                    Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("payment_gateway_ho_adyen", String.format("%s,%s,%s,%s", pspReference, refAmount, origAmount, sPayGw)).getXML();
                    long resStatus = XMLUtils.getLongValue(response, "status");
                    String gwMessage = XMLUtils.getValue(response, "message");
                    EftposUtils.debugPoint(pParent, "AP21Adyen Service Response for : " + pspReference);
                    EftposUtils.debugPoint(pParent, "Response Code\t: " + String.valueOf(resStatus));
                    EftposUtils.debugPoint(pParent, "Response\t: " + gwMessage);
                    retMessage.append(gwMessage);
                    if (resStatus != 200L) {
                        this.setEFTStatus(6);
                        bOk = false;
                    } else {
                        bOk = true;
                    }
                } else {
                    EFTDlg eftDlg = new EFTDlg(pParent, this.eftposTran, retMessage);
                    eftDlg.setVisible(true);
                    bOk = eftDlg.getOk();
                }
            }
            String logMessage = (bOk ? "OK" : (SP.sParams.eftpos.isTransactionInUnknownState() ? "UNKNOWN STATE" : "FAILED")) + ". Msg: " + retMessage.toString();
            EftposUtils.debugPoint(pParent, "Received response from pinpad:\n" + logMessage + "\n" + this.eftposTran.toString());
            EftposUtils.logInfo(SP.sParams.conn, Long.toString(this.vshIdx.longValue()), EftposUtils.Action.RESPONSE, logMessage);
            if (bOk) {
                this.status = 3;
            } else if (SP.sParams.eftpos.isTransactionInUnknownState()) {
                EftposUtils.debugPoint(pParent, "Eftpos returned in an unknown state: " + retMessage.toString() + "\nClosing Payment screen and entering EFTPOS reversal mode...");
                this.status = 5;
                if (!reversalMode) {
                    return false;
                }
            } else {
                EftposUtils.debugPoint(pParent, "Printing failed transaction receipt\nReceipt:\n" + this.eftposTran.getReceipt());
                SP.sParams.eftposListener.printReceipt(false, false, this.eftposTran.getReceipt());
            }
            PosUtils.startTrans(SP.sParams.conn);
            EftposUtils.debugPoint(pParent, "Deleting from EFTPOS_INCOMPLETE_DET\nVSHIDX: " + this.vshIdx.longValue());
            try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("delete from EFTPOS_INCOMPLETE_DET where VSHIDX = ? and TILL_NUMBER=?");){
                stmt.setLong(1, this.vshIdx.longValue());
                stmt.setString(2, SP.sParams.tillnum);
                stmt.execute();
            }
            if (bOk) {
                EftposUtils.debugPoint(pParent, "Inserting eftpos receipt BLOBTEXT and updating RET_TRANP with eftpos details\nVSHIDX: " + this.vshIdx.longValue());
                long nBlobidx = SP.sParams.nextVal("XBLOBTEXT") * -1L;
                long nMerchantBlobidx = SP.sParams.nextVal("XBLOBTEXT") * -1L;
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT)  VALUES ( ? ,? )");){
                    stmt.setLong(1, nBlobidx);
                    stmt.setString(2, this.eftposTran.getReceipt());
                    stmt.execute();
                }
                stmt = SP.sParams.conn.prepareStatement("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT)  VALUES ( ? ,? )");
                var13_28 = null;
                try {
                    stmt.setLong(1, nMerchantBlobidx);
                    stmt.setString(2, this.eftposTran.getMerchantReceipt());
                    stmt.execute();
                }
                catch (Throwable throwable) {
                    var13_28 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var13_28 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var13_28.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?, EFTPOS_AUTHCODE = ?, EFTPOS_SETTLEMENT = ?, EFTPOS_ACTYPE = ?, EFTPOS_CARDTYPE = ?, EFTPOS_REFERENCE = ?, EFTPOS_BLOBIDX = ?, EFTPOS_PROVIDER = ?, EFTPOS_BANK_NON_CASH_AMOUNT = ?, EFTPOS_MASKEDPAN = ?, EFTPOS_MERCHANTID = ?, EFTPOS_MERCHANT_BLOBIDX = ?, EFTPOS_POSREFID = ?, EFTPOS_PURCHASE_AMOUNT = ?, EFTPOS_SURCHARGE = ?, EFTPOS_TERMINALID = ?, EFTPOS_TERMINALREFID = ?, EFTPOS_TRANSACTION_TYPE = ?, EFTPOS_TIPAMOUNT = ?, EFTPOS_RETRIEVAL_REF = ?, EFTPOS_DATE_TIME = ?, CASHOUT_AMOUNT = ?, SPAY_GATEWAY = ? where VSHIDX = ?");
                var13_28 = null;
                try {
                    stmt.setString(1, this.eftposTran.getStan());
                    stmt.setString(2, this.eftposTran.getAuthCode());
                    stmt.setString(3, this.eftposTran.getSettlement());
                    stmt.setString(4, this.eftposTran.getAccountType());
                    stmt.setString(5, this.eftposTran.getCardType());
                    stmt.setString(6, this.eftposTran.getReference());
                    stmt.setLong(7, nBlobidx);
                    stmt.setString(8, SP.sParams.eftpos.getProviderName());
                    stmt.setDouble(9, this.eftposTran.getBankNonCashAmount());
                    stmt.setString(10, this.eftposTran.getMaskedPan());
                    stmt.setString(11, this.eftposTran.getMerchantId());
                    stmt.setLong(12, nMerchantBlobidx);
                    stmt.setString(13, this.eftposTran.getPosRefId());
                    stmt.setDouble(14, this.eftposTran.getPurchaseAmount());
                    stmt.setDouble(15, this.eftposTran.getSurcharge());
                    stmt.setString(16, this.eftposTran.getTerminalId());
                    stmt.setString(17, this.eftposTran.getTerminalRefId());
                    stmt.setString(18, this.eftposTran.getTransactionType());
                    stmt.setDouble(19, this.eftposTran.getTipAmount());
                    stmt.setString(20, this.eftposTran.getRetrievalRefNum());
                    stmt.setString(21, this.eftposTran.getTranDateTime());
                    stmt.setDouble(22, this.eftposTran.getCashout());
                    stmt.setString(23, SP.sParams.isEftposProviderAdyen() ? SP.sParams.gatewayIdx : null);
                    stmt.setLong(24, this.vshIdx.longValue());
                    stmt.execute();
                }
                catch (Throwable throwable) {
                    var13_28 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var13_28 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var13_28.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                if (reversalMode) {
                    EftposUtils.debugPoint(pParent, "Deactivating the following RET_TRANP records\nCurrent VSHIDX: " + this.vshIdx.longValue() + ", Reversing VHIDX: " + this.reversingRetTranP.vshIdx.longValue());
                    stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set \"ACTIVE\"=0 where VSHIDX = ? or VSHIDX = ?");
                    var13_28 = null;
                    try {
                        stmt.setLong(1, this.vshIdx.longValue());
                        stmt.setLong(2, this.reversingRetTranP.vshIdx.longValue());
                        stmt.execute();
                    }
                    catch (Throwable throwable) {
                        var13_28 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (var13_28 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    var13_28.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
            }
            PosUtils.endTrans(SP.sParams.conn);
        }
        catch (Exception e) {
            bOk = false;
            PosUtils.logError(e);
        }
        return bOk;
    }

    public boolean doAfterpay(PaymentDlg pParent, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        AfterpayTran afterpayTran = (AfterpayTran)this.getETran();
        afterpayTran.setReference(this.vshIdx.toString());
        AfterpayGateway afterpay = AfterpayGateway.getInstance();
        if (afterpay.isConfigured()) {
            if (afterpay.createAfterpayTran(pParent, afterpayTran, this.vhIdx.longValue(), processMessage)) {
                this.setEFTStatus(3);
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?where VSHIDX = ?");){
                    stmt.setString(1, afterpayTran.getStan());
                    stmt.setString(2, afterpayTran.getReference());
                    stmt.setLong(3, this.vshIdx.longValue());
                    stmt.execute();
                }
                if (this.reversingRetTranP != null) {
                    stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set \"ACTIVE\"=0 where VSHIDX = ? or VSHIDX = ?");
                    var7_7 = null;
                    try {
                        stmt.setLong(1, this.vshIdx.longValue());
                        stmt.setLong(2, this.reversingRetTranP.vshIdx.longValue());
                        stmt.execute();
                    }
                    catch (Throwable throwable) {
                        var7_7 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (var7_7 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    var7_7.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                    AfterpayTran afterpayReverseTran = (AfterpayTran)this.reversingRetTranP.getETran();
                    AfterpayGateway.removeInProgressFlag(afterpayTran.getStan());
                    AfterpayGateway.removeInProgressFlag(afterpayReverseTran.getStan());
                }
                return true;
            }
            if (afterpayTran.getUnknownState()) {
                this.setEFTStatus(5);
            } else {
                this.setEFTDeclined(processMessage.toString());
            }
        }
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean isGatewayVoucherRedemption() {
        return this.getPayType().isVoucher && this.getVoucherAdapter() != null && this.getVoucherAdapter().getGatewayVoucher() != null;
    }

    public boolean doGatewayVoucherRedemption(PaymentDlg pParent, StringBuffer retMessage) throws SQLException {
        StringBuilder processMessage = new StringBuilder();
        GatewayVoucherTran tran = (GatewayVoucherTran)this.getETran();
        IVoucherGateway gateway = this.getVoucherAdapter().getGatewayVoucher().getGateway();
        if (gateway != null) {
            try {
                GatewayVoucher voucher = gateway.redeemVoucher(this.vhIdx.longValue(), this.vshIdx.longValue(), tran.getVoucherNumber(), tran.getPin(), tran.getAmount(), tran.getReference());
                tran.setTransactionId(voucher.getGatewayTransactionId());
                tran.setStan(voucher.getReceiptNumber());
                tran.setAuthCode(voucher.getAuthCode());
                tran.setSettlement(voucher.getSettlementDate());
                this.setEFTStatus(3);
                SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE RET_TRANP SET EFTPOS_STAN = ?, EFTPOS_REFERENCE = ?, EFTPOS_AUTHCODE = ?, EFTPOS_SETTLEMENT = ?, VOUCHER_GATEWAY_IDX = ?, VOUCHER_BALANCE = ?, EXPIRY_DATE = ? WHERE VSHIDX = ?", tran.getStan(), tran.getReference(), tran.getAuthCode(), tran.getSettlement(), VoucherGatewayManager.getInstance().getGatewayRcidx(), voucher.getAvailableAmount(), voucher.getExpiryDate(), this.vshIdx.longValue());
                this.voucherAdapter.getGatewayVoucher().copyFrom(voucher);
                return true;
            }
            catch (VoucherGatewayException e) {
                this.setEFTDeclined(processMessage.toString());
                retMessage.append(e.toString());
                return false;
            }
        }
        String noGatewayResponse = MessageFormat.format(SP.getRS("voucher_gateway_not_available"), VoucherGatewayManager.getInstance().getGatewayTypeName());
        this.setEFTDeclined(noGatewayResponse);
        retMessage.append(noGatewayResponse);
        return false;
    }

    public void reverseGatewayVoucherRedemption() {
        if (this.isGatewayVoucherRedemption()) {
            GatewayVoucherTran tran = (GatewayVoucherTran)this.getETran();
            if (this.getEFTStatus() == 3 && tran.getTransactionId() != null) {
                GatewayVoucher voucher = this.getVoucherAdapter().getGatewayVoucher();
                voucher.getGateway().cancelRedemption(this.vhIdx.longValue(), this.vshIdx.longValue(), voucher);
            }
        }
    }

    public boolean doPaypal(PaymentDlg payDlg, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        Paypal paypal = SP.sParams.getPaypal();
        if (paypal == null) {
            return false;
        }
        PaypalTran paypalTran = (PaypalTran)this.getETran();
        if (paypalTran.getRefund()) {
            if (StringUtils.isNullOrEmpty((String)paypalTran.getOrigStan())) {
                return false;
            }
            if (paypal.RefundPayment(this, processMessage)) {
                this.setEFTStatus(3);
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?,EFTPOS_CARDTYPE = ? where VSHIDX = ?");){
                    stmt.setString(1, paypalTran.getOrigStan());
                    stmt.setString(2, paypalTran.getReference());
                    stmt.setString(3, paypalTran.getOrigCardType());
                    stmt.setLong(4, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        }
        this.setEFTDeclined(processMessage.toString());
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean doBraintree(PaymentDlg payDlg, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        Braintree braintree = SP.sParams.getBraintree();
        if (braintree == null) {
            return false;
        }
        BraintreeTran braintreeTran = (BraintreeTran)this.getETran();
        if (braintreeTran.getRefund()) {
            if (braintreeTran.getOrigStan() == null || braintreeTran.getOrigStan().length() == 0) {
                return false;
            }
            if (braintree.RefundRequest(this, processMessage)) {
                this.setEFTStatus(3);
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?,EFTPOS_CARDTYPE = ? where VSHIDX = ?");){
                    stmt.setString(1, braintreeTran.getOrigStan());
                    stmt.setString(2, braintreeTran.getReference());
                    stmt.setString(3, braintreeTran.getOrigCardType());
                    stmt.setLong(4, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        }
        this.setEFTDeclined(processMessage.toString());
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean doZipPay(PaymentDlg payDlg, StringBuffer retMessage) throws Exception {
        ZipPayTran zipPayTran;
        StringBuilder processMessage = new StringBuilder();
        ZipPay zipPay = SP.sParams.getZipPay();
        if (zipPay == null) {
            return false;
        }
        if (this.getETran() == null) {
            zipPayTran = new ZipPayTran(true, 0.0);
            zipPayTran.setSalesRepName(payDlg.frSales.salesRep.getName());
            this.setEFTTran(zipPayTran);
        } else {
            zipPayTran = (ZipPayTran)this.getETran();
        }
        if (!zipPayTran.getRefund()) {
            if (zipPayTran.getStan() != null && !zipPayTran.getStan().isEmpty() && zipPayTran.getZipStatus() == ZipStatus.Pending && zipPay.PollRequestStatus(zipPayTran, processMessage) == ZipStatus.Approved) {
                this.setEFTStatus(3);
            }
            if (this.getEFTStatus() != 3) {
                DlgShopInStore dlgCode = new DlgShopInStore((Frame)payDlg.frSales, SP.getRS("zippay_dlg"), zipPayTran);
                dlgCode.setVisible(true);
                if (dlgCode.getResult() && zipPay.RequestPayment(this, processMessage)) {
                    this.setEFTStatus(1);
                    DlgWaitingForConfirmation dlgWait = new DlgWaitingForConfirmation(payDlg, SP.getRS("zippay_dlg"), zipPayTran);
                    dlgWait.setVisible(true);
                    if (dlgWait.getResult()) {
                        this.setEFTStatus(3);
                    } else {
                        retMessage.append(dlgWait.getPollingMessage());
                        this.setEFTDeclined(retMessage.toString());
                    }
                }
            }
            if (this.getEFTStatus() == 3) {
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?where VSHIDX = ?");){
                    stmt.setString(1, zipPayTran.getStan());
                    stmt.setString(2, zipPayTran.getReference());
                    stmt.setLong(3, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        } else {
            if (zipPayTran.getOrigStan() == null || zipPayTran.getOrigStan().length() == 0) {
                DlgOriginalPaymentRef dlgOrigPayRef = new DlgOriginalPaymentRef((Frame)payDlg.frSales, zipPayTran);
                dlgOrigPayRef.setVisible(true);
                if (!dlgOrigPayRef.getResult()) {
                    return false;
                }
            }
            if (zipPay.RefundPayment(this, processMessage)) {
                this.setEFTStatus(3);
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?where VSHIDX = ?");){
                    stmt.setString(1, zipPayTran.getOrigStan());
                    stmt.setString(2, zipPayTran.getReference());
                    stmt.setLong(3, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        }
        this.setEFTDeclined(processMessage.toString());
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean reverseZipPay(PayDialog pParent, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        ZipPay zipPay = SP.sParams.getZipPay();
        if (zipPay != null) {
            ZipPayTran zipPayTran = (ZipPayTran)this.getETran();
            if (!this.getETran().getRefund()) {
                if (zipPay.ReversePaymentRequest(zipPayTran, processMessage)) {
                    this.setEFTStatus(2);
                    return true;
                }
            } else if (zipPay.ReverseRefundRequest(zipPayTran, processMessage)) {
                this.setEFTStatus(2);
                return true;
            }
            retMessage.append(processMessage.toString());
        }
        return false;
    }

    public boolean doQantas(PaymentDlg payDlg, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        QantasTransaction qantasTransaction = (QantasTransaction)this.getETran();
        if (!qantasTransaction.getRefund() && this.getEFTStatus() != 3) {
            Qantas qantas = new Qantas();
            if (qantas.completeTransaction(this.frParent, qantasTransaction, retMessage)) {
                this.setEFTStatus(3);
            } else {
                this.setEFTDeclined(processMessage.toString());
                return false;
            }
        }
        if (this.getEFTStatus() == 3) {
            long nBlobidx = SP.sParams.nextVal("XBLOBTEXT") * -1L;
            qantasTransaction.generateReceipt();
            try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO BLOBTEXT(BLOBIDX, BLOBTEXT)  VALUES ( ? ,? )");){
                stmt.setLong(1, nBlobidx);
                stmt.setString(2, qantasTransaction.getReceipt());
                stmt.execute();
            }
            stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set PAYMENT_REF1 = ?,PAYMENT_REF2 = ?,PAYMENT_REF3 = ?,EFTPOS_STAN = ?,EFTPOS_BLOBIDX = ?where VSHIDX = ?");
            var8_8 = null;
            try {
                stmt.setString(1, qantasTransaction.getTransactionNumber());
                stmt.setString(2, qantasTransaction.getAp21TransactionId());
                stmt.setLong(3, qantasTransaction.getPointsBurnt());
                stmt.setString(4, qantasTransaction.getBurnReference());
                stmt.setLong(5, nBlobidx);
                stmt.setLong(6, this.vshIdx.longValue());
                stmt.execute();
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var8_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            return true;
        }
        this.setEFTDeclined(processMessage.toString());
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean doOpenpay(PaymentDlg payDlg, StringBuffer retMessage) throws Exception {
        OpenpayTran openpayTran;
        StringBuilder processMessage = new StringBuilder();
        Openpay openpay = SP.sParams.getOpenpay();
        if (openpay == null) {
            return false;
        }
        if (this.getETran() == null) {
            openpayTran = new OpenpayTran(true, 0.0);
            openpayTran.setSalesRepName(payDlg.frSales.salesRep.getName());
            this.setEFTTran(openpayTran);
        } else {
            openpayTran = (OpenpayTran)this.getETran();
        }
        if (!openpayTran.getRefund()) {
            if (openpayTran.getStan() != null && !openpayTran.getStan().isEmpty() && openpayTran.getOpenpayStatus().OrderStatus == Openpay.OrderStatus.Received && openpayTran.getOpenpayStatus().PlanStatus == Openpay.PlanStatus.NotProcessed) {
                Openpay.OrderStatusResult pollResult = openpay.GetOrderStatusRequest(this, Openpay.PollingBy.OrderId, processMessage);
                if (pollResult.OrderStatus == Openpay.OrderStatus.Approved && pollResult.PlanStatus == Openpay.PlanStatus.Active) {
                    this.setEFTStatus(3);
                }
            }
            if (this.getEFTStatus() != 3) {
                openpayTran.setSalesRepName(payDlg.frSales.salesRep.getName());
                DlgOpenpayCustomerId dlgCode = new DlgOpenpayCustomerId((Frame)payDlg.frSales, SP.getRS("openpay_dlg"), openpayTran);
                dlgCode.setVisible(true);
                if (dlgCode.getResult() && openpay.RequestPayment(this, processMessage)) {
                    this.setEFTStatus(1);
                    DlgWaitingForConfirmationOpenpay dlgWait = new DlgWaitingForConfirmationOpenpay(payDlg, SP.getRS("openpay_dlg"), this);
                    dlgWait.setVisible(true);
                    if (dlgWait.getResult()) {
                        this.setEFTStatus(3);
                    } else {
                        retMessage.append(dlgWait.getPollingMessage());
                        this.setEFTDeclined(retMessage.toString());
                    }
                }
            }
            if (this.getEFTStatus() == 3) {
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?where VSHIDX = ?");){
                    stmt.setString(1, openpayTran.getStan());
                    stmt.setString(2, openpayTran.getReference());
                    stmt.setLong(3, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        } else {
            if (openpayTran.getOrigStan() == null || openpayTran.getOrigStan().length() == 0) {
                DlgOriginalPaymentRefOpenpay dlgOrigPayRef = new DlgOriginalPaymentRefOpenpay((Frame)payDlg.frSales, openpayTran);
                dlgOrigPayRef.setVisible(true);
                if (!dlgOrigPayRef.getResult()) {
                    return false;
                }
            }
            if (openpay.RefundPayment(this, processMessage, false)) {
                this.setEFTStatus(3);
                try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("Update RET_TRANP set EFTPOS_STAN = ?,EFTPOS_REFERENCE = ?where VSHIDX = ?");){
                    stmt.setString(1, openpayTran.getOrigStan());
                    stmt.setString(2, openpayTran.getReference());
                    stmt.setLong(3, this.vshIdx.longValue());
                    stmt.execute();
                }
                return true;
            }
        }
        this.setEFTDeclined(processMessage.toString());
        retMessage.append(processMessage.toString());
        return false;
    }

    public boolean reverseOpenPay(PayDialog pParent, StringBuffer retMessage) throws Exception {
        StringBuilder processMessage = new StringBuilder();
        Openpay openpay = SP.sParams.getOpenpay();
        if (openpay != null) {
            if (!this.getETran().getRefund() && openpay.RefundPayment(this, processMessage, true)) {
                this.setEFTStatus(2);
                return true;
            }
            retMessage.append(processMessage.toString());
        }
        return false;
    }

    public VoucherAdapter getVoucherAdapter() {
        return this.voucherAdapter;
    }

    public CreditNoteAdapter getCreditNoteAdapter() {
        return this.creditNoteAdapter;
    }

    public ETran getETran() {
        return this.eftposTran;
    }

    public TransactionMode getEftMode() {
        return this.eftMode;
    }

    public void setEftMode(TransactionMode mode) {
        this.eftMode = mode;
    }
}

